/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliveryMethodSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final String[] ALLOWED_VALUES = new String[]{"any", "mhs", "physical", "telex", "teletex", "g3fax", "g4fax", "ia5", "videotex", "telephone"};
    private HashSet<String> allowedValues;
    private ApproximateMatchingRule defaultApproximateMatchingRule;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.allowedValues = new HashSet(ALLOWED_VALUES.length);
        for (String s : ALLOWED_VALUES) {
            this.allowedValues.add(s);
        }
        this.defaultApproximateMatchingRule = DirectoryServer.getApproximateMatchingRule("1.3.6.1.4.1.26027.1.4.1");
        if (this.defaultApproximateMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553601, "1.3.6.1.4.1.26027.1.4.1", "DeliveryMethod");
        }
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "DeliveryMethod");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "DeliveryMethod");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "DeliveryMethod");
        }
    }

    @Override
    public String getSyntaxName() {
        return "DeliveryMethod";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.14";
    }

    @Override
    public String getDescription() {
        return "Delivery Method";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return this.defaultApproximateMatchingRule;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        String stringValue = StaticUtils.toLowerCase(value.stringValue());
        StringTokenizer tokenizer = new StringTokenizer(stringValue, " $");
        if (!tokenizer.hasMoreTokens()) {
            invalidReason.append(MessageHandler.getMessage(6488075, value.stringValue()));
            return false;
        }
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (this.allowedValues.contains(token)) continue;
            invalidReason.append(MessageHandler.getMessage(6488076, value.stringValue(), token));
            return false;
        }
        return true;
    }
}

