/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.HashSet;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaxNumberSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    public static final HashSet<String> ALLOWED_FAX_PARAMETERS = new HashSet(7);
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "FacsimileTelephoneNumber");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "FacsimileTelephoneNumber");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "FacsimileTelephoneNumber");
        }
    }

    @Override
    public String getSyntaxName() {
        return "FacsimileTelephoneNumber";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.22";
    }

    @Override
    public String getDescription() {
        return "Facsimile Telephone Number";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        String paramStr;
        int msgID;
        int pos;
        String valueString = StaticUtils.toLowerCase(value.stringValue());
        int valueLength = valueString.length();
        if (valueLength == 0) {
            int msgID2 = 6488253;
            invalidReason.append(MessageHandler.getMessage(msgID2));
            return false;
        }
        char c = valueString.charAt(0);
        if (!PrintableString.isPrintableCharacter(c)) {
            int msgID3 = 6488254;
            invalidReason.append(MessageHandler.getMessage(msgID3, valueString, Character.valueOf(c), 0));
            return false;
        }
        for (pos = 1; pos < valueLength; ++pos) {
            c = valueString.charAt(pos);
            if (c == '$') {
                ++pos;
                break;
            }
            if (PrintableString.isPrintableCharacter(c)) continue;
            msgID = 6488254;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), pos));
        }
        if (pos >= valueLength) {
            if (c == '$') {
                msgID = 6488255;
                invalidReason.append(MessageHandler.getMessage(msgID, valueString));
                return false;
            }
            return true;
        }
        int paramStartPos = pos;
        while (pos < valueLength) {
            if ((c = valueString.charAt(pos++)) != '$') continue;
            paramStr = valueString.substring(paramStartPos, pos);
            if (!ALLOWED_FAX_PARAMETERS.contains(paramStr)) {
                int msgID4 = 6488256;
                invalidReason.append(MessageHandler.getMessage(msgID4, valueString, paramStr, paramStartPos, pos - 1));
                return false;
            }
            paramStartPos = pos;
        }
        paramStr = valueString.substring(paramStartPos);
        if (!ALLOWED_FAX_PARAMETERS.contains(paramStr)) {
            int msgID5 = 6488256;
            invalidReason.append(MessageHandler.getMessage(msgID5, valueString, paramStr, paramStartPos, pos - 1));
            return false;
        }
        return true;
    }

    static {
        ALLOWED_FAX_PARAMETERS.add("twodimensional");
        ALLOWED_FAX_PARAMETERS.add("fineresolution");
        ALLOWED_FAX_PARAMETERS.add("unlimitedlength");
        ALLOWED_FAX_PARAMETERS.add("b4length");
        ALLOWED_FAX_PARAMETERS.add("a3width");
        ALLOWED_FAX_PARAMETERS.add("b4width");
        ALLOWED_FAX_PARAMETERS.add("uncompressed");
    }
}

