/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

public class IntegerEqualityMatchingRule
extends EqualityMatchingRule {
    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "integerMatch";
    }

    public String getOID() {
        return "2.5.13.14";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.27";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        int msgID;
        byte[] valueBytes = value.value();
        int length = valueBytes.length;
        StringBuilder buffer = new StringBuilder(length);
        boolean logged = false;
        block41: for (int i = 0; i < length; ++i) {
            switch (valueBytes[i]) {
                case 48: {
                    String message;
                    int msgID2;
                    switch (buffer.length()) {
                        case 0: {
                            if (i == length - 1) {
                                buffer.append("0");
                                continue block41;
                            }
                            msgID2 = 6422571;
                            message = MessageHandler.getMessage(msgID2, value.stringValue());
                            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                                case REJECT: {
                                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID2);
                                }
                                case WARN: {
                                    if (logged) break;
                                    logged = true;
                                    ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, message, msgID2);
                                }
                            }
                            continue block41;
                        }
                        case 1: {
                            if (buffer.charAt(0) == '-') {
                                msgID2 = 6422571;
                                message = MessageHandler.getMessage(msgID2, value.stringValue());
                                switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                                    case REJECT: {
                                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID2);
                                    }
                                    case WARN: {
                                        if (logged) break;
                                        logged = true;
                                        ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, message, msgID2);
                                    }
                                }
                                continue block41;
                            }
                            buffer.append("0");
                            continue block41;
                        }
                    }
                    buffer.append("0");
                    continue block41;
                }
                case 49: {
                    buffer.append('1');
                    continue block41;
                }
                case 50: {
                    buffer.append('2');
                    continue block41;
                }
                case 51: {
                    buffer.append('3');
                    continue block41;
                }
                case 52: {
                    buffer.append('4');
                    continue block41;
                }
                case 53: {
                    buffer.append('5');
                    continue block41;
                }
                case 54: {
                    buffer.append('6');
                    continue block41;
                }
                case 55: {
                    buffer.append('7');
                    continue block41;
                }
                case 56: {
                    buffer.append('8');
                    continue block41;
                }
                case 57: {
                    buffer.append('9');
                    continue block41;
                }
                case 45: {
                    if (buffer.length() == 0) {
                        buffer.append("-");
                        continue block41;
                    }
                    int msgID2 = 6422572;
                    String message = MessageHandler.getMessage(msgID2, value.stringValue());
                    switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                        case REJECT: {
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID2);
                        }
                        case WARN: {
                            if (logged) break;
                            logged = true;
                            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, message, msgID2);
                        }
                    }
                    continue block41;
                }
                default: {
                    int msgID2 = 6422573;
                    String message = MessageHandler.getMessage(msgID2, value.stringValue(), Character.valueOf((char)valueBytes[i]), i);
                    switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                        case REJECT: {
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID2);
                        }
                        case WARN: {
                            if (logged) continue block41;
                            logged = true;
                            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, message, msgID2);
                        }
                    }
                }
            }
        }
        if (buffer.length() == 0) {
            msgID = 6422574;
            String message = MessageHandler.getMessage(msgID, value.stringValue());
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                case WARN: {
                    if (!logged) {
                        logged = true;
                        ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                    }
                    buffer.append("0");
                    break;
                }
                default: {
                    buffer.append("0");
                    break;
                }
            }
        } else if (buffer.length() == 1 && buffer.charAt(0) == '-') {
            msgID = 6422575;
            String message = MessageHandler.getMessage(msgID, value.stringValue());
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                case WARN: {
                    if (!logged) {
                        logged = true;
                        ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                    }
                    buffer.setCharAt(0, '0');
                    break;
                }
                default: {
                    buffer.setCharAt(0, '0');
                }
            }
        }
        return new ASN1OctetString(buffer.toString());
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        return Arrays.equals(value1.value(), value2.value());
    }
}

