/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;
    public static final AttributeValueDecoder<Integer> DECODER = new AttributeValueDecoder<Integer>(){

        @Override
        public Integer decode(AttributeValue value) throws DirectoryException {
            ByteString nvalue = value.getNormalizedValue();
            try {
                return Integer.valueOf(nvalue.stringValue());
            }
            catch (NumberFormatException e) {
                int msgID = 6422788;
                String message = MessageHandler.getMessage(msgID, nvalue.stringValue());
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
        }
    };

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.14");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.14", "Integer");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.15");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.15", "Integer");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.7");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.7", "Integer");
        }
    }

    @Override
    public String getSyntaxName() {
        return "Integer";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.27";
    }

    @Override
    public String getDescription() {
        return "Integer";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        String valueString = value.stringValue();
        int length = valueString.length();
        if (length == 0) {
            invalidReason.append(MessageHandler.getMessage(6422574, valueString));
            return false;
        }
        if (length == 1) {
            switch (valueString.charAt(0)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return true;
                }
                case '-': {
                    int msgID = 6422575;
                    invalidReason.append(MessageHandler.getMessage(msgID, valueString));
                    return false;
                }
            }
            int msgID = 6422573;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(valueString.charAt(0)), 0));
            return false;
        }
        boolean negative = false;
        switch (valueString.charAt(0)) {
            case '0': {
                int msgID = 6422571;
                invalidReason.append(MessageHandler.getMessage(msgID, valueString));
                return false;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            case '-': {
                negative = true;
                break;
            }
            default: {
                int msgID = 6422573;
                invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(valueString.charAt(0)), 0));
                return false;
            }
        }
        switch (valueString.charAt(1)) {
            case '0': {
                if (!negative) break;
                int msgID = 6422571;
                invalidReason.append(MessageHandler.getMessage(msgID, valueString));
                return false;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                break;
            }
            default: {
                int msgID = 6422573;
                invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(valueString.charAt(0)), 0));
                return false;
            }
        }
        block16: for (int i = 2; i < length; ++i) {
            switch (valueString.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block16;
                }
                default: {
                    int msgID = 6422573;
                    invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(valueString.charAt(0)), 0));
                    return false;
                }
            }
        }
        return true;
    }
}

