/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingRuleSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "MatchingRuleDescription");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "MatchingRuleDescription");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "MatchingRuleDescription");
        }
    }

    @Override
    public String getSyntaxName() {
        return "MatchingRuleDescription";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.30";
    }

    @Override
    public String getDescription() {
        return "Matching Rule Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        char c;
        int pos;
        String valueStr = value.stringValue();
        String lowerStr = StaticUtils.toLowerCase(valueStr);
        int length = valueStr.length();
        for (pos = 0; pos < length && valueStr.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            int msgID = 6488213;
            invalidReason.append(MessageHandler.getMessage(msgID));
            return false;
        }
        if ((c = valueStr.charAt(pos++)) != '(') {
            int msgID = 6488214;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr, pos - 1, Character.valueOf(c)));
            return false;
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            int msgID = 6488215;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr));
            return false;
        }
        int oidStartPos = pos;
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        int msgID = 6488216;
                        invalidReason.append(MessageHandler.getMessage(msgID, valueStr, pos - 1));
                        return false;
                    }
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    int msgID = 6488217;
                    invalidReason.append(MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1));
                    return false;
                }
                lastWasPeriod = false;
            }
        } else {
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                int msgID = 6488218;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1));
                return false;
            }
        }
        if (pos >= length) {
            int msgID = 6488215;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr));
            return false;
        }
        String oid = lowerStr.substring(oidStartPos, pos - 1);
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            int msgID = 6488215;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr));
            return false;
        }
        ConcurrentHashMap<String, String> names = new ConcurrentHashMap<String, String>();
        AttributeSyntax syntax = null;
        ConcurrentHashMap<String, CopyOnWriteArrayList<String>> extraProperties = new ConcurrentHashMap<String, CopyOnWriteArrayList<String>>();
        block19: while (true) {
            StringBuilder tokenNameBuffer = new StringBuilder();
            try {
                pos = MatchingRuleSyntax.readTokenName(valueStr, tokenNameBuffer, pos);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                invalidReason.append(de.getErrorMessage());
                return false;
            }
            String tokenName = tokenNameBuffer.toString();
            String lowerTokenName = StaticUtils.toLowerCase(tokenName);
            if (tokenName.equals(")")) {
                if (pos >= length) break;
                int msgID = 6488219;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, pos - 1));
                return false;
            }
            if (lowerTokenName.equals("name")) {
                StringBuilder userBuffer;
                if ((c = valueStr.charAt(pos++)) == '\'') {
                    userBuffer = new StringBuilder();
                    StringBuilder lowerBuffer = new StringBuilder();
                    try {
                        pos = MatchingRuleSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos - 1);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        invalidReason.append(de.getErrorMessage());
                        return false;
                    }
                    names.put(lowerBuffer.toString(), userBuffer.toString());
                    continue;
                }
                if (c == '(') {
                    userBuffer = new StringBuilder();
                    StringBuilder lowerBuffer = new StringBuilder();
                    try {
                        pos = MatchingRuleSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        invalidReason.append(de.getErrorMessage());
                        return false;
                    }
                    names.put(lowerBuffer.toString(), userBuffer.toString());
                    while (true) {
                        if (valueStr.charAt(pos) == ')') {
                            ++pos;
                            while (true) {
                                if (pos >= length || (c = valueStr.charAt(pos)) != ' ') continue block19;
                                ++pos;
                            }
                        }
                        userBuffer = new StringBuilder();
                        lowerBuffer = new StringBuilder();
                        try {
                            pos = MatchingRuleSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            invalidReason.append(de.getErrorMessage());
                            return false;
                        }
                        names.put(lowerBuffer.toString(), userBuffer.toString());
                    }
                }
                int msgID = 6488220;
                invalidReason.append(MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1));
                return false;
            }
            if (lowerTokenName.equals("desc")) {
                StringBuilder descriptionBuffer = new StringBuilder();
                try {
                    pos = MatchingRuleSyntax.readQuotedString(valueStr, descriptionBuffer, pos);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    invalidReason.append(de.getErrorMessage());
                    return false;
                }
            }
            if (lowerTokenName.equals("obsolete")) continue;
            if (lowerTokenName.equals("syntax")) {
                StringBuilder oidBuffer = new StringBuilder();
                try {
                    pos = MatchingRuleSyntax.readWOID(lowerStr, oidBuffer, pos);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    invalidReason.append(de.getErrorMessage());
                    return false;
                }
                syntax = DirectoryServer.getAttributeSyntax(oidBuffer.toString(), false);
                if (syntax != null) continue;
                int msgID = 6488221;
                String message = MessageHandler.getMessage(msgID, valueStr, oidBuffer.toString());
                ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                syntax = DirectoryServer.getDefaultAttributeSyntax();
                continue;
            }
            CopyOnWriteArrayList<String> valueList = new CopyOnWriteArrayList<String>();
            try {
                pos = MatchingRuleSyntax.readExtraParameterValues(valueStr, valueList, pos);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                invalidReason.append(de.getErrorMessage());
                return false;
            }
            extraProperties.put(tokenName, valueList);
        }
        if (syntax == null) {
            int msgID = 6488222;
            invalidReason.append(MessageHandler.getMessage(msgID, valueStr));
            return false;
        }
        return true;
    }

    private static int readTokenName(String valueStr, StringBuilder tokenName, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488215;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
            tokenName.append(c);
        }
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, StringBuilder valueBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488215;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (c != '\'') {
            int msgID = 6488223;
            String message = MessageHandler.getMessage(msgID, valueStr, startPos, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
            valueBuffer.append(c);
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488215;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, String lowerStr, StringBuilder userBuffer, StringBuilder lowerBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488215;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (c != '\'') {
            int msgID = 6488223;
            String message = MessageHandler.getMessage(msgID, valueStr, startPos, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) != '\'') {
            lowerBuffer.append(c);
            userBuffer.append(valueStr.charAt(startPos));
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488215;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    private static int readWOID(String lowerStr, StringBuilder woidBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488135;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        int msgID = 6488136;
                        String message = MessageHandler.getMessage(msgID, lowerStr, startPos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                    }
                    woidBuffer.append(c);
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return startPos - 1;
                    }
                    int msgID = 6488137;
                    String message = MessageHandler.getMessage(msgID, lowerStr, Character.valueOf(c), startPos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                woidBuffer.append(c);
                lastWasPeriod = false;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    woidBuffer.append(c);
                    continue;
                }
                if (c == ')') {
                    return startPos - 1;
                }
                int msgID = 6488138;
                String message = MessageHandler.getMessage(msgID, lowerStr, Character.valueOf(c), startPos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
        } else {
            int msgID = 6488139;
            String message = MessageHandler.getMessage(msgID, lowerStr, Character.valueOf(c), startPos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488135;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    private static int readExtraParameterValues(String valueStr, CopyOnWriteArrayList<String> valueList, int startPos) throws DirectoryException {
        StringBuilder valueBuffer;
        int length = valueStr.length();
        char c = valueStr.charAt(startPos++);
        while (startPos < length && c == ' ') {
            c = valueStr.charAt(startPos++);
        }
        if (startPos >= length) {
            int msgID = 6488215;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (c == '\'') {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != '\'') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        } else if (c == '(') {
            while (true) {
                ++startPos;
                while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
                    ++startPos;
                }
                if (startPos >= length) {
                    int msgID = 6488215;
                    String message = MessageHandler.getMessage(msgID, valueStr);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                if (c != ')') {
                    if (c == '(') {
                        int msgID = 6488220;
                        String message = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), startPos);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                    }
                    startPos = MatchingRuleSyntax.readExtraParameterValues(valueStr, valueList, startPos);
                    continue;
                }
                break;
            }
        } else {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        }
        while (startPos < length && valueStr.charAt(startPos) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488215;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }
}

