/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameFormSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException, InitializationException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            int msgID = 6553602;
            String message = MessageHandler.getMessage(msgID, "2.5.13.2", "NameFormDescription");
            throw new InitializationException(msgID, message);
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            int msgID = 6553603;
            String message = MessageHandler.getMessage(msgID, "2.5.13.3", "NameFormDescription");
            throw new InitializationException(msgID, message);
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            int msgID = 0x640004;
            String message = MessageHandler.getMessage(msgID, "2.5.13.4", "NameFormDescription");
            throw new InitializationException(msgID, message);
        }
    }

    @Override
    public String getSyntaxName() {
        return "NameFormDescription";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.35";
    }

    @Override
    public String getDescription() {
        return "Name Form Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        try {
            NameFormSyntax.decodeNameForm(value, DirectoryServer.getSchema(), true);
            return true;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            invalidReason.append(de.getErrorMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static NameForm decodeNameForm(ByteString value, Schema schema, boolean allowUnknownElements) throws DirectoryException {
        char c;
        int pos;
        String valueStr = value.stringValue();
        String lowerStr = StaticUtils.toLowerCase(valueStr);
        int length = valueStr.length();
        for (pos = 0; pos < length && valueStr.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            int msgID = 6488199;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if ((c = valueStr.charAt(pos++)) != '(') {
            int msgID = 6488200;
            String message = MessageHandler.getMessage(msgID, valueStr, pos - 1, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            int msgID = 6488201;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        int oidStartPos = pos;
        if (!StaticUtils.isDigit(c)) {
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                int msgID = 6488204;
                String message = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
        } else {
            boolean lastWasPeriod = false;
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        int msgID = 6488202;
                        String message = MessageHandler.getMessage(msgID, valueStr, pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                    }
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    int msgID = 6488203;
                    String message = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                lastWasPeriod = false;
            }
        }
        if (pos >= length) {
            int msgID = 6488201;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        String oid = lowerStr.substring(oidStartPos, pos - 1);
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            int msgID = 6488201;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
        String description = null;
        boolean isObsolete = false;
        ObjectClass structuralClass = null;
        LinkedHashSet<AttributeType> requiredAttributes = new LinkedHashSet<AttributeType>();
        LinkedHashSet<AttributeType> optionalAttributes = new LinkedHashSet<AttributeType>();
        LinkedHashMap<String, List<String>> extraProperties = new LinkedHashMap<String, List<String>>();
        block5: while (true) {
            LinkedList<AttributeType> attrs;
            block39: {
                AttributeType attr;
                StringBuilder woidBuffer;
                block47: {
                    block38: {
                        block45: {
                            StringBuilder lowerBuffer;
                            StringBuilder userBuffer;
                            block43: {
                                block41: {
                                    String tokenName;
                                    block46: {
                                        String lowerTokenName;
                                        block44: {
                                            block42: {
                                                String message;
                                                block40: {
                                                    StringBuilder tokenNameBuffer = new StringBuilder();
                                                    pos = NameFormSyntax.readTokenName(valueStr, tokenNameBuffer, pos);
                                                    tokenName = tokenNameBuffer.toString();
                                                    lowerTokenName = StaticUtils.toLowerCase(tokenName);
                                                    if (!tokenName.equals(")")) break block40;
                                                    if (pos < length) {
                                                        int msgID = 6488205;
                                                        message = MessageHandler.getMessage(msgID, valueStr, pos - 1);
                                                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                                                    }
                                                    break block41;
                                                }
                                                if (!lowerTokenName.equals("name")) break block42;
                                                if ((c = valueStr.charAt(pos++)) == '\'') {
                                                    userBuffer = new StringBuilder();
                                                    lowerBuffer = new StringBuilder();
                                                    pos = NameFormSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos - 1);
                                                    names.put(lowerBuffer.toString(), userBuffer.toString());
                                                    continue;
                                                }
                                                if (c != '(') {
                                                    int msgID = 6488206;
                                                    message = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                                                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                                                }
                                                break block43;
                                            }
                                            if (lowerTokenName.equals("desc")) {
                                                StringBuilder descriptionBuffer = new StringBuilder();
                                                pos = NameFormSyntax.readQuotedString(valueStr, descriptionBuffer, pos);
                                                description = descriptionBuffer.toString();
                                                continue;
                                            }
                                            if (lowerTokenName.equals("obsolete")) {
                                                isObsolete = true;
                                                continue;
                                            }
                                            if (lowerTokenName.equals("oc")) {
                                                String message;
                                                StringBuilder woidBuffer2 = new StringBuilder();
                                                pos = NameFormSyntax.readWOID(lowerStr, woidBuffer2, pos);
                                                structuralClass = schema.getObjectClass(woidBuffer2.toString());
                                                if (structuralClass == null) {
                                                    if (!allowUnknownElements) {
                                                        int msgID = 6488207;
                                                        message = MessageHandler.getMessage(msgID, String.valueOf(oid), String.valueOf(woidBuffer2));
                                                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                                                    }
                                                    structuralClass = DirectoryServer.getDefaultObjectClass(woidBuffer2.toString());
                                                    continue;
                                                }
                                                if (structuralClass.getObjectClassType() == ObjectClassType.STRUCTURAL) continue;
                                                int msgID = 6488208;
                                                message = MessageHandler.getMessage(msgID, String.valueOf(oid), String.valueOf(woidBuffer2), structuralClass.getNameOrOID(), String.valueOf((Object)structuralClass.getObjectClassType()));
                                                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                                            }
                                            if (!lowerTokenName.equals("must")) break block44;
                                            attrs = new LinkedList<AttributeType>();
                                            if ((c = valueStr.charAt(pos++)) == '(') break block45;
                                            woidBuffer = new StringBuilder();
                                            pos = NameFormSyntax.readWOID(lowerStr, woidBuffer, pos - 1);
                                            attr = schema.getAttributeType(woidBuffer.toString());
                                            if (attr == null) {
                                                if (!allowUnknownElements) {
                                                    int msgID = 6488209;
                                                    String message = MessageHandler.getMessage(msgID, oid, woidBuffer.toString());
                                                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                                                }
                                                attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                                            }
                                            attrs.add(attr);
                                            break block38;
                                        }
                                        if (!lowerTokenName.equals("may")) break block46;
                                        attrs = new LinkedList();
                                        if ((c = valueStr.charAt(pos++)) == '(') break block47;
                                        woidBuffer = new StringBuilder();
                                        pos = NameFormSyntax.readWOID(lowerStr, woidBuffer, pos - 1);
                                        attr = schema.getAttributeType(woidBuffer.toString());
                                        if (attr == null) {
                                            if (!allowUnknownElements) {
                                                int msgID = 6488210;
                                                String message = MessageHandler.getMessage(msgID, oid, woidBuffer.toString());
                                                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                                            }
                                            attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                                        }
                                        attrs.add(attr);
                                        break block39;
                                    }
                                    LinkedList<String> valueList = new LinkedList<String>();
                                    pos = NameFormSyntax.readExtraParameterValues(valueStr, valueList, pos);
                                    extraProperties.put(tokenName, valueList);
                                    continue;
                                }
                                if (structuralClass == null) {
                                    int msgID = 6488211;
                                    String message = MessageHandler.getMessage(msgID, valueStr);
                                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                                }
                                return new NameForm(value.stringValue(), names, oid, description, isObsolete, structuralClass, requiredAttributes, optionalAttributes, extraProperties);
                            }
                            userBuffer = new StringBuilder();
                            lowerBuffer = new StringBuilder();
                            pos = NameFormSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                            names.put(lowerBuffer.toString(), userBuffer.toString());
                            while (true) {
                                if (valueStr.charAt(pos) == ')') {
                                    ++pos;
                                    while (true) {
                                        if (pos >= length || (c = valueStr.charAt(pos)) != ' ') continue block5;
                                        ++pos;
                                    }
                                }
                                userBuffer = new StringBuilder();
                                lowerBuffer = new StringBuilder();
                                pos = NameFormSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                                names.put(lowerBuffer.toString(), userBuffer.toString());
                            }
                        }
                        do {
                            woidBuffer = new StringBuilder();
                            pos = NameFormSyntax.readWOID(lowerStr, woidBuffer, pos);
                            attr = schema.getAttributeType(woidBuffer.toString());
                            if (attr == null) {
                                if (!allowUnknownElements) {
                                    int msgID = 6488209;
                                    String message = MessageHandler.getMessage(msgID, oid, woidBuffer.toString());
                                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                                }
                                attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                            }
                            attrs.add(attr);
                            c = valueStr.charAt(pos++);
                            if (c == ')') break block38;
                        } while (c == '$');
                        int msgID = 6488206;
                        String message = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                    }
                    requiredAttributes.addAll(attrs);
                    continue;
                }
                do {
                    woidBuffer = new StringBuilder();
                    pos = NameFormSyntax.readWOID(lowerStr, woidBuffer, pos);
                    attr = schema.getAttributeType(woidBuffer.toString());
                    if (attr == null) {
                        if (!allowUnknownElements) {
                            int msgID = 6488210;
                            String message = MessageHandler.getMessage(msgID, oid, woidBuffer.toString());
                            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                        }
                        attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                    }
                    attrs.add(attr);
                    c = valueStr.charAt(pos++);
                    if (c == ')') break block39;
                } while (c == '$');
                int msgID = 6488206;
                String message = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
            optionalAttributes.addAll(attrs);
        }
    }

    private static int readTokenName(String valueStr, StringBuilder tokenName, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488201;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
            tokenName.append(c);
        }
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, StringBuilder valueBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488201;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (c != '\'') {
            int msgID = 6488212;
            String message = MessageHandler.getMessage(msgID, valueStr, startPos, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
            valueBuffer.append(c);
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488201;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, String lowerStr, StringBuilder userBuffer, StringBuilder lowerBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488201;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (c != '\'') {
            int msgID = 6488212;
            String message = MessageHandler.getMessage(msgID, valueStr, startPos, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) != '\'') {
            lowerBuffer.append(c);
            userBuffer.append(valueStr.charAt(startPos));
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488201;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    private static int readWOID(String lowerStr, StringBuilder woidBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488201;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        int msgID = 6488202;
                        String message = MessageHandler.getMessage(msgID, lowerStr, startPos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                    }
                    woidBuffer.append(c);
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return startPos - 1;
                    }
                    int msgID = 6488203;
                    String message = MessageHandler.getMessage(msgID, lowerStr, Character.valueOf(c), startPos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                woidBuffer.append(c);
                lastWasPeriod = false;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    woidBuffer.append(c);
                    continue;
                }
                if (c == ')') {
                    return startPos - 1;
                }
                int msgID = 6488204;
                String message = MessageHandler.getMessage(msgID, lowerStr, Character.valueOf(c), startPos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
            }
        } else {
            int msgID = 6488206;
            String message = MessageHandler.getMessage(msgID, lowerStr, Character.valueOf(c), startPos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488201;
            String message = MessageHandler.getMessage(msgID, lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }

    private static int readExtraParameterValues(String valueStr, List<String> valueList, int startPos) throws DirectoryException {
        StringBuilder valueBuffer;
        int length = valueStr.length();
        char c = valueStr.charAt(startPos++);
        while (startPos < length && c == ' ') {
            c = valueStr.charAt(startPos++);
        }
        if (startPos >= length) {
            int msgID = 6488201;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (c == '\'') {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != '\'') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        } else if (c == '(') {
            while (true) {
                ++startPos;
                while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
                    ++startPos;
                }
                if (startPos >= length) {
                    int msgID = 6488201;
                    String message = MessageHandler.getMessage(msgID, valueStr);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                if (c != ')') {
                    if (c == '(') {
                        int msgID = 6488206;
                        String message = MessageHandler.getMessage(msgID, valueStr, Character.valueOf(c), startPos);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                    }
                    startPos = NameFormSyntax.readExtraParameterValues(valueStr, valueList, startPos);
                    continue;
                }
                break;
            }
        } else {
            valueBuffer = new StringBuilder();
            while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
                valueBuffer.append(c);
            }
            valueList.add(valueBuffer.toString());
        }
        while (startPos < length && valueStr.charAt(startPos) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            int msgID = 6488201;
            String message = MessageHandler.getMessage(msgID, valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return startPos;
    }
}

