/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OtherMailboxSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.11");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.11", "OtherMailbox");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.12");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.12", "OtherMailbox");
        }
    }

    @Override
    public String getSyntaxName() {
        return "OtherMailbox";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.39";
    }

    @Override
    public String getDescription() {
        return "Other Mailbox";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return null;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        char c;
        int pos;
        if (value == null) {
            int msgID = 6488264;
            invalidReason.append(MessageHandler.getMessage(msgID));
            return false;
        }
        String valueString = value.stringValue();
        int valueLength = valueString.length();
        if (valueLength == 0) {
            int msgID = 6488264;
            invalidReason.append(MessageHandler.getMessage(msgID));
            return false;
        }
        for (pos = 0; pos < valueLength; ++pos) {
            c = valueString.charAt(pos);
            if (c == '$') {
                if (pos == 0) {
                    int msgID = 6488265;
                    invalidReason.append(MessageHandler.getMessage(msgID, valueString));
                    return false;
                }
                ++pos;
                break;
            }
            if (PrintableString.isPrintableCharacter(c)) continue;
            int msgID = 6488266;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), pos));
            return false;
        }
        if (pos >= valueLength) {
            int msgID = 6488267;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString));
            return false;
        }
        while (pos < valueLength) {
            c = valueString.charAt(pos);
            if (c != (c & 0x7F)) {
                int msgID = 6488268;
                invalidReason.append(MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), pos));
                return false;
            }
            ++pos;
        }
        return true;
    }
}

