/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTCTimeSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static ReentrantLock dateFormatLock;
    private static SimpleDateFormat dateFormat;
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.27");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.27", "UTCTime");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.28");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.28", "UTCTime");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "UTCTime");
        }
    }

    @Override
    public String getSyntaxName() {
        return "UTCTime";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.53";
    }

    @Override
    public String getDescription() {
        return "UTC Time";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        String valueString = value.stringValue().toUpperCase();
        int length = valueString.length();
        if (length < 11) {
            int msgID = 6488173;
            String message = MessageHandler.getMessage(msgID, valueString);
            invalidReason.append(message);
            return false;
        }
        block56: for (int i = 0; i < 2; ++i) {
            switch (valueString.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block56;
                }
                default: {
                    int msgID = 6488174;
                    String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(valueString.charAt(i)));
                    invalidReason.append(message);
                    return false;
                }
            }
        }
        char m1 = valueString.charAt(2);
        char m2 = valueString.charAt(3);
        block3 : switch (m1) {
            case '0': {
                switch (m2) {
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block3;
                    }
                }
                int msgID = 6488175;
                String message = MessageHandler.getMessage(msgID, valueString, valueString.substring(2, 4));
                invalidReason.append(message);
                return false;
            }
            case '1': {
                switch (m2) {
                    case '0': 
                    case '1': 
                    case '2': {
                        break block3;
                    }
                }
                int msgID = 6488175;
                String message = MessageHandler.getMessage(msgID, valueString, valueString.substring(2, 4));
                invalidReason.append(message);
                return false;
            }
            default: {
                int msgID = 6488175;
                String message = MessageHandler.getMessage(msgID, valueString, valueString.substring(2, 4));
                invalidReason.append(message);
                return false;
            }
        }
        char d1 = valueString.charAt(4);
        char d2 = valueString.charAt(5);
        block13 : switch (d1) {
            case '0': {
                switch (d2) {
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block13;
                    }
                }
                int msgID = 6488176;
                String message = MessageHandler.getMessage(msgID, valueString, valueString.substring(4, 6));
                invalidReason.append(message);
                return false;
            }
            case '1': 
            case '2': {
                switch (d2) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block13;
                    }
                }
                int msgID = 6488176;
                String message = MessageHandler.getMessage(msgID, valueString, valueString.substring(4, 6));
                invalidReason.append(message);
                return false;
            }
            case '3': {
                switch (d2) {
                    case '0': 
                    case '1': {
                        break block13;
                    }
                }
                int msgID = 6488176;
                String message = MessageHandler.getMessage(msgID, valueString, valueString.substring(4, 6));
                invalidReason.append(message);
                return false;
            }
            default: {
                int msgID = 6488176;
                String message = MessageHandler.getMessage(msgID, valueString, valueString.substring(4, 6));
                invalidReason.append(message);
                return false;
            }
        }
        char h1 = valueString.charAt(6);
        char h2 = valueString.charAt(7);
        block27 : switch (h1) {
            case '0': 
            case '1': {
                switch (h2) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block27;
                    }
                }
                int msgID = 6488177;
                String message = MessageHandler.getMessage(msgID, valueString, valueString.substring(6, 8));
                invalidReason.append(message);
                return false;
            }
            case '2': {
                switch (h2) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        break block27;
                    }
                }
                int msgID = 6488177;
                String message = MessageHandler.getMessage(msgID, valueString, valueString.substring(6, 8));
                invalidReason.append(message);
                return false;
            }
            default: {
                int msgID = 6488177;
                String message = MessageHandler.getMessage(msgID, valueString, valueString.substring(6, 8));
                invalidReason.append(message);
                return false;
            }
        }
        m1 = valueString.charAt(8);
        block37 : switch (m1) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (length < 11) {
                    int msgID = 6488179;
                    String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(m1), 8);
                    invalidReason.append(message);
                    return false;
                }
                switch (valueString.charAt(9)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block37;
                    }
                }
                int msgID = 6488178;
                String message = MessageHandler.getMessage(msgID, valueString, valueString.substring(8, 10));
                invalidReason.append(message);
                return false;
            }
            default: {
                int msgID = 6488179;
                String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(m1), 8);
                invalidReason.append(message);
                return false;
            }
        }
        char s1 = valueString.charAt(10);
        block43 : switch (s1) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (length < 13) {
                    int msgID = 6488179;
                    String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(s1), 10);
                    invalidReason.append(message);
                    return false;
                }
                switch (valueString.charAt(11)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block43;
                    }
                }
                int msgID = 6488180;
                String message = MessageHandler.getMessage(msgID, valueString, valueString.substring(10, 12));
                invalidReason.append(message);
                return false;
            }
            case '6': {
                if (length < 13) {
                    int msgID = 6488179;
                    String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(s1), 10);
                    invalidReason.append(message);
                    return false;
                }
                if (valueString.charAt(11) == '0') break;
                int msgID = 6488180;
                String message = MessageHandler.getMessage(msgID, valueString, valueString.substring(10, 12));
                invalidReason.append(message);
                return false;
            }
            case 'Z': {
                if (length == 11) {
                    return true;
                }
                int msgID = 6488179;
                String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(s1), 10);
                invalidReason.append(message);
                return false;
            }
            case '+': 
            case '-': {
                if (length == 15) {
                    return this.hasValidOffset(valueString, 11, invalidReason);
                }
                int msgID = 6488179;
                String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(s1), 10);
                invalidReason.append(message);
                return false;
            }
            default: {
                int msgID = 6488179;
                String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(s1), 10);
                invalidReason.append(message);
                return false;
            }
        }
        switch (valueString.charAt(12)) {
            case 'Z': {
                if (length == 13) {
                    return true;
                }
                int msgID = 6488179;
                String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(valueString.charAt(12)), 12);
                invalidReason.append(message);
                return false;
            }
            case '+': 
            case '-': {
                if (length == 17 || length == 15) {
                    return this.hasValidOffset(valueString, 13, invalidReason);
                }
                int msgID = 6488179;
                String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(valueString.charAt(12)), 12);
                invalidReason.append(message);
                return false;
            }
        }
        int msgID = 6488179;
        String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(valueString.charAt(12)), 12);
        invalidReason.append(message);
        return false;
    }

    private boolean hasValidOffset(String value, int startPos, StringBuilder invalidReason) {
        int offsetLength = value.length() - startPos;
        if (offsetLength < 2) {
            int msgID = 6488173;
            String message = MessageHandler.getMessage(msgID, value);
            invalidReason.append(message);
            return false;
        }
        block0 : switch (value.charAt(startPos)) {
            case '0': 
            case '1': {
                switch (value.charAt(startPos + 1)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block0;
                    }
                }
                int msgID = 6488181;
                String message = MessageHandler.getMessage(msgID, value, value.substring(startPos, startPos + offsetLength));
                invalidReason.append(message);
                return false;
            }
            case '2': {
                switch (value.charAt(startPos + 1)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        break block0;
                    }
                }
                int msgID = 6488181;
                String message = MessageHandler.getMessage(msgID, value, value.substring(startPos, startPos + offsetLength));
                invalidReason.append(message);
                return false;
            }
            default: {
                int msgID = 6488181;
                String message = MessageHandler.getMessage(msgID, value, value.substring(startPos, startPos + offsetLength));
                invalidReason.append(message);
                return false;
            }
        }
        if (offsetLength == 4) {
            block10 : switch (value.charAt(startPos + 2)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': {
                    switch (value.charAt(startPos + 3)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break block10;
                        }
                    }
                    int msgID = 6488181;
                    String message = MessageHandler.getMessage(msgID, value, value.substring(startPos, startPos + offsetLength));
                    invalidReason.append(message);
                    return false;
                }
                default: {
                    int msgID = 6488181;
                    String message = MessageHandler.getMessage(msgID, value, value.substring(startPos, startPos + offsetLength));
                    invalidReason.append(message);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttributeValue createUTCTimeValue(Date d) {
        String valueString;
        dateFormatLock.lock();
        try {
            valueString = dateFormat.format(d);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            valueString = null;
        }
        finally {
            dateFormatLock.unlock();
        }
        return new AttributeValue(new ASN1OctetString(valueString), (ByteString)new ASN1OctetString(valueString));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Date decodeUTCTimeValue(ByteString normalizedValue) throws DirectoryException {
        String valueString = normalizedValue.stringValue();
        try {
            dateFormatLock.lock();
            try {
                Date date = dateFormat.parse(valueString);
                return date;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                dateFormatLock.unlock();
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 6488182;
            String message = MessageHandler.getMessage(msgID, valueString, String.valueOf(e));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID, e);
        }
    }

    static {
        dateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormatLock = new ReentrantLock();
    }
}

