/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UUIDSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("1.3.6.1.1.16.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "1.3.6.1.1.16.2", "UUID");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("1.3.6.1.1.16.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "1.3.6.1.1.16.3", "UUID");
        }
    }

    @Override
    public String getSyntaxName() {
        return "UUID";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.1.16.1";
    }

    @Override
    public String getDescription() {
        return "UUID";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return null;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        String valueString = value.stringValue();
        if (valueString.length() != 36) {
            int msgID = 6422764;
            invalidReason.append(MessageHandler.getMessage(msgID, valueString, valueString.length()));
            return false;
        }
        block6: for (int i = 0; i < 36; ++i) {
            switch (i) {
                case 8: 
                case 13: 
                case 18: 
                case 23: {
                    if (valueString.charAt(i) == '-') continue block6;
                    int msgID = 6422765;
                    invalidReason.append(MessageHandler.getMessage(msgID, valueString, i, Character.valueOf(valueString.charAt(i))));
                    return false;
                }
                default: {
                    switch (valueString.charAt(i)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'f': {
                            continue block6;
                        }
                    }
                    int msgID = 6422766;
                    invalidReason.append(MessageHandler.getMessage(msgID, valueString, i, Character.valueOf(valueString.charAt(i))));
                    return false;
                }
            }
        }
        return true;
    }
}

