/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.admin.std.server.EqualityMatchingRuleCfg;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class UniqueMemberEqualityMatchingRule
extends EqualityMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public void initializeMatchingRule(EqualityMatchingRuleCfg configuration) throws ConfigException, InitializationException {
    }

    public String getName() {
        return "uniqueMemberMatch";
    }

    public String getOID() {
        return "2.5.13.23";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.34";
    }

    public ByteString normalizeValue(ByteString value) throws DirectoryException {
        int valueLength;
        String valueString = value.stringValue().trim();
        int dnEndPos = valueLength = valueString.length();
        int sharpPos = -1;
        if ((valueString.endsWith("'B") || valueString.endsWith("'b")) && (sharpPos = valueString.lastIndexOf("#'")) > 0) {
            dnEndPos = sharpPos;
        }
        StringBuilder valueBuffer = new StringBuilder(valueLength);
        try {
            DN dn = DN.decode(valueString.substring(0, dnEndPos));
            dn.toNormalizedString(valueBuffer);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 6488257;
            String message = MessageHandler.getMessage(msgID, valueString, StaticUtils.getExceptionMessage(e));
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                }
                case WARN: {
                    ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.MILD_ERROR, message, msgID);
                    valueBuffer.append(StaticUtils.toLowerCase(valueString).substring(0, dnEndPos));
                    break;
                }
                default: {
                    valueBuffer.append(StaticUtils.toLowerCase(valueString).substring(0, dnEndPos));
                }
            }
        }
        if (sharpPos > 0) {
            valueBuffer.append("#'");
            int endPos = valueLength - 2;
            boolean logged = false;
            block10: for (int i = sharpPos + 2; i < endPos; ++i) {
                char c = valueString.charAt(i);
                if (c == '0' || c == '1') {
                    valueBuffer.append(c);
                    continue;
                }
                int msgID = 6488258;
                String message = MessageHandler.getMessage(msgID, valueString, Character.valueOf(c), i);
                switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                    case REJECT: {
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
                    }
                    case WARN: {
                        if (logged) continue block10;
                        ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.MILD_ERROR, message, msgID);
                        logged = true;
                    }
                }
            }
            valueBuffer.append("'B");
        }
        return new ASN1OctetString(valueBuffer.toString());
    }

    public boolean areEqual(ByteString value1, ByteString value2) {
        return Arrays.equals(value1.value(), value2.value());
    }
}

