/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserPasswordSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("1.3.6.1.4.1.26027.1.4.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "ds-mr-user-password-exact", "ds-syntax-user-password");
        }
    }

    @Override
    public String getSyntaxName() {
        return "ds-syntax-user-password";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.26027.1.3.1";
    }

    @Override
    public String getDescription() {
        return "User Password Syntax";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return null;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return null;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString value, StringBuilder invalidReason) {
        return true;
    }

    public static String[] decodeUserPassword(String userPasswordValue) throws DirectoryException {
        if (userPasswordValue == null || userPasswordValue.length() == 0) {
            int msgID = 6553853;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        if (userPasswordValue.charAt(0) != '{') {
            int msgID = 6553854;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        int closePos = userPasswordValue.indexOf(125);
        if (closePos < 0) {
            int msgID = 6553855;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        String schemeName = userPasswordValue.substring(1, closePos);
        String encodedValue = userPasswordValue.substring(closePos + 1);
        if (schemeName.length() == 0) {
            int msgID = 6553856;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, msgID);
        }
        return new String[]{StaticUtils.toLowerCase(schemeName), encodedValue};
    }

    public static boolean isEncoded(ByteString value) {
        byte[] valueBytes;
        if (value == null || (valueBytes = value.value()).length == 0) {
            return false;
        }
        if (valueBytes[0] != 123) {
            return false;
        }
        int closingBracePos = -1;
        for (int i = 1; i < valueBytes.length; ++i) {
            if (valueBytes[i] != 125) continue;
            closingBracePos = i;
            break;
        }
        if (closingBracePos < 0 || closingBracePos == 1) {
            return false;
        }
        return closingBracePos != valueBytes.length - 1;
    }
}

