/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SchemaConfigManager;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.Modification;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

public class AddSchemaFileTask
extends Task {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    TreeSet<String> filesToAdd;

    public void initializeTask() throws DirectoryException {
        AttributeType attrType;
        ClientConnection clientConnection;
        Operation operation = this.getOperation();
        if (operation != null && !(clientConnection = operation.getClientConnection()).hasPrivilege(Privilege.UPDATE_SCHEMA, operation)) {
            int msgID = 11796490;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
        }
        Entry taskEntry = this.getTaskEntry();
        List<Attribute> attrList = taskEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-task-schema-file-name", true));
        if (attrList == null || attrList.isEmpty()) {
            int msgID = 11796485;
            String message = MessageHandler.getMessage(msgID, "ds-task-schema-file-name", String.valueOf(taskEntry.getDN()));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
        }
        String schemaDirectory = SchemaConfigManager.getSchemaDirectoryPath();
        this.filesToAdd = new TreeSet();
        for (Attribute a : attrList) {
            for (AttributeValue v : a.getValues()) {
                String filename = v.getStringValue();
                this.filesToAdd.add(filename);
                try {
                    File schemaFile = new File(schemaDirectory, filename);
                    if (schemaFile.exists() && schemaFile.getParent().equals(schemaDirectory)) continue;
                    int msgID = 11796486;
                    String message = MessageHandler.getMessage(msgID, filename, schemaDirectory);
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    int msgID = 11796487;
                    String message = MessageHandler.getMessage(msgID, filename, schemaDirectory, StaticUtils.getExceptionMessage(e));
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, msgID, e);
                }
            }
        }
        Schema schema = DirectoryServer.getSchema().duplicate();
        for (String schemaFile : this.filesToAdd) {
            String message;
            try {
                SchemaConfigManager.loadSchemaFile(schema, schemaFile);
            }
            catch (ConfigException ce) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ce);
                }
                int msgID = 11796488;
                message = MessageHandler.getMessage(msgID, String.valueOf(schemaFile), ce.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, ce);
            }
            catch (InitializationException ie) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                }
                int msgID = 11796488;
                message = MessageHandler.getMessage(msgID, String.valueOf(schemaFile), ie.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, msgID, ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    protected TaskState runTask() {
        DN schemaDN = DirectoryServer.getSchemaDN();
        Lock schemaLock = LockManager.lockWrite(schemaDN);
        for (int i = 0; schemaLock == null && i < 3; ++i) {
            schemaLock = LockManager.lockWrite(schemaDN);
        }
        if (schemaLock == null) {
            int msgID = 11796489;
            String message = MessageHandler.getMessage(msgID, String.valueOf(schemaDN));
            this.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return TaskState.STOPPED_BY_ERROR;
        }
        try {
            String message;
            LinkedList<Modification> mods = new LinkedList<Modification>();
            Schema schema = DirectoryServer.getSchema().duplicate();
            for (String schemaFile : this.filesToAdd) {
                TaskState taskState;
                try {
                    List<Modification> modList = SchemaConfigManager.loadSchemaFile(schema, schemaFile);
                    for (Modification m : modList) {
                        Attribute a = m.getAttribute();
                        LinkedHashSet<AttributeValue> valuesWithFileElement = new LinkedHashSet<AttributeValue>();
                        for (AttributeValue v : a.getValues()) {
                            String s = v.getStringValue();
                            if (s.indexOf("X-SCHEMA-FILE") < 0) {
                                if (s.endsWith(" )")) {
                                    s = s.substring(0, s.length() - 1) + "X-SCHEMA-FILE" + " '" + schemaFile + "' )";
                                } else if (s.endsWith(")")) {
                                    s = s.substring(0, s.length() - 1) + " " + "X-SCHEMA-FILE" + " '" + schemaFile + "' )";
                                }
                            }
                            valuesWithFileElement.add(new AttributeValue(a.getAttributeType(), s));
                        }
                        Attribute attrWithFile = new Attribute(a.getAttributeType(), a.getName(), valuesWithFileElement);
                        mods.add(new Modification(m.getModificationType(), attrWithFile));
                    }
                }
                catch (ConfigException ce) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ce);
                    }
                    int msgID = 11796488;
                    message = MessageHandler.getMessage(msgID, String.valueOf(schemaFile), ce.getMessage());
                    this.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    taskState = TaskState.STOPPED_BY_ERROR;
                    LockManager.unlock(schemaDN, schemaLock);
                    return taskState;
                }
                catch (InitializationException ie) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, ie);
                    }
                    int msgID = 11796488;
                    message = MessageHandler.getMessage(msgID, String.valueOf(schemaFile), ie.getMessage());
                    this.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    taskState = TaskState.STOPPED_BY_ERROR;
                    LockManager.unlock(schemaDN, schemaLock);
                    return taskState;
                }
            }
            if (!mods.isEmpty()) {
                for (SynchronizationProvider provider : DirectoryServer.getSynchronizationProviders()) {
                    try {
                        provider.processSchemaChange(mods);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        int msgID = 11796497;
                        message = MessageHandler.getMessage(msgID, provider.getClass().getName(), StaticUtils.getExceptionMessage(e));
                        this.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    }
                }
                Schema.writeConcatenatedSchema();
            }
            schema.setYoungestModificationTime(System.currentTimeMillis());
            DirectoryServer.setSchema(schema);
            TaskState taskState = TaskState.COMPLETED_SUCCESSFULLY;
            return taskState;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            LockManager.unlock(schemaDN, schemaLock);
        }
    }
}

