/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class BackupTask
extends Task {
    private boolean backUpAll;
    private boolean compress;
    private boolean encrypt;
    private boolean hash;
    private boolean incremental;
    private boolean signHash;
    private List<String> backendIDList;
    private String backupID;
    private File backupDirectory;
    private String incrementalBase;
    private Map<String, ConfigEntry> configEntries;
    private ArrayList<Backend> backendsToArchive;

    public void initializeTask() throws DirectoryException {
        ClientConnection clientConnection;
        Operation operation = this.getOperation();
        if (operation != null && !(clientConnection = operation.getClientConnection()).hasPrivilege(Privilege.BACKEND_BACKUP, operation)) {
            int msgID = 0xB4000B;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
        }
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeBackupAll = DirectoryServer.getAttributeType("ds-task-backup-all", true);
        AttributeType typeCompress = DirectoryServer.getAttributeType("ds-task-backup-compress", true);
        AttributeType typeEncrypt = DirectoryServer.getAttributeType("ds-task-backup-encrypt", true);
        AttributeType typeHash = DirectoryServer.getAttributeType("ds-task-backup-hash", true);
        AttributeType typeIncremental = DirectoryServer.getAttributeType("ds-task-backup-incremental", true);
        AttributeType typeSignHash = DirectoryServer.getAttributeType("ds-task-backup-sign-hash", true);
        AttributeType typeBackendID = DirectoryServer.getAttributeType("ds-task-backup-backend-id", true);
        AttributeType typeBackupID = DirectoryServer.getAttributeType("ds-backup-id", true);
        AttributeType typeBackupDirectory = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        AttributeType typeIncrementalBaseID = DirectoryServer.getAttributeType("ds-task-backup-incremental-base-id", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeBackupAll);
        this.backUpAll = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeCompress);
        this.compress = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeEncrypt);
        this.encrypt = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeHash);
        this.hash = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeIncremental);
        this.incremental = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeSignHash);
        this.signHash = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeBackendID);
        this.backendIDList = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeBackupID);
        this.backupID = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeBackupDirectory);
        String backupDirectoryPath = TaskUtils.getSingleValueString(attrList);
        this.backupDirectory = new File(backupDirectoryPath);
        if (!this.backupDirectory.isAbsolute()) {
            this.backupDirectory = new File(DirectoryServer.getServerRoot(), backupDirectoryPath);
        }
        attrList = taskEntry.getAttribute(typeIncrementalBaseID);
        this.incrementalBase = TaskUtils.getSingleValueString(attrList);
        this.configEntries = TaskUtils.getBackendConfigEntries();
    }

    private boolean argumentsAreValid() {
        if (this.backUpAll) {
            if (!this.backendIDList.isEmpty()) {
                int msgID = 10748179;
                String message = MessageHandler.getMessage(msgID, "ds-task-backup-all", "ds-task-backup-backend-id");
                this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                return false;
            }
        } else if (this.backendIDList.isEmpty()) {
            int msgID = 10748180;
            String message = MessageHandler.getMessage(msgID, "ds-task-backup-all", "ds-task-backup-backend-id");
            this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return false;
        }
        if (this.backupID == null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.backupID = dateFormat.format(new Date());
        }
        if (this.incrementalBase != null && !this.incremental) {
            int msgID = 10748192;
            String message = MessageHandler.getMessage(msgID, "ds-task-backup-incremental-base-id", "ds-task-backup-incremental");
            this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return false;
        }
        if (this.signHash && !this.hash) {
            int msgID = 10748230;
            String message = MessageHandler.getMessage(msgID, "ds-task-backup-sign-hash", "ds-task-backup-hash");
            this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return false;
        }
        if (!this.backupDirectory.exists()) {
            try {
                this.backupDirectory.mkdirs();
            }
            catch (Exception e) {
                int msgID = 10748181;
                String string = MessageHandler.getMessage(msgID, this.backupDirectory.getPath(), StaticUtils.getExceptionMessage(e));
                System.err.println(string);
                return false;
            }
        }
        int numBackends = this.configEntries.size();
        this.backendsToArchive = new ArrayList(numBackends);
        if (this.backUpAll) {
            for (Map.Entry entry : this.configEntries.entrySet()) {
                Backend b = DirectoryServer.getBackend((String)entry.getKey());
                if (b == null || !b.supportsBackup()) continue;
                this.backendsToArchive.add(b);
            }
        } else {
            for (String string : this.backendIDList) {
                String message;
                int msgID;
                Backend b = DirectoryServer.getBackend(string);
                if (b == null || this.configEntries.get(string) == null) {
                    msgID = 10748165;
                    message = MessageHandler.getMessage(msgID, string);
                    this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    continue;
                }
                if (!b.supportsBackup()) {
                    msgID = 10617110;
                    message = MessageHandler.getMessage(msgID, b.getBackendID());
                    this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
                    continue;
                }
                this.backendsToArchive.add(b);
            }
            if (this.backendsToArchive.size() != this.backendIDList.size()) {
                return false;
            }
        }
        if (this.backendsToArchive.isEmpty()) {
            int msgID = 10617111;
            String string = MessageHandler.getMessage(msgID);
            this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, msgID);
            return false;
        }
        return true;
    }

    private boolean backupBackend(Backend b, File backupLocation) {
        BackupDirectory backupDir;
        BackendCfg cfg = TaskUtils.getConfigEntry(b);
        if (backupLocation.exists()) {
            String descriptorPath = backupLocation.getPath() + File.separator + "backup.info";
            File descriptorFile = new File(descriptorPath);
            if (descriptorFile.exists()) {
                try {
                    backupDir = BackupDirectory.readBackupDirectoryDescriptor(backupLocation.getPath());
                }
                catch (ConfigException ce) {
                    int msgID = 10748185;
                    String message = MessageHandler.getMessage(msgID, descriptorPath, ce.getMessage());
                    this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    return false;
                }
                catch (Exception e) {
                    int msgID = 10748185;
                    String message = MessageHandler.getMessage(msgID, descriptorPath, StaticUtils.getExceptionMessage(e));
                    this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    return false;
                }
            } else {
                backupDir = new BackupDirectory(backupLocation.getPath(), cfg.dn());
            }
        } else {
            try {
                backupLocation.mkdirs();
            }
            catch (Exception e) {
                int msgID = 10748181;
                String message = MessageHandler.getMessage(msgID, backupLocation.getPath(), StaticUtils.getExceptionMessage(e));
                this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                return false;
            }
            backupDir = new BackupDirectory(backupLocation.getPath(), cfg.dn());
        }
        BackupConfig backupConfig = new BackupConfig(backupDir, this.backupID, this.incremental);
        backupConfig.setCompressData(this.compress);
        backupConfig.setEncryptData(this.encrypt);
        backupConfig.setHashData(this.hash);
        backupConfig.setSignHash(this.signHash);
        backupConfig.setIncrementalBaseID(this.incrementalBase);
        try {
            DirectoryServer.notifyBackupBeginning(b, backupConfig);
            b.createBackup(backupConfig);
            DirectoryServer.notifyBackupEnded(b, backupConfig, true);
        }
        catch (DirectoryException de) {
            DirectoryServer.notifyBackupEnded(b, backupConfig, false);
            int msgID = 10748169;
            String message = MessageHandler.getMessage(msgID, b.getBackendID(), de.getErrorMessage());
            this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return false;
        }
        catch (Exception e) {
            DirectoryServer.notifyBackupEnded(b, backupConfig, false);
            int msgID = 10748169;
            String message = MessageHandler.getMessage(msgID, b.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return false;
        }
        return true;
    }

    private boolean lockBackend(Backend b) {
        try {
            String lockFile = LockFileManager.getBackendLockFileName(b);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                int msgID = 10748232;
                String message = MessageHandler.getMessage(msgID, b.getBackendID(), String.valueOf(failureReason));
                this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                return false;
            }
        }
        catch (Exception e) {
            int msgID = 10748232;
            String message = MessageHandler.getMessage(msgID, b.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return false;
        }
        return true;
    }

    private boolean unlockBackend(Backend b) {
        try {
            String lockFile = LockFileManager.getBackendLockFileName(b);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                int msgID = 10617161;
                String message = MessageHandler.getMessage(msgID, b.getBackendID(), String.valueOf(failureReason));
                this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                return false;
            }
        }
        catch (Exception e) {
            int msgID = 10617161;
            String message = MessageHandler.getMessage(msgID, b.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskState runTask() {
        String message;
        if (!this.argumentsAreValid()) {
            return TaskState.STOPPED_BY_ERROR;
        }
        boolean multiple = this.backUpAll ? true : this.backendsToArchive.size() > 1;
        boolean errorsEncountered = false;
        for (Backend b : this.backendsToArchive) {
            if (!this.lockBackend(b)) {
                errorsEncountered = true;
                continue;
            }
            try {
                int msgID = 10944792;
                String message2 = MessageHandler.getMessage(msgID, b.getBackendID());
                this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message2, msgID);
                File backupLocation = multiple ? new File(this.backupDirectory, b.getBackendID()) : this.backupDirectory;
                if (this.backupBackend(b, backupLocation)) continue;
                errorsEncountered = true;
            }
            finally {
                if (this.unlockBackend(b)) continue;
                errorsEncountered = true;
            }
        }
        if (errorsEncountered) {
            int msgID = 10944794;
            message = MessageHandler.getMessage(msgID);
            this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
            return TaskState.COMPLETED_WITH_ERRORS;
        }
        int msgID = 10944795;
        message = MessageHandler.getMessage(msgID);
        this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, message, msgID);
        return TaskState.COMPLETED_SUCCESSFULLY;
    }
}

