/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.net.InetAddress;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;

public class EnterLockdownModeTask
extends Task {
    public void initializeTask() throws DirectoryException {
        Operation operation = this.getOperation();
        if (operation != null) {
            DN authzDN = operation.getAuthorizationDN();
            if (authzDN == null || !DirectoryServer.isRootDN(authzDN)) {
                int msgID = 11796501;
                String message = MessageHandler.getMessage(msgID);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
            InetAddress clientAddress = operation.getClientConnection().getRemoteAddress();
            if (clientAddress != null && !clientAddress.isLoopbackAddress()) {
                int msgID = 11796502;
                String message = MessageHandler.getMessage(msgID);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
        }
    }

    protected TaskState runTask() {
        DirectoryServer.setLockdownMode(true);
        return TaskState.COMPLETED_SUCCESSFULLY;
    }
}

