/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

public class ImportTask
extends Task {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    boolean append = false;
    boolean isCompressed = false;
    boolean isEncrypted = false;
    boolean overwrite = false;
    boolean replaceExisting = false;
    boolean skipSchemaValidation = false;
    boolean clearBackend = false;
    String backendID = null;
    String rejectFile = null;
    String skipFile = null;
    ArrayList<String> excludeAttributeStrings = null;
    ArrayList<String> excludeBranchStrings = null;
    ArrayList<String> excludeFilterStrings = null;
    ArrayList<String> includeAttributeStrings = null;
    ArrayList<String> includeBranchStrings = null;
    ArrayList<String> includeFilterStrings = null;
    ArrayList<String> ldifFiles = null;

    public void initializeTask() throws DirectoryException {
        ClientConnection clientConnection;
        Operation operation = this.getOperation();
        if (operation != null && !(clientConnection = operation.getClientConnection()).hasPrivilege(Privilege.LDIF_IMPORT, operation)) {
            int msgID = 11796493;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
        }
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeLdifFile = DirectoryServer.getAttributeType("ds-task-import-ldif-file", true);
        AttributeType typeAppend = DirectoryServer.getAttributeType("ds-task-import-append", true);
        AttributeType typeReplaceExisting = DirectoryServer.getAttributeType("ds-task-import-replace-existing", true);
        AttributeType typeBackendID = DirectoryServer.getAttributeType("ds-task-import-backend-id", true);
        AttributeType typeIncludeBranch = DirectoryServer.getAttributeType("ds-task-import-include-branch", true);
        AttributeType typeExcludeBranch = DirectoryServer.getAttributeType("ds-task-import-exclude-branch", true);
        AttributeType typeIncludeAttribute = DirectoryServer.getAttributeType("ds-task-import-include-attribute", true);
        AttributeType typeExcludeAttribute = DirectoryServer.getAttributeType("ds-task-import-exclude-attribute", true);
        AttributeType typeIncludeFilter = DirectoryServer.getAttributeType("ds-task-import-include-filter", true);
        AttributeType typeExcludeFilter = DirectoryServer.getAttributeType("ds-task-import-exclude-filter", true);
        AttributeType typeRejectFile = DirectoryServer.getAttributeType("ds-task-import-reject-file", true);
        AttributeType typeSkipFile = DirectoryServer.getAttributeType("ds-task-import-skip-file", true);
        AttributeType typeOverwrite = DirectoryServer.getAttributeType("ds-task-import-overwrite-rejects", true);
        AttributeType typeSkipSchemaValidation = DirectoryServer.getAttributeType("ds-task-import-skip-schema-validation", true);
        AttributeType typeIsCompressed = DirectoryServer.getAttributeType("ds-task-import-is-compressed", true);
        AttributeType typeIsEncrypted = DirectoryServer.getAttributeType("ds-task-import-is-encrypted", true);
        AttributeType typeClearBackend = DirectoryServer.getAttributeType("ds-task-import-clear-backend", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeLdifFile);
        this.ldifFiles = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeAppend);
        this.append = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeReplaceExisting);
        this.replaceExisting = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeBackendID);
        this.backendID = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeIncludeBranch);
        this.includeBranchStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeExcludeBranch);
        this.excludeBranchStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeIncludeAttribute);
        this.includeAttributeStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeExcludeAttribute);
        this.excludeAttributeStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeIncludeFilter);
        this.includeFilterStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeExcludeFilter);
        this.excludeFilterStrings = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeRejectFile);
        this.rejectFile = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeSkipFile);
        this.skipFile = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeOverwrite);
        this.overwrite = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeSkipSchemaValidation);
        this.skipSchemaValidation = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeIsCompressed);
        this.isCompressed = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeIsEncrypted);
        this.isEncrypted = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeClearBackend);
        this.clearBackend = TaskUtils.getBoolean(attrList, false);
        if (this.includeBranchStrings.isEmpty() && this.backendID == null) {
            int msgID = 10749156;
            String message = MessageHandler.getMessage(msgID, typeIncludeBranch.getNameOrOID(), typeBackendID.getNameOrOID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
        }
        Backend backend = null;
        ArrayList<DN> excludeBranches = new ArrayList<DN>(this.excludeBranchStrings.size());
        ArrayList<DN> includeBranches = new ArrayList<DN>(this.includeBranchStrings.size());
        for (String s : this.includeBranchStrings) {
            DN includeBranch;
            try {
                includeBranch = DN.decode(s);
            }
            catch (DirectoryException de) {
                int msgID = 10748122;
                String message = MessageHandler.getMessage(msgID, s, de.getErrorMessage());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
            catch (Exception e) {
                int msgID = 10748122;
                String message = MessageHandler.getMessage(msgID, s, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
            if (includeBranches.contains(includeBranch)) continue;
            includeBranches.add(includeBranch);
        }
        for (String s : this.excludeBranchStrings) {
            DN excludeBranch;
            try {
                excludeBranch = DN.decode(s);
            }
            catch (DirectoryException de) {
                int msgID = 10747998;
                String message = MessageHandler.getMessage(msgID, s, de.getErrorMessage());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
            catch (Exception e) {
                int msgID = 10747998;
                String message = MessageHandler.getMessage(msgID, s, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
            if (excludeBranches.contains(excludeBranch)) continue;
            excludeBranches.add(excludeBranch);
        }
        for (String filterString : this.excludeFilterStrings) {
            try {
                SearchFilter.createFilterFromString(filterString);
            }
            catch (DirectoryException de) {
                int msgID = 10747993;
                String message = MessageHandler.getMessage(msgID, filterString, de.getErrorMessage());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
        }
        for (String filterString : this.includeFilterStrings) {
            try {
                SearchFilter.createFilterFromString(filterString);
            }
            catch (DirectoryException de) {
                int msgID = 10747994;
                String message = MessageHandler.getMessage(msgID, filterString, de.getErrorMessage());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
        }
        if (this.backendID != null) {
            String message;
            backend = DirectoryServer.getBackend(this.backendID);
            if (backend == null) {
                int msgID = 10747997;
                message = MessageHandler.getMessage(msgID, this.backendID);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
            if (!backend.supportsLDIFImport()) {
                int msgID = 10748118;
                message = MessageHandler.getMessage(msgID, this.backendID);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
            if (!this.append && this.includeBranchStrings.isEmpty() && backend.getBaseDNs().length > 1 && !this.clearBackend) {
                StringBuilder builder = new StringBuilder();
                for (DN dn : backend.getBaseDNs()) {
                    builder.append(dn.toNormalizedString());
                    builder.append(" ");
                }
                int msgID = 10749157;
                String message2 = MessageHandler.getMessage(msgID, builder.toString(), typeClearBackend.getNameOrOID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message2, msgID);
            }
        } else {
            for (DN includeBranch : includeBranches) {
                Backend locatedBackend = DirectoryServer.getBackend(includeBranch);
                if (locatedBackend == null) continue;
                if (backend == null) {
                    backend = locatedBackend;
                    continue;
                }
                if (backend == locatedBackend) continue;
                int msgID = 10748123;
                String message = MessageHandler.getMessage(msgID, includeBranch.toNormalizedString(), backend.getBackendID());
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
            }
        }
        ArrayList<DN> defaultIncludeBranches = new ArrayList<DN>(backend.getBaseDNs().length);
        for (DN dn : backend.getBaseDNs()) {
            defaultIncludeBranches.add(dn);
        }
        for (DN includeBranch : includeBranches) {
            if (Backend.handlesEntry(includeBranch, defaultIncludeBranches, excludeBranches)) continue;
            int msgID = 10748123;
            String message = MessageHandler.getMessage(msgID, includeBranch.toNormalizedString(), backend.getBackendID());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message, msgID);
        }
    }

    /*
     * Exception decompiling
     */
    protected TaskState runTask() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

