/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.io.File;
import java.util.List;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class RestoreTask
extends Task {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private File backupDirectory;
    private String backupID;
    private boolean verifyOnly;

    public void initializeTask() throws DirectoryException {
        ClientConnection clientConnection;
        Operation operation = this.getOperation();
        if (operation != null && !(clientConnection = operation.getClientConnection()).hasPrivilege(Privilege.BACKEND_RESTORE, operation)) {
            int msgID = 11796492;
            String message = MessageHandler.getMessage(msgID);
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
        }
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeBackupDirectory = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        AttributeType typebackupID = DirectoryServer.getAttributeType("ds-backup-id", true);
        AttributeType typeVerifyOnly = DirectoryServer.getAttributeType("ds-task-restore-verify-only", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeBackupDirectory);
        String backupDirectoryPath = TaskUtils.getSingleValueString(attrList);
        this.backupDirectory = new File(backupDirectoryPath);
        if (!this.backupDirectory.isAbsolute()) {
            this.backupDirectory = new File(DirectoryServer.getServerRoot(), backupDirectoryPath);
        }
        attrList = taskEntry.getAttribute(typebackupID);
        this.backupID = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeVerifyOnly);
        this.verifyOnly = TaskUtils.getBoolean(attrList, false);
    }

    private boolean lockBackend(Backend backend) {
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                int msgID = 10748234;
                String message = MessageHandler.getMessage(msgID, backend.getBackendID(), String.valueOf(failureReason));
                this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                return false;
            }
        }
        catch (Exception e) {
            int msgID = 10748234;
            String message = MessageHandler.getMessage(msgID, backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return false;
        }
        return true;
    }

    private boolean unlockBackend(Backend backend) {
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                int msgID = 10617163;
                String message = MessageHandler.getMessage(msgID, backend.getBackendID(), String.valueOf(failureReason));
                this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
                return false;
            }
        }
        catch (Exception e) {
            int msgID = 10617163;
            String message = MessageHandler.getMessage(msgID, backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message, msgID);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskState runTask() {
        boolean errorsEncountered;
        block29: {
            ConfigEntry configEntry;
            BackupDirectory backupDir;
            try {
                backupDir = BackupDirectory.readBackupDirectoryDescriptor(this.backupDirectory.getPath());
            }
            catch (Exception e) {
                int msgID = 10748208;
                String message = MessageHandler.getMessage(msgID, this.backupDirectory, StaticUtils.getExceptionMessage(e));
                this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                return TaskState.STOPPED_BY_ERROR;
            }
            if (this.backupID != null) {
                BackupInfo backupInfo = backupDir.getBackupInfo(this.backupID);
                if (backupInfo == null) {
                    int msgID = 10748217;
                    String message = MessageHandler.getMessage(msgID, this.backupID, this.backupDirectory);
                    this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    return TaskState.STOPPED_BY_ERROR;
                }
            } else {
                BackupInfo latestBackup = backupDir.getLatestBackup();
                if (latestBackup == null) {
                    int msgID = 10748218;
                    String message = MessageHandler.getMessage(msgID, this.backupDirectory);
                    this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                    return TaskState.STOPPED_BY_ERROR;
                }
                this.backupID = latestBackup.getBackupID();
            }
            DN configEntryDN = backupDir.getConfigEntryDN();
            try {
                configEntry = DirectoryServer.getConfigEntry(configEntryDN);
            }
            catch (ConfigException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 10748219;
                String message = MessageHandler.getMessage(msgID, this.backupDirectory, configEntryDN.toString());
                this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                return TaskState.STOPPED_BY_ERROR;
            }
            String backendID = TaskUtils.getBackendID(configEntry);
            Backend backend = DirectoryServer.getBackend(backendID);
            if (!backend.supportsRestore()) {
                int msgID = 10748220;
                String message = MessageHandler.getMessage(msgID, backend.getBackendID());
                this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                return TaskState.STOPPED_BY_ERROR;
            }
            RestoreConfig restoreConfig = new RestoreConfig(backupDir, this.backupID, this.verifyOnly);
            DirectoryServer.notifyRestoreBeginning(backend, restoreConfig);
            try {
                TaskUtils.disableBackend(backendID);
            }
            catch (DirectoryException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, e.getErrorMessage(), e.getMessageID());
                return TaskState.STOPPED_BY_ERROR;
            }
            errorsEncountered = false;
            try {
                if (!this.lockBackend(backend)) break block29;
                try {
                    try {
                        backend.restoreBackup(restoreConfig);
                    }
                    catch (DirectoryException de) {
                        DirectoryServer.notifyRestoreEnded(backend, restoreConfig, false);
                        int msgID = 10748221;
                        String message = MessageHandler.getMessage(msgID, this.backupID, backupDir.getPath(), de.getErrorMessage());
                        this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                        errorsEncountered = true;
                    }
                    catch (Exception e) {
                        DirectoryServer.notifyRestoreEnded(backend, restoreConfig, false);
                        int msgID = 10748221;
                        String message = MessageHandler.getMessage(msgID, this.backupID, backupDir.getPath(), StaticUtils.getExceptionMessage(e));
                        this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                        errorsEncountered = true;
                    }
                }
                finally {
                    if (!this.unlockBackend(backend)) {
                        errorsEncountered = true;
                    }
                }
            }
            finally {
                try {
                    TaskUtils.enableBackend(backendID);
                    backend = DirectoryServer.getBackend(backendID);
                }
                catch (DirectoryException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    this.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, e.getErrorMessage(), e.getMessageID());
                    errorsEncountered = true;
                }
                DirectoryServer.notifyRestoreEnded(backend, restoreConfig, true);
            }
        }
        if (errorsEncountered) {
            return TaskState.COMPLETED_WITH_ERRORS;
        }
        return TaskState.COMPLETED_SUCCESSFULLY;
    }
}

