/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.LinkedHashSet;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tasks.RestartTaskThread;
import org.opends.server.tasks.ShutdownTaskThread;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class ShutdownTask
extends Task {
    private boolean restart;
    private String shutdownMessage;

    public void initializeTask() throws DirectoryException {
        Operation operation;
        String valueString;
        Attribute attr;
        LinkedHashSet<AttributeValue> values;
        Entry taskEntry = this.getTaskEntry();
        this.restart = false;
        this.shutdownMessage = MessageHandler.getMessage(0xB00003, String.valueOf(taskEntry.getDN()));
        AttributeType attrType = DirectoryServer.getAttributeType("ds-task-shutdown-message", true);
        List<Attribute> attrList = taskEntry.getAttribute(attrType);
        if (attrList != null && attrList.size() > 0 && (values = (attr = attrList.get(0)).getValues()) != null && !values.isEmpty()) {
            valueString = ((AttributeValue)values.iterator().next()).getStringValue();
            this.shutdownMessage = MessageHandler.getMessage(0xB00004, String.valueOf(taskEntry.getDN()), String.valueOf(valueString));
        }
        if ((attrList = taskEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-task-restart-server", true))) != null && attrList.size() > 0 && (values = (attr = attrList.get(0)).getValues()) != null && !values.isEmpty()) {
            valueString = StaticUtils.toLowerCase(((AttributeValue)values.iterator().next()).getStringValue());
            boolean bl = this.restart = valueString.equals("true") || valueString.equals("yes") || valueString.equals("on") || valueString.equals("1");
        }
        if ((operation = this.getOperation()) != null) {
            ClientConnection clientConnection = operation.getClientConnection();
            if (this.restart) {
                if (!clientConnection.hasPrivilege(Privilege.SERVER_RESTART, operation)) {
                    int msgID = 11796495;
                    String message = MessageHandler.getMessage(msgID);
                    throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
                }
            } else if (!clientConnection.hasPrivilege(Privilege.SERVER_SHUTDOWN, operation)) {
                int msgID = 11796496;
                String message = MessageHandler.getMessage(msgID);
                throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message, msgID);
            }
        }
    }

    public TaskState runTask() {
        if (this.restart) {
            RestartTaskThread restartThread = new RestartTaskThread(this.shutdownMessage);
            restartThread.start();
        } else {
            ShutdownTaskThread shutdownThread = new ShutdownTaskThread(this.shutdownMessage);
            shutdownThread.start();
        }
        return TaskState.COMPLETED_SUCCESSFULLY;
    }
}

