/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskUtils {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public static String getBackendID(ConfigEntry configEntry) {
        try {
            int msgID = 3146110;
            StringConfigAttribute idStub = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(msgID), true, false, true);
            StringConfigAttribute idAttr = (StringConfigAttribute)configEntry.getConfigAttribute(idStub);
            return idAttr.activeValue();
        }
        catch (ConfigException ce) {
            int msgID = 10748121;
            String message = MessageHandler.getMessage(msgID, String.valueOf(configEntry.getDN()), ce.getMessage());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return null;
        }
        catch (Exception e) {
            int msgID = 10748121;
            String message = MessageHandler.getMessage(msgID, String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return null;
        }
    }

    public static Map<String, ConfigEntry> getBackendConfigEntries() {
        ConfigEntry baseEntry;
        DN backendBaseDN;
        HashMap<String, ConfigEntry> configEntries = new HashMap<String, ConfigEntry>();
        try {
            backendBaseDN = DN.decode("cn=Backends,cn=config");
        }
        catch (DirectoryException de) {
            int msgID = 10747964;
            String message = MessageHandler.getMessage(msgID, "cn=Backends,cn=config", de.getErrorMessage());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return configEntries;
        }
        catch (Exception e) {
            int msgID = 10747964;
            String message = MessageHandler.getMessage(msgID, "cn=Backends,cn=config", StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return configEntries;
        }
        try {
            baseEntry = DirectoryServer.getConfigEntry(backendBaseDN);
        }
        catch (ConfigException ce) {
            int msgID = 10747965;
            String message = MessageHandler.getMessage(msgID, "cn=Backends,cn=config", ce.getMessage());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return configEntries;
        }
        catch (Exception e) {
            int msgID = 10747965;
            String message = MessageHandler.getMessage(msgID, "cn=Backends,cn=config", StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
            return configEntries;
        }
        for (ConfigEntry configEntry : baseEntry.getChildren().values()) {
            String message;
            String backendID;
            try {
                int msgID = 3146110;
                StringConfigAttribute idStub = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(msgID), true, false, true);
                StringConfigAttribute idAttr = (StringConfigAttribute)configEntry.getConfigAttribute(idStub);
                if (idAttr == null) continue;
                backendID = idAttr.activeValue();
            }
            catch (ConfigException ce) {
                int msgID = 10748121;
                message = MessageHandler.getMessage(msgID, String.valueOf(configEntry.getDN()), ce.getMessage());
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                continue;
            }
            catch (Exception e) {
                int msgID = 10748121;
                message = MessageHandler.getMessage(msgID, String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID);
                continue;
            }
            configEntries.put(backendID, configEntry);
        }
        return configEntries;
    }

    public static BackendCfg getConfigEntry(Backend backend) {
        RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
        try {
            return root.getBackend(backend.getBackendID());
        }
        catch (ConfigException e) {
            return null;
        }
    }

    public static void enableBackend(String backendID) throws DirectoryException {
        DN configEntryDN;
        RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
        try {
            BackendCfg cfg = root.getBackend(backendID);
            configEntryDN = cfg.dn();
        }
        catch (ConfigException e) {
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessage(), e.getMessageID(), e);
        }
        ArrayList<ASN1OctetString> valueList = new ArrayList<ASN1OctetString>(1);
        valueList.add(new ASN1OctetString("TRUE"));
        LDAPAttribute a = new LDAPAttribute("ds-cfg-backend-enabled", valueList);
        LDAPModification m = new LDAPModification(ModificationType.REPLACE, a);
        ArrayList<RawModification> modList = new ArrayList<RawModification>(1);
        modList.add(m);
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        String backendDNString = configEntryDN.toString();
        ASN1OctetString rawEntryDN = new ASN1OctetString(backendDNString);
        ModifyOperation internalModify = conn.processModify(rawEntryDN, modList);
        ResultCode resultCode = internalModify.getResultCode();
        if (resultCode != ResultCode.SUCCESS) {
            int msgID = 11796481;
            String message = MessageHandler.getMessage(msgID, backendDNString);
            throw new DirectoryException(resultCode, message, msgID);
        }
    }

    public static void disableBackend(String backendID) throws DirectoryException {
        DN configEntryDN;
        RootCfg root = ServerManagementContext.getInstance().getRootConfiguration();
        try {
            BackendCfg cfg = root.getBackend(backendID);
            configEntryDN = cfg.dn();
        }
        catch (ConfigException e) {
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), e.getMessage(), e.getMessageID(), e);
        }
        ArrayList<ASN1OctetString> valueList = new ArrayList<ASN1OctetString>(1);
        valueList.add(new ASN1OctetString("FALSE"));
        LDAPAttribute a = new LDAPAttribute("ds-cfg-backend-enabled", valueList);
        LDAPModification m = new LDAPModification(ModificationType.REPLACE, a);
        ArrayList<RawModification> modList = new ArrayList<RawModification>(1);
        modList.add(m);
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        String backendDNString = configEntryDN.toString();
        ASN1OctetString rawEntryDN = new ASN1OctetString(backendDNString);
        ModifyOperation internalModify = conn.processModify(rawEntryDN, modList);
        ResultCode resultCode = internalModify.getResultCode();
        if (resultCode != ResultCode.SUCCESS) {
            int msgID = 11796482;
            String message = MessageHandler.getMessage(msgID, backendDNString);
            throw new DirectoryException(resultCode, message, msgID);
        }
    }

    public static boolean getBoolean(List<Attribute> attrList, boolean defaultValue) {
        if (attrList == null || attrList.isEmpty()) {
            return defaultValue;
        }
        for (Attribute a : attrList) {
            for (AttributeValue v : a.getValues()) {
                String valueString = StaticUtils.toLowerCase(v.getStringValue());
                if (valueString.equals("true") || valueString.equals("yes") || valueString.equals("on") || valueString.equals("1")) {
                    return true;
                }
                if (!valueString.equals("false") && !valueString.equals("no") && !valueString.equals("off") && !valueString.equals("0")) continue;
                return false;
            }
        }
        return defaultValue;
    }

    public static ArrayList<String> getMultiValueString(List<Attribute> attrList) {
        Attribute attr;
        LinkedHashSet<AttributeValue> values;
        ArrayList<String> valueStrings = new ArrayList<String>();
        if (attrList != null && !attrList.isEmpty() && (values = (attr = attrList.get(0)).getValues()) != null && !values.isEmpty()) {
            for (AttributeValue value : values) {
                valueStrings.add(value.getStringValue());
            }
        }
        return valueStrings;
    }

    public static String getSingleValueString(List<Attribute> attrList) {
        if (attrList == null || attrList.isEmpty()) {
            return null;
        }
        String valueString = null;
        Attribute attr = attrList.get(0);
        LinkedHashSet<AttributeValue> values = attr.getValues();
        if (values != null && !values.isEmpty()) {
            valueString = ((AttributeValue)values.iterator().next()).getStringValue();
        }
        return valueString;
    }

    public static int getSingleValueInteger(List<Attribute> attrList, int defaultValue) {
        block3: {
            Attribute attr;
            LinkedHashSet<AttributeValue> values;
            if (attrList != null && !attrList.isEmpty() && (values = (attr = attrList.get(0)).getValues()) != null && !values.isEmpty()) {
                String valueString = ((AttributeValue)values.iterator().next()).getStringValue();
                try {
                    return Integer.parseInt(valueString);
                }
                catch (NumberFormatException e) {
                    if (!DebugLogger.debugEnabled()) break block3;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return defaultValue;
    }
}

