/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class ConfigureWindowsService {
    private static final String CLASS_NAME = "org.opends.server.tools.ConfigureWindowsService";
    private static final String DEBUG_OPTION = "--debug";
    public static final String LAUNCHER_OPTION = "run";
    private static int ERROR = 1;
    public static final int SERVICE_ENABLE_SUCCESS = 0;
    public static final int SERVICE_ALREADY_ENABLED = 1;
    public static final int SERVICE_NAME_ALREADY_IN_USE = 2;
    public static final int SERVICE_ENABLE_ERROR = 3;
    public static final int SERVICE_DISABLE_SUCCESS = 0;
    public static final int SERVICE_ALREADY_DISABLED = 1;
    public static final int SERVICE_MARKED_FOR_DELETION = 2;
    public static final int SERVICE_DISABLE_ERROR = 3;
    public static final int SERVICE_STATE_ENABLED = 0;
    public static final int SERVICE_STATE_DISABLED = 1;
    public static final int SERVICE_STATE_ERROR = 2;
    public static final int SERVICE_CLEANUP_SUCCESS = 0;
    public static final int SERVICE_NOT_FOUND = 1;
    public static final int SERVICE_CLEANUP_ERROR = 2;
    public static final int SERVICE_CLEANUP_MARKED_FOR_DELETION = 3;

    public static void main(String[] args) {
        int result = ConfigureWindowsService.configureWindowsService(args, System.out, System.err);
        System.exit(StaticUtils.filterExitCode(result));
    }

    public static int configureWindowsService(String[] args, OutputStream outStream, OutputStream errStream) {
        String message;
        int msgID;
        int returnValue = 0;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        String toolDescription = MessageHandler.getMessage(0xA00330);
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
        BooleanArgument enableService = null;
        BooleanArgument disableService = null;
        Argument serviceState = null;
        Argument cleanupService = null;
        BooleanArgument showUsage = null;
        try {
            enableService = new BooleanArgument("enableservice", Character.valueOf('e'), "enableService", 10486578, new Object[0]);
            argParser.addArgument(enableService);
            disableService = new BooleanArgument("disableservice", Character.valueOf('d'), "disableService", 0xA00333, new Object[0]);
            argParser.addArgument(disableService);
            serviceState = new BooleanArgument("servicestate", Character.valueOf('s'), "serviceState", 10486580, new Object[0]);
            argParser.addArgument(serviceState);
            cleanupService = new StringArgument("cleanupservice", Character.valueOf('c'), "cleanupService", false, false, true, "{serviceName}", null, null, 10486604, new Object[0]);
            argParser.addArgument(cleanupService);
            showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", 10486577, new Object[0]);
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            msgID = 10747920;
            message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            returnValue = ERROR;
        }
        if (returnValue == 0) {
            try {
                argParser.parseArguments(args);
            }
            catch (ArgumentException ae) {
                msgID = 10747921;
                message = MessageHandler.getMessage(msgID, ae.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                returnValue = ERROR;
            }
        }
        if (returnValue == 0 && !argParser.usageOrVersionDisplayed()) {
            int nArgs = 0;
            if (enableService.isPresent()) {
                ++nArgs;
            }
            if (disableService.isPresent()) {
                ++nArgs;
            }
            if (serviceState.isPresent()) {
                ++nArgs;
            }
            if (cleanupService.isPresent()) {
                ++nArgs;
            }
            if (nArgs > 1) {
                msgID = 10748727;
                message = MessageHandler.getMessage(msgID, null);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                returnValue = ERROR;
            }
            if (nArgs == 0) {
                msgID = 10748728;
                message = MessageHandler.getMessage(msgID, null);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                returnValue = ERROR;
            }
        }
        if (returnValue == 0 && !argParser.usageOrVersionDisplayed()) {
            returnValue = enableService.isPresent() ? ConfigureWindowsService.enableService(out, err) : (disableService.isPresent() ? ConfigureWindowsService.disableService(out, err) : (serviceState.isPresent() ? ConfigureWindowsService.serviceState(out, err) : ConfigureWindowsService.cleanupService(cleanupService.getValue(), out, err)));
        }
        return returnValue;
    }

    static String getServiceName() {
        String serviceName = null;
        String serverRoot = ConfigureWindowsService.getServerRoot();
        String[] cmd = new String[]{ConfigureWindowsService.getBinaryFullPath(), "state", serverRoot};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            BufferedReader stdout = new BufferedReader(new InputStreamReader(p.getInputStream()));
            boolean processDone = false;
            while (!processDone) {
                String s;
                try {
                    p.exitValue();
                    processDone = true;
                }
                catch (Throwable t) {
                    // empty catch block
                }
                while ((s = stdout.readLine()) != null) {
                    serviceName = s;
                    if (serviceName.trim().length() != 0) continue;
                    serviceName = null;
                }
            }
        }
        catch (Throwable t) {
            serviceName = null;
        }
        return serviceName;
    }

    public static int enableService(PrintStream out, PrintStream err) {
        int returnValue;
        String serverRoot = ConfigureWindowsService.getServerRoot();
        String[] cmd = ConfigureWindowsService.isVista() ? new String[]{ConfigureWindowsService.getLauncherBinaryFullPath(), LAUNCHER_OPTION, ConfigureWindowsService.getLauncherAdministratorBinaryFullPath(), LAUNCHER_OPTION, ConfigureWindowsService.getBinaryFullPath(), "create", serverRoot, MessageHandler.getMessage(10486585, null), MessageHandler.getMessage(0xA0033A, serverRoot), DEBUG_OPTION} : new String[]{ConfigureWindowsService.getBinaryFullPath(), "create", serverRoot, MessageHandler.getMessage(10486585, null), MessageHandler.getMessage(0xA0033A, serverRoot), DEBUG_OPTION};
        try {
            int resultCode = Runtime.getRuntime().exec(cmd).waitFor();
            switch (resultCode) {
                case 0: {
                    returnValue = 0;
                    String msg = MessageHandler.getMessage(10486587, null);
                    out.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                    break;
                }
                case 1: {
                    returnValue = 1;
                    String msg = MessageHandler.getMessage(10486588, null);
                    out.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                    break;
                }
                case 2: {
                    returnValue = 2;
                    String msg = MessageHandler.getMessage(10748733, null);
                    err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                    break;
                }
                case 3: {
                    returnValue = 3;
                    String msg = MessageHandler.getMessage(10748734, null);
                    err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                    break;
                }
                default: {
                    returnValue = 3;
                    String msg = MessageHandler.getMessage(10748734, null);
                    err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                    break;
                }
            }
        }
        catch (Throwable t) {
            err.println("Fucking throwable: " + t);
            t.printStackTrace();
            returnValue = 3;
            String msg = MessageHandler.getMessage(10748734, null);
            err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
        }
        return returnValue;
    }

    public static int disableService(PrintStream out, PrintStream err) {
        int returnValue;
        String serverRoot = ConfigureWindowsService.getServerRoot();
        String[] cmd = ConfigureWindowsService.isVista() ? new String[]{ConfigureWindowsService.getLauncherBinaryFullPath(), LAUNCHER_OPTION, ConfigureWindowsService.getLauncherAdministratorBinaryFullPath(), LAUNCHER_OPTION, ConfigureWindowsService.getBinaryFullPath(), "remove", serverRoot, DEBUG_OPTION} : new String[]{ConfigureWindowsService.getBinaryFullPath(), "remove", serverRoot, DEBUG_OPTION};
        try {
            int resultCode = Runtime.getRuntime().exec(cmd).waitFor();
            switch (resultCode) {
                case 0: {
                    returnValue = 0;
                    String msg = MessageHandler.getMessage(10486591, null);
                    out.println(msg);
                    break;
                }
                case 1: {
                    returnValue = 1;
                    String msg = MessageHandler.getMessage(10486592, null);
                    out.println(msg);
                    break;
                }
                case 2: {
                    returnValue = 2;
                    String msg = MessageHandler.getMessage(10617665, null);
                    out.println(msg);
                    break;
                }
                case 3: {
                    returnValue = 3;
                    String msg = MessageHandler.getMessage(10748738, null);
                    err.println(msg);
                    break;
                }
                default: {
                    returnValue = 3;
                    String msg = MessageHandler.getMessage(10748738, null);
                    err.println(msg);
                    break;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            returnValue = 3;
            String msg = MessageHandler.getMessage(10748738, null);
            err.println(msg);
        }
        return returnValue;
    }

    public static int cleanupService(String serviceName, PrintStream out, PrintStream err) {
        int returnValue;
        String[] cmd = ConfigureWindowsService.isVista() ? new String[]{ConfigureWindowsService.getLauncherBinaryFullPath(), LAUNCHER_OPTION, ConfigureWindowsService.getLauncherAdministratorBinaryFullPath(), LAUNCHER_OPTION, ConfigureWindowsService.getBinaryFullPath(), "cleanup", serviceName, DEBUG_OPTION} : new String[]{ConfigureWindowsService.getBinaryFullPath(), "cleanup", serviceName, DEBUG_OPTION};
        try {
            int resultCode = Runtime.getRuntime().exec(cmd).waitFor();
            switch (resultCode) {
                case 0: {
                    returnValue = 0;
                    String msg = MessageHandler.getMessage(10486605, serviceName);
                    out.println(msg);
                    break;
                }
                case 1: {
                    returnValue = 1;
                    String msg = MessageHandler.getMessage(10748750, serviceName);
                    err.println(msg);
                    break;
                }
                case 2: {
                    returnValue = 3;
                    String msg = MessageHandler.getMessage(10617679, serviceName);
                    out.println(msg);
                    break;
                }
                case 3: {
                    returnValue = 2;
                    String msg = MessageHandler.getMessage(10748752, serviceName);
                    err.println(msg);
                    break;
                }
                default: {
                    returnValue = 2;
                    String msg = MessageHandler.getMessage(10748752, serviceName);
                    err.println(msg);
                    break;
                }
            }
        }
        catch (Throwable t) {
            returnValue = 2;
            String msg = MessageHandler.getMessage(10748752, serviceName);
            err.println(msg);
        }
        return returnValue;
    }

    public static int serviceState(PrintStream out, PrintStream err) {
        int returnValue;
        block15: {
            String serviceName = null;
            String serverRoot = ConfigureWindowsService.getServerRoot();
            String[] cmd = new String[]{ConfigureWindowsService.getBinaryFullPath(), "state", serverRoot, DEBUG_OPTION};
            try {
                int resultCode = -1;
                ProcessBuilder pb = new ProcessBuilder(cmd);
                Process process = pb.start();
                BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
                boolean processDone = false;
                while (!processDone) {
                    String s;
                    try {
                        resultCode = process.exitValue();
                        processDone = true;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    while ((s = stdout.readLine()) != null) {
                        if (s.trim().length() == 0) continue;
                        serviceName = s;
                    }
                }
                switch (resultCode) {
                    case 0: {
                        returnValue = 0;
                        if (out != null) {
                            String msg = MessageHandler.getMessage(10486595, serviceName);
                            out.println(msg);
                        }
                        break;
                    }
                    case 1: {
                        returnValue = 1;
                        if (out != null) {
                            String msg = MessageHandler.getMessage(10486596, null);
                            out.println(msg);
                        }
                        break;
                    }
                    case 2: {
                        returnValue = 2;
                        if (out != null) {
                            String msg = MessageHandler.getMessage(10748741, null);
                            out.println(msg);
                        }
                        break;
                    }
                    default: {
                        returnValue = 2;
                        if (err != null) {
                            String msg = MessageHandler.getMessage(10748741, null);
                            err.println(msg);
                        }
                        break;
                    }
                }
            }
            catch (Throwable t) {
                returnValue = 2;
                if (err == null) break block15;
                String msg = MessageHandler.getMessage(10748741, null);
                err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
            }
        }
        return returnValue;
    }

    private static String getServerRoot() {
        String serverRoot = DirectoryServer.getServerRoot();
        File f = new File(serverRoot);
        try {
            File canonical;
            f = canonical = f.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        serverRoot = f.toString();
        if (serverRoot.endsWith(File.separator)) {
            serverRoot = serverRoot.substring(0, serverRoot.length() - 1);
        }
        return serverRoot;
    }

    private static String getBinaryFullPath() {
        return ConfigureWindowsService.getServerRoot() + "\\lib\\opends_service.exe";
    }

    public static String getLauncherAdministratorBinaryFullPath() {
        return ConfigureWindowsService.getServerRoot() + "\\lib\\launcher_administrator.exe";
    }

    public static String getLauncherBinaryFullPath() {
        return ConfigureWindowsService.getServerRoot() + "\\lib\\winlauncher.exe";
    }

    private static boolean isVista() {
        return SetupUtils.isVista();
    }
}

