/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordStorageSchemeConfigManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.StringArgument;

public class EncodePassword {
    public static void main(String[] args) {
        int returnCode = EncodePassword.encodePassword(args, true, System.out, System.err);
        if (returnCode != 0) {
            System.exit(StaticUtils.filterExitCode(returnCode));
        }
    }

    public static int encodePassword(String[] args) {
        return EncodePassword.encodePassword(args, true, System.out, System.err);
    }

    public static int encodePassword(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        String scheme;
        PasswordStorageScheme storageScheme;
        boolean compareMode;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        BooleanArgument authPasswordSyntax = null;
        BooleanArgument useCompareResultCode = null;
        BooleanArgument listSchemes = null;
        BooleanArgument showUsage = null;
        StringArgument clearPassword = null;
        FileBasedArgument clearPasswordFile = null;
        StringArgument encodedPassword = null;
        FileBasedArgument encodedPasswordFile = null;
        StringArgument configClass = null;
        StringArgument configFile = null;
        StringArgument schemeName = null;
        String toolDescription = MessageHandler.getMessage(10486445);
        ArgumentParser argParser = new ArgumentParser("org.opends.server.tools.EncodePassword", toolDescription, false);
        try {
            listSchemes = new BooleanArgument("listschemes", Character.valueOf('l'), "listSchemes", 0xA00007, new Object[0]);
            argParser.addArgument(listSchemes);
            clearPassword = new StringArgument("clearpw", Character.valueOf('c'), "clearPassword", false, false, true, "{clearPW}", null, null, 0xA00008, new Object[0]);
            argParser.addArgument(clearPassword);
            clearPasswordFile = new FileBasedArgument("clearpwfile", Character.valueOf('f'), "clearPasswordFile", false, false, "{filename}", null, null, 0xA00009, new Object[0]);
            argParser.addArgument(clearPasswordFile);
            encodedPassword = new StringArgument("encodedpw", Character.valueOf('e'), "encodedPassword", false, false, true, "{encodedPW}", null, null, 0xA0000A, new Object[0]);
            argParser.addArgument(encodedPassword);
            encodedPasswordFile = new FileBasedArgument("encodedpwfile", Character.valueOf('E'), "encodedPasswordFile", false, false, "{filename}", null, null, 0xA0000B, new Object[0]);
            argParser.addArgument(encodedPasswordFile);
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 0xA0000C, new Object[0]);
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            configFile = new StringArgument("configfile", Character.valueOf('F'), "configFile", true, false, true, "{configFile}", null, null, 0xA0000D, new Object[0]);
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            schemeName = new StringArgument("scheme", Character.valueOf('s'), "storageScheme", false, false, true, "{scheme}", null, null, 0xA0000E, new Object[0]);
            argParser.addArgument(schemeName);
            authPasswordSyntax = new BooleanArgument("authpasswordsyntax", Character.valueOf('a'), "authPasswordSyntax", 10486129, new Object[0]);
            argParser.addArgument(authPasswordSyntax);
            useCompareResultCode = new BooleanArgument("usecompareresultcode", Character.valueOf('r'), "useCompareResultCode", 10486509, new Object[0]);
            argParser.addArgument(useCompareResultCode);
            showUsage = new BooleanArgument("usage", Character.valueOf('H'), "help", 0xA0000F, new Object[0]);
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (clearPassword.isPresent() && clearPasswordFile.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, clearPassword.getLongIdentifier(), clearPasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (encodedPassword.isPresent() && encodedPasswordFile.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, encodedPassword.getLongIdentifier(), encodedPasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        ASN1OctetString clearPW = null;
        if (!listSchemes.isPresent()) {
            if (clearPassword.hasValue()) {
                clearPW = new ASN1OctetString(clearPassword.getValue());
            } else if (clearPasswordFile.hasValue()) {
                clearPW = new ASN1OctetString(clearPasswordFile.getValue());
            } else {
                int msgID = 10747922;
                String message = MessageHandler.getMessage(msgID, clearPassword.getLongIdentifier(), clearPasswordFile.getLongIdentifier());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
            if (!(encodedPassword.isPresent() || encodedPasswordFile.isPresent() || schemeName.isPresent())) {
                int msgID = 10747923;
                String message = MessageHandler.getMessage(msgID, schemeName.getLongIdentifier());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
        }
        ByteString encodedPW = null;
        if (encodedPassword.hasValue()) {
            compareMode = true;
            encodedPW = new ASN1OctetString(encodedPassword.getValue());
        } else if (encodedPasswordFile.hasValue()) {
            compareMode = true;
            encodedPW = new ASN1OctetString(encodedPasswordFile.getValue());
        } else {
            compareMode = false;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            try {
                directoryServer.bootstrapClient();
                directoryServer.initializeJMX();
            }
            catch (Exception e) {
                int msgID = 10747924;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
            }
            catch (InitializationException ie) {
                int msgID = 10747925;
                String message = MessageHandler.getMessage(msgID, ie.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID = 10747925;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                int msgID = 10747926;
                String message = MessageHandler.getMessage(msgID, ce.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID = 10747926;
                String message = MessageHandler.getMessage(msgID, ie.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID = 10747926;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                int msgID = 10747927;
                String message = MessageHandler.getMessage(msgID, ce.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID = 10747927;
                String message = MessageHandler.getMessage(msgID, ie.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID = 10747927;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                PasswordStorageSchemeConfigManager storageSchemeConfigManager = new PasswordStorageSchemeConfigManager();
                storageSchemeConfigManager.initializePasswordStorageSchemes();
            }
            catch (ConfigException ce) {
                int msgID = 10747928;
                String message = MessageHandler.getMessage(msgID, ce.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID = 10747928;
                String message = MessageHandler.getMessage(msgID, ie.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID = 10747928;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (listSchemes.isPresent()) {
            ConcurrentHashMap<String, PasswordStorageScheme> storageSchemes;
            if (authPasswordSyntax.isPresent()) {
                storageSchemes = DirectoryServer.getAuthPasswordStorageSchemes();
                if (storageSchemes.isEmpty()) {
                    int msgID = 10747929;
                    String message = MessageHandler.getMessage(msgID);
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                } else {
                    int size = storageSchemes.size();
                    ArrayList<String> nameList = new ArrayList<String>(size);
                    for (PasswordStorageScheme s : storageSchemes.values()) {
                        nameList.add(s.getAuthPasswordSchemeName());
                    }
                    Object[] nameArray = new String[size];
                    nameList.toArray(nameArray);
                    Arrays.sort(nameArray);
                    for (Object storageSchemeName : nameArray) {
                        out.println((String)storageSchemeName);
                    }
                }
                return 0;
            }
            storageSchemes = DirectoryServer.getPasswordStorageSchemes();
            if (storageSchemes.isEmpty()) {
                int msgID = 10747929;
                String message = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            } else {
                int size = storageSchemes.size();
                ArrayList<String> nameList = new ArrayList<String>(size);
                for (PasswordStorageScheme s : storageSchemes.values()) {
                    nameList.add(s.getStorageSchemeName());
                }
                Object[] nameArray = new String[size];
                nameList.toArray(nameArray);
                Arrays.sort(nameArray);
                for (Object storageSchemeName : nameArray) {
                    out.println((String)storageSchemeName);
                }
            }
            return 0;
        }
        if (compareMode) {
            String encodedPWString;
            block75: {
                if (authPasswordSyntax.isPresent()) {
                    String authValue;
                    String authInfo;
                    String scheme2;
                    try {
                        StringBuilder[] authPWElements = AuthPasswordSyntax.decodeAuthPassword(encodedPW.stringValue());
                        scheme2 = authPWElements[0].toString();
                        authInfo = authPWElements[1].toString();
                        authValue = authPWElements[2].toString();
                    }
                    catch (DirectoryException de) {
                        int msgID = 10748276;
                        String message = MessageHandler.getMessage(msgID, de.getErrorMessage());
                        err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    catch (Exception e) {
                        int msgID = 10748276;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(e));
                        err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    PasswordStorageScheme storageScheme2 = DirectoryServer.getAuthPasswordStorageScheme(scheme2);
                    if (storageScheme2 == null) {
                        int msgID = 10748275;
                        String message = MessageHandler.getMessage(msgID, scheme2);
                        err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    if (storageScheme2.authPasswordMatches(clearPW, authInfo, authValue)) {
                        int msgID = 10485787;
                        String message = MessageHandler.getMessage(msgID);
                        out.println(message);
                        if (useCompareResultCode.isPresent()) {
                            return 6;
                        }
                        return 0;
                    }
                    int msgID = 10485788;
                    String message = MessageHandler.getMessage(msgID);
                    out.println(message);
                    if (useCompareResultCode.isPresent()) {
                        return 5;
                    }
                    return 0;
                }
                if (UserPasswordSyntax.isEncoded(encodedPW)) {
                    try {
                        String[] userPWElements = UserPasswordSyntax.decodeUserPassword(encodedPW.stringValue());
                        encodedPWString = userPWElements[1];
                        storageScheme = DirectoryServer.getPasswordStorageScheme(userPWElements[0]);
                        if (storageScheme == null) {
                            int msgID = 10747930;
                            String message = MessageHandler.getMessage(msgID, userPWElements[0]);
                            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                            return 1;
                        }
                        break block75;
                    }
                    catch (DirectoryException de) {
                        int msgID = 10748652;
                        String message = MessageHandler.getMessage(msgID, de.getErrorMessage());
                        err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    catch (Exception e) {
                        int msgID = 10748652;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(e));
                        err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                }
                if (!schemeName.isPresent()) {
                    int msgID = 10747923;
                    String message = MessageHandler.getMessage(msgID, schemeName.getLongIdentifier());
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                encodedPWString = ((Object)encodedPW).toString();
                String scheme3 = StaticUtils.toLowerCase(schemeName.getValue());
                storageScheme = DirectoryServer.getPasswordStorageScheme(scheme3);
                if (storageScheme == null) {
                    int msgID = 10747930;
                    String message = MessageHandler.getMessage(msgID, scheme3);
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            }
            if (storageScheme.passwordMatches(clearPW, new ASN1OctetString(encodedPWString))) {
                int msgID = 10485787;
                String message = MessageHandler.getMessage(msgID);
                out.println(message);
                if (useCompareResultCode.isPresent()) {
                    return 6;
                }
                return 0;
            }
            int msgID = 10485788;
            String message = MessageHandler.getMessage(msgID);
            out.println(message);
            if (useCompareResultCode.isPresent()) {
                return 5;
            }
            return 0;
        }
        if (authPasswordSyntax.isPresent()) {
            scheme = schemeName.getValue();
            storageScheme = DirectoryServer.getAuthPasswordStorageScheme(scheme);
            if (storageScheme == null) {
                int msgID = 10748275;
                String message = MessageHandler.getMessage(msgID, scheme);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        } else {
            scheme = StaticUtils.toLowerCase(schemeName.getValue());
            storageScheme = DirectoryServer.getPasswordStorageScheme(scheme);
            if (storageScheme == null) {
                int msgID = 10747930;
                String message = MessageHandler.getMessage(msgID, scheme);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (authPasswordSyntax.isPresent()) {
            try {
                encodedPW = storageScheme.encodeAuthPassword(clearPW);
                int msgID = 10747933;
                String message = MessageHandler.getMessage(msgID, encodedPW.stringValue());
                out.println(message);
            }
            catch (DirectoryException de) {
                int msgID = 10747934;
                String message = MessageHandler.getMessage(msgID, de.getErrorMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID = 10747934;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        try {
            encodedPW = storageScheme.encodePasswordWithScheme(clearPW);
            int msgID = 10747933;
            String message = MessageHandler.getMessage(msgID, encodedPW.stringValue());
            out.println(message);
        }
        catch (DirectoryException de) {
            int msgID = 10747934;
            String message = MessageHandler.getMessage(msgID, de.getErrorMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        catch (Exception e) {
            int msgID = 10747934;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        return 0;
    }
}

