/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigConstants;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.ThreadFilterTextErrorLogPublisher;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class ImportLDIF {
    public static final int LDIF_BUFFER_SIZE = 0x100000;
    private static ErrorLogPublisher errorLogPublisher = null;

    public static void main(String[] args) {
        int retCode = ImportLDIF.mainImportLDIF(args, true, System.out, System.err);
        if (errorLogPublisher != null) {
            ErrorLogger.removeErrorLogPublisher(errorLogPublisher);
        }
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainImportLDIF(String[] args) {
        return ImportLDIF.mainImportLDIF(args, true, System.out, System.err);
    }

    public static int mainImportLDIF(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        ExistingFileBehavior existingBehavior;
        LDIFImportConfig importConfig;
        String message;
        String message2;
        int msgID;
        String message3;
        ArrayList<List<DN>> dnList;
        ArrayList<BackendCfg> entryList;
        ArrayList<Backend> backendList;
        int code;
        ArrayList<SearchFilter> includeFilters;
        ArrayList<SearchFilter> excludeFilters;
        HashSet<AttributeType> includeAttributes;
        HashSet<AttributeType> excludeAttributes;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        BooleanArgument append = null;
        BooleanArgument countRejects = null;
        BooleanArgument displayUsage = null;
        BooleanArgument isCompressed = null;
        BooleanArgument isEncrypted = null;
        BooleanArgument overwrite = null;
        BooleanArgument quietMode = null;
        BooleanArgument replaceExisting = null;
        BooleanArgument skipSchemaValidation = null;
        BooleanArgument clearBackend = null;
        IntegerArgument randomSeed = null;
        StringArgument backendID = null;
        StringArgument configClass = null;
        StringArgument configFile = null;
        StringArgument excludeAttributeStrings = null;
        StringArgument excludeBranchStrings = null;
        StringArgument excludeFilterStrings = null;
        StringArgument includeAttributeStrings = null;
        StringArgument includeBranchStrings = null;
        StringArgument includeFilterStrings = null;
        StringArgument ldifFiles = null;
        StringArgument rejectFile = null;
        StringArgument skipFile = null;
        StringArgument templateFile = null;
        String toolDescription = MessageHandler.getMessage(10486447);
        ArgumentParser argParser = new ArgumentParser("org.opends.server.tools.ImportLDIF", toolDescription, false);
        try {
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 0xA0000C, new Object[0]);
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, "{configFile}", null, null, 0xA0000D, new Object[0]);
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            ldifFiles = new StringArgument("ldiffile", Character.valueOf('l'), "ldifFile", false, true, true, "{ldifFile}", null, null, 10485829, new Object[0]);
            argParser.addArgument(ldifFiles);
            templateFile = new StringArgument("templatefile", Character.valueOf('t'), "templateFile", false, false, true, "{templateFile}", null, null, 10486363, new Object[0]);
            argParser.addArgument(templateFile);
            append = new BooleanArgument("append", Character.valueOf('a'), "append", 10485830, new Object[0]);
            argParser.addArgument(append);
            replaceExisting = new BooleanArgument("replaceexisting", Character.valueOf('r'), "replaceExisting", 10485831, new Object[0]);
            argParser.addArgument(replaceExisting);
            backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", false, false, true, "{backendID}", null, null, 10485832, new Object[0]);
            argParser.addArgument(backendID);
            clearBackend = new BooleanArgument("clearbackend", Character.valueOf('F'), "clearBackend", 10487011, new Object[0]);
            argParser.addArgument(clearBackend);
            includeBranchStrings = new StringArgument("includebranch", Character.valueOf('b'), "includeBranch", false, true, true, "{branchDN}", null, null, 10485976, new Object[0]);
            argParser.addArgument(includeBranchStrings);
            excludeBranchStrings = new StringArgument("excludebranch", Character.valueOf('B'), "excludeBranch", false, true, true, "{branchDN}", null, null, 10485833, new Object[0]);
            argParser.addArgument(excludeBranchStrings);
            includeAttributeStrings = new StringArgument("includeattribute", Character.valueOf('i'), "includeAttribute", false, true, true, "{attribute}", null, null, 0xA0004A, new Object[0]);
            argParser.addArgument(includeAttributeStrings);
            excludeAttributeStrings = new StringArgument("excludeattribute", Character.valueOf('e'), "excludeAttribute", false, true, true, "{attribute}", null, null, 10485835, new Object[0]);
            argParser.addArgument(excludeAttributeStrings);
            includeFilterStrings = new StringArgument("includefilter", Character.valueOf('I'), "includeFilter", false, true, true, "{filter}", null, null, 10485836, new Object[0]);
            argParser.addArgument(includeFilterStrings);
            excludeFilterStrings = new StringArgument("excludefilter", Character.valueOf('E'), "excludeFilter", false, true, true, "{filter}", null, null, 10485837, new Object[0]);
            argParser.addArgument(excludeFilterStrings);
            rejectFile = new StringArgument("rejectfile", Character.valueOf('R'), "rejectFile", false, false, true, "{rejectFile}", null, null, 10485838, new Object[0]);
            argParser.addArgument(rejectFile);
            skipFile = new StringArgument("skipfile", Character.valueOf('K'), "skipFile", false, false, true, "{skipFile}", null, null, 10486957, new Object[0]);
            argParser.addArgument(skipFile);
            overwrite = new BooleanArgument("overwrite", Character.valueOf('O'), "overwrite", 10485839, new Object[0]);
            argParser.addArgument(overwrite);
            randomSeed = new IntegerArgument("randomseed", Character.valueOf('s'), "randomSeed", false, false, true, "{seed}", 0, null, false, 0, false, 0, 10486369, new Object[0]);
            argParser.addArgument(randomSeed);
            skipSchemaValidation = new BooleanArgument("skipschema", Character.valueOf('S'), "skipSchemaValidation", 10486099, new Object[0]);
            argParser.addArgument(skipSchemaValidation);
            countRejects = new BooleanArgument("countrejects", null, "countRejects", 10486955, new Object[0]);
            argParser.addArgument(countRejects);
            isCompressed = new BooleanArgument("iscompressed", Character.valueOf('c'), "isCompressed", 0xA00050, new Object[0]);
            argParser.addArgument(isCompressed);
            isEncrypted = new BooleanArgument("isencrypted", Character.valueOf('y'), "isEncrypted", 10485841, new Object[0]);
            argParser.addArgument(isEncrypted);
            quietMode = new BooleanArgument("quietmode", Character.valueOf('q'), "quiet", 10486292, new Object[0]);
            argParser.addArgument(quietMode);
            displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", 0xA0000F, new Object[0]);
            argParser.addArgument(displayUsage);
            argParser.setUsageArgument(displayUsage);
        }
        catch (ArgumentException ae) {
            int msgID2 = 10747920;
            String message4 = MessageHandler.getMessage(msgID2, ae.getMessage());
            err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID3 = 10747921;
            String message5 = MessageHandler.getMessage(msgID3, ae.getMessage());
            err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (ldifFiles.isPresent()) {
            if (templateFile.isPresent()) {
                int msgID4 = 10748508;
                String message6 = MessageHandler.getMessage(msgID4, ldifFiles.getLongIdentifier(), templateFile.getLongIdentifier());
                err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        } else if (!templateFile.isPresent()) {
            int msgID5 = 10748509;
            String message7 = MessageHandler.getMessage(msgID5, ldifFiles.getLongIdentifier(), templateFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (!includeBranchStrings.isPresent() && !backendID.isPresent()) {
            int msgID6 = 10749156;
            String message8 = MessageHandler.getMessage(msgID6, includeBranchStrings.getLongIdentifier(), backendID.getLongIdentifier());
            err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
            }
            catch (Exception e) {
                int msgID7 = 10747924;
                String message9 = MessageHandler.getMessage(msgID7, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
            }
            catch (InitializationException ie) {
                int msgID8 = 10747925;
                String message10 = MessageHandler.getMessage(msgID8, ie.getMessage());
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID9 = 10747925;
                String message11 = MessageHandler.getMessage(msgID9, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                int msgID10 = 10747926;
                String message12 = MessageHandler.getMessage(msgID10, ce.getMessage());
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID11 = 10747926;
                String message13 = MessageHandler.getMessage(msgID11, ie.getMessage());
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID12 = 10747926;
                String message14 = MessageHandler.getMessage(msgID12, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                int msgID13 = 10747927;
                String message15 = MessageHandler.getMessage(msgID13, ce.getMessage());
                err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID14 = 10747927;
                String message16 = MessageHandler.getMessage(msgID14, ie.getMessage());
                err.println(StaticUtils.wrapText(message16, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID15 = 10747927;
                String message17 = MessageHandler.getMessage(msgID15, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message17, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeCryptoManager();
            }
            catch (ConfigException ce) {
                int msgID16 = 10748188;
                String message18 = MessageHandler.getMessage(msgID16, ce.getMessage());
                err.println(StaticUtils.wrapText(message18, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID17 = 10748188;
                String message19 = MessageHandler.getMessage(msgID17, ie.getMessage());
                err.println(StaticUtils.wrapText(message19, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID18 = 10748188;
                String message20 = MessageHandler.getMessage(msgID18, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message20, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            if (!quietMode.isPresent()) {
                try {
                    errorLogPublisher = new ThreadFilterTextErrorLogPublisher(Thread.currentThread(), new TextWriter.STREAM(out));
                    ErrorLogger.addErrorLogPublisher(errorLogPublisher);
                }
                catch (Exception e) {
                    err.println("Error installing the custom error logger: " + StaticUtils.stackTraceToSingleLineString(e));
                }
            }
            try {
                directoryServer.initializePasswordPolicyComponents();
            }
            catch (ConfigException ce) {
                int msgID19 = 10748277;
                String message21 = MessageHandler.getMessage(msgID19, ce.getMessage());
                err.println(StaticUtils.wrapText(message21, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID20 = 10748277;
                String message22 = MessageHandler.getMessage(msgID20, ie.getMessage());
                err.println(StaticUtils.wrapText(message22, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID21 = 10748277;
                String message23 = MessageHandler.getMessage(msgID21, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message23, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                HashSet<PluginType> pluginTypes = new HashSet<PluginType>(1);
                pluginTypes.add(PluginType.LDIF_IMPORT);
                directoryServer.initializePlugins(pluginTypes);
            }
            catch (ConfigException ce) {
                int msgID22 = 10748245;
                String message24 = MessageHandler.getMessage(msgID22, ce.getMessage());
                err.println(StaticUtils.wrapText(message24, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID23 = 10748245;
                String message25 = MessageHandler.getMessage(msgID23, ie.getMessage());
                err.println(StaticUtils.wrapText(message25, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID24 = 10748245;
                String message26 = MessageHandler.getMessage(msgID24, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message26, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        boolean excludeAllUserAttributes = false;
        boolean excludeAllOperationalAttributes = false;
        if (excludeAttributeStrings == null) {
            excludeAttributes = null;
        } else {
            excludeAttributes = new HashSet<AttributeType>();
            for (String attrName : excludeAttributeStrings.getValues()) {
                String lowerName = attrName.toLowerCase();
                if (lowerName.equals("*")) {
                    excludeAllUserAttributes = true;
                    continue;
                }
                if (lowerName.equals("+")) {
                    excludeAllOperationalAttributes = true;
                    continue;
                }
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(attrName);
                }
                excludeAttributes.add(attrType);
            }
        }
        boolean includeAllUserAttributes = false;
        boolean includeAllOperationalAttributes = false;
        if (includeAttributeStrings == null) {
            includeAttributes = null;
        } else {
            includeAttributes = new HashSet<AttributeType>();
            for (String attrName : includeAttributeStrings.getValues()) {
                String lowerName = attrName.toLowerCase();
                if (lowerName.equals("*")) {
                    includeAllUserAttributes = true;
                    continue;
                }
                if (lowerName.equals("+")) {
                    includeAllOperationalAttributes = true;
                    continue;
                }
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(attrName);
                }
                includeAttributes.add(attrType);
            }
        }
        if (excludeFilterStrings == null) {
            excludeFilters = null;
        } else {
            excludeFilters = new ArrayList<SearchFilter>();
            for (String filterString : excludeFilterStrings.getValues()) {
                try {
                    excludeFilters.add(SearchFilter.createFilterFromString(filterString));
                }
                catch (DirectoryException de) {
                    int msgID25 = 10747993;
                    String message27 = MessageHandler.getMessage(msgID25, filterString, de.getErrorMessage());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message27, msgID25);
                    return 1;
                }
                catch (Exception e) {
                    int msgID26 = 10747993;
                    String message28 = MessageHandler.getMessage(msgID26, filterString, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message28, msgID26);
                    return 1;
                }
            }
        }
        if (includeFilterStrings == null) {
            includeFilters = null;
        } else {
            includeFilters = new ArrayList<SearchFilter>();
            for (String filterString : includeFilterStrings.getValues()) {
                try {
                    includeFilters.add(SearchFilter.createFilterFromString(filterString));
                }
                catch (DirectoryException de) {
                    int msgID27 = 10747994;
                    String message29 = MessageHandler.getMessage(msgID27, filterString, de.getErrorMessage());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message29, msgID27);
                    return 1;
                }
                catch (Exception e) {
                    int msgID28 = 10747994;
                    String message30 = MessageHandler.getMessage(msgID28, filterString, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message30, msgID28);
                    return 1;
                }
            }
        }
        Backend backend = null;
        List<DN> defaultIncludeBranches = null;
        ArrayList<DN> excludeBranches = new ArrayList<DN>();
        ArrayList<DN> includeBranches = new ArrayList<DN>();
        if (includeBranchStrings.isPresent()) {
            includeBranches = new ArrayList();
            for (String s : includeBranchStrings.getValues()) {
                DN includeBranch;
                try {
                    includeBranch = DN.decode(s);
                }
                catch (DirectoryException de) {
                    int msgID29 = 10748122;
                    String message31 = MessageHandler.getMessage(msgID29, s, de.getErrorMessage());
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message31, msgID29);
                    return 1;
                }
                catch (Exception e) {
                    int msgID30 = 10748122;
                    String message32 = MessageHandler.getMessage(msgID30, s, StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message32, msgID30);
                    return 1;
                }
                includeBranches.add(includeBranch);
            }
        }
        if ((code = BackendToolUtils.getBackends(backendList = new ArrayList<Backend>(), entryList = new ArrayList<BackendCfg>(), dnList = new ArrayList<List<DN>>())) != 0) {
            return code;
        }
        int numBackends = backendList.size();
        for (int i = 0; i < numBackends; ++i) {
            Backend b = backendList.get(i);
            if (backendID.isPresent()) {
                if (!backendID.getValue().equals(b.getBackendID())) {
                    continue;
                }
            } else {
                boolean useBackend = false;
                for (DN baseDN : dnList.get(i)) {
                    for (DN includeDN : includeBranches) {
                        if (!baseDN.isAncestorOf(includeDN)) continue;
                        useBackend = true;
                        break;
                    }
                    if (!useBackend) continue;
                    break;
                }
                if (!useBackend) continue;
            }
            if (backend == null) {
                backend = b;
                defaultIncludeBranches = dnList.get(i);
                continue;
            }
            int msgID31 = 10747996;
            message3 = MessageHandler.getMessage(msgID31);
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message3, msgID31);
            return 1;
        }
        if (backend == null) {
            msgID = 10747997;
            message2 = MessageHandler.getMessage(msgID, backendID.getValue());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message2, msgID);
            return 1;
        }
        if (!backend.supportsLDIFImport()) {
            msgID = 10748118;
            message2 = MessageHandler.getMessage(msgID, backendID.getValue());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message2, msgID);
            return 1;
        }
        for (List<DN> baseList : dnList) {
            block67: for (DN baseDN : baseList) {
                for (DN importBase : defaultIncludeBranches) {
                    if (!baseDN.isDescendantOf(importBase) || baseDN.equals(importBase)) continue;
                    if (excludeBranches.contains(baseDN)) continue block67;
                    excludeBranches.add(baseDN);
                    continue block67;
                }
            }
        }
        if (backendID.isPresent() && !includeBranchStrings.isPresent() && !append.isPresent() && defaultIncludeBranches.size() > 1 && !clearBackend.isPresent()) {
            StringBuilder builder = new StringBuilder();
            builder.append(backend.getBaseDNs()[0].toNormalizedString());
            for (int i = 1; i < backend.getBaseDNs().length; ++i) {
                builder.append(" / ");
                builder.append(backend.getBaseDNs()[i].toNormalizedString());
            }
            int msgID32 = 10749157;
            String message33 = MessageHandler.getMessage(msgID32, builder.toString(), clearBackend.getLongIdentifier());
            err.println(StaticUtils.wrapText(message33, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        for (String s : excludeBranchStrings.getValues()) {
            DN excludeBranch;
            try {
                excludeBranch = DN.decode(s);
            }
            catch (DirectoryException de) {
                int msgID33 = 10747998;
                message = MessageHandler.getMessage(msgID33, s, de.getErrorMessage());
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID33);
                return 1;
            }
            catch (Exception e) {
                int msgID34 = 10747998;
                message = MessageHandler.getMessage(msgID34, s, StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID34);
                return 1;
            }
            if (excludeBranches.contains(excludeBranch)) continue;
            excludeBranches.add(excludeBranch);
        }
        if (!includeBranchStrings.isPresent()) {
            includeBranches = defaultIncludeBranches;
        } else {
            for (DN includeBranch : includeBranches) {
                if (Backend.handlesEntry(includeBranch, defaultIncludeBranches, excludeBranches)) continue;
                int msgID35 = 10748123;
                message3 = MessageHandler.getMessage(msgID35, includeBranch.toNormalizedString(), backendID.getValue());
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message3, msgID35);
                return 1;
            }
        }
        if (ldifFiles.isPresent()) {
            ArrayList<String> fileList = new ArrayList<String>(ldifFiles.getValues());
            int badFileCount = 0;
            for (String pathname : fileList) {
                File f = new File(pathname);
                if (f.canRead()) continue;
                int msgID36 = 10748791;
                String message34 = MessageHandler.getMessage(msgID36, pathname);
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message34, msgID36);
                ++badFileCount;
            }
            if (badFileCount > 0) {
                return 1;
            }
            importConfig = new LDIFImportConfig(fileList);
        } else {
            Random random;
            if (randomSeed.isPresent()) {
                try {
                    random = new Random(randomSeed.getIntValue());
                }
                catch (Exception e) {
                    random = new Random();
                }
            } else {
                random = new Random();
            }
            String resourcePath = DirectoryServer.getServerRoot() + File.separator + ConfigConstants.PATH_MAKELDIF_RESOURCE_DIR;
            TemplateFile tf = new TemplateFile(resourcePath, random);
            ArrayList<String> warnings = new ArrayList<String>();
            try {
                tf.parse(templateFile.getValue(), warnings);
            }
            catch (Exception e) {
                int msgID37 = 10748510;
                String message35 = MessageHandler.getMessage(msgID37, templateFile.getValue(), e.getMessage());
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message35, msgID37);
                return 1;
            }
            importConfig = new LDIFImportConfig(tf);
        }
        importConfig.setAppendToExistingData(append.isPresent());
        importConfig.setReplaceExistingEntries(replaceExisting.isPresent());
        importConfig.setCompressed(isCompressed.isPresent());
        importConfig.setClearBackend(clearBackend.isPresent());
        importConfig.setEncrypted(isEncrypted.isPresent());
        importConfig.setExcludeAttributes(excludeAttributes);
        importConfig.setExcludeBranches(excludeBranches);
        importConfig.setExcludeFilters(excludeFilters);
        importConfig.setIncludeAttributes(includeAttributes);
        importConfig.setIncludeBranches(includeBranches);
        importConfig.setIncludeFilters(includeFilters);
        importConfig.setValidateSchema(!skipSchemaValidation.isPresent());
        importConfig.setBufferSize(0x100000);
        importConfig.setExcludeAllUserAttributes(excludeAllUserAttributes);
        importConfig.setExcludeAllOperationalAttributes(excludeAllOperationalAttributes);
        importConfig.setIncludeAllOpAttributes(includeAllOperationalAttributes);
        importConfig.setIncludeAllUserAttributes(includeAllUserAttributes);
        importConfig.setInvokeImportPlugins(true);
        if (rejectFile != null) {
            try {
                existingBehavior = overwrite.isPresent() ? ExistingFileBehavior.OVERWRITE : ExistingFileBehavior.APPEND;
                importConfig.writeRejectedEntries(rejectFile.getValue(), existingBehavior);
            }
            catch (Exception e) {
                int msgID38 = 10747999;
                message3 = MessageHandler.getMessage(msgID38, rejectFile.getValue(), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message3, msgID38);
                return 1;
            }
        }
        if (skipFile != null) {
            try {
                existingBehavior = overwrite.isPresent() ? ExistingFileBehavior.OVERWRITE : ExistingFileBehavior.APPEND;
                importConfig.writeSkippedEntries(skipFile.getValue(), existingBehavior);
            }
            catch (Exception e) {
                int msgID39 = 10749102;
                message3 = MessageHandler.getMessage(msgID39, skipFile.getValue(), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message3, msgID39);
                return 1;
            }
        }
        DN[] baseDNs = new DN[defaultIncludeBranches.size()];
        defaultIncludeBranches.toArray(baseDNs);
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                int msgID40 = 10748236;
                message = MessageHandler.getMessage(msgID40, backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID40);
                return 1;
            }
        }
        catch (Exception e) {
            int msgID41 = 10748236;
            String message36 = MessageHandler.getMessage(msgID41, backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message36, msgID41);
            return 1;
        }
        int retCode = 0;
        try {
            LDIFImportResult importResult = backend.importLDIF(importConfig);
            if (countRejects.isPresent()) {
                retCode = importResult.getEntriesRejected() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)importResult.getEntriesRejected();
            }
        }
        catch (DirectoryException de) {
            int msgID42 = 10748000;
            message = MessageHandler.getMessage(msgID42, de.getErrorMessage());
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID42);
            retCode = 1;
        }
        catch (Exception e) {
            int msgID43 = 10748000;
            message = MessageHandler.getMessage(msgID43, StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, message, msgID43);
            retCode = 1;
        }
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                int msgID44 = 10617165;
                String message37 = MessageHandler.getMessage(msgID44, backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message37, msgID44);
                retCode = 1;
            }
        }
        catch (Exception e) {
            int msgID45 = 10617165;
            message = MessageHandler.getMessage(msgID45, backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, message, msgID45);
            retCode = 1;
        }
        importConfig.close();
        return retCode;
    }
}

