/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.ConfigureDS;
import org.opends.server.tools.ConfigureWindowsService;
import org.opends.server.tools.ImportLDIF;
import org.opends.server.types.DN;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class InstallDS {
    private static final String CLASS_NAME = "org.opends.server.tools.InstallDS";
    private static final boolean isWindows = SetupUtils.isWindows();
    private static String versionString;
    private static String programName;
    private static final int POPULATE_TYPE_BASE_ONLY = 1;
    private static final int POPULATE_TYPE_LEAVE_EMPTY = 2;
    private static final int POPULATE_TYPE_IMPORT_FROM_LDIF = 3;
    private static final int POPULATE_TYPE_GENERATE_SAMPLE_DATA = 4;

    public static void main(String[] args) {
        int exitCode = InstallDS.installMain(args);
        if (exitCode != 0) {
            System.exit(StaticUtils.filterExitCode(exitCode));
        }
    }

    public static int installMain(String[] args) {
        String message;
        int returnValue;
        String message2;
        LinkedList<String> ldifFiles;
        int numUsers;
        int populateType;
        LinkedList<DN> baseDNs;
        String rootPassword;
        LinkedList<DN> rootDNs;
        int jmxPortNumber;
        int ldapPortNumber;
        String configClassName;
        String configFileName;
        BooleanArgument enableWindowsService;
        BooleanArgument silentInstall;
        block114: {
            FileBasedArgument rootPWFile;
            StringArgument rootPWString;
            StringArgument rootDN;
            IntegerArgument sampleData;
            StringArgument importLDIF;
            BooleanArgument addBaseEntry;
            StringArgument baseDN;
            block113: {
                BooleanArgument skipPortCheck;
                IntegerArgument jmxPort;
                block112: {
                    IntegerArgument ldapPort;
                    StringArgument configClass;
                    StringArgument configFile;
                    BooleanArgument testOnly;
                    versionString = DirectoryServer.getVersionString();
                    programName = isWindows ? "setup.bat" : "setup";
                    String toolDescription = MessageHandler.getMessage(10486448);
                    ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false);
                    try {
                        testOnly = new BooleanArgument("test", Character.valueOf('t'), "testOnly", 10486245, new Object[0]);
                        testOnly.setHidden(true);
                        argParser.addArgument(testOnly);
                        StringArgument progName = new StringArgument("progname", Character.valueOf('P'), "programName", false, false, true, "{programName}", programName, null, 10486246, new Object[0]);
                        progName.setHidden(true);
                        argParser.addArgument(progName);
                        configFile = new StringArgument("configfile", Character.valueOf('c'), "configFile", false, false, true, "{configFile}", null, null, 0xA0000D, new Object[0]);
                        configFile.setHidden(true);
                        argParser.addArgument(configFile);
                        configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 0xA0000C, new Object[0]);
                        configClass.setHidden(true);
                        argParser.addArgument(configClass);
                        BooleanArgument cliMode = new BooleanArgument("cli", null, "cli", 10486512, new Object[0]);
                        argParser.addArgument(cliMode);
                        silentInstall = new BooleanArgument("silent", Character.valueOf('s'), "silentInstall", 10486249, new Object[0]);
                        argParser.addArgument(silentInstall);
                        baseDN = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, true, true, "{baseDN}", "dc=example,dc=com", null, 10486250, new Object[0]);
                        argParser.addArgument(baseDN);
                        addBaseEntry = new BooleanArgument("addbase", Character.valueOf('a'), "addBaseEntry", 10486251, new Object[0]);
                        argParser.addArgument(addBaseEntry);
                        importLDIF = new StringArgument("importldif", Character.valueOf('l'), "ldifFile", false, true, true, "{ldifFile}", null, null, 10486252, new Object[0]);
                        argParser.addArgument(importLDIF);
                        sampleData = new IntegerArgument("sampledata", Character.valueOf('d'), "sampleData", false, false, true, "{numEntries}", 0, null, true, 0, false, 0, 10486513, new Object[0]);
                        argParser.addArgument(sampleData);
                        ldapPort = new IntegerArgument("ldapport", Character.valueOf('p'), "ldapPort", false, false, true, "{port}", 389, null, true, 1, true, 65535, 10486253, new Object[0]);
                        argParser.addArgument(ldapPort);
                        jmxPort = new IntegerArgument("jmxport", Character.valueOf('x'), "jmxPort", false, false, true, "{jmxPort}", SetupUtils.getDefaultJMXPort(), null, true, 1, true, 65535, 10486568, new Object[0]);
                        argParser.addArgument(jmxPort);
                        skipPortCheck = new BooleanArgument("skipportcheck", Character.valueOf('S'), "skipPortCheck", 10486254, new Object[0]);
                        argParser.addArgument(skipPortCheck);
                        rootDN = new StringArgument("rootdn", Character.valueOf('D'), "rootUserDN", false, true, true, "{rootUserDN}", "cn=Directory Manager", null, 10486255, new Object[0]);
                        argParser.addArgument(rootDN);
                        rootPWString = new StringArgument("rootpwstring", Character.valueOf('w'), "rootUserPassword", false, false, true, "{password}", null, null, 10486256, new Object[0]);
                        argParser.addArgument(rootPWString);
                        rootPWFile = new FileBasedArgument("rootpwfile", Character.valueOf('j'), "rootUserPasswordFile", false, false, "{bindPasswordFile}", null, null, 10486257, new Object[0]);
                        argParser.addArgument(rootPWFile);
                        enableWindowsService = new BooleanArgument("enablewindowsservice", Character.valueOf('e'), "enableWindowsService", 10486603, new Object[0]);
                        if (SetupUtils.isWindows()) {
                            argParser.addArgument(enableWindowsService);
                        }
                        BooleanArgument showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", 10486258, new Object[0]);
                        argParser.addArgument(showUsage);
                        argParser.setUsageArgument(showUsage);
                    }
                    catch (ArgumentException ae) {
                        System.err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                        System.err.println(argParser.getUsage());
                        return 1;
                    }
                    try {
                        argParser.parseArguments(args);
                    }
                    catch (ArgumentException ae) {
                        System.err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                        System.err.println(argParser.getUsage());
                        return 1;
                    }
                    if (argParser.usageOrVersionDisplayed() || testOnly.isPresent()) {
                        return 0;
                    }
                    try {
                        HashSet<Integer> ports = new HashSet<Integer>();
                        if (ldapPort.isPresent()) {
                            ports.add(ldapPort.getIntValue());
                        }
                        if (jmxPort.isPresent()) {
                            if (ports.contains(jmxPort.getIntValue())) {
                                int msgID = 10749115;
                                String message3 = MessageHandler.getMessage(msgID, String.valueOf(jmxPort.getIntValue()));
                                System.err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                                System.err.println(argParser.getUsage());
                                return 1;
                            }
                            ports.add(jmxPort.getIntValue());
                        }
                    }
                    catch (ArgumentException ae) {
                        int msgID = 10747920;
                        String message4 = MessageHandler.getMessage(msgID, ae.getMessage());
                        System.err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    if (addBaseEntry.isPresent()) {
                        if (importLDIF.isPresent()) {
                            int msgID = 10748606;
                            String message5 = MessageHandler.getMessage(msgID, addBaseEntry.getLongIdentifier(), importLDIF.getLongIdentifier());
                            System.err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                            return 1;
                        }
                        if (sampleData.isPresent()) {
                            int msgID = 10748606;
                            String message6 = MessageHandler.getMessage(msgID, addBaseEntry.getLongIdentifier(), sampleData.getLongIdentifier());
                            System.err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                            return 1;
                        }
                    } else if (importLDIF.isPresent() && sampleData.isPresent()) {
                        int msgID = 10748606;
                        String message7 = MessageHandler.getMessage(msgID, importLDIF.getLongIdentifier(), sampleData.getLongIdentifier());
                        System.err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    if (!configFile.isPresent()) {
                        int msgID = 10748403;
                        String message8 = MessageHandler.getMessage(msgID, configFile.getLongIdentifier());
                        System.err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    configFileName = configFile.getValue();
                    configClassName = configClass.getValue();
                    if (!silentInstall.isPresent()) {
                        System.out.println(versionString);
                        System.out.println();
                        int msgID = 10486294;
                        String message9 = MessageHandler.getMessage(msgID);
                        System.out.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                    }
                    DirectoryServer directoryServer = DirectoryServer.getInstance();
                    directoryServer.bootstrapClient();
                    try {
                        directoryServer.initializeJMX();
                    }
                    catch (Exception e) {
                        int msgID = 10748404;
                        String message10 = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
                        System.err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    try {
                        directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
                    }
                    catch (Exception e) {
                        int msgID = 10748405;
                        String message11 = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
                        System.err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    try {
                        directoryServer.initializeSchema();
                    }
                    catch (Exception e) {
                        int msgID = 10748406;
                        String message12 = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
                        System.err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                    if (silentInstall.isPresent() || ldapPort.isPresent()) {
                        try {
                            ldapPortNumber = ldapPort.getIntValue();
                            if (!skipPortCheck.isPresent() && !SetupUtils.canUseAsPort(ldapPortNumber)) {
                                if (SetupUtils.isPriviledgedPort(ldapPortNumber)) {
                                    int msgID = 10748414;
                                    String message13 = MessageHandler.getMessage(msgID, ldapPortNumber);
                                    System.err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                                } else {
                                    int msgID = 10748415;
                                    String message14 = MessageHandler.getMessage(msgID, ldapPortNumber);
                                    System.err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                                }
                                return 1;
                            }
                            break block112;
                        }
                        catch (ArgumentException ae) {
                            System.err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                            return 1;
                        }
                    }
                    while (true) {
                        int msgID = 10486269;
                        String message15 = MessageHandler.getMessage(msgID);
                        ldapPortNumber = InstallDS.promptForInteger(message15, 389, 1, 65535);
                        if (skipPortCheck.isPresent() || SetupUtils.canUseAsPort(ldapPortNumber)) break;
                        if (SetupUtils.isPriviledgedPort(ldapPortNumber)) {
                            msgID = 10748414;
                            message15 = MessageHandler.getMessage(msgID, ldapPortNumber);
                            System.err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                            continue;
                        }
                        msgID = 10748415;
                        message15 = MessageHandler.getMessage(msgID, ldapPortNumber);
                        System.err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                    }
                }
                if (silentInstall.isPresent() || jmxPort.isPresent()) {
                    try {
                        jmxPortNumber = jmxPort.getIntValue();
                        if (!skipPortCheck.isPresent() && !SetupUtils.canUseAsPort(jmxPortNumber)) {
                            if (SetupUtils.isPriviledgedPort(jmxPortNumber)) {
                                int msgID = 10748414;
                                String message16 = MessageHandler.getMessage(msgID, jmxPortNumber);
                                System.err.println(StaticUtils.wrapText(message16, ServerConstants.MAX_LINE_WIDTH));
                            } else {
                                int msgID = 10748415;
                                String message17 = MessageHandler.getMessage(msgID, jmxPortNumber);
                                System.err.println(StaticUtils.wrapText(message17, ServerConstants.MAX_LINE_WIDTH));
                            }
                            return 1;
                        }
                        break block113;
                    }
                    catch (ArgumentException ae) {
                        System.err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                }
                jmxPortNumber = -1;
            }
            if (rootDN.isPresent()) {
                rootDNs = new LinkedList<DN>();
                for (String s : rootDN.getValues()) {
                    try {
                        rootDNs.add(DN.decode(s));
                    }
                    catch (Exception e) {
                        int msgID = 10748407;
                        String message18 = MessageHandler.getMessage(msgID, s, e.getMessage());
                        System.err.println(StaticUtils.wrapText(message18, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                }
            } else if (silentInstall.isPresent()) {
                rootDNs = new LinkedList();
                try {
                    rootDNs.add(DN.decode(rootDN.getDefaultValue()));
                }
                catch (Exception e) {
                    int msgID = 10748407;
                    String message19 = MessageHandler.getMessage(msgID, rootDN.getDefaultValue(), e.getMessage());
                    System.err.println(StaticUtils.wrapText(message19, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            } else {
                int msgID = 0xA00200;
                String message20 = MessageHandler.getMessage(msgID);
                rootDNs = new LinkedList();
                rootDNs.add(InstallDS.promptForDN(message20, rootDN.getDefaultValue()));
            }
            if (rootPWString.isPresent()) {
                rootPassword = rootPWString.getValue();
                if (rootPWFile.isPresent()) {
                    int msgID = 10748411;
                    String message21 = MessageHandler.getMessage(msgID, rootPWString.getLongIdentifier(), rootPWFile.getLongIdentifier());
                    System.err.println(StaticUtils.wrapText(message21, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            } else if (rootPWFile.isPresent()) {
                rootPassword = rootPWFile.getValue();
            } else {
                if (silentInstall.isPresent()) {
                    int msgID = 10748417;
                    String message22 = MessageHandler.getMessage(msgID, rootPWString.getLongIdentifier(), rootPWFile.getLongIdentifier());
                    System.err.println(StaticUtils.wrapText(message22, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                int msgID = 0xA00202;
                String initialPrompt = MessageHandler.getMessage(msgID);
                msgID = 10486275;
                String confirmPrompt = MessageHandler.getMessage(msgID);
                rootPassword = new String(InstallDS.promptForPassword(initialPrompt, confirmPrompt));
            }
            if (baseDN.isPresent()) {
                baseDNs = new LinkedList<DN>();
                for (String s : baseDN.getValues()) {
                    try {
                        baseDNs.add(DN.decode(s));
                    }
                    catch (Exception e) {
                        int msgID = 10748407;
                        String message23 = MessageHandler.getMessage(msgID, s, e.getMessage());
                        System.err.println(StaticUtils.wrapText(message23, ServerConstants.MAX_LINE_WIDTH));
                        return 1;
                    }
                }
            } else if (silentInstall.isPresent()) {
                try {
                    baseDNs = new LinkedList();
                    baseDNs.add(DN.decode(baseDN.getDefaultValue()));
                }
                catch (Exception e) {
                    int msgID = 10748407;
                    String message24 = MessageHandler.getMessage(msgID, baseDN.getDefaultValue(), e.getMessage());
                    System.err.println(StaticUtils.wrapText(message24, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            } else {
                int msgID = 10486264;
                String message25 = MessageHandler.getMessage(msgID);
                baseDNs = new LinkedList();
                baseDNs.add(InstallDS.promptForDN(message25, baseDN.getDefaultValue()));
            }
            populateType = 2;
            numUsers = -1;
            ldifFiles = null;
            if (addBaseEntry.isPresent()) {
                populateType = 1;
            } else if (importLDIF.isPresent()) {
                ldifFiles = importLDIF.getValues();
                populateType = 3;
            } else {
                if (sampleData.isPresent()) {
                    try {
                        numUsers = sampleData.getIntValue();
                        populateType = 4;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return 1;
                    }
                }
                if (silentInstall.isPresent()) {
                    populateType = 2;
                } else {
                    int msgID = 10486514;
                    System.out.println(StaticUtils.wrapText(MessageHandler.getMessage(msgID), ServerConstants.MAX_LINE_WIDTH));
                    msgID = 10486515;
                    System.out.println(StaticUtils.wrapText("1.  " + MessageHandler.getMessage(msgID), ServerConstants.MAX_LINE_WIDTH));
                    msgID = 10486516;
                    System.out.println(StaticUtils.wrapText("2.  " + MessageHandler.getMessage(msgID), ServerConstants.MAX_LINE_WIDTH));
                    msgID = 10486517;
                    System.out.println(StaticUtils.wrapText("3.  " + MessageHandler.getMessage(msgID), ServerConstants.MAX_LINE_WIDTH));
                    msgID = 10486518;
                    System.out.println(StaticUtils.wrapText("4.  " + MessageHandler.getMessage(msgID), ServerConstants.MAX_LINE_WIDTH));
                    msgID = 10486519;
                    populateType = InstallDS.promptForInteger(MessageHandler.getMessage(msgID), 1, 1, 4);
                    System.out.println();
                    if (populateType == 3) {
                        ldifFiles = new LinkedList();
                        while (true) {
                            String path;
                            if (new File(path = InstallDS.promptForString(message2 = MessageHandler.getMessage(msgID = 10486266), "")).exists()) {
                                ldifFiles.add(path);
                                System.out.println();
                                break block114;
                            }
                            msgID = 10748684;
                            message2 = MessageHandler.getMessage(msgID, path);
                            System.err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                            System.err.println();
                        }
                    }
                    if (populateType == 4) {
                        msgID = 10486541;
                        message2 = MessageHandler.getMessage(msgID);
                        numUsers = InstallDS.promptForInteger(message2, 2000, 0, Integer.MAX_VALUE);
                        System.out.println();
                    }
                }
            }
        }
        boolean enableService = false;
        if (SetupUtils.isWindows()) {
            if (silentInstall.isPresent()) {
                enableService = enableWindowsService.isPresent();
            } else if (enableWindowsService.isPresent()) {
                enableService = true;
            } else {
                message2 = MessageHandler.getMessage(10486602);
                enableService = InstallDS.promptForBoolean(message2, Boolean.TRUE);
            }
        }
        ArrayList<String> argList = new ArrayList<String>();
        argList.add("-C");
        argList.add(configClassName);
        argList.add("-c");
        argList.add(configFileName);
        argList.add("-p");
        argList.add(String.valueOf(ldapPortNumber));
        if (jmxPortNumber != -1) {
            argList.add("-x");
            argList.add(String.valueOf(jmxPortNumber));
        }
        for (DN dn : baseDNs) {
            argList.add("-b");
            argList.add(dn.toString());
        }
        for (DN dn : rootDNs) {
            argList.add("-D");
            argList.add(dn.toString());
        }
        argList.add("-w");
        argList.add(rootPassword);
        String[] configureDSArguments = new String[argList.size()];
        argList.toArray(configureDSArguments);
        if (!silentInstall.isPresent()) {
            System.out.println();
            String message26 = MessageHandler.getMessage(10486276);
            System.out.println(StaticUtils.wrapText(message26, ServerConstants.MAX_LINE_WIDTH));
        }
        if ((returnValue = ConfigureDS.configMain(configureDSArguments)) != 0) {
            return returnValue;
        }
        if (populateType == 1) {
            if (!silentInstall.isPresent()) {
                message = MessageHandler.getMessage(10486277);
                System.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            try {
                File ldifFile = File.createTempFile("opends-base-entry", ".ldif");
                String ldifFilePath = ldifFile.getAbsolutePath();
                ldifFile.deleteOnExit();
                LDIFExportConfig exportConfig = new LDIFExportConfig(ldifFilePath, ExistingFileBehavior.OVERWRITE);
                LDIFWriter writer = new LDIFWriter(exportConfig);
                for (DN dn : baseDNs) {
                    writer.writeEntry(StaticUtils.createEntry(dn));
                }
                writer.close();
                if (ldifFiles == null) {
                    ldifFiles = new LinkedList();
                }
                ldifFiles.add(ldifFilePath);
            }
            catch (Exception e) {
                int msgID = 10748422;
                String message27 = MessageHandler.getMessage(msgID, String.valueOf(e));
                System.err.println(StaticUtils.wrapText(message27, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (populateType == 4) {
            try {
                File templateFile = SetupUtils.createTemplateFile(((DN)baseDNs.getFirst()).toString(), numUsers);
                if (ldifFiles == null) {
                    ldifFiles = new LinkedList();
                }
                ldifFiles.add(templateFile.getAbsolutePath());
            }
            catch (Exception e) {
                int msgID = 10748686;
                String message28 = MessageHandler.getMessage(msgID, String.valueOf(e));
                System.err.println(StaticUtils.wrapText(message28, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (ldifFiles != null && !ldifFiles.isEmpty()) {
            String message29;
            if (!silentInstall.isPresent()) {
                message = MessageHandler.getMessage(10486279);
                System.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            argList = new ArrayList();
            argList.add("-C");
            argList.add(configClassName);
            argList.add("-f");
            argList.add(configFileName);
            argList.add("-n");
            argList.add("userRoot");
            for (String s : ldifFiles) {
                if (populateType == 4) {
                    argList.add("-t");
                } else {
                    argList.add("-l");
                }
                argList.add(s);
            }
            if (populateType == 4) {
                argList.add("-s");
                argList.add("0");
            }
            if (populateType == 1) {
                argList.add("-q");
            }
            String[] importLDIFArguments = new String[argList.size()];
            argList.toArray(importLDIFArguments);
            returnValue = ImportLDIF.mainImportLDIF(importLDIFArguments);
            if (returnValue != 0) {
                message29 = MessageHandler.getMessage(10748576);
                System.out.println(StaticUtils.wrapText(message29, ServerConstants.MAX_LINE_WIDTH));
                return returnValue;
            }
            message29 = MessageHandler.getMessage(10486293);
            System.out.println(StaticUtils.wrapText(message29, ServerConstants.MAX_LINE_WIDTH));
        }
        try {
            String serverRoot = System.getenv("INSTANCE_ROOT");
            if (serverRoot == null || serverRoot.length() == 0) {
                File f = new File(configFileName);
                serverRoot = f.getParentFile().getParentFile().getAbsolutePath();
            }
            SetupUtils.writeSetJavaHome(serverRoot);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (enableService) {
            message = MessageHandler.getMessage(10486601);
            System.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            int code = ConfigureWindowsService.enableService(System.out, System.err);
            switch (code) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    return code;
                }
            }
        }
        if (!silentInstall.isPresent()) {
            message = MessageHandler.getMessage(10486280);
            System.out.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
        }
        return 0;
    }

    private static boolean promptForBoolean(String prompt, Boolean defaultValue) {
        String wrappedPrompt = StaticUtils.wrapText(prompt, ServerConstants.MAX_LINE_WIDTH);
        while (true) {
            String message;
            System.out.println();
            System.out.println(wrappedPrompt);
            if (defaultValue == null) {
                System.out.print(": ");
            } else {
                System.out.print("[");
                if (defaultValue.booleanValue()) {
                    System.out.print(MessageHandler.getMessage(10486281));
                } else {
                    System.out.print(MessageHandler.getMessage(0xA0020A));
                }
                System.out.print("]: ");
            }
            System.out.flush();
            String response = StaticUtils.toLowerCase(InstallDS.readLine());
            if (response.equals("true") || response.equals("yes") || response.equals("t") || response.equals("y")) {
                return true;
            }
            if (response.equals("false") || response.equals("no") || response.equals("f") || response.equals("n")) {
                return false;
            }
            if (response.equals("")) {
                if (defaultValue == null) {
                    message = MessageHandler.getMessage(10682891);
                    System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    continue;
                }
                return defaultValue;
            }
            message = MessageHandler.getMessage(10682891);
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
        }
    }

    private static int promptForInteger(String prompt, Integer defaultValue, Integer lowerBound, Integer upperBound) {
        String wrappedPrompt = StaticUtils.wrapText(prompt, ServerConstants.MAX_LINE_WIDTH);
        while (true) {
            String message;
            System.out.println();
            System.out.println(wrappedPrompt);
            if (defaultValue == null) {
                System.out.print(": ");
            } else {
                System.out.print("[");
                System.out.print(defaultValue);
                System.out.print("]: ");
            }
            System.out.flush();
            String response = InstallDS.readLine();
            if (response.equals("")) {
                if (defaultValue == null) {
                    String message2 = MessageHandler.getMessage(10682892);
                    System.err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                    continue;
                }
                return defaultValue;
            }
            try {
                int intValue = Integer.parseInt(response);
                if (lowerBound != null && intValue < lowerBound) {
                    message = MessageHandler.getMessage(10682893, lowerBound);
                    System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    continue;
                }
                if (upperBound != null && intValue > upperBound) {
                    message = MessageHandler.getMessage(10682894, upperBound);
                    System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    continue;
                }
                return intValue;
            }
            catch (NumberFormatException nfe) {
                message = MessageHandler.getMessage(10682892);
                System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                continue;
            }
            break;
        }
    }

    private static DN promptForDN(String prompt, String defaultValue) {
        String wrappedPrompt = StaticUtils.wrapText(prompt, ServerConstants.MAX_LINE_WIDTH);
        while (true) {
            String message;
            System.out.println();
            System.out.println(wrappedPrompt);
            if (defaultValue == null) {
                System.out.print(": ");
            } else {
                System.out.print("[");
                System.out.print(defaultValue);
                System.out.print("]: ");
            }
            System.out.flush();
            String response = InstallDS.readLine();
            if (response.equals("")) {
                if (defaultValue == null) {
                    String message2 = MessageHandler.getMessage(10682895);
                    System.err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
                    continue;
                }
                try {
                    return DN.decode(defaultValue);
                }
                catch (Exception e) {
                    message = MessageHandler.getMessage(10682895);
                    System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    continue;
                }
            }
            try {
                return DN.decode(response);
            }
            catch (Exception e) {
                message = MessageHandler.getMessage(10682895);
                System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                continue;
            }
            break;
        }
    }

    private static String promptForString(String prompt, String defaultValue) {
        String response;
        block3: {
            System.out.println();
            String wrappedPrompt = StaticUtils.wrapText(prompt, ServerConstants.MAX_LINE_WIDTH);
            while (true) {
                System.out.println(wrappedPrompt);
                if (defaultValue == null) {
                    System.out.print(": ");
                } else {
                    System.out.print("[");
                    System.out.print(defaultValue);
                    System.out.print("]: ");
                }
                System.out.flush();
                response = InstallDS.readLine();
                if (!response.equals("")) break block3;
                if (defaultValue != null) break;
                String message = MessageHandler.getMessage(10682896);
                System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            }
            return defaultValue;
        }
        return response;
    }

    private static char[] promptForPassword(String initialPrompt, String reEntryPrompt) {
        char[] password;
        String wrappedInitialPrompt = StaticUtils.wrapText(initialPrompt, ServerConstants.MAX_LINE_WIDTH);
        String wrappedReEntryPrompt = StaticUtils.wrapText(reEntryPrompt, ServerConstants.MAX_LINE_WIDTH);
        while (true) {
            System.out.println();
            System.out.print(wrappedInitialPrompt);
            System.out.print(": ");
            System.out.flush();
            password = PasswordReader.readPassword();
            if (password == null || password.length == 0) {
                String message = MessageHandler.getMessage(10682897);
                System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                continue;
            }
            System.out.print(wrappedReEntryPrompt);
            System.out.print(": ");
            System.out.flush();
            char[] confirmedPassword = PasswordReader.readPassword();
            if (confirmedPassword != null && Arrays.equals(password, confirmedPassword)) break;
            String message = MessageHandler.getMessage(10682898);
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
        }
        return password;
    }

    private static String readLine() {
        try {
            int b;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = System.in.read()) >= 0 && b != 10) {
                if (b == 13) {
                    int b2 = System.in.read();
                    if (b2 == 10) break;
                    baos.write(b);
                    baos.write(b2);
                    continue;
                }
                baos.write(b);
            }
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            String message = MessageHandler.getMessage(10682899, String.valueOf(e));
            System.err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return null;
        }
    }
}

