/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPResultCode;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.LDAPReader;
import org.opends.server.tools.LDAPWriter;
import org.opends.server.types.LDAPException;
import org.opends.server.util.Base64;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPAuthenticationHandler
implements PrivilegedExceptionAction<Object>,
CallbackHandler {
    private ASN1OctetString gssapiBindDN;
    private LDAPReader reader;
    private LDAPWriter writer;
    private AtomicInteger nextMessageID;
    private byte[] iPad;
    private byte[] oPad;
    private char[] gssapiAuthPW;
    private MessageDigest md5Digest;
    private SecureRandom secureRandom;
    private String gssapiAuthID;
    private String gssapiAuthzID;
    private String gssapiQoP;
    private String hostName;
    private String saslMechanism;

    public LDAPAuthenticationHandler(LDAPReader reader, LDAPWriter writer, String hostName, AtomicInteger nextMessageID) {
        this.reader = reader;
        this.writer = writer;
        this.hostName = hostName;
        this.nextMessageID = nextMessageID;
        this.md5Digest = null;
        this.secureRandom = null;
        this.iPad = null;
        this.oPad = null;
    }

    public static String[] getSupportedSASLMechanisms() {
        return new String[]{"ANONYMOUS", "CRAM-MD5", "DIGEST-MD5", "EXTERNAL", "GSSAPI", "PLAIN"};
    }

    public static LinkedHashMap<String, String> getSASLProperties(String mechanism) {
        String upperName = StaticUtils.toUpperCase(mechanism);
        if (upperName.equals("ANONYMOUS")) {
            return LDAPAuthenticationHandler.getSASLAnonymousProperties();
        }
        if (upperName.equals("CRAM-MD5")) {
            return LDAPAuthenticationHandler.getSASLCRAMMD5Properties();
        }
        if (upperName.equals("DIGEST-MD5")) {
            return LDAPAuthenticationHandler.getSASLDigestMD5Properties();
        }
        if (upperName.equals("EXTERNAL")) {
            return LDAPAuthenticationHandler.getSASLExternalProperties();
        }
        if (upperName.equals("GSSAPI")) {
            return LDAPAuthenticationHandler.getSASLGSSAPIProperties();
        }
        if (upperName.equals("PLAIN")) {
            return LDAPAuthenticationHandler.getSASLPlainProperties();
        }
        return null;
    }

    public String doSimpleBind(int ldapVersion, ASN1OctetString bindDN, ASN1OctetString bindPassword, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        LDAPMessage responseMessage;
        if (bindPassword == null) {
            if (bindDN == null) {
                bindPassword = new ASN1OctetString();
            } else {
                System.out.print(MessageHandler.getMessage(10485959, bindDN.stringValue()));
                char[] pwChars = PasswordReader.readPassword();
                if (pwChars == null) {
                    bindPassword = new ASN1OctetString();
                } else {
                    bindPassword = new ASN1OctetString(StaticUtils.getBytes(pwChars));
                    Arrays.fill(pwChars, '\u0000');
                }
            }
        }
        if (bindDN == null) {
            bindDN = new ASN1OctetString();
        }
        BindRequestProtocolOp bindRequest = new BindRequestProtocolOp(bindDN, ldapVersion, bindPassword);
        LDAPMessage bindRequestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest, requestControls);
        try {
            this.writer.writeMessage(bindRequestMessage);
        }
        catch (IOException ioe) {
            int msgID = 10748040;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (Exception e) {
            int msgID = 10748040;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, msgID, message, e);
        }
        try {
            responseMessage = this.reader.readMessage();
            if (responseMessage == null) {
                int msgID = 10748693;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(81, msgID, message);
            }
        }
        catch (IOException ioe) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (ASN1Exception ae) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, msgID, message, ae);
        }
        catch (LDAPException le) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, msgID, message, le);
        }
        catch (Exception e) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message, e);
        }
        ArrayList<LDAPControl> respControls = responseMessage.getControls();
        if (respControls != null && !respControls.isEmpty()) {
            responseControls.addAll(respControls);
        }
        switch (responseMessage.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    int msgID = 10748042;
                    String message = MessageHandler.getMessage(msgID, extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), msgID, message);
                }
                int msgID = 10748043;
                String message = MessageHandler.getMessage(msgID, String.valueOf(extendedResponse));
                throw new ClientException(82, msgID, message);
            }
            default: {
                int msgID = 10748044;
                String message = MessageHandler.getMessage(msgID, String.valueOf(responseMessage.getProtocolOp()));
                throw new ClientException(82, msgID, message);
            }
        }
        BindResponseProtocolOp bindResponse = responseMessage.getBindResponseProtocolOp();
        int resultCode = bindResponse.getResultCode();
        if (resultCode == 0) {
            return null;
        }
        int msgID = 10682509;
        String message = MessageHandler.getMessage(msgID);
        throw new LDAPException(resultCode, bindResponse.getErrorMessage(), msgID, message, bindResponse.getMatchedDN(), null);
    }

    public String doSASLBind(ASN1OctetString bindDN, ASN1OctetString bindPassword, String mechanism, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        if (bindDN == null) {
            bindDN = new ASN1OctetString();
        }
        if (mechanism == null || mechanism.length() == 0) {
            int msgID = 10748046;
            String message = MessageHandler.getMessage(msgID);
            throw new ClientException(89, msgID, message);
        }
        this.saslMechanism = StaticUtils.toUpperCase(mechanism);
        if (this.saslMechanism.equals("ANONYMOUS")) {
            return this.doSASLAnonymous(bindDN, saslProperties, requestControls, responseControls);
        }
        if (this.saslMechanism.equals("CRAM-MD5")) {
            return this.doSASLCRAMMD5(bindDN, bindPassword, saslProperties, requestControls, responseControls);
        }
        if (this.saslMechanism.equals("DIGEST-MD5")) {
            return this.doSASLDigestMD5(bindDN, bindPassword, saslProperties, requestControls, responseControls);
        }
        if (this.saslMechanism.equals("EXTERNAL")) {
            return this.doSASLExternal(bindDN, saslProperties, requestControls, responseControls);
        }
        if (this.saslMechanism.equals("GSSAPI")) {
            return this.doSASLGSSAPI(bindDN, bindPassword, saslProperties, requestControls, responseControls);
        }
        if (this.saslMechanism.equals("PLAIN")) {
            return this.doSASLPlain(bindDN, bindPassword, saslProperties, requestControls, responseControls);
        }
        int msgID = 10682511;
        String message = MessageHandler.getMessage(msgID, mechanism);
        throw new ClientException(86, msgID, message);
    }

    public String doSASLAnonymous(ASN1OctetString bindDN, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        LDAPMessage responseMessage;
        String trace = null;
        if (saslProperties != null && !saslProperties.isEmpty()) {
            for (String name : saslProperties.keySet()) {
                if (name.equalsIgnoreCase("trace")) {
                    List<String> values = saslProperties.get("trace");
                    Iterator<String> iterator = values.iterator();
                    if (!iterator.hasNext()) continue;
                    trace = iterator.next();
                    if (!iterator.hasNext()) continue;
                    int msgID = 10682512;
                    String message = MessageHandler.getMessage(msgID);
                    throw new ClientException(89, msgID, message);
                }
                int msgID = 10682513;
                String message = MessageHandler.getMessage(msgID, name, "ANONYMOUS");
                throw new ClientException(89, msgID, message);
            }
        }
        ASN1OctetString saslCredentials = trace == null ? null : new ASN1OctetString(trace);
        BindRequestProtocolOp bindRequest = new BindRequestProtocolOp(bindDN, "ANONYMOUS", saslCredentials);
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest, requestControls);
        try {
            this.writer.writeMessage(requestMessage);
        }
        catch (IOException ioe) {
            int msgID = 10748050;
            String message = MessageHandler.getMessage(msgID, "ANONYMOUS", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (Exception e) {
            int msgID = 10748050;
            String message = MessageHandler.getMessage(msgID, "ANONYMOUS", StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, msgID, message, e);
        }
        try {
            responseMessage = this.reader.readMessage();
            if (responseMessage == null) {
                int msgID = 10748693;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(81, msgID, message);
            }
        }
        catch (IOException ioe) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (ASN1Exception ae) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, msgID, message, ae);
        }
        catch (LDAPException le) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, msgID, message, le);
        }
        catch (Exception e) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message, e);
        }
        ArrayList<LDAPControl> respControls = responseMessage.getControls();
        if (respControls != null && !respControls.isEmpty()) {
            responseControls.addAll(respControls);
        }
        switch (responseMessage.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    int msgID = 10748042;
                    String message = MessageHandler.getMessage(msgID, extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), msgID, message);
                }
                int msgID = 10748043;
                String message = MessageHandler.getMessage(msgID, String.valueOf(extendedResponse));
                throw new ClientException(82, msgID, message);
            }
            default: {
                int msgID = 10748044;
                String message = MessageHandler.getMessage(msgID, String.valueOf(responseMessage.getProtocolOp()));
                throw new ClientException(82, msgID, message);
            }
        }
        BindResponseProtocolOp bindResponse = responseMessage.getBindResponseProtocolOp();
        int resultCode = bindResponse.getResultCode();
        if (resultCode == 0) {
            return null;
        }
        int msgID = 10682515;
        String message = MessageHandler.getMessage(msgID, "ANONYMOUS");
        throw new LDAPException(resultCode, bindResponse.getErrorMessage(), msgID, message, bindResponse.getMatchedDN(), null);
    }

    public static LinkedHashMap<String, String> getSASLAnonymousProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(1);
        properties.put("trace", MessageHandler.getMessage(0xA000B0));
        return properties;
    }

    public String doSASLCRAMMD5(ASN1OctetString bindDN, ASN1OctetString bindPassword, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        LDAPMessage responseMessage2;
        LDAPMessage responseMessage1;
        String authID = null;
        if (saslProperties == null || saslProperties.isEmpty()) {
            int msgID = 10682516;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5");
            throw new ClientException(89, msgID, message);
        }
        for (String name : saslProperties.keySet()) {
            String lowerName = StaticUtils.toLowerCase(name);
            if (lowerName.equals("authid")) {
                List<String> values = saslProperties.get("authid");
                Iterator<String> iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                authID = iterator.next();
                if (!iterator.hasNext()) continue;
                int msgID = 10682517;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(89, msgID, message);
            }
            int msgID = 10682513;
            String message = MessageHandler.getMessage(msgID, name, "CRAM-MD5");
            throw new ClientException(89, msgID, message);
        }
        if (authID == null || authID.length() == 0) {
            int msgID = 10682518;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5");
            throw new ClientException(89, msgID, message);
        }
        if (bindPassword == null) {
            System.out.print(MessageHandler.getMessage(10485959, authID));
            char[] pwChars = PasswordReader.readPassword();
            if (pwChars == null) {
                bindPassword = new ASN1OctetString();
            } else {
                bindPassword = new ASN1OctetString(StaticUtils.getBytes(pwChars));
                Arrays.fill(pwChars, '\u0000');
            }
        }
        BindRequestProtocolOp bindRequest1 = new BindRequestProtocolOp(bindDN, "CRAM-MD5", null);
        LDAPMessage requestMessage1 = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest1);
        try {
            this.writer.writeMessage(requestMessage1);
        }
        catch (IOException ioe) {
            int msgID = 10682519;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (Exception e) {
            int msgID = 10682519;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, msgID, message, e);
        }
        try {
            responseMessage1 = this.reader.readMessage();
            if (responseMessage1 == null) {
                int msgID = 10748693;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(81, msgID, message);
            }
        }
        catch (IOException ioe) {
            int msgID = 10682520;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (ASN1Exception ae) {
            int msgID = 10682520;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5", StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, msgID, message, ae);
        }
        catch (LDAPException le) {
            int msgID = 10682520;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5", StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, msgID, message, le);
        }
        catch (Exception e) {
            int msgID = 10682520;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message, e);
        }
        switch (responseMessage1.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage1.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    int msgID = 10748042;
                    String message = MessageHandler.getMessage(msgID, extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), msgID, message);
                }
                int msgID = 10748043;
                String message = MessageHandler.getMessage(msgID, String.valueOf(extendedResponse));
                throw new ClientException(82, msgID, message);
            }
            default: {
                int msgID = 10748044;
                String message = MessageHandler.getMessage(msgID, String.valueOf(responseMessage1.getProtocolOp()));
                throw new ClientException(82, msgID, message);
            }
        }
        BindResponseProtocolOp bindResponse1 = responseMessage1.getBindResponseProtocolOp();
        int resultCode1 = bindResponse1.getResultCode();
        if (resultCode1 != 14) {
            String errorMessage = bindResponse1.getErrorMessage();
            if (errorMessage == null) {
                errorMessage = "";
            }
            int msgID = 10682521;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5", resultCode1, LDAPResultCode.toString(resultCode1), errorMessage);
            throw new LDAPException(resultCode1, errorMessage, msgID, message, bindResponse1.getMatchedDN(), null);
        }
        ASN1OctetString serverChallenge = bindResponse1.getServerSASLCredentials();
        if (serverChallenge == null) {
            int msgID = 10682522;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(authID);
        buffer.append(' ');
        buffer.append(this.generateCRAMMD5Digest(bindPassword, serverChallenge));
        BindRequestProtocolOp bindRequest2 = new BindRequestProtocolOp(bindDN, "CRAM-MD5", new ASN1OctetString(buffer.toString()));
        LDAPMessage requestMessage2 = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest2, requestControls);
        try {
            this.writer.writeMessage(requestMessage2);
        }
        catch (IOException ioe) {
            int msgID = 10682524;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (Exception e) {
            int msgID = 10682524;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message, e);
        }
        try {
            responseMessage2 = this.reader.readMessage();
            if (responseMessage2 == null) {
                int msgID = 10748693;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(81, msgID, message);
            }
        }
        catch (IOException ioe) {
            int msgID = 10682525;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (ASN1Exception ae) {
            int msgID = 10682525;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5", StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, msgID, message, ae);
        }
        catch (LDAPException le) {
            int msgID = 10682525;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5", StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, msgID, message, le);
        }
        catch (Exception e) {
            int msgID = 10682525;
            String message = MessageHandler.getMessage(msgID, "CRAM-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message, e);
        }
        ArrayList<LDAPControl> respControls = responseMessage2.getControls();
        if (respControls != null && !respControls.isEmpty()) {
            responseControls.addAll(respControls);
        }
        switch (responseMessage2.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage2.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    int msgID = 10748042;
                    String message = MessageHandler.getMessage(msgID, extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), msgID, message);
                }
                int msgID = 10748043;
                String message = MessageHandler.getMessage(msgID, String.valueOf(extendedResponse));
                throw new ClientException(82, msgID, message);
            }
            default: {
                int msgID = 10748044;
                String message = MessageHandler.getMessage(msgID, String.valueOf(responseMessage2.getProtocolOp()));
                throw new ClientException(82, msgID, message);
            }
        }
        BindResponseProtocolOp bindResponse2 = responseMessage2.getBindResponseProtocolOp();
        int resultCode2 = bindResponse2.getResultCode();
        if (resultCode2 == 0) {
            return null;
        }
        int msgID = 10682515;
        String message = MessageHandler.getMessage(msgID, "CRAM-MD5");
        throw new LDAPException(resultCode2, bindResponse2.getErrorMessage(), msgID, message, bindResponse2.getMatchedDN(), null);
    }

    private String generateCRAMMD5Digest(ASN1OctetString password, ASN1OctetString challenge) throws ClientException {
        if (this.md5Digest == null) {
            try {
                this.md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (Exception e) {
                int msgID = 10682523;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                throw new ClientException(82, msgID, message, e);
            }
        }
        if (this.iPad == null) {
            this.iPad = new byte[64];
            this.oPad = new byte[64];
            Arrays.fill(this.iPad, (byte)54);
            Arrays.fill(this.oPad, (byte)92);
        }
        byte[] p = password.value();
        byte[] c = challenge.value();
        if (p.length > 64) {
            p = this.md5Digest.digest(p);
        }
        byte[] iPadAndData = new byte[64 + c.length];
        System.arraycopy(this.iPad, 0, iPadAndData, 0, 64);
        System.arraycopy(c, 0, iPadAndData, 64, c.length);
        byte[] oPadAndHash = new byte[80];
        System.arraycopy(this.oPad, 0, oPadAndHash, 0, 64);
        for (int i = 0; i < p.length; ++i) {
            int n = i;
            iPadAndData[n] = (byte)(iPadAndData[n] ^ p[i]);
            int n2 = i;
            oPadAndHash[n2] = (byte)(oPadAndHash[n2] ^ p[i]);
        }
        System.arraycopy(this.md5Digest.digest(iPadAndData), 0, oPadAndHash, 64, 16);
        byte[] digestBytes = this.md5Digest.digest(oPadAndHash);
        StringBuilder hexDigest = new StringBuilder(2 * digestBytes.length);
        for (byte b : digestBytes) {
            hexDigest.append(StaticUtils.byteToLowerHex(b));
        }
        return hexDigest.toString();
    }

    public static LinkedHashMap<String, String> getSASLCRAMMD5Properties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(1);
        properties.put("authid", MessageHandler.getMessage(10485937));
        return properties;
    }

    public String doSASLDigestMD5(ASN1OctetString bindDN, ASN1OctetString bindPassword, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        byte[] clientRspAuth;
        byte[] serverRspAuth;
        LDAPMessage responseMessage2;
        String responseDigest;
        LDAPMessage responseMessage1;
        String authID = null;
        String realm = null;
        String qop = "auth";
        String digestURI = "ldap/" + this.hostName;
        String authzID = null;
        boolean realmSetFromProperty = false;
        if (saslProperties == null || saslProperties.isEmpty()) {
            int msgID = 10682516;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5");
            throw new ClientException(89, msgID, message);
        }
        for (String name : saslProperties.keySet()) {
            Iterator<String> iterator;
            List<String> values;
            String lowerName = StaticUtils.toLowerCase(name);
            if (lowerName.equals("authid")) {
                values = saslProperties.get("authid");
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                authID = iterator.next();
                if (!iterator.hasNext()) continue;
                int msgID = 10682517;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(89, msgID, message);
            }
            if (lowerName.equals("realm")) {
                values = saslProperties.get("realm");
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                realm = iterator.next();
                realmSetFromProperty = true;
                if (!iterator.hasNext()) continue;
                int msgID = 0xA300A0;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(89, msgID, message);
            }
            if (lowerName.equals("qop")) {
                values = saslProperties.get("qop");
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                qop = StaticUtils.toLowerCase(iterator.next());
                if (iterator.hasNext()) {
                    int msgID = 10682529;
                    String message = MessageHandler.getMessage(msgID);
                    throw new ClientException(89, msgID, message);
                }
                if (qop.equals("auth")) continue;
                if (qop.equals("auth-int") || qop.equals("auth-conf")) {
                    int msgID = 10682530;
                    String message = MessageHandler.getMessage(msgID, qop);
                    throw new ClientException(89, msgID, message);
                }
                int msgID = 0xA300A3;
                String message = MessageHandler.getMessage(msgID, qop);
                throw new ClientException(89, msgID, message);
            }
            if (lowerName.equals("digest-uri")) {
                values = saslProperties.get("digest-uri");
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                digestURI = StaticUtils.toLowerCase(iterator.next());
                if (!iterator.hasNext()) continue;
                int msgID = 10682532;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(89, msgID, message);
            }
            if (lowerName.equals("authzid")) {
                values = saslProperties.get("authzid");
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                authzID = StaticUtils.toLowerCase(iterator.next());
                if (!iterator.hasNext()) continue;
                int msgID = 10682527;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(89, msgID, message);
            }
            int msgID = 10682513;
            String message = MessageHandler.getMessage(msgID, name, "DIGEST-MD5");
            throw new ClientException(89, msgID, message);
        }
        if (authID == null || authID.length() == 0) {
            int msgID = 10682518;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5");
            throw new ClientException(89, msgID, message);
        }
        if (bindPassword == null) {
            System.out.print(MessageHandler.getMessage(10485959, authID));
            char[] pwChars = PasswordReader.readPassword();
            if (pwChars == null) {
                bindPassword = new ASN1OctetString();
            } else {
                bindPassword = new ASN1OctetString(StaticUtils.getBytes(pwChars));
                Arrays.fill(pwChars, '\u0000');
            }
        }
        BindRequestProtocolOp bindRequest1 = new BindRequestProtocolOp(bindDN, "DIGEST-MD5", null);
        LDAPMessage requestMessage1 = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest1);
        try {
            this.writer.writeMessage(requestMessage1);
        }
        catch (IOException ioe) {
            int msgID = 10682519;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (Exception e) {
            int msgID = 10682519;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, msgID, message, e);
        }
        try {
            responseMessage1 = this.reader.readMessage();
            if (responseMessage1 == null) {
                int msgID = 10748693;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(81, msgID, message);
            }
        }
        catch (IOException ioe) {
            int msgID = 10682520;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (ASN1Exception ae) {
            int msgID = 10682520;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5", StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, msgID, message, ae);
        }
        catch (LDAPException le) {
            int msgID = 10682520;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5", StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, msgID, message, le);
        }
        catch (Exception e) {
            int msgID = 10682520;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message, e);
        }
        switch (responseMessage1.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage1.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    int msgID = 10748042;
                    String message = MessageHandler.getMessage(msgID, extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), msgID, message);
                }
                int msgID = 10748043;
                String message = MessageHandler.getMessage(msgID, String.valueOf(extendedResponse));
                throw new ClientException(82, msgID, message);
            }
            default: {
                int msgID = 10748044;
                String message = MessageHandler.getMessage(msgID, String.valueOf(responseMessage1.getProtocolOp()));
                throw new ClientException(82, msgID, message);
            }
        }
        BindResponseProtocolOp bindResponse1 = responseMessage1.getBindResponseProtocolOp();
        int resultCode1 = bindResponse1.getResultCode();
        if (resultCode1 != 14) {
            String errorMessage = bindResponse1.getErrorMessage();
            if (errorMessage == null) {
                errorMessage = "";
            }
            int msgID = 10682521;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5", resultCode1, LDAPResultCode.toString(resultCode1), errorMessage);
            throw new LDAPException(resultCode1, errorMessage, msgID, message, bindResponse1.getMatchedDN(), null);
        }
        ASN1OctetString serverCredentials = bindResponse1.getServerSASLCredentials();
        if (serverCredentials == null) {
            int msgID = 10682533;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        String credString = serverCredentials.stringValue();
        String lowerCreds = StaticUtils.toLowerCase(credString);
        String nonce = null;
        boolean useUTF8 = false;
        int pos = 0;
        int length = credString.length();
        while (pos < length) {
            int equalPos = credString.indexOf(61, pos + 1);
            if (equalPos < 0) {
                int msgID = 10682534;
                String message = MessageHandler.getMessage(msgID, pos);
                throw new LDAPException(2, msgID, message);
            }
            String tokenName = lowerCreds.substring(pos, equalPos);
            StringBuilder valueBuffer = new StringBuilder();
            pos = this.readToken(credString, equalPos + 1, length, valueBuffer);
            String tokenValue = valueBuffer.toString();
            if (tokenName.equals("charset")) {
                if (!tokenValue.equalsIgnoreCase("utf-8")) {
                    int msgID = 10682535;
                    String message = MessageHandler.getMessage(msgID, tokenValue);
                    throw new LDAPException(2, msgID, message);
                }
                useUTF8 = true;
                continue;
            }
            if (tokenName.equals("realm")) {
                if (realmSetFromProperty) continue;
                if (realm == null) {
                    realm = tokenValue;
                    continue;
                }
                realm = null;
                realmSetFromProperty = true;
                continue;
            }
            if (tokenName.equals("nonce")) {
                nonce = tokenValue;
                continue;
            }
            if (!tokenName.equals("qop")) continue;
            StringTokenizer tokenizer = new StringTokenizer(tokenValue, ",");
            LinkedList<String> qopModes = new LinkedList<String>();
            while (tokenizer.hasMoreTokens()) {
                qopModes.add(StaticUtils.toLowerCase(tokenizer.nextToken().trim()));
            }
            if (qopModes.contains(qop)) continue;
            int msgID = 10682536;
            String message = MessageHandler.getMessage(msgID, qop, tokenValue);
            throw new ClientException(89, msgID, message);
        }
        if (nonce == null) {
            int msgID = 10682537;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        String cnonce = this.generateCNonce();
        String nonceCount = "00000001";
        String charset = useUTF8 ? "UTF-8" : "ISO-8859-1";
        try {
            responseDigest = this.generateDigestMD5Response(authID, authzID, bindPassword.value(), realm, nonce, cnonce, nonceCount, digestURI, qop, charset);
        }
        catch (ClientException ce) {
            throw ce;
        }
        catch (Exception e) {
            int msgID = 0xA300AA;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message, e);
        }
        StringBuilder credBuffer = new StringBuilder();
        credBuffer.append("username=\"");
        credBuffer.append(authID);
        credBuffer.append("\"");
        if (realm != null) {
            credBuffer.append(",realm=\"");
            credBuffer.append(realm);
            credBuffer.append("\"");
        }
        credBuffer.append(",nonce=\"");
        credBuffer.append(nonce);
        credBuffer.append("\",cnonce=\"");
        credBuffer.append(cnonce);
        credBuffer.append("\",nc=");
        credBuffer.append(nonceCount);
        credBuffer.append(",qop=");
        credBuffer.append(qop);
        credBuffer.append(",digest-uri=\"");
        credBuffer.append(digestURI);
        credBuffer.append("\",response=");
        credBuffer.append(responseDigest);
        if (useUTF8) {
            credBuffer.append(",charset=utf-8");
        }
        if (authzID != null) {
            credBuffer.append(",authzid=\"");
            credBuffer.append(authzID);
            credBuffer.append("\"");
        }
        BindRequestProtocolOp bindRequest2 = new BindRequestProtocolOp(bindDN, "DIGEST-MD5", new ASN1OctetString(credBuffer.toString()));
        LDAPMessage requestMessage2 = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest2, requestControls);
        try {
            this.writer.writeMessage(requestMessage2);
        }
        catch (IOException ioe) {
            int msgID = 10682524;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (Exception e) {
            int msgID = 10682524;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, msgID, message, e);
        }
        try {
            responseMessage2 = this.reader.readMessage();
            if (responseMessage2 == null) {
                int msgID = 10748693;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(81, msgID, message);
            }
        }
        catch (IOException ioe) {
            int msgID = 10682525;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (ASN1Exception ae) {
            int msgID = 10682525;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5", StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, msgID, message, ae);
        }
        catch (LDAPException le) {
            int msgID = 10682525;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5", StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, msgID, message, le);
        }
        catch (Exception e) {
            int msgID = 10682525;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5", StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message, e);
        }
        ArrayList<LDAPControl> respControls = responseMessage2.getControls();
        if (respControls != null && !respControls.isEmpty()) {
            responseControls.addAll(respControls);
        }
        switch (responseMessage2.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage2.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    int msgID = 10748042;
                    String message = MessageHandler.getMessage(msgID, extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), msgID, message);
                }
                int msgID = 10748043;
                String message = MessageHandler.getMessage(msgID, String.valueOf(extendedResponse));
                throw new ClientException(82, msgID, message);
            }
            default: {
                int msgID = 10748044;
                String message = MessageHandler.getMessage(msgID, String.valueOf(responseMessage2.getProtocolOp()));
                throw new ClientException(82, msgID, message);
            }
        }
        BindResponseProtocolOp bindResponse2 = responseMessage2.getBindResponseProtocolOp();
        int resultCode2 = bindResponse2.getResultCode();
        if (resultCode2 != 0) {
            int msgID = 10682515;
            String message = MessageHandler.getMessage(msgID, "DIGEST-MD5");
            throw new LDAPException(resultCode2, bindResponse2.getErrorMessage(), msgID, message, bindResponse2.getMatchedDN(), null);
        }
        ASN1OctetString rspAuthCreds = bindResponse2.getServerSASLCredentials();
        if (rspAuthCreds == null) {
            int msgID = 10682539;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        String credStr = StaticUtils.toLowerCase(rspAuthCreds.stringValue());
        if (!credStr.startsWith("rspauth=")) {
            int msgID = 10682539;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(2, msgID, message);
        }
        try {
            serverRspAuth = StaticUtils.hexStringToByteArray(credStr.substring(8));
        }
        catch (Exception e) {
            int msgID = 10682540;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new LDAPException(2, msgID, message);
        }
        try {
            clientRspAuth = this.generateDigestMD5RspAuth(authID, authzID, bindPassword.value(), realm, nonce, cnonce, nonceCount, digestURI, qop, charset);
        }
        catch (Exception e) {
            int msgID = 10682541;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message);
        }
        if (!Arrays.equals(serverRspAuth, clientRspAuth)) {
            int msgID = 10682542;
            String message = MessageHandler.getMessage(msgID);
            throw new ClientException(82, msgID, message);
        }
        return null;
    }

    private int readToken(String credentials, int startPos, int length, StringBuilder token) throws LDAPException {
        char c;
        if (startPos >= length) {
            return startPos;
        }
        boolean isEscaped = false;
        boolean isQuoted = false;
        int pos = startPos;
        if ((c = credentials.charAt(pos++)) == ',') {
            return pos;
        }
        if (c == '\"') {
            isQuoted = true;
        } else if (c == '\\') {
            isEscaped = true;
        } else {
            token.append(c);
        }
        while (pos < length) {
            c = credentials.charAt(pos++);
            if (isEscaped) {
                token.append(c);
                isEscaped = false;
                continue;
            }
            if (c == ',') {
                if (!isQuoted) break;
                token.append(c);
                continue;
            }
            if (c == '\"') {
                if (isQuoted) {
                    char c2;
                    if (pos >= length || (c2 = credentials.charAt(pos++)) == ',') break;
                    int msgID = 10682543;
                    String message = MessageHandler.getMessage(msgID, pos - 2);
                    throw new LDAPException(49, msgID, message);
                }
                token.append(c);
                continue;
            }
            if (c == '\\') {
                isEscaped = true;
                continue;
            }
            token.append(c);
        }
        return pos;
    }

    private String generateCNonce() {
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
        byte[] cnonceBytes = new byte[16];
        this.secureRandom.nextBytes(cnonceBytes);
        return Base64.encode(cnonceBytes);
    }

    private String generateDigestMD5Response(String authID, String authzID, byte[] password, String realm, String nonce, String cnonce, String nonceCount, String digestURI, String qop, String charset) throws ClientException, UnsupportedEncodingException {
        if (this.md5Digest == null) {
            try {
                this.md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (Exception e) {
                int msgID = 10682523;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                throw new ClientException(82, msgID, message, e);
            }
        }
        StringBuilder a1String1 = new StringBuilder();
        a1String1.append(authID);
        a1String1.append(':');
        a1String1.append(realm == null ? "" : realm);
        a1String1.append(':');
        byte[] a1Bytes1a = a1String1.toString().getBytes(charset);
        byte[] a1Bytes1 = new byte[a1Bytes1a.length + password.length];
        System.arraycopy(a1Bytes1a, 0, a1Bytes1, 0, a1Bytes1a.length);
        System.arraycopy(password, 0, a1Bytes1, a1Bytes1a.length, password.length);
        byte[] urpHash = this.md5Digest.digest(a1Bytes1);
        StringBuilder a1String2 = new StringBuilder();
        a1String2.append(':');
        a1String2.append(nonce);
        a1String2.append(':');
        a1String2.append(cnonce);
        if (authzID != null) {
            a1String2.append(':');
            a1String2.append(authzID);
        }
        byte[] a1Bytes2a = a1String2.toString().getBytes(charset);
        byte[] a1Bytes2 = new byte[urpHash.length + a1Bytes2a.length];
        System.arraycopy(urpHash, 0, a1Bytes2, 0, urpHash.length);
        System.arraycopy(a1Bytes2a, 0, a1Bytes2, urpHash.length, a1Bytes2a.length);
        byte[] a1Hash = this.md5Digest.digest(a1Bytes2);
        byte[] a2Bytes = ("AUTHENTICATE:" + digestURI).getBytes(charset);
        byte[] a2Hash = this.md5Digest.digest(a2Bytes);
        String a1HashHex = this.getHexString(a1Hash);
        String a2HashHex = this.getHexString(a2Hash);
        StringBuilder kdStr = new StringBuilder();
        kdStr.append(a1HashHex);
        kdStr.append(':');
        kdStr.append(nonce);
        kdStr.append(':');
        kdStr.append(nonceCount);
        kdStr.append(':');
        kdStr.append(cnonce);
        kdStr.append(':');
        kdStr.append(qop);
        kdStr.append(':');
        kdStr.append(a2HashHex);
        return this.getHexString(this.md5Digest.digest(kdStr.toString().getBytes(charset)));
    }

    public byte[] generateDigestMD5RspAuth(String authID, String authzID, byte[] password, String realm, String nonce, String cnonce, String nonceCount, String digestURI, String qop, String charset) throws UnsupportedEncodingException {
        StringBuilder a1String1 = new StringBuilder();
        a1String1.append(authID);
        a1String1.append(':');
        a1String1.append(realm);
        a1String1.append(':');
        byte[] a1Bytes1a = a1String1.toString().getBytes(charset);
        byte[] a1Bytes1 = new byte[a1Bytes1a.length + password.length];
        System.arraycopy(a1Bytes1a, 0, a1Bytes1, 0, a1Bytes1a.length);
        System.arraycopy(password, 0, a1Bytes1, a1Bytes1a.length, password.length);
        byte[] urpHash = this.md5Digest.digest(a1Bytes1);
        StringBuilder a1String2 = new StringBuilder();
        a1String2.append(':');
        a1String2.append(nonce);
        a1String2.append(':');
        a1String2.append(cnonce);
        if (authzID != null) {
            a1String2.append(':');
            a1String2.append(authzID);
        }
        byte[] a1Bytes2a = a1String2.toString().getBytes(charset);
        byte[] a1Bytes2 = new byte[urpHash.length + a1Bytes2a.length];
        System.arraycopy(urpHash, 0, a1Bytes2, 0, urpHash.length);
        System.arraycopy(a1Bytes2a, 0, a1Bytes2, urpHash.length, a1Bytes2a.length);
        byte[] a1Hash = this.md5Digest.digest(a1Bytes2);
        String a2String = ":" + digestURI;
        if (qop.equals("auth-int") || qop.equals("auth-conf")) {
            a2String = a2String + ":00000000000000000000000000000000";
        }
        byte[] a2Bytes = a2String.getBytes(charset);
        byte[] a2Hash = this.md5Digest.digest(a2Bytes);
        String a1HashHex = this.getHexString(a1Hash);
        String a2HashHex = this.getHexString(a2Hash);
        StringBuilder kdStr = new StringBuilder();
        kdStr.append(a1HashHex);
        kdStr.append(':');
        kdStr.append(nonce);
        kdStr.append(':');
        kdStr.append(nonceCount);
        kdStr.append(':');
        kdStr.append(cnonce);
        kdStr.append(':');
        kdStr.append(qop);
        kdStr.append(':');
        kdStr.append(a2HashHex);
        return this.md5Digest.digest(kdStr.toString().getBytes(charset));
    }

    private String getHexString(byte[] byteArray) {
        StringBuilder buffer = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            buffer.append(StaticUtils.byteToLowerHex(b));
        }
        return buffer.toString();
    }

    public static LinkedHashMap<String, String> getSASLDigestMD5Properties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(5);
        properties.put("authid", MessageHandler.getMessage(10485937));
        properties.put("realm", MessageHandler.getMessage(10485938));
        properties.put("qop", MessageHandler.getMessage(10485939));
        properties.put("digest-uri", MessageHandler.getMessage(10485940));
        properties.put("authzid", MessageHandler.getMessage(10485941));
        return properties;
    }

    public String doSASLExternal(ASN1OctetString bindDN, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        LDAPMessage responseMessage;
        if (saslProperties != null && !saslProperties.isEmpty()) {
            int msgID = 10682526;
            String message = MessageHandler.getMessage(msgID, "EXTERNAL");
            throw new ClientException(89, msgID, message);
        }
        BindRequestProtocolOp bindRequest = new BindRequestProtocolOp(bindDN, "EXTERNAL", null);
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest, requestControls);
        try {
            this.writer.writeMessage(requestMessage);
        }
        catch (IOException ioe) {
            int msgID = 10748050;
            String message = MessageHandler.getMessage(msgID, "EXTERNAL", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (Exception e) {
            int msgID = 10748050;
            String message = MessageHandler.getMessage(msgID, "EXTERNAL", StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, msgID, message, e);
        }
        try {
            responseMessage = this.reader.readMessage();
            if (responseMessage == null) {
                int msgID = 10748693;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(81, msgID, message);
            }
        }
        catch (IOException ioe) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (ASN1Exception ae) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, msgID, message, ae);
        }
        catch (LDAPException le) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, msgID, message, le);
        }
        catch (Exception e) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message, e);
        }
        ArrayList<LDAPControl> respControls = responseMessage.getControls();
        if (respControls != null && !respControls.isEmpty()) {
            responseControls.addAll(respControls);
        }
        switch (responseMessage.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    int msgID = 10748042;
                    String message = MessageHandler.getMessage(msgID, extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), msgID, message);
                }
                int msgID = 10748043;
                String message = MessageHandler.getMessage(msgID, String.valueOf(extendedResponse));
                throw new ClientException(82, msgID, message);
            }
            default: {
                int msgID = 10748044;
                String message = MessageHandler.getMessage(msgID, String.valueOf(responseMessage.getProtocolOp()));
                throw new ClientException(82, msgID, message);
            }
        }
        BindResponseProtocolOp bindResponse = responseMessage.getBindResponseProtocolOp();
        int resultCode = bindResponse.getResultCode();
        if (resultCode == 0) {
            return null;
        }
        int msgID = 10682515;
        String message = MessageHandler.getMessage(msgID, "EXTERNAL");
        throw new LDAPException(resultCode, bindResponse.getErrorMessage(), msgID, message, bindResponse.getMatchedDN(), null);
    }

    public static LinkedHashMap<String, String> getSASLExternalProperties() {
        return new LinkedHashMap<String, String>(0);
    }

    public String doSASLGSSAPI(ASN1OctetString bindDN, ASN1OctetString bindPassword, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        LoginContext loginContext;
        String configFileName;
        String message;
        String kdc = null;
        String realm = null;
        this.gssapiBindDN = bindDN;
        this.gssapiAuthID = null;
        this.gssapiAuthzID = null;
        this.gssapiQoP = "auth";
        this.gssapiAuthPW = (char[])(bindPassword == null ? null : bindPassword.stringValue().toCharArray());
        if (saslProperties == null || saslProperties.isEmpty()) {
            int msgID = 10682516;
            String message2 = MessageHandler.getMessage(msgID, "GSSAPI");
            throw new ClientException(89, msgID, message2);
        }
        for (String name : saslProperties.keySet()) {
            Iterator<String> iterator;
            List<String> values;
            String lowerName = StaticUtils.toLowerCase(name);
            if (lowerName.equals("authid")) {
                values = saslProperties.get("authid");
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                this.gssapiAuthID = iterator.next();
                if (!iterator.hasNext()) continue;
                int msgID = 10682517;
                String message3 = MessageHandler.getMessage(msgID);
                throw new ClientException(89, msgID, message3);
            }
            if (lowerName.equals("authzid")) {
                values = saslProperties.get("authzid");
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                this.gssapiAuthzID = iterator.next();
                if (!iterator.hasNext()) continue;
                int msgID = 10682527;
                String message4 = MessageHandler.getMessage(msgID);
                throw new ClientException(89, msgID, message4);
            }
            if (lowerName.equals("kdc")) {
                values = saslProperties.get("kdc");
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                kdc = iterator.next();
                if (!iterator.hasNext()) continue;
                int msgID = 10682552;
                String message5 = MessageHandler.getMessage(msgID);
                throw new ClientException(89, msgID, message5);
            }
            if (lowerName.equals("qop")) {
                values = saslProperties.get("qop");
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                this.gssapiQoP = StaticUtils.toLowerCase(iterator.next());
                if (iterator.hasNext()) {
                    int msgID = 10682529;
                    String message6 = MessageHandler.getMessage(msgID);
                    throw new ClientException(89, msgID, message6);
                }
                if (this.gssapiQoP.equals("auth")) continue;
                if (this.gssapiQoP.equals("auth-int") || this.gssapiQoP.equals("auth-conf")) {
                    int msgID = 10682530;
                    String message7 = MessageHandler.getMessage(msgID, this.gssapiQoP);
                    throw new ClientException(89, msgID, message7);
                }
                int msgID = 10682553;
                String message8 = MessageHandler.getMessage(msgID, this.gssapiQoP);
                throw new ClientException(89, msgID, message8);
            }
            if (lowerName.equals("realm")) {
                values = saslProperties.get("realm");
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                realm = iterator.next();
                if (!iterator.hasNext()) continue;
                int msgID = 0xA300A0;
                String message9 = MessageHandler.getMessage(msgID);
                throw new ClientException(89, msgID, message9);
            }
            int msgID = 10682513;
            message = MessageHandler.getMessage(msgID, name, "GSSAPI");
            throw new ClientException(89, msgID, message);
        }
        if (this.gssapiAuthID == null || this.gssapiAuthID.length() == 0) {
            int msgID = 10682518;
            String message10 = MessageHandler.getMessage(msgID, "GSSAPI");
            throw new ClientException(89, msgID, message10);
        }
        if (this.gssapiAuthzID == null) {
            this.gssapiAuthzID = this.gssapiAuthID;
        }
        if (realm != null) {
            System.setProperty("java.security.krb5.realm", realm);
        }
        if (kdc != null) {
            System.setProperty("java.security.krb5.kdc", kdc);
        }
        try {
            File tempFile = File.createTempFile("login", "conf");
            configFileName = tempFile.getAbsolutePath();
            tempFile.deleteOnExit();
            BufferedWriter w = new BufferedWriter(new FileWriter(tempFile, false));
            w.write(this.getClass().getName() + " {");
            w.newLine();
            w.write("  com.sun.security.auth.module.Krb5LoginModule required client=TRUE useTicketCache=TRUE;");
            w.newLine();
            w.write("};");
            w.newLine();
            w.flush();
            w.close();
        }
        catch (Exception e) {
            int msgID = 10748090;
            message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message, e);
        }
        System.setProperty("java.security.auth.login.config", configFileName);
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "true");
        try {
            loginContext = new LoginContext(this.getClass().getName(), this);
            loginContext.login();
        }
        catch (Exception e) {
            int msgID = 10682555;
            String message11 = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message11, e);
        }
        try {
            Subject.doAs(loginContext.getSubject(), this);
        }
        catch (Exception e) {
            if (e instanceof ClientException) {
                throw (ClientException)e;
            }
            if (e instanceof LDAPException) {
                throw (LDAPException)e;
            }
            int msgID = 10682556;
            String message12 = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message12, e);
        }
        return null;
    }

    public static LinkedHashMap<String, String> getSASLGSSAPIProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(4);
        properties.put("authid", MessageHandler.getMessage(10485937));
        properties.put("authzid", MessageHandler.getMessage(10485941));
        properties.put("kdc", MessageHandler.getMessage(10485943));
        properties.put("realm", MessageHandler.getMessage(10485938));
        return properties;
    }

    public String doSASLPlain(ASN1OctetString bindDN, ASN1OctetString bindPassword, Map<String, List<String>> saslProperties, ArrayList<LDAPControl> requestControls, ArrayList<LDAPControl> responseControls) throws ClientException, LDAPException {
        LDAPMessage responseMessage;
        String authID = null;
        String authzID = null;
        if (saslProperties == null || saslProperties.isEmpty()) {
            int msgID = 10682516;
            String message = MessageHandler.getMessage(msgID, "PLAIN");
            throw new ClientException(89, msgID, message);
        }
        for (String name : saslProperties.keySet()) {
            Iterator<String> iterator;
            List<String> values;
            String lowerName = StaticUtils.toLowerCase(name);
            if (lowerName.equals("authid")) {
                values = saslProperties.get("authid");
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                authID = iterator.next();
                if (!iterator.hasNext()) continue;
                int msgID = 10682517;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(89, msgID, message);
            }
            if (lowerName.equals("authzid")) {
                values = saslProperties.get("authzid");
                iterator = values.iterator();
                if (!iterator.hasNext()) continue;
                authzID = iterator.next();
                if (!iterator.hasNext()) continue;
                int msgID = 10682527;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(89, msgID, message);
            }
            int msgID = 10682513;
            String message = MessageHandler.getMessage(msgID, name, "PLAIN");
            throw new ClientException(89, msgID, message);
        }
        if (authID == null || authID.length() == 0) {
            int msgID = 10682518;
            String message = MessageHandler.getMessage(msgID, "PLAIN");
            throw new ClientException(89, msgID, message);
        }
        if (bindPassword == null) {
            System.out.print(MessageHandler.getMessage(10485959, authID));
            char[] pwChars = PasswordReader.readPassword();
            if (pwChars == null) {
                bindPassword = new ASN1OctetString();
            } else {
                bindPassword = new ASN1OctetString(StaticUtils.getBytes(pwChars));
                Arrays.fill(pwChars, '\u0000');
            }
        }
        StringBuilder credBuffer = new StringBuilder();
        if (authzID != null) {
            credBuffer.append(authzID);
        }
        credBuffer.append('\u0000');
        credBuffer.append(authID);
        credBuffer.append('\u0000');
        credBuffer.append(bindPassword.stringValue());
        ASN1OctetString saslCredentials = new ASN1OctetString(credBuffer.toString());
        BindRequestProtocolOp bindRequest = new BindRequestProtocolOp(bindDN, "PLAIN", saslCredentials);
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest, requestControls);
        try {
            this.writer.writeMessage(requestMessage);
        }
        catch (IOException ioe) {
            int msgID = 10748050;
            String message = MessageHandler.getMessage(msgID, "PLAIN", StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (Exception e) {
            int msgID = 10748050;
            String message = MessageHandler.getMessage(msgID, "PLAIN", StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, msgID, message, e);
        }
        try {
            responseMessage = this.reader.readMessage();
            if (responseMessage == null) {
                int msgID = 10748693;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(81, msgID, message);
            }
        }
        catch (IOException ioe) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (ASN1Exception ae) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, msgID, message, ae);
        }
        catch (LDAPException le) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, msgID, message, le);
        }
        catch (Exception e) {
            int msgID = 10748041;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message, e);
        }
        ArrayList<LDAPControl> respControls = responseMessage.getControls();
        if (respControls != null && !respControls.isEmpty()) {
            responseControls.addAll(respControls);
        }
        switch (responseMessage.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
                String responseOID = extendedResponse.getOID();
                if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                    int msgID = 10748042;
                    String message = MessageHandler.getMessage(msgID, extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                    throw new LDAPException(extendedResponse.getResultCode(), msgID, message);
                }
                int msgID = 10748043;
                String message = MessageHandler.getMessage(msgID, String.valueOf(extendedResponse));
                throw new ClientException(82, msgID, message);
            }
            default: {
                int msgID = 10748044;
                String message = MessageHandler.getMessage(msgID, String.valueOf(responseMessage.getProtocolOp()));
                throw new ClientException(82, msgID, message);
            }
        }
        BindResponseProtocolOp bindResponse = responseMessage.getBindResponseProtocolOp();
        int resultCode = bindResponse.getResultCode();
        if (resultCode == 0) {
            return null;
        }
        int msgID = 10682515;
        String message = MessageHandler.getMessage(msgID, "PLAIN");
        throw new LDAPException(resultCode, bindResponse.getErrorMessage(), msgID, message, bindResponse.getMatchedDN(), null);
    }

    public static LinkedHashMap<String, String> getSASLPlainProperties() {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(2);
        properties.put("authid", MessageHandler.getMessage(10485937));
        properties.put("authzid", MessageHandler.getMessage(10485941));
        return properties;
    }

    @Override
    public Object run() throws ClientException, LDAPException {
        block44: {
            if (this.saslMechanism == null) {
                int msgID = 10748093;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getBacktrace());
                throw new ClientException(82, msgID, message);
            }
            if (this.saslMechanism.equals("GSSAPI")) {
                BindResponseProtocolOp bindResponse;
                int resultCode;
                LDAPMessage responseMessage;
                ASN1OctetString saslCredentials;
                SaslClient saslClient;
                HashMap<String, String> saslProperties = new HashMap<String, String>();
                saslProperties.put("javax.security.sasl.qop", this.gssapiQoP);
                saslProperties.put("javax.security.sasl.server.authentication", "true");
                try {
                    saslClient = Sasl.createSaslClient(new String[]{"GSSAPI"}, this.gssapiAuthzID, "ldap", this.hostName, saslProperties, this);
                }
                catch (Exception e) {
                    int msgID = 10748095;
                    String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                    throw new ClientException(82, msgID, message, e);
                }
                if (saslClient.hasInitialResponse()) {
                    try {
                        byte[] credBytes = saslClient.evaluateChallenge(new byte[0]);
                        saslCredentials = new ASN1OctetString(credBytes);
                    }
                    catch (Exception e) {
                        int msgID = 10748096;
                        String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                        throw new ClientException(82, msgID, message, e);
                    }
                } else {
                    saslCredentials = null;
                }
                BindRequestProtocolOp bindRequest = new BindRequestProtocolOp(this.gssapiBindDN, "GSSAPI", saslCredentials);
                LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest);
                try {
                    this.writer.writeMessage(requestMessage);
                }
                catch (IOException ioe) {
                    int msgID = 10748050;
                    String message = MessageHandler.getMessage(msgID, "GSSAPI", StaticUtils.getExceptionMessage(ioe));
                    throw new ClientException(81, msgID, message, ioe);
                }
                catch (Exception e) {
                    int msgID = 10748050;
                    String message = MessageHandler.getMessage(msgID, "GSSAPI", StaticUtils.getExceptionMessage(e));
                    throw new ClientException(83, msgID, message, e);
                }
                try {
                    responseMessage = this.reader.readMessage();
                    if (responseMessage == null) {
                        int msgID = 10748693;
                        String message = MessageHandler.getMessage(msgID);
                        throw new ClientException(81, msgID, message);
                    }
                }
                catch (IOException ioe) {
                    int msgID = 10748041;
                    String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ioe));
                    throw new ClientException(81, msgID, message, ioe);
                }
                catch (ASN1Exception ae) {
                    int msgID = 10748041;
                    String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ae));
                    throw new ClientException(84, msgID, message, ae);
                }
                catch (LDAPException le) {
                    int msgID = 10748041;
                    String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(le));
                    throw new ClientException(84, msgID, message, le);
                }
                catch (Exception e) {
                    int msgID = 10748041;
                    String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                    throw new ClientException(82, msgID, message, e);
                }
                switch (responseMessage.getProtocolOpType()) {
                    case 97: {
                        break;
                    }
                    case 120: {
                        ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
                        String responseOID = extendedResponse.getOID();
                        if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                            int msgID = 10748042;
                            String message = MessageHandler.getMessage(msgID, extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                            throw new LDAPException(extendedResponse.getResultCode(), msgID, message);
                        }
                        int msgID = 10748043;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(extendedResponse));
                        throw new ClientException(82, msgID, message);
                    }
                    default: {
                        int msgID = 10748044;
                        String message = MessageHandler.getMessage(msgID, String.valueOf(responseMessage.getProtocolOp()));
                        throw new ClientException(82, msgID, message);
                    }
                }
                while (true) {
                    byte[] credBytes;
                    ASN1OctetString serverSASLCredentials;
                    if ((resultCode = (bindResponse = responseMessage.getBindResponseProtocolOp()).getResultCode()) == 0) {
                        serverSASLCredentials = bindResponse.getServerSASLCredentials();
                        if (serverSASLCredentials != null) {
                            try {
                                saslClient.evaluateChallenge(serverSASLCredentials.value());
                            }
                            catch (Exception e) {
                                int msgID = 10682561;
                                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                                throw new ClientException(82, msgID, message, e);
                            }
                        }
                        if (!saslClient.isComplete()) {
                            int msgID = 10682562;
                            String message = MessageHandler.getMessage(msgID);
                            throw new ClientException(82, msgID, message);
                        }
                        break block44;
                    }
                    if (resultCode != 14) break;
                    serverSASLCredentials = bindResponse.getServerSASLCredentials();
                    try {
                        credBytes = serverSASLCredentials == null ? saslClient.evaluateChallenge(new byte[0]) : saslClient.evaluateChallenge(serverSASLCredentials.value());
                    }
                    catch (Exception e) {
                        int msgID = 10682561;
                        String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                        throw new ClientException(82, msgID, message, e);
                    }
                    bindRequest = new BindRequestProtocolOp(this.gssapiBindDN, "GSSAPI", new ASN1OctetString(credBytes));
                    requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequest);
                    try {
                        this.writer.writeMessage(requestMessage);
                    }
                    catch (IOException ioe) {
                        int msgID = 10748050;
                        String message = MessageHandler.getMessage(msgID, "GSSAPI", StaticUtils.getExceptionMessage(ioe));
                        throw new ClientException(81, msgID, message, ioe);
                    }
                    catch (Exception e) {
                        int msgID = 10748050;
                        String message = MessageHandler.getMessage(msgID, "GSSAPI", StaticUtils.getExceptionMessage(e));
                        throw new ClientException(83, msgID, message, e);
                    }
                    try {
                        responseMessage = this.reader.readMessage();
                        if (responseMessage == null) {
                            int msgID = 10748693;
                            String message = MessageHandler.getMessage(msgID);
                            throw new ClientException(81, msgID, message);
                        }
                    }
                    catch (IOException ioe) {
                        int msgID = 10748041;
                        String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ioe));
                        throw new ClientException(81, msgID, message, ioe);
                    }
                    catch (ASN1Exception ae) {
                        int msgID = 10748041;
                        String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ae));
                        throw new ClientException(84, msgID, message, ae);
                    }
                    catch (LDAPException le) {
                        int msgID = 10748041;
                        String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(le));
                        throw new ClientException(84, msgID, message, le);
                    }
                    catch (Exception e) {
                        int msgID = 10748041;
                        String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                        throw new ClientException(82, msgID, message, e);
                    }
                    switch (responseMessage.getProtocolOpType()) {
                        case 97: {
                            break;
                        }
                        case 120: {
                            ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
                            String responseOID = extendedResponse.getOID();
                            if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
                                int msgID = 10748042;
                                String message = MessageHandler.getMessage(msgID, extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
                                throw new LDAPException(extendedResponse.getResultCode(), msgID, message);
                            }
                            int msgID = 10748043;
                            String message = MessageHandler.getMessage(msgID, String.valueOf(extendedResponse));
                            throw new ClientException(82, msgID, message);
                        }
                        default: {
                            int msgID = 10748044;
                            String message = MessageHandler.getMessage(msgID, String.valueOf(responseMessage.getProtocolOp()));
                            throw new ClientException(82, msgID, message);
                        }
                    }
                }
                int msgID = 10682563;
                String message = MessageHandler.getMessage(msgID);
                throw new LDAPException(resultCode, bindResponse.getErrorMessage(), msgID, message, bindResponse.getMatchedDN(), null);
            }
            int msgID = 10748094;
            String message = MessageHandler.getMessage(msgID, this.saslMechanism, StaticUtils.getBacktrace());
            throw new ClientException(82, msgID, message);
        }
        return null;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        if (this.saslMechanism == null) {
            int msgID = 10748100;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getBacktrace());
            throw new UnsupportedCallbackException(callbacks[0], message);
        }
        if (this.saslMechanism.equals("GSSAPI")) {
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    ((NameCallback)cb).setName(this.gssapiAuthID);
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    if (this.gssapiAuthPW == null) {
                        System.out.print(MessageHandler.getMessage(10485959, this.gssapiAuthID));
                        this.gssapiAuthPW = PasswordReader.readPassword();
                    }
                    ((PasswordCallback)cb).setPassword(this.gssapiAuthPW);
                    continue;
                }
                int msgID = 10748101;
                String message = MessageHandler.getMessage(msgID, String.valueOf(cb));
                throw new UnsupportedCallbackException(cb, message);
            }
        } else {
            int msgID = 10748102;
            String message = MessageHandler.getMessage(msgID, this.saslMechanism, StaticUtils.getBacktrace());
            throw new UnsupportedCallbackException(callbacks[0], message);
        }
    }

    public ASN1OctetString requestAuthorizationIdentity() throws ClientException, LDAPException {
        LDAPMessage responseMessage;
        ExtendedRequestProtocolOp extendedRequest = new ExtendedRequestProtocolOp("1.3.6.1.4.1.4203.1.11.3");
        LDAPMessage requestMessage = new LDAPMessage(this.nextMessageID.getAndIncrement(), extendedRequest);
        try {
            this.writer.writeMessage(requestMessage);
        }
        catch (IOException ioe) {
            int msgID = 10748106;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (Exception e) {
            int msgID = 10748106;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ClientException(83, msgID, message, e);
        }
        try {
            responseMessage = this.reader.readMessage();
            if (responseMessage == null) {
                int msgID = 10748693;
                String message = MessageHandler.getMessage(msgID);
                throw new ClientException(81, msgID, message);
            }
        }
        catch (IOException ioe) {
            int msgID = 10748107;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ioe));
            throw new ClientException(81, msgID, message, ioe);
        }
        catch (ASN1Exception ae) {
            int msgID = 10748107;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(ae));
            throw new ClientException(84, msgID, message, ae);
        }
        catch (LDAPException le) {
            int msgID = 10748107;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(le));
            throw new ClientException(84, msgID, message, le);
        }
        catch (Exception e) {
            int msgID = 10748107;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            throw new ClientException(82, msgID, message, e);
        }
        if (responseMessage.getProtocolOpType() != 120) {
            int msgID = 10748044;
            String message = MessageHandler.getMessage(msgID, String.valueOf(responseMessage.getProtocolOp()));
            throw new ClientException(82, msgID, message);
        }
        ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
        String responseOID = extendedResponse.getOID();
        if (responseOID != null && responseOID.equals("1.3.6.1.4.1.1466.20036")) {
            int msgID = 10748042;
            String message = MessageHandler.getMessage(msgID, extendedResponse.getResultCode(), extendedResponse.getErrorMessage());
            throw new LDAPException(extendedResponse.getResultCode(), msgID, message);
        }
        int resultCode = extendedResponse.getResultCode();
        if (resultCode != 0) {
            int msgID = 10682572;
            String message = MessageHandler.getMessage(msgID);
            throw new LDAPException(resultCode, extendedResponse.getErrorMessage(), msgID, message, extendedResponse.getMatchedDN(), null);
        }
        ASN1OctetString authzID = extendedResponse.getValue();
        if (authzID == null || authzID.value() == null || authzID.value().length == 0) {
            return null;
        }
        String valueString = authzID.stringValue();
        if (valueString == null || valueString.length() == 0 || valueString.equalsIgnoreCase("dn:")) {
            return null;
        }
        return authzID;
    }
}

