/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.tools.LDAPCompareOptions;
import org.opends.server.tools.LDAPConnection;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.LDAPToolUtils;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.Base64;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPCompare {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPCompare";
    private AtomicInteger nextMessageID;
    private PrintStream err;
    private PrintStream out;

    public LDAPCompare(AtomicInteger nextMessageID, PrintStream out, PrintStream err) {
        this.nextMessageID = nextMessageID;
        this.out = out;
        this.err = err;
    }

    public void readAndExecute(LDAPConnection connection, String attributeType, byte[] attributeVal, ArrayList<String> lines, LDAPCompareOptions compareOptions) throws IOException, LDAPException {
        for (String line : lines) {
            this.executeCompare(connection, attributeType, attributeVal, line, compareOptions);
        }
    }

    public void readAndExecute(LDAPConnection connection, String attributeType, byte[] attributeVal, Reader reader, LDAPCompareOptions compareOptions) throws IOException, LDAPException {
        BufferedReader in = new BufferedReader(reader);
        String line = null;
        while ((line = in.readLine()) != null) {
            this.executeCompare(connection, attributeType, attributeVal, line, compareOptions);
        }
        in.close();
    }

    private void executeCompare(LDAPConnection connection, String attributeType, byte[] attributeVal, String line, LDAPCompareOptions compareOptions) throws IOException, LDAPException {
        ArrayList<LDAPControl> controls = compareOptions.getControls();
        ASN1OctetString dnOctetStr = new ASN1OctetString(line);
        ASN1OctetString attrValOctetStr = new ASN1OctetString(attributeVal);
        CompareRequestProtocolOp protocolOp = new CompareRequestProtocolOp(dnOctetStr, attributeType, attrValOctetStr);
        int msgID = 10485867;
        this.out.println(MessageHandler.getMessage(msgID, attributeType, attrValOctetStr, dnOctetStr));
        if (!compareOptions.showOperations()) {
            LDAPMessage responseMessage = null;
            try {
                LDAPMessage message = new LDAPMessage(this.nextMessageID.getAndIncrement(), protocolOp, controls);
                connection.getLDAPWriter().writeMessage(message);
                responseMessage = connection.getLDAPReader().readMessage();
            }
            catch (ASN1Exception ae) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ae);
                }
                if (!compareOptions.continueOnError()) {
                    throw new IOException(ae.getMessage());
                }
                msgID = 10485865;
                String msg = MessageHandler.getMessage(msgID, "COMPARE");
                this.err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
                this.err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                return;
            }
            CompareResponseProtocolOp op = responseMessage.getCompareResponseProtocolOp();
            int resultCode = op.getResultCode();
            String errorMessage = op.getErrorMessage();
            if (resultCode != 6 && resultCode != 5 && !compareOptions.continueOnError()) {
                msgID = 10485865;
                String msg = MessageHandler.getMessage(msgID, "COMPARE");
                throw new LDAPException(resultCode, errorMessage, msgID, msg, op.getMatchedDN(), null);
            }
            if (resultCode == 5) {
                msgID = 10485868;
                this.out.println(MessageHandler.getMessage(msgID, line));
            } else if (resultCode == 6) {
                msgID = 10485869;
                this.out.println(MessageHandler.getMessage(msgID, line));
            } else {
                msgID = 10485865;
                String msg = MessageHandler.getMessage(msgID, "COMPARE");
                LDAPToolUtils.printErrorMessage(this.err, msg, resultCode, errorMessage, op.getMatchedDN());
            }
        }
    }

    public static void main(String[] args) {
        int retCode = LDAPCompare.mainCompare(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainCompare(String[] args) {
        return LDAPCompare.mainCompare(args, true, System.out, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainCompare(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        int n;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        LDAPCompareOptions compareOptions = new LDAPCompareOptions();
        LDAPConnection connection = null;
        BooleanArgument continueOnError = null;
        BooleanArgument noop = null;
        BooleanArgument saslExternal = null;
        BooleanArgument showUsage = null;
        BooleanArgument startTLS = null;
        BooleanArgument trustAll = null;
        BooleanArgument useSSL = null;
        BooleanArgument verbose = null;
        FileBasedArgument bindPasswordFile = null;
        FileBasedArgument keyStorePasswordFile = null;
        FileBasedArgument trustStorePasswordFile = null;
        IntegerArgument port = null;
        IntegerArgument version = null;
        StringArgument assertionFilter = null;
        StringArgument bindDN = null;
        StringArgument bindPassword = null;
        StringArgument certNickname = null;
        StringArgument controlStr = null;
        StringArgument encodingStr = null;
        StringArgument filename = null;
        StringArgument hostName = null;
        StringArgument keyStorePath = null;
        StringArgument keyStorePassword = null;
        StringArgument saslOptions = null;
        StringArgument trustStorePath = null;
        StringArgument trustStorePassword = null;
        ArrayList<String> dnStrings = new ArrayList<String>();
        String attributeType = null;
        byte[] attributeVal = null;
        InputStreamReader rdr = null;
        String toolDescription = MessageHandler.getMessage(10486449);
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false, true, 1, 0, " 'attribute:value' \"DN\" ...");
        try {
            hostName = new StringArgument("host", Character.valueOf('h'), "hostname", false, false, true, "{host}", "localhost", null, 10485880, new Object[0]);
            argParser.addArgument(hostName);
            port = new IntegerArgument("port", Character.valueOf('p'), "port", false, false, true, "{port}", 389, null, 10485881, new Object[0]);
            argParser.addArgument(port);
            useSSL = new BooleanArgument("useSSL", Character.valueOf('Z'), "useSSL", 10485885, new Object[0]);
            argParser.addArgument(useSSL);
            startTLS = new BooleanArgument("startTLS", Character.valueOf('q'), "useStartTLS", 10485886, new Object[0]);
            argParser.addArgument(startTLS);
            bindDN = new StringArgument("bindDN", Character.valueOf('D'), "bindDN", false, false, true, "{bindDN}", null, null, 0xA00070, new Object[0]);
            argParser.addArgument(bindDN);
            bindPassword = new StringArgument("bindPassword", Character.valueOf('w'), "bindPassword", false, false, true, "{bindPassword}", null, null, 10485873, new Object[0]);
            argParser.addArgument(bindPassword);
            bindPasswordFile = new FileBasedArgument("bindPasswordFile", Character.valueOf('j'), "bindPasswordFile", false, false, "{bindPasswordFile}", null, null, 10485874, new Object[0]);
            argParser.addArgument(bindPasswordFile);
            filename = new StringArgument("filename", Character.valueOf('f'), "filename", false, false, true, "{filename}", null, null, 10486173, new Object[0]);
            argParser.addArgument(filename);
            saslExternal = new BooleanArgument("useSASLExternal", Character.valueOf('r'), "useSASLExternal", 10485887, new Object[0]);
            argParser.addArgument(saslExternal);
            saslOptions = new StringArgument("saslOption", Character.valueOf('o'), "saslOption", false, true, true, "{name=value}", null, null, 10485942, new Object[0]);
            argParser.addArgument(saslOptions);
            trustAll = new BooleanArgument("trustAll", Character.valueOf('X'), "trustAll", 10485871, new Object[0]);
            argParser.addArgument(trustAll);
            keyStorePath = new StringArgument("keyStorePath", Character.valueOf('K'), "keyStorePath", false, false, true, "{keyStorePath}", null, null, 10485877, new Object[0]);
            argParser.addArgument(keyStorePath);
            keyStorePassword = new StringArgument("keyStorePassword", Character.valueOf('W'), "keyStorePassword", false, false, true, "{keyStorePassword}", null, null, 0xA00077, new Object[0]);
            argParser.addArgument(keyStorePassword);
            keyStorePasswordFile = new FileBasedArgument("keyStorePasswordFile", Character.valueOf('u'), "keyStorePasswordFile", false, false, "{path}", null, null, 10486480, new Object[0]);
            argParser.addArgument(keyStorePasswordFile);
            certNickname = new StringArgument("certnickname", Character.valueOf('N'), "certNickname", false, false, true, "{nickname}", null, null, 10486565, new Object[0]);
            argParser.addArgument(certNickname);
            trustStorePath = new StringArgument("trustStorePath", Character.valueOf('P'), "trustStorePath", false, false, true, "{trustStorePath}", null, null, 10485878, new Object[0]);
            argParser.addArgument(trustStorePath);
            trustStorePassword = new StringArgument("trustStorePassword", null, "trustStorePassword", false, false, true, "{trustStorePassword}", null, null, 10486481, new Object[0]);
            argParser.addArgument(trustStorePassword);
            trustStorePasswordFile = new FileBasedArgument("trustStorePasswordFile", Character.valueOf('U'), "TrustStorePasswordFile", false, false, "{path}", null, null, 10486482, new Object[0]);
            argParser.addArgument(trustStorePasswordFile);
            assertionFilter = new StringArgument("assertionfilter", null, "assertionFilter", false, false, true, "{filter}", null, null, 10486102, new Object[0]);
            argParser.addArgument(assertionFilter);
            controlStr = new StringArgument("control", Character.valueOf('J'), "control", false, true, true, "{controloid[:criticality[:value|::b64value|:<filePath]]}", null, null, 10485883, new Object[0]);
            argParser.addArgument(controlStr);
            version = new IntegerArgument("version", Character.valueOf('V'), "ldapVersion", false, false, true, "{version}", 3, null, 10485960, new Object[0]);
            argParser.addArgument(version);
            encodingStr = new StringArgument("encoding", Character.valueOf('i'), "encoding", false, false, true, "{encoding}", null, null, 10485875, new Object[0]);
            argParser.addArgument(encodingStr);
            continueOnError = new BooleanArgument("continueOnError", Character.valueOf('c'), "continueOnError", 10485884, new Object[0]);
            argParser.addArgument(continueOnError);
            noop = new BooleanArgument("no-op", Character.valueOf('n'), "dry-run", 10486087, new Object[0]);
            argParser.addArgument(noop);
            verbose = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", 10485876, new Object[0]);
            argParser.addArgument(verbose);
            showUsage = new BooleanArgument("showUsage", Character.valueOf('H'), "help", 0xA0007A, new Object[0]);
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage, out);
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (bindPassword.isPresent() && bindPasswordFile.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, bindPassword.getLongIdentifier(), bindPasswordFile.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        ArrayList<String> attrAndDNStrings = argParser.getTrailingArguments();
        if (attrAndDNStrings.isEmpty()) {
            int msgID = 10748607;
            String message = MessageHandler.getMessage(msgID);
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        String attributeString = attrAndDNStrings.remove(0);
        for (String s : attrAndDNStrings) {
            dnStrings.add(s);
        }
        if (dnStrings.isEmpty()) {
            int msgID = 10748586;
            err.println(StaticUtils.wrapText(MessageHandler.getMessage(msgID), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        int idx = attributeString.indexOf(":");
        if (idx == -1) {
            int msgID = 10748608;
            String message = MessageHandler.getMessage(msgID, attributeString);
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        attributeType = attributeString.substring(0, idx);
        String remainder = attributeString.substring(idx + 1, attributeString.length());
        if (remainder.length() > 0) {
            char nextChar = remainder.charAt(0);
            if (nextChar == ':') {
                String base64 = remainder.substring(1, remainder.length());
                try {
                    attributeVal = Base64.decode(base64);
                }
                catch (ParseException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    int msgID = 10486433;
                    err.println(StaticUtils.wrapText(MessageHandler.getMessage(msgID), ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            } else if (nextChar == '<') {
                try {
                    String filePath = remainder.substring(1, remainder.length());
                    attributeVal = LDAPToolUtils.readBytesFromFile(filePath, err);
                }
                catch (Exception e) {
                    int msgID = 0xA002A2;
                    err.println(StaticUtils.wrapText(MessageHandler.getMessage(msgID, String.valueOf(e)), ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
            } else {
                attributeVal = remainder.getBytes();
            }
        } else {
            attributeVal = remainder.getBytes();
        }
        String hostNameValue = hostName.getValue();
        int portNumber = 389;
        try {
            portNumber = port.getIntValue();
        }
        catch (ArgumentException ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            int versionNumber = version.getIntValue();
            if (versionNumber != 2 && versionNumber != 3) {
                int msgID = 10682569;
                err.println(StaticUtils.wrapText(MessageHandler.getMessage(msgID, versionNumber), ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            connectionOptions.setVersionNumber(versionNumber);
        }
        catch (ArgumentException ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            err.println(StaticUtils.wrapText(ae.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        String bindDNValue = bindDN.getValue();
        String fileNameValue = filename.getValue();
        String bindPasswordValue = bindPassword.getValue();
        if (bindPasswordValue != null && bindPasswordValue.equals("-")) {
            try {
                out.print(MessageHandler.getMessage(10485959, bindDNValue));
                char[] pwChars = PasswordReader.readPassword();
                bindPasswordValue = new String(pwChars);
            }
            catch (Exception ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                err.println(StaticUtils.wrapText(ex.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        } else if (bindPasswordValue == null) {
            bindPasswordValue = bindPasswordFile.getValue();
        }
        String keyStorePathValue = keyStorePath.getValue();
        String trustStorePathValue = trustStorePath.getValue();
        String keyStorePasswordValue = null;
        if (keyStorePassword.isPresent()) {
            keyStorePasswordValue = keyStorePassword.getValue();
        } else if (keyStorePasswordFile.isPresent()) {
            keyStorePasswordValue = keyStorePasswordFile.getValue();
        }
        String trustStorePasswordValue = null;
        if (trustStorePassword.isPresent()) {
            trustStorePasswordValue = trustStorePassword.getValue();
        } else if (trustStorePasswordFile.isPresent()) {
            trustStorePasswordValue = trustStorePasswordFile.getValue();
        }
        compareOptions.setShowOperations(noop.isPresent());
        compareOptions.setVerbose(verbose.isPresent());
        compareOptions.setContinueOnError(continueOnError.isPresent());
        compareOptions.setEncoding(encodingStr.getValue());
        if (controlStr.isPresent()) {
            for (String ctrlString : controlStr.getValues()) {
                LDAPControl ctrl = LDAPToolUtils.getControl(ctrlString, err);
                if (ctrl == null) {
                    int msgID = 10748609;
                    String message = MessageHandler.getMessage(msgID, ctrlString);
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    err.println(argParser.getUsage());
                    return 1;
                }
                compareOptions.getControls().add(ctrl);
            }
        }
        if (assertionFilter.isPresent()) {
            String filterString = assertionFilter.getValue();
            try {
                LDAPFilter filter = LDAPFilter.decode(filterString);
                LDAPControl assertionControl = new LDAPControl("1.3.6.1.1.12", true, new ASN1OctetString(filter.encode().encode()));
                compareOptions.getControls().add(assertionControl);
            }
            catch (LDAPException le) {
                int msgID = 10682711;
                String message = MessageHandler.getMessage(msgID, le.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        connectionOptions.setSASLExternal(saslExternal.isPresent());
        if (saslOptions.isPresent()) {
            LinkedList<String> values = saslOptions.getValues();
            for (String saslOption : values) {
                boolean val;
                if (!(saslOption.startsWith("mech=") ? !(val = connectionOptions.setSASLMechanism(saslOption)) : !(val = connectionOptions.addSASLProperty(saslOption)))) continue;
                return 1;
            }
        }
        connectionOptions.setUseSSL(useSSL.isPresent());
        connectionOptions.setStartTLS(startTLS.isPresent());
        if (connectionOptions.useSASLExternal()) {
            String message;
            if (!connectionOptions.useSSL() && !connectionOptions.useStartTLS()) {
                int msgID = 10748610;
                message = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            if (keyStorePathValue == null) {
                int msgID = 10748611;
                message = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        LDAPCompare ldapCompare = null;
        try {
            if (initializeServer) {
                DirectoryServer.bootstrapClient();
            }
            SSLConnectionFactory sslConnectionFactory = null;
            if (connectionOptions.useSSL() || connectionOptions.useStartTLS()) {
                String clientAlias = certNickname.isPresent() ? certNickname.getValue() : null;
                sslConnectionFactory = new SSLConnectionFactory();
                sslConnectionFactory.init(trustAll.isPresent(), keyStorePathValue, keyStorePasswordValue, clientAlias, trustStorePathValue, trustStorePasswordValue);
                connectionOptions.setSSLConnectionFactory(sslConnectionFactory);
            }
            AtomicInteger nextMessageID = new AtomicInteger(1);
            connection = new LDAPConnection(hostNameValue, portNumber, connectionOptions, out, err);
            connection.connectToHost(bindDNValue, bindPasswordValue, nextMessageID);
            ldapCompare = new LDAPCompare(nextMessageID, out, err);
            if (fileNameValue == null && dnStrings.isEmpty()) {
                rdr = new InputStreamReader(System.in);
            } else if (fileNameValue != null) {
                rdr = new FileReader(fileNameValue);
            }
            if (rdr != null) {
                ldapCompare.readAndExecute(connection, attributeType, attributeVal, rdr, compareOptions);
            } else {
                ldapCompare.readAndExecute(connection, attributeType, attributeVal, dnStrings, compareOptions);
            }
        }
        catch (LDAPException le) {
            int code;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, le);
            }
            LDAPToolUtils.printErrorMessage(err, le.getMessage(), le.getResultCode(), le.getErrorMessage(), le.getMatchedDN());
            n = code = le.getResultCode();
            return n;
        }
        catch (LDAPConnectionException lce) {
            int code;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, lce);
            }
            LDAPToolUtils.printErrorMessage(err, lce.getMessage(), lce.getResultCode(), lce.getErrorMessage(), lce.getMatchedDN());
            n = code = lce.getResultCode();
            return n;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            int n2 = 1;
            return n2;
        }
        finally {
            if (connection != null) {
                if (ldapCompare == null) {
                    connection.close(null);
                } else {
                    connection.close(ldapCompare.nextMessageID);
                }
            }
        }
        return 0;
    }
}

