/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import org.opends.server.types.DN;

public class LDAPConnectionException
extends Exception {
    private static final long serialVersionUID = 3135563348838654570L;
    private final int resultCode;
    private final DN matchedDN;
    private final String errorMessage;

    public LDAPConnectionException(String message) {
        super(message);
        this.resultCode = -1;
        this.matchedDN = null;
        this.errorMessage = null;
    }

    public LDAPConnectionException(String message, int resultCode, String errorMessage) {
        super(message);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = null;
    }

    public LDAPConnectionException(String message, Throwable cause) {
        super(message, cause);
        this.resultCode = -1;
        this.matchedDN = null;
        this.errorMessage = null;
    }

    public LDAPConnectionException(String message, int resultCode, String errorMessage, Throwable cause) {
        super(message, cause);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = null;
    }

    public LDAPConnectionException(String message, int resultCode, String errorMessage, DN matchedDN, Throwable cause) {
        super(message, cause);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = matchedDN;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public DN getMatchedDN() {
        return this.matchedDN;
    }
}

