/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.MultiChoiceArgument;
import org.opends.server.util.args.StringArgument;

public class LDIFSearch {
    private static final String CLASS_NAME = "org.opends.server.tools.LDIFSearch";
    private static final String SCOPE_STRING_BASE = "base";
    private static final String SCOPE_STRING_ONE = "one";
    private static final String SCOPE_STRING_SUB = "sub";
    private static final String SCOPE_STRING_SUBORDINATE = "subordinate";

    public static void main(String[] args) {
        int exitCode = LDIFSearch.mainSearch(args, true, System.out, System.err);
        if (exitCode != 0) {
            System.exit(StaticUtils.filterExitCode(exitCode));
        }
    }

    public static int mainSearch(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        LDIFWriter writer;
        LDIFReader reader;
        int sizeLimitValue;
        long timeLimitMillis;
        String scopeStr;
        LinkedList<String> attributeNames;
        ArrayList<String> trailingArguments;
        LinkedList<String> filterStrings;
        IntegerArgument timeLimit;
        IntegerArgument sizeLimit;
        BooleanArgument dontWrap;
        BooleanArgument overwriteExisting;
        StringArgument outputFile;
        FileBasedArgument filterFile;
        StringArgument configClass;
        StringArgument configFile;
        MultiChoiceArgument scopeString;
        StringArgument baseDNString;
        StringArgument ldifFile;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        LinkedHashSet<String> scopeStrings = new LinkedHashSet<String>(4);
        scopeStrings.add(SCOPE_STRING_BASE);
        scopeStrings.add(SCOPE_STRING_ONE);
        scopeStrings.add(SCOPE_STRING_SUB);
        scopeStrings.add(SCOPE_STRING_SUBORDINATE);
        String toolDescription = MessageHandler.getMessage(10486456);
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false, true, 0, 0, "[filter] [attributes ...]");
        try {
            ldifFile = new StringArgument("ldiffile", Character.valueOf('l'), "ldifFile", false, true, true, "{ldifFile}", null, null, 10486174, new Object[0]);
            argParser.addArgument(ldifFile);
            baseDNString = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, true, true, "{baseDN}", "", null, 10486175, new Object[0]);
            argParser.addArgument(baseDNString);
            scopeString = new MultiChoiceArgument("scope", Character.valueOf('s'), "scope", false, false, true, "{scope}", SCOPE_STRING_SUB, null, scopeStrings, false, 0xA001A0, new Object[0]);
            argParser.addArgument(scopeString);
            configFile = new StringArgument("configfile", Character.valueOf('c'), "configFile", false, false, true, "{configFile}", null, null, 0xA0000D, new Object[0]);
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 0xA0000C, new Object[0]);
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            filterFile = new FileBasedArgument("filterfile", Character.valueOf('f'), "filterFile", false, false, "{filterFile}", null, null, 10486179, new Object[0]);
            argParser.addArgument(filterFile);
            outputFile = new StringArgument("outputfile", Character.valueOf('o'), "outputFile", false, false, true, "{outputFile}", null, null, 10486180, new Object[0]);
            argParser.addArgument(outputFile);
            overwriteExisting = new BooleanArgument("overwriteexisting", Character.valueOf('O'), "overwriteExisting", 10486181, new Object[0]);
            argParser.addArgument(overwriteExisting);
            dontWrap = new BooleanArgument("dontwrap", Character.valueOf('T'), "dontWrap", 10486182, new Object[0]);
            argParser.addArgument(dontWrap);
            sizeLimit = new IntegerArgument("sizelimit", Character.valueOf('z'), "sizeLimit", false, false, true, "{sizeLimit}", 0, null, true, 0, false, 0, 10486183, new Object[0]);
            argParser.addArgument(sizeLimit);
            timeLimit = new IntegerArgument("timelimit", Character.valueOf('t'), "timeLimit", false, false, true, "{timeLimit}", 0, null, true, 0, false, 0, 10486184, new Object[0]);
            argParser.addArgument(timeLimit);
            BooleanArgument showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", 0xA0000F, new Object[0]);
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(message);
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(message);
            err.println(argParser.getUsage());
            return 89;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        boolean allUserAttrs = false;
        boolean allOperationalAttrs = false;
        boolean includeObjectclassAttrs = true;
        LinkedList<String> objectClassNames = new LinkedList<String>();
        if (filterFile.isPresent()) {
            filterStrings = filterFile.getValues();
            trailingArguments = argParser.getTrailingArguments();
            if (trailingArguments == null || trailingArguments.isEmpty()) {
                attributeNames = new LinkedList<String>();
            } else {
                attributeNames = new LinkedList();
                for (String attributeName : trailingArguments) {
                    String lowerName = StaticUtils.toLowerCase(attributeName);
                    if (lowerName.equals("*")) {
                        allUserAttrs = true;
                        continue;
                    }
                    if (lowerName.equals("+")) {
                        allOperationalAttrs = true;
                        continue;
                    }
                    if (lowerName.startsWith("@")) {
                        objectClassNames.add(lowerName.substring(1));
                        continue;
                    }
                    attributeNames.add(lowerName);
                }
            }
        } else {
            trailingArguments = argParser.getTrailingArguments();
            if (trailingArguments == null || trailingArguments.isEmpty()) {
                int msgID = 10748332;
                String message = MessageHandler.getMessage(msgID);
                err.println(message);
                return 1;
            }
            Iterator<String> iterator = trailingArguments.iterator();
            filterStrings = new LinkedList();
            filterStrings.add(iterator.next());
            attributeNames = new LinkedList();
            while (iterator.hasNext()) {
                String lowerName = StaticUtils.toLowerCase(iterator.next());
                if (lowerName.equals("*")) {
                    allUserAttrs = true;
                    continue;
                }
                if (lowerName.equals("+")) {
                    allOperationalAttrs = true;
                    continue;
                }
                if (lowerName.startsWith("@")) {
                    objectClassNames.add(lowerName.substring(1));
                    continue;
                }
                attributeNames.add(lowerName);
            }
        }
        if (attributeNames.isEmpty() && objectClassNames.isEmpty() && !allOperationalAttrs) {
            allUserAttrs = true;
        }
        if (!allUserAttrs) {
            if (allOperationalAttrs && objectClassNames.isEmpty() && attributeNames.isEmpty()) {
                includeObjectclassAttrs = false;
            }
            if (!attributeNames.isEmpty() && objectClassNames.isEmpty() && !attributeNames.contains("objectclass")) {
                includeObjectclassAttrs = false;
            }
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        boolean checkSchema = configFile.isPresent();
        if (initializeServer) {
            DirectoryServer.bootstrapClient();
            if (checkSchema) {
                try {
                    DirectoryServer.initializeJMX();
                }
                catch (Exception e) {
                    int msgID = 10748346;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message);
                    return 1;
                }
                try {
                    directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
                }
                catch (Exception e) {
                    int msgID = 10748333;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message);
                    return 1;
                }
                try {
                    directoryServer.initializeSchema();
                }
                catch (Exception e) {
                    int msgID = 10748334;
                    String message = MessageHandler.getMessage(msgID, String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message);
                    return 1;
                }
            }
        }
        SearchScope searchScope = scopeString.isPresent() ? ((scopeStr = StaticUtils.toLowerCase(scopeString.getValue())).equals(SCOPE_STRING_BASE) ? SearchScope.BASE_OBJECT : (scopeStr.equals(SCOPE_STRING_ONE) ? SearchScope.SINGLE_LEVEL : (scopeStr.equals(SCOPE_STRING_SUBORDINATE) ? SearchScope.SUBORDINATE_SUBTREE : SearchScope.WHOLE_SUBTREE))) : SearchScope.WHOLE_SUBTREE;
        LinkedList<SearchFilter> searchFilters = new LinkedList<SearchFilter>();
        for (String filterString : filterStrings) {
            try {
                searchFilters.add(SearchFilter.createFilterFromString(filterString));
            }
            catch (Exception e) {
                int msgID = 10748335;
                String message = MessageHandler.getMessage(msgID, filterString, e.getMessage());
                err.println(message);
                return 1;
            }
        }
        LinkedHashSet<AttributeType> userAttributeTypes = new LinkedHashSet<AttributeType>();
        LinkedHashSet<AttributeType> operationalAttributeTypes = new LinkedHashSet<AttributeType>();
        for (String attributeName : attributeNames) {
            AttributeType t = DirectoryServer.getAttributeType(attributeName, true);
            if (t.isOperational()) {
                operationalAttributeTypes.add(t);
                continue;
            }
            userAttributeTypes.add(t);
        }
        for (String objectClassName : objectClassNames) {
            ObjectClass c = DirectoryServer.getObjectClass(objectClassName, true);
            for (AttributeType t : c.getRequiredAttributeChain()) {
                if (t.isOperational()) {
                    operationalAttributeTypes.add(t);
                    continue;
                }
                userAttributeTypes.add(t);
            }
            for (AttributeType t : c.getOptionalAttributeChain()) {
                if (t.isOperational()) {
                    operationalAttributeTypes.add(t);
                    continue;
                }
                userAttributeTypes.add(t);
            }
        }
        LinkedList<DN> baseDNs = new LinkedList<DN>();
        if (baseDNString.isPresent()) {
            for (String dnString : baseDNString.getValues()) {
                try {
                    baseDNs.add(DN.decode(dnString));
                }
                catch (Exception e) {
                    int msgID = 10748336;
                    String message = MessageHandler.getMessage(msgID, dnString, e.getMessage());
                    err.println(message);
                    return 1;
                }
            }
        } else {
            baseDNs.add(DN.nullDN());
        }
        try {
            timeLimitMillis = timeLimit.isPresent() ? 1000L * (long)timeLimit.getIntValue() : 0L;
        }
        catch (Exception e) {
            int msgID = 10748337;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            err.println(message);
            return 1;
        }
        try {
            sizeLimitValue = sizeLimit.isPresent() ? sizeLimit.getIntValue() : 0;
        }
        catch (Exception e) {
            int msgID = 10748338;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            err.println(message);
            return 1;
        }
        LDIFImportConfig importConfig = ldifFile.isPresent() ? new LDIFImportConfig(ldifFile.getValues()) : new LDIFImportConfig(System.in);
        LDIFExportConfig exportConfig = outputFile.isPresent() ? (overwriteExisting.isPresent() ? new LDIFExportConfig(outputFile.getValue(), ExistingFileBehavior.OVERWRITE) : new LDIFExportConfig(outputFile.getValue(), ExistingFileBehavior.APPEND)) : new LDIFExportConfig(out);
        exportConfig.setIncludeObjectClasses(includeObjectclassAttrs);
        if (dontWrap.isPresent()) {
            exportConfig.setWrapColumn(0);
        } else {
            exportConfig.setWrapColumn(75);
        }
        try {
            reader = new LDIFReader(importConfig);
        }
        catch (Exception e) {
            int msgID = 10748339;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            err.println(message);
            return 1;
        }
        try {
            writer = new LDIFWriter(exportConfig);
        }
        catch (Exception e) {
            try {
                reader.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            int msgID = 10748340;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            err.println(message);
            return 1;
        }
        long startTime = System.currentTimeMillis();
        long stopTime = startTime + timeLimitMillis;
        long matchCount = 0L;
        int resultCode = 0;
        while (true) {
            String message;
            int msgID;
            if (timeLimitMillis > 0L && System.currentTimeMillis() > stopTime) {
                resultCode = 3;
                int msgID2 = 10551733;
                String message2 = MessageHandler.getMessage(msgID2);
                err.println(message2);
                break;
            }
            try {
                Iterator<AttributeType> iterator;
                Entry entry = reader.readEntry(checkSchema);
                if (entry == null) break;
                boolean matchesBaseAndScope = false;
                for (DN baseDN : baseDNs) {
                    if (!entry.matchesBaseAndScope(baseDN, searchScope)) continue;
                    matchesBaseAndScope = true;
                    break;
                }
                if (!matchesBaseAndScope) continue;
                boolean matchesFilter = false;
                for (SearchFilter filter : searchFilters) {
                    if (!filter.matchesEntry(entry)) continue;
                    matchesFilter = true;
                    break;
                }
                if (!matchesFilter) continue;
                if (!allUserAttrs) {
                    iterator = entry.getUserAttributes().keySet().iterator();
                    while (iterator.hasNext()) {
                        if (userAttributeTypes.contains(iterator.next())) continue;
                        iterator.remove();
                    }
                }
                if (!allOperationalAttrs) {
                    iterator = entry.getOperationalAttributes().keySet().iterator();
                    while (iterator.hasNext()) {
                        if (operationalAttributeTypes.contains(iterator.next())) continue;
                        iterator.remove();
                    }
                }
                writer.writeEntry(entry);
                writer.flush();
                if (sizeLimitValue <= 0 || ++matchCount <= (long)sizeLimitValue) continue;
                resultCode = 4;
                int msgID3 = 10551734;
                String message3 = MessageHandler.getMessage(msgID3);
                err.println(message3);
            }
            catch (LDIFException le) {
                if (le.canContinueReading()) {
                    msgID = 10748343;
                    message = MessageHandler.getMessage(msgID, le.getMessage());
                    err.println(message);
                    continue;
                }
                msgID = 10748344;
                message = MessageHandler.getMessage(msgID, le.getMessage());
                err.println(message);
                resultCode = 82;
            }
            catch (Exception e) {
                msgID = 10748345;
                message = MessageHandler.getMessage(msgID, String.valueOf(e));
                err.println(message);
                resultCode = 82;
            }
            break;
        }
        try {
            reader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            writer.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return resultCode;
    }
}

