/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBackends {
    public static void main(String[] args) {
        int retCode = ListBackends.listBackends(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int listBackends(String[] args) {
        return ListBackends.listBackends(args, true, System.out, System.err);
    }

    public static int listBackends(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        TreeMap<String, TreeSet<DN>> backends;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        BooleanArgument displayUsage = null;
        StringArgument backendID = null;
        StringArgument baseDN = null;
        StringArgument configClass = null;
        StringArgument configFile = null;
        String toolDescription = MessageHandler.getMessage(10486483);
        ArgumentParser argParser = new ArgumentParser("org.opends.server.tools.ListBackends", toolDescription, false);
        try {
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 0xA0000C, new Object[0]);
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, "{configFile}", null, null, 0xA0000D, new Object[0]);
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", false, true, true, "{backendID}", null, null, 10486486, new Object[0]);
            argParser.addArgument(backendID);
            baseDN = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, true, true, "{baseDN}", null, null, 10486487, new Object[0]);
            argParser.addArgument(baseDN);
            displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", 10486488, new Object[0]);
            argParser.addArgument(displayUsage);
            argParser.setUsageArgument(displayUsage, out);
        }
        catch (ArgumentException ae) {
            int msgID = 10747920;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            int msgID = 10747921;
            String message = MessageHandler.getMessage(msgID, ae.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (backendID.isPresent() && baseDN.isPresent()) {
            int msgID = 10748606;
            String message = MessageHandler.getMessage(msgID, backendID.getLongIdentifier(), baseDN.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            try {
                directoryServer.bootstrapClient();
                directoryServer.initializeJMX();
            }
            catch (Exception e) {
                int msgID = 10747924;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
            }
            catch (InitializationException ie) {
                int msgID = 10747925;
                String message = MessageHandler.getMessage(msgID, ie.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID = 10747925;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                int msgID = 10747926;
                String message = MessageHandler.getMessage(msgID, ce.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                int msgID = 10747926;
                String message = MessageHandler.getMessage(msgID, ie.getMessage());
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                int msgID = 10747926;
                String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        try {
            backends = ListBackends.getBackends();
        }
        catch (ConfigException ce) {
            int msgID = 10748638;
            String message = MessageHandler.getMessage(msgID, ce.getMessage());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        catch (Exception e) {
            int msgID = 10748638;
            String message = MessageHandler.getMessage(msgID, StaticUtils.getExceptionMessage(e));
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (baseDN.isPresent()) {
            TreeMap<DN, String> baseToIDMap = new TreeMap<DN, String>();
            for (String id : backends.keySet()) {
                for (DN dn : backends.get(id)) {
                    baseToIDMap.put(dn, id);
                }
            }
            block21: for (String dnStr : baseDN.getValues()) {
                String message;
                int msgID;
                DN dn;
                try {
                    dn = DN.decode(dnStr);
                }
                catch (DirectoryException de) {
                    msgID = 10748639;
                    message = MessageHandler.getMessage(msgID, dnStr, de.getMessage());
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                catch (Exception e) {
                    msgID = 10748639;
                    message = MessageHandler.getMessage(msgID, dnStr, StaticUtils.getExceptionMessage(e));
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    return 1;
                }
                String id = (String)baseToIDMap.get(dn);
                if (id == null) {
                    msgID = 10486496;
                    message = MessageHandler.getMessage(msgID, dn.toString());
                    out.println(message);
                    DN parentDN = dn.getParent();
                    while (true) {
                        if (parentDN == null) {
                            msgID = 10486497;
                            message = MessageHandler.getMessage(msgID, dn.toString());
                            out.println(message);
                            continue block21;
                        }
                        id = (String)baseToIDMap.get(parentDN);
                        if (id != null) {
                            msgID = 10486498;
                            message = MessageHandler.getMessage(msgID, dn.toString(), parentDN.toString(), id);
                            out.println(message);
                            continue block21;
                        }
                        parentDN = parentDN.getParent();
                    }
                }
                msgID = 10486499;
                message = MessageHandler.getMessage(msgID, dn.toString(), id);
                out.println(message);
            }
        } else {
            int i;
            LinkedList<String> backendIDs = backendID.isPresent() ? backendID.getValues() : new LinkedList<String>(backends.keySet());
            String backendIDLabel = MessageHandler.getMessage(10486500);
            String baseDNLabel = MessageHandler.getMessage(10486501);
            int backendIDLength = 10;
            int baseDNLength = 7;
            Iterator iterator = backendIDs.iterator();
            while (iterator.hasNext()) {
                String id = (String)iterator.next();
                TreeSet<DN> baseDNs = backends.get(id);
                if (baseDNs == null) {
                    int msgID = 10748646;
                    String message = MessageHandler.getMessage(msgID, id);
                    err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                    iterator.remove();
                    continue;
                }
                backendIDLength = Math.max(id.length(), backendIDLength);
                for (DN dn : baseDNs) {
                    baseDNLength = Math.max(dn.toString().length(), baseDNLength);
                }
            }
            if (backendIDs.isEmpty()) {
                int msgID = 10748647;
                String message = MessageHandler.getMessage(msgID);
                err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            out.print(backendIDLabel);
            for (i = backendIDLabel.length(); i < backendIDLength + 2; ++i) {
                out.print(" ");
            }
            out.println(baseDNLabel);
            for (i = 0; i < backendIDLength; ++i) {
                out.print("-");
            }
            out.print("  ");
            for (i = 0; i < baseDNLength; ++i) {
                out.print("-");
            }
            out.println();
            for (String id : backendIDs) {
                out.print(id);
                for (int i2 = id.length(); i2 < backendIDLength + 2; ++i2) {
                    out.print(" ");
                }
                TreeSet<DN> baseDNs = backends.get(id);
                Iterator<DN> dnIterator = baseDNs.iterator();
                out.println(dnIterator.next().toString());
                while (dnIterator.hasNext()) {
                    for (int i3 = 0; i3 < backendIDLength + 2; ++i3) {
                        out.print(" ");
                    }
                    out.println(dnIterator.next().toString());
                }
            }
        }
        return 0;
    }

    private static TreeMap<String, TreeSet<DN>> getBackends() throws ConfigException {
        DN backendBaseDN = null;
        try {
            backendBaseDN = DN.decode("cn=Backends,cn=config");
        }
        catch (DirectoryException de) {
            int msgID = 10747964;
            String message = MessageHandler.getMessage(msgID, "cn=Backends,cn=config", de.getErrorMessage());
            throw new ConfigException(msgID, message, de);
        }
        catch (Exception e) {
            int msgID = 10747964;
            String message = MessageHandler.getMessage(msgID, "cn=Backends,cn=config", StaticUtils.getExceptionMessage(e));
            throw new ConfigException(msgID, message, e);
        }
        ConfigEntry baseEntry = null;
        try {
            baseEntry = DirectoryServer.getConfigEntry(backendBaseDN);
        }
        catch (ConfigException ce) {
            int msgID = 10747965;
            String message = MessageHandler.getMessage(msgID, "cn=Backends,cn=config", ce.getMessage());
            throw new ConfigException(msgID, message, ce);
        }
        catch (Exception e) {
            int msgID = 10747965;
            String message = MessageHandler.getMessage(msgID, "cn=Backends,cn=config", StaticUtils.getExceptionMessage(e));
            throw new ConfigException(msgID, message, e);
        }
        TreeMap<String, TreeSet<DN>> backendMap = new TreeMap<String, TreeSet<DN>>();
        for (ConfigEntry configEntry : baseEntry.getChildren().values()) {
            String message;
            String backendID = null;
            try {
                int msgID = 3146110;
                StringConfigAttribute idStub = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(msgID), true, false, true);
                StringConfigAttribute idAttr = (StringConfigAttribute)configEntry.getConfigAttribute(idStub);
                if (idAttr == null) continue;
                backendID = idAttr.activeValue();
            }
            catch (ConfigException ce) {
                int msgID = 10748121;
                message = MessageHandler.getMessage(msgID, String.valueOf(configEntry.getDN()), ce.getMessage());
                throw new ConfigException(msgID, message, ce);
            }
            catch (Exception e) {
                int msgID = 10748121;
                message = MessageHandler.getMessage(msgID, String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                throw new ConfigException(msgID, message, e);
            }
            TreeSet<DN> baseDNs = new TreeSet<DN>();
            try {
                int msgID = 0x300131;
                DNConfigAttribute baseDNStub = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(msgID), true, true, true);
                DNConfigAttribute baseDNAttr = (DNConfigAttribute)configEntry.getConfigAttribute(baseDNStub);
                if (baseDNAttr != null) {
                    baseDNs.addAll(baseDNAttr.activeValues());
                }
            }
            catch (Exception e) {
                int msgID = 10747970;
                String message2 = MessageHandler.getMessage(msgID, String.valueOf(configEntry.getDN()), StaticUtils.getExceptionMessage(e));
                throw new ConfigException(msgID, message2, e);
            }
            backendMap.put(backendID, baseDNs);
        }
        return backendMap;
    }
}

