/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.opends.server.messages.MessageHandler;

public class PromptTrustManager
implements X509TrustManager {
    private static TrustManager[] trustManagerArray = new TrustManager[]{new PromptTrustManager()};

    private PromptTrustManager() {
    }

    public static TrustManager[] getTrustManagers() {
        return trustManagerArray;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        int msgID = 10748699;
        String message = MessageHandler.getMessage(msgID);
        throw new CertificateException(message);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        String message;
        int msgID;
        if (chain == null || chain.length == 0) {
            System.out.println(MessageHandler.getMessage(10617628));
        } else {
            Date currentDate = new Date();
            Date notAfterDate = chain[0].getNotAfter();
            Date notBeforeDate = chain[0].getNotBefore();
            if (currentDate.after(notAfterDate)) {
                msgID = 10617629;
                message = MessageHandler.getMessage(msgID, String.valueOf(notAfterDate));
                System.err.println(message);
            } else if (currentDate.before(notBeforeDate)) {
                msgID = 10617630;
                message = MessageHandler.getMessage(msgID, String.valueOf(notBeforeDate));
                System.err.println(message);
            }
            System.out.println(MessageHandler.getMessage(10486559, chain[0].getSubjectDN().getName(), chain[0].getIssuerDN().getName(), String.valueOf(notBeforeDate), String.valueOf(notAfterDate)));
        }
        String prompt = MessageHandler.getMessage(10486560);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                System.out.print(prompt);
                String line = reader.readLine().toLowerCase();
                if (line.equals("y") || line.equals("yes")) {
                    return;
                }
                if (line.equals("n") || line.equals("no")) {
                    msgID = 10748705;
                    message = MessageHandler.getMessage(msgID);
                    throw new CertificateException(message);
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            System.out.println();
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }
}

