/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.util.ServerConstants;

public class VerboseTracer {
    private boolean verbose;
    private PrintStream err;
    private long firstMessageTimestamp = 0L;
    private long lastMessageTimestamp = 0L;
    private DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");

    public VerboseTracer(boolean verbose, PrintStream err) {
        this.verbose = verbose;
        this.err = err;
    }

    private synchronized void traceMessage(String messageDirection, LDAPMessage message, ASN1Element element) {
        long timeSinceLast;
        StringBuilder header = new StringBuilder();
        StringBuilder builder = new StringBuilder();
        long timestamp = System.currentTimeMillis();
        if (this.firstMessageTimestamp == 0L) {
            this.firstMessageTimestamp = timestamp;
        }
        if (this.lastMessageTimestamp == 0L) {
            this.lastMessageTimestamp = timestamp;
        }
        if ((timeSinceLast = timestamp - this.lastMessageTimestamp) < 0L) {
            timeSinceLast = 0L;
        }
        String timestampString = this.dateFormat.format(new Date(timestamp));
        header.append(messageDirection);
        header.append(' ');
        header.append(timestampString);
        header.append(" (");
        header.append(timeSinceLast);
        header.append("ms) ");
        builder.append("LDAP: ");
        builder.append((CharSequence)header);
        builder.append(message);
        builder.append(ServerConstants.EOL);
        builder.append("ASN1: ");
        builder.append((CharSequence)header);
        element.toString(builder, 0);
        this.err.print(builder);
        if (timestamp > this.lastMessageTimestamp) {
            this.lastMessageTimestamp = timestamp;
        }
    }

    public void traceIncomingMessage(LDAPMessage message, ASN1Element element) {
        if (this.verbose && message.getProtocolOpType() != 100) {
            this.traceMessage("S>C", message, element);
        }
    }

    public void traceOutgoingMessage(LDAPMessage message, ASN1Element element) {
        if (this.verbose && message.getProtocolOpType() != 100) {
            this.traceMessage("C>S", message, element);
        }
    }
}

