/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionUsageBuilder;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.PropertyIsMandatoryException;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyIsSingleValuedException;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArgumentExceptionFactory {
    public static ArgumentException adaptIllegalManagedObjectNameException(IllegalManagedObjectNameException e, AbstractManagedObjectDefinition<?, ?> d) {
        String illegalName = e.getIllegalName();
        PropertyDefinition<?> pd = e.getNamingPropertyDefinition();
        if (illegalName.length() == 0) {
            int msgID = 10749109;
            String message = MessageHandler.getMessage(msgID, d.getUserFriendlyPluralName());
            return new ArgumentException(msgID, message);
        }
        if (illegalName.trim().length() == 0) {
            int msgID = 10749110;
            String message = MessageHandler.getMessage(msgID, d.getUserFriendlyPluralName());
            return new ArgumentException(msgID, message);
        }
        if (pd != null) {
            try {
                pd.decodeValue(illegalName);
            }
            catch (IllegalPropertyValueStringException e1) {
                PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
                String syntax = b.getUsage(pd);
                int msgID = 10749108;
                String message = MessageHandler.getMessage(msgID, illegalName, d.getUserFriendlyName(), pd.getName(), syntax);
                return new ArgumentException(msgID, message);
            }
        }
        int msgID = 10749111;
        String message = MessageHandler.getMessage(msgID, illegalName, d.getUserFriendlyName());
        return new ArgumentException(msgID, message);
    }

    public static ArgumentException adaptMissingMandatoryPropertiesException(MissingMandatoryPropertiesException e, AbstractManagedObjectDefinition<?, ?> d) {
        int msgID = 10748936;
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (PropertyIsMandatoryException pe : e.getCauses()) {
            if (!isFirst) {
                builder.append(", ");
            }
            builder.append(pe.getPropertyDefinition().getName());
            isFirst = false;
        }
        String msg = MessageHandler.getMessage(msgID, d.getUserFriendlyName(), builder.toString());
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException adaptPropertyException(PropertyException e, AbstractManagedObjectDefinition<?, ?> d) {
        if (e instanceof IllegalPropertyValueException) {
            IllegalPropertyValueException pe = (IllegalPropertyValueException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof IllegalPropertyValueStringException) {
            IllegalPropertyValueStringException pe = (IllegalPropertyValueStringException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof PropertyIsMandatoryException) {
            PropertyIsMandatoryException pe = (PropertyIsMandatoryException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof PropertyIsSingleValuedException) {
            PropertyIsSingleValuedException pe = (PropertyIsSingleValuedException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof PropertyIsReadOnlyException) {
            PropertyIsReadOnlyException pe = (PropertyIsReadOnlyException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        if (e instanceof DefaultBehaviorException) {
            DefaultBehaviorException pe = (DefaultBehaviorException)e;
            return ArgumentExceptionFactory.adapt(d, pe);
        }
        int msgID = 10748964;
        String message = MessageHandler.getMessage(msgID, d.getUserFriendlyName(), e.getPropertyDefinition().getName(), e.getMessage());
        return new ArgumentException(msgID, message);
    }

    public static ArgumentException incompatiblePropertyModification(String arg) {
        int msgID = 10748975;
        String msg = MessageHandler.getMessage(msgID, arg);
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException missingBindPassword(String bindDN) {
        int msgID = 10748915;
        String msg = MessageHandler.getMessage(msgID, bindDN);
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException missingMandatoryNonInteractiveArgument(Argument arg) {
        int msgID = 10749127;
        String msg = MessageHandler.getMessage(msgID, arg.getLongIdentifier());
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException missingNameInPropertyArgument(String arg) {
        int msgID = 10748968;
        String msg = MessageHandler.getMessage(msgID, arg);
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException missingNameInPropertyModification(String arg) {
        int msgID = 10748973;
        String msg = MessageHandler.getMessage(msgID, arg);
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException missingSeparatorInPropertyArgument(String arg) {
        int msgID = 10748967;
        String msg = MessageHandler.getMessage(msgID, arg);
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException missingSeparatorInPropertyModification(String arg) {
        int msgID = 10748972;
        String msg = MessageHandler.getMessage(msgID, arg);
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException missingValueInPropertyArgument(String arg) {
        int msgID = 10748969;
        String msg = MessageHandler.getMessage(msgID, arg);
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException missingValueInPropertyModification(String arg) {
        int msgID = 10748973;
        String msg = MessageHandler.getMessage(msgID, arg);
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException unableToReadBindPassword(Exception cause) {
        int msgID = 10748904;
        String message = MessageHandler.getMessage(msgID, cause.getMessage());
        return new ArgumentException(msgID, message, cause);
    }

    public static ArgumentException unableToReadBindPasswordInteractively() {
        int msgID = 10748997;
        String message = MessageHandler.getMessage(msgID);
        return new ArgumentException(msgID, message);
    }

    public static ArgumentException unableToReadConsoleInput(Exception cause) {
        int msgID = 10749128;
        String message = MessageHandler.getMessage(msgID, cause.getMessage());
        return new ArgumentException(msgID, message, cause);
    }

    public static ArgumentException unableToResetMandatoryProperty(AbstractManagedObjectDefinition<?, ?> d, String name, String setOption) {
        int msgID = 10749104;
        String message = MessageHandler.getMessage(msgID, d.getUserFriendlyPluralName(), name, setOption);
        return new ArgumentException(msgID, message);
    }

    public static ArgumentException unableToSetNamingProperty(AbstractManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd) {
        int msgID = 10749114;
        String message = MessageHandler.getMessage(msgID, pd.getName(), d.getUserFriendlyName());
        return new ArgumentException(msgID, message);
    }

    public static ArgumentException unknownCategory(String categoryName) {
        int msgID = 10749191;
        String msg = MessageHandler.getMessage(msgID, categoryName);
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException unknownProperty(AbstractManagedObjectDefinition<?, ?> d, String name) {
        int msgID = 10748916;
        String message = MessageHandler.getMessage(msgID, name, d.getUserFriendlyPluralName());
        return new ArgumentException(msgID, message);
    }

    public static ArgumentException unknownProperty(String name) {
        int msgID = 10749193;
        String message = MessageHandler.getMessage(msgID, name);
        return new ArgumentException(msgID, message);
    }

    public static ArgumentException unknownSubType(RelationDefinition<?, ?> r, String typeName, String typeUsage) {
        int msgID = 10748970;
        String msg = MessageHandler.getMessage(msgID, typeName, r.getUserFriendlyName(), typeUsage);
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException unknownType(String typeName) {
        int msgID = 10748971;
        String msg = MessageHandler.getMessage(msgID, typeName);
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException unknownTypeInCategory(String categoryName, String typeName) {
        int msgID = 10749192;
        String msg = MessageHandler.getMessage(msgID, typeName, categoryName);
        return new ArgumentException(msgID, msg);
    }

    public static ArgumentException wrongManagedObjectType(RelationDefinition<?, ?> r, ManagedObjectDefinition<?, ?> d) {
        int msgID = 10748971;
        String msg = MessageHandler.getMessage(msgID, r.getUserFriendlyName(), d.getUserFriendlyName());
        return new ArgumentException(msgID, msg);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, DefaultBehaviorException e) {
        int msgID = 10748965;
        String message = MessageHandler.getMessage(msgID, d.getUserFriendlyName(), e.getPropertyDefinition().getName(), e.getMessage());
        return new ArgumentException(msgID, message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, IllegalPropertyValueException e) {
        PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
        String syntax = b.getUsage(e.getPropertyDefinition());
        if (syntax.length() > 20) {
            // empty if block
        }
        int msgID = 10748917;
        String message = MessageHandler.getMessage(msgID, String.valueOf(e.getIllegalValue()), d.getUserFriendlyName(), e.getPropertyDefinition().getName(), syntax);
        return new ArgumentException(msgID, message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, IllegalPropertyValueStringException e) {
        PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
        String syntax = b.getUsage(e.getPropertyDefinition());
        if (syntax.length() > 20) {
            // empty if block
        }
        int msgID = 10748917;
        String message = MessageHandler.getMessage(msgID, String.valueOf(e.getIllegalValueString()), d.getUserFriendlyName(), e.getPropertyDefinition().getName(), syntax);
        return new ArgumentException(msgID, message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, PropertyIsMandatoryException e) {
        int msgID = 10748919;
        String message = MessageHandler.getMessage(msgID, d.getUserFriendlyName(), e.getPropertyDefinition().getName());
        return new ArgumentException(msgID, message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, PropertyIsReadOnlyException e) {
        int msgID = 10748918;
        String message = MessageHandler.getMessage(msgID, d.getUserFriendlyName(), e.getPropertyDefinition().getName());
        return new ArgumentException(msgID, message);
    }

    private static ArgumentException adapt(AbstractManagedObjectDefinition<?, ?> d, PropertyIsSingleValuedException e) {
        int msgID = 10748920;
        String message = MessageHandler.getMessage(msgID, d.getUserFriendlyName(), e.getPropertyDefinition().getName());
        return new ArgumentException(msgID, message);
    }

    private ArgumentExceptionFactory() {
    }
}

