/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsSingleValuedException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.ConsoleApplication;
import org.opends.server.tools.dsconfig.HelpCallback;
import org.opends.server.tools.dsconfig.PropertyValueReader;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.tools.dsconfig.ValidationCallback;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CreateSubCommandHandler<C extends ConfigurationClient, S extends Configuration>
extends SubCommandHandler {
    private static final String GENERIC_TYPE = "generic";
    private static final String OPTION_DSCFG_LONG_SET = "set";
    private static final String OPTION_DSCFG_LONG_TYPE = "type";
    private static final Character OPTION_DSCFG_SHORT_SET = null;
    private static final Character OPTION_DSCFG_SHORT_TYPE = Character.valueOf('t');
    private final List<StringArgument> namingArgs;
    private final PropertyDefinition<?> namingPropertyDefinition;
    private final ManagedObjectPath<?, ?> path;
    private final StringArgument propertySetArgument;
    private final RelationDefinition<C, S> relation;
    private final SubCommand subCommand;
    private final StringArgument typeArgument;
    private final SortedMap<String, ManagedObjectDefinition<? extends C, ? extends S>> types;
    private final String typeUsage;

    public static <C extends ConfigurationClient, S extends Configuration> CreateSubCommandHandler<C, S> create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<C, S> r) throws ArgumentException {
        return new CreateSubCommandHandler<C, S>(app, parser, p, r, r.getNamingPropertyDefinition(), p.child(r, "DUMMY"));
    }

    public static <C extends ConfigurationClient, S extends Configuration> CreateSubCommandHandler<C, S> create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, OptionalRelationDefinition<C, S> r) throws ArgumentException {
        return new CreateSubCommandHandler<C, S>(app, parser, p, r, null, p.child(r));
    }

    private CreateSubCommandHandler(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, RelationDefinition<C, S> r, PropertyDefinition<?> pd, ManagedObjectPath<?, ?> c) throws ArgumentException {
        super(app);
        this.path = p;
        this.relation = r;
        this.namingPropertyDefinition = pd;
        String name = "create-" + r.getName();
        int descriptionID = 10486764;
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, descriptionID, r.getChildDefinition().getUserFriendlyPluralName());
        this.types = this.getSubTypes(r.getChildDefinition());
        this.namingArgs = this.createNamingArgs(this.subCommand, c, true);
        this.registerAdvancedModeArgument(this.subCommand, 10486977, r.getUserFriendlyName());
        this.propertySetArgument = new StringArgument(OPTION_DSCFG_LONG_SET, OPTION_DSCFG_SHORT_SET, OPTION_DSCFG_LONG_SET, false, true, true, "{PROP:VALUE}", null, null, 0xA00440, new Object[0]);
        this.subCommand.addArgument(this.propertySetArgument);
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String s : this.types.keySet()) {
            if (!isFirst) {
                builder.append(" | ");
            }
            builder.append(s);
            isFirst = false;
        }
        this.typeUsage = builder.toString();
        if (!this.types.containsKey(GENERIC_TYPE)) {
            this.typeArgument = new StringArgument(OPTION_DSCFG_LONG_TYPE, OPTION_DSCFG_SHORT_TYPE, OPTION_DSCFG_LONG_TYPE, false, false, true, "{TYPE}", null, null, 10486770, r.getChildDefinition().getUserFriendlyName(), this.typeUsage);
        } else {
            this.typeArgument = new StringArgument(OPTION_DSCFG_LONG_TYPE, OPTION_DSCFG_SHORT_TYPE, OPTION_DSCFG_LONG_TYPE, false, false, true, "{TYPE}", GENERIC_TYPE, null, 10486833, r.getChildDefinition().getUserFriendlyName(), GENERIC_TYPE, this.typeUsage);
            if (this.types.size() == 1) {
                this.typeArgument.setHidden(true);
            }
        }
        this.subCommand.addArgument(this.typeArgument);
        this.addTags(this.relation.getChildDefinition().getAllTags());
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int run() throws ArgumentException, ClientException {
        ManagedObject<?> parent;
        String typeName;
        if (!this.typeArgument.isPresent()) {
            if (this.getConsoleApplication().isInteractive()) {
                if (this.types.size() == 1) {
                    typeName = this.types.keySet().iterator().next();
                } else {
                    ArrayList<String> values = new ArrayList<String>(this.types.keySet());
                    ArrayList<String> descriptions = new ArrayList<String>(values.size());
                    for (ManagedObjectDefinition<C, S> d : this.types.values()) {
                        descriptions.add(d.getUserFriendlyName());
                    }
                    int msgID = 10486985;
                    String msg = MessageHandler.getMessage(msgID, this.relation.getChildDefinition().getUserFriendlyName());
                    typeName = this.getConsoleApplication().readChoice(msg, descriptions, values, new TypeHelpCallback());
                }
            } else {
                if (this.typeArgument.getDefaultValue() == null) throw ArgumentExceptionFactory.missingMandatoryNonInteractiveArgument(this.typeArgument);
                typeName = this.typeArgument.getDefaultValue();
            }
        } else {
            typeName = this.typeArgument.getValue();
        }
        ManagedObjectDefinition d = (ManagedObjectDefinition)this.types.get(typeName);
        if (d == null) {
            throw ArgumentExceptionFactory.unknownSubType(this.relation, typeName, this.typeUsage);
        }
        List<String> names = this.getNamingArgValues(this.namingArgs);
        LinkedList<String> propertyArgs = this.propertySetArgument.getValues();
        MyPropertyProvider provider = new MyPropertyProvider(d, this.namingPropertyDefinition, propertyArgs);
        try {
            parent = this.getManagedObject(this.path, names);
        }
        catch (AuthorizationException e) {
            int msgID = 0xA4040A;
            String msg = MessageHandler.getMessage(msgID, d.getUserFriendlyName());
            throw new ClientException(50, msgID, msg);
        }
        catch (DefinitionDecodingException e) {
            int msgID = 10748930;
            String ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            String msg = MessageHandler.getMessage(msgID, ufn, ufn, ufn);
            throw new ClientException(1, msgID, msg);
        }
        catch (ManagedObjectDecodingException e) {
            int msgID = 10748931;
            String ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            String msg = MessageHandler.getMessage(msgID, ufn);
            throw new ClientException(1, msgID, msg);
        }
        catch (CommunicationException e) {
            int msgID = 10748939;
            String msg = MessageHandler.getMessage(msgID, d.getUserFriendlyName(), e.getMessage());
            throw new ClientException(81, msgID, msg);
        }
        catch (ConcurrentModificationException e) {
            int msgID = 10748940;
            String msg = MessageHandler.getMessage(msgID, d.getUserFriendlyName());
            throw new ClientException(19, msgID, msg);
        }
        catch (ManagedObjectNotFoundException e) {
            int msgID = 0xA40404;
            String ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            String msg = MessageHandler.getMessage(msgID, ufn);
            throw new ClientException(32, msgID, msg);
        }
        try {
            String msg;
            ManagedObject<Object> child;
            LinkedList<DefaultBehaviorException> exceptions = new LinkedList<DefaultBehaviorException>();
            if (this.relation instanceof InstantiableRelationDefinition) {
                InstantiableRelationDefinition irelation = (InstantiableRelationDefinition)this.relation;
                String name = names.get(names.size() - 1);
                if (name == null) {
                    if (!this.getConsoleApplication().isInteractive()) throw ArgumentExceptionFactory.missingMandatoryNonInteractiveArgument(this.namingArgs.get(names.size() - 1));
                    child = this.createChildInteractively(parent, irelation, d, exceptions);
                } else {
                    try {
                        child = parent.createChild(irelation, d, name, exceptions);
                    }
                    catch (IllegalManagedObjectNameException e) {
                        throw ArgumentExceptionFactory.adaptIllegalManagedObjectNameException(e, d);
                    }
                }
            } else {
                OptionalRelationDefinition orelation = (OptionalRelationDefinition)this.relation;
                child = parent.createChild(orelation, d, exceptions);
            }
            for (PropertyDefinition<?> pd : provider.getProperties()) {
                this.setProperty(child, provider, pd);
            }
            if (this.getConsoleApplication().isInteractive()) {
                TreeSet properties = new TreeSet();
                for (PropertyDefinition<?> pd : d.getAllPropertyDefinitions()) {
                    if (pd.hasOption(PropertyOption.HIDDEN) || pd.hasOption(PropertyOption.MONITORING) || !this.isAdvancedMode() && pd.hasOption(PropertyOption.ADVANCED)) continue;
                    properties.add(pd);
                }
                PropertyValueReader reader = new PropertyValueReader(this.getConsoleApplication());
                reader.readAll(child, properties);
            }
            String prompt = MessageHandler.getMessage(10487037, d.getUserFriendlyName());
            if (!this.getConsoleApplication().confirmAction(prompt)) {
                msg = MessageHandler.getMessage(10487043, d.getUserFriendlyName());
                this.getConsoleApplication().printVerboseMessage(msg);
                return 1;
            }
            child.commit();
            msg = MessageHandler.getMessage(0xA00500, d.getUserFriendlyName());
            this.getConsoleApplication().printVerboseMessage(msg);
            return 0;
        }
        catch (MissingMandatoryPropertiesException e) {
            throw ArgumentExceptionFactory.adaptMissingMandatoryPropertiesException(e, d);
        }
        catch (AuthorizationException e) {
            int msgID = 0xA4040A;
            String msg = MessageHandler.getMessage(msgID, d.getUserFriendlyName());
            throw new ClientException(50, msgID, msg);
        }
        catch (ManagedObjectAlreadyExistsException e) {
            int msgID = 10748937;
            String msg = MessageHandler.getMessage(msgID, d.getUserFriendlyName());
            throw new ClientException(68, msgID, msg);
        }
        catch (ConcurrentModificationException e) {
            int msgID = 10748940;
            String msg = MessageHandler.getMessage(msgID, d.getUserFriendlyName());
            throw new ClientException(19, msgID, msg);
        }
        catch (OperationRejectedException e) {
            int msgID = 10748941;
            String msg = MessageHandler.getMessage(msgID, d.getUserFriendlyName(), e.getMessage());
            throw new ClientException(19, msgID, msg);
        }
        catch (CommunicationException e) {
            int msgID = 10748939;
            String msg = MessageHandler.getMessage(msgID, d.getUserFriendlyName(), e.getMessage());
            throw new ClientException(81, msgID, msg);
        }
    }

    private ManagedObject<? extends C> createChildInteractively(final ManagedObject<?> parent, final InstantiableRelationDefinition<C, S> irelation, final ManagedObjectDefinition<? extends C, ? extends S> d, final List<DefaultBehaviorException> exceptions) throws ArgumentException, ClientException {
        int msgID = 10486986;
        String msg = MessageHandler.getMessage(msgID, d.getUserFriendlyName());
        ValidationCallback validator = new ValidationCallback<ManagedObject<? extends C>>(){

            @Override
            public ManagedObject<? extends C> validate(ConsoleApplication app, String input) throws ClientException {
                ManagedObject child;
                try {
                    child = parent.createChild(irelation, d, input, exceptions);
                }
                catch (IllegalManagedObjectNameException e) {
                    ArgumentException ae = ArgumentExceptionFactory.adaptIllegalManagedObjectNameException(e, d);
                    app.println();
                    app.printMessage(ae.getMessage());
                    return null;
                }
                try {
                    parent.getChild(irelation, input);
                }
                catch (AuthorizationException e) {
                    int msgID = 0xA4040A;
                    String msg = MessageHandler.getMessage(msgID, irelation.getUserFriendlyName());
                    throw new ClientException(50, msgID, msg);
                }
                catch (ConcurrentModificationException e) {
                    int msgID = 10748940;
                    String msg = MessageHandler.getMessage(msgID, irelation.getUserFriendlyName());
                    throw new ClientException(19, msgID, msg);
                }
                catch (CommunicationException e) {
                    int msgID = 10748939;
                    String msg = MessageHandler.getMessage(msgID, irelation.getUserFriendlyName(), e.getMessage());
                    throw new ClientException(81, msgID, msg);
                }
                catch (DefinitionDecodingException e) {
                }
                catch (ManagedObjectDecodingException e) {
                }
                catch (ManagedObjectNotFoundException e) {
                    return child;
                }
                int msgID = 10749131;
                String msg = MessageHandler.getMessage(msgID, CreateSubCommandHandler.this.relation.getUserFriendlyName(), input);
                app.println();
                app.printMessage(msg);
                return null;
            }
        };
        return (ManagedObject)this.getConsoleApplication().readValidatedInput(msg, validator);
    }

    private SortedMap<String, ManagedObjectDefinition<? extends C, ? extends S>> getSubTypes(AbstractManagedObjectDefinition<C, S> d) {
        TreeMap<String, ManagedObjectDefinition<C, S>> map = new TreeMap<String, ManagedObjectDefinition<C, S>>();
        if (d instanceof ManagedObjectDefinition) {
            ManagedObjectDefinition mod = (ManagedObjectDefinition)d;
            map.put(GENERIC_TYPE, mod);
        }
        String suffix = "-" + d.getName();
        for (AbstractManagedObjectDefinition<C, S> c : d.getAllChildren()) {
            if (!(c instanceof ManagedObjectDefinition)) continue;
            ManagedObjectDefinition mod = (ManagedObjectDefinition)c;
            String name = mod.getName();
            if (name.endsWith(suffix)) {
                name = name.substring(0, name.length() - suffix.length());
            }
            map.put(name, mod);
        }
        return map;
    }

    private <T> void setProperty(ManagedObject<?> mo, MyPropertyProvider provider, PropertyDefinition<T> pd) {
        Collection<T> values = provider.getPropertyValues(pd);
        mo.setPropertyValues(pd, values);
    }

    private final class TypeHelpCallback
    implements HelpCallback {
        private TypeHelpCallback() {
        }

        public void display(ConsoleApplication app) {
            TableBuilder builder = new TableBuilder();
            int msgID = 10486988;
            builder.appendHeading(MessageHandler.getMessage(msgID));
            msgID = 10486989;
            builder.appendHeading(MessageHandler.getMessage(msgID));
            boolean isFirst = true;
            for (ManagedObjectDefinition d : CreateSubCommandHandler.this.types.values()) {
                if (!isFirst) {
                    builder.startRow();
                    builder.startRow();
                } else {
                    isFirst = false;
                }
                builder.startRow();
                builder.appendCell(d.getUserFriendlyName());
                builder.appendCell(d.getSynopsis());
                if (d.getDescription() == null) continue;
                builder.startRow();
                builder.startRow();
                builder.appendCell();
                builder.appendCell(d.getDescription());
            }
            TextTablePrinter printer = new TextTablePrinter(app.getErrorStream());
            printer.setColumnWidth(1, 0);
            printer.setColumnSeparator(":");
            builder.print(printer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyPropertyProvider
    implements PropertyProvider {
        private final Map<PropertyDefinition<?>, Collection<?>> properties = new HashMap();

        public MyPropertyProvider(ManagedObjectDefinition<?, ?> d, PropertyDefinition<?> namingPropertyDefinition, List<String> args) throws ArgumentException {
            for (String s : args) {
                PropertyDefinition<?> pd;
                int sep = s.indexOf(58);
                if (sep < 0) {
                    throw ArgumentExceptionFactory.missingSeparatorInPropertyArgument(s);
                }
                if (sep == 0) {
                    throw ArgumentExceptionFactory.missingNameInPropertyArgument(s);
                }
                String propertyName = s.substring(0, sep);
                String value = s.substring(sep + 1, s.length());
                if (value.length() == 0) {
                    throw ArgumentExceptionFactory.missingValueInPropertyArgument(s);
                }
                try {
                    pd = d.getPropertyDefinition(propertyName);
                }
                catch (IllegalArgumentException e) {
                    throw ArgumentExceptionFactory.unknownProperty(d, propertyName);
                }
                if (pd.equals(namingPropertyDefinition)) {
                    throw ArgumentExceptionFactory.unableToSetNamingProperty(d, pd);
                }
                this.addPropertyValue(d, pd, value);
            }
        }

        public Set<PropertyDefinition<?>> getProperties() {
            return this.properties.keySet();
        }

        @Override
        public <T> Collection<T> getPropertyValues(PropertyDefinition<T> d) throws IllegalArgumentException {
            Collection<?> values = this.properties.get(d);
            if (values == null) {
                return Collections.emptySet();
            }
            return values;
        }

        private <T> void addPropertyValue(ManagedObjectDefinition<?, ?> d, PropertyDefinition<T> pd, String s) throws ArgumentException {
            T value;
            try {
                value = pd.decodeValue(s);
            }
            catch (IllegalPropertyValueStringException e) {
                throw ArgumentExceptionFactory.adaptPropertyException(e, d);
            }
            Collection<?> values = this.properties.get(pd);
            if (values == null) {
                values = new LinkedList();
            }
            values.add(value);
            if (values.size() > 1 && !pd.hasOption(PropertyOption.MULTI_VALUED)) {
                PropertyIsSingleValuedException e = new PropertyIsSingleValuedException(pd);
                throw ArgumentExceptionFactory.adaptPropertyException(e, d);
            }
            this.properties.put(pd, values);
        }
    }
}

