/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.util.List;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ConsoleApplication;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DeleteSubCommandHandler
extends SubCommandHandler {
    private static final String OPTION_DSCFG_LONG_FORCE = "force";
    private static final char OPTION_DSCFG_SHORT_FORCE = 'f';
    private final BooleanArgument forceArgument;
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final RelationDefinition<?, ?> relation;
    private final SubCommand subCommand;

    public static DeleteSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new DeleteSubCommandHandler(app, parser, p, r, p.child(r, "DUMMY"));
    }

    public static DeleteSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new DeleteSubCommandHandler(app, parser, p, r, p.child(r));
    }

    private DeleteSubCommandHandler(ConsoleApplication app, SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, RelationDefinition<?, ?> r, ManagedObjectPath<?, ?> c) throws ArgumentException {
        super(app);
        this.path = p;
        this.relation = r;
        String name = "delete-" + r.getName();
        String ufpn = r.getChildDefinition().getUserFriendlyPluralName();
        int descriptionID = 10486765;
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, descriptionID, ufpn);
        this.namingArgs = this.createNamingArgs(this.subCommand, c, false);
        this.forceArgument = new BooleanArgument(OPTION_DSCFG_LONG_FORCE, Character.valueOf('f'), OPTION_DSCFG_LONG_FORCE, 10486956, ufpn);
        this.subCommand.addArgument(this.forceArgument);
        this.addTags(this.relation.getChildDefinition().getAllTags());
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public int run() throws ArgumentException, ClientException {
        block20: {
            ManagedObject<?> parent;
            List<String> names;
            block19: {
                names = this.getNamingArgValues(this.namingArgs);
                parent = null;
                try {
                    parent = this.getManagedObject(this.path, names);
                }
                catch (AuthorizationException e) {
                    int msgID = 10748943;
                    String msg = MessageHandler.getMessage(msgID, this.relation.getUserFriendlyName());
                    throw new ClientException(50, msgID, msg);
                }
                catch (DefinitionDecodingException e) {
                    int msgID = 10748930;
                    String ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                    String msg = MessageHandler.getMessage(msgID, ufn, ufn, ufn);
                    throw new ClientException(1, msgID, msg);
                }
                catch (ManagedObjectDecodingException e) {
                    int msgID = 10748931;
                    String ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                    String msg = MessageHandler.getMessage(msgID, ufn);
                    throw new ClientException(1, msgID, msg);
                }
                catch (CommunicationException e) {
                    int msgID = 10748945;
                    String msg = MessageHandler.getMessage(msgID, this.relation.getUserFriendlyName(), e.getMessage());
                    throw new ClientException(81, msgID, msg);
                }
                catch (ConcurrentModificationException e) {
                    int msgID = 10748946;
                    String msg = MessageHandler.getMessage(msgID, this.relation.getUserFriendlyName());
                    throw new ClientException(19, msgID, msg);
                }
                catch (ManagedObjectNotFoundException e) {
                    if (this.forceArgument.isPresent()) break block19;
                    int msgID = 0xA40404;
                    String ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                    String msg = MessageHandler.getMessage(msgID, ufn);
                    throw new ClientException(32, msgID, msg);
                }
            }
            if (parent != null) {
                try {
                    if (this.relation instanceof InstantiableRelationDefinition) {
                        InstantiableRelationDefinition irelation = (InstantiableRelationDefinition)this.relation;
                        String childName = names.get(names.size() - 1);
                        if (childName == null) {
                            childName = this.readChildName(parent, irelation, null);
                        }
                        if (this.confirmDeletion()) {
                            parent.removeChild(irelation, childName);
                            break block20;
                        }
                        return 1;
                    }
                    if (!(this.relation instanceof OptionalRelationDefinition)) break block20;
                    OptionalRelationDefinition orelation = (OptionalRelationDefinition)this.relation;
                    if (this.confirmDeletion()) {
                        parent.removeChild(orelation);
                        break block20;
                    }
                    return 1;
                }
                catch (AuthorizationException e) {
                    int msgID = 10748943;
                    String msg = MessageHandler.getMessage(msgID, this.relation.getUserFriendlyName());
                    throw new ClientException(50, msgID, msg);
                }
                catch (OperationRejectedException e) {
                    int msgID = 10748944;
                    String msg = MessageHandler.getMessage(msgID, this.relation.getUserFriendlyName(), e.getMessage());
                    throw new ClientException(19, msgID, msg);
                }
                catch (ManagedObjectNotFoundException e) {
                    if (!this.forceArgument.isPresent()) {
                        int msgID = 10748942;
                        String msg = MessageHandler.getMessage(msgID, this.relation.getUserFriendlyName());
                        throw new ClientException(32, msgID, msg);
                    }
                }
                catch (ConcurrentModificationException e) {
                    int msgID = 10748946;
                    String msg = MessageHandler.getMessage(msgID, this.relation.getUserFriendlyName());
                    throw new ClientException(19, msgID, msg);
                }
                catch (CommunicationException e) {
                    int msgID = 10748945;
                    String msg = MessageHandler.getMessage(msgID, this.relation.getUserFriendlyName(), e.getMessage());
                    throw new ClientException(81, msgID, msg);
                }
            }
        }
        String msg = MessageHandler.getMessage(10487041, this.relation.getUserFriendlyName());
        this.getConsoleApplication().printVerboseMessage(msg);
        return 0;
    }

    private boolean confirmDeletion() throws ArgumentException {
        String prompt = MessageHandler.getMessage(10487038, this.relation.getUserFriendlyName());
        if (!this.getConsoleApplication().confirmAction(prompt)) {
            String msg = MessageHandler.getMessage(10487044, this.relation.getUserFriendlyName());
            this.getConsoleApplication().printVerboseMessage(msg);
            return false;
        }
        return true;
    }
}

