/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opends.server.admin.AbsoluteInheritedDefaultBehaviorProvider;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.DefaultBehaviorProviderVisitor;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionUsageBuilder;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.UnknownPropertyDefinitionException;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.ConsoleApplication;
import org.opends.server.tools.dsconfig.PropertyValuePrinter;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TablePrinter;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HelpSubCommandHandler
extends SubCommandHandler {
    private static final String GENERIC_TYPE = "generic";
    private static final String HEADING_SEPARATOR = " : ";
    private static final int HEADING_WIDTH;
    private static final String OPTION_DSCFG_LONG_INHERITED = "inherited";
    private static final Character OPTION_DSCFG_SHORT_INHERITED;
    private static final String OPTION_DSCFG_LONG_TYPE = "type";
    private static final Character OPTION_DSCFG_SHORT_TYPE;
    private static final String OPTION_DSCFG_LONG_CATEGORY = "category";
    private static final Character OPTION_DSCFG_SHORT_CATEGORY;
    private final SubCommand subCommand;
    private final StringArgument categoryArgument;
    private BooleanArgument inheritedModeArgument;
    private final StringArgument typeArgument;
    private final Map<String, Map<String, AbstractManagedObjectDefinition<?, ?>>> categoryMap;
    private final Map<Tag, Map<String, AbstractManagedObjectDefinition<?, ?>>> tagMap;

    public static HelpSubCommandHandler create(ConsoleApplication app, SubCommandArgumentParser parser) throws ArgumentException {
        return new HelpSubCommandHandler(app, parser);
    }

    public static void displayVerboseSingleProperty(AbstractManagedObjectDefinition<?, ?> d, String name, PrintStream out) {
        PropertyDefinition<?> pd = d.getPropertyDefinition(name);
        out.println(MessageHandler.getMessage(10487023, name));
        out.println();
        out.println(StaticUtils.wrapText(pd.getSynopsis(), ServerConstants.MAX_LINE_WIDTH));
        if (pd.getDescription() != null) {
            out.println();
            out.println(StaticUtils.wrapText(pd.getDescription(), ServerConstants.MAX_LINE_WIDTH));
        }
        out.println();
        SyntaxPrinter syntaxPrinter = new SyntaxPrinter();
        syntaxPrinter.print(out, pd);
        out.println();
        TableBuilder builder = new TableBuilder();
        DefaultBehaviorPrinter defaultPrinter = new DefaultBehaviorPrinter();
        builder.startRow();
        builder.appendCell(MessageHandler.getMessage(10487025));
        builder.appendCell(HEADING_SEPARATOR);
        builder.appendCell(defaultPrinter.print(pd));
        builder.startRow();
        builder.appendCell(MessageHandler.getMessage(10487027));
        builder.appendCell(HEADING_SEPARATOR);
        if (pd.hasOption(PropertyOption.ADVANCED)) {
            builder.appendCell(MessageHandler.getMessage(10486995));
        } else {
            builder.appendCell(MessageHandler.getMessage(10486994));
        }
        builder.startRow();
        builder.appendCell(MessageHandler.getMessage(10487028));
        builder.appendCell(HEADING_SEPARATOR);
        if (pd.hasOption(PropertyOption.MULTI_VALUED)) {
            builder.appendCell(MessageHandler.getMessage(10486995));
        } else {
            builder.appendCell(MessageHandler.getMessage(10486994));
        }
        builder.startRow();
        builder.appendCell(MessageHandler.getMessage(10487026));
        builder.appendCell(HEADING_SEPARATOR);
        if (pd.hasOption(PropertyOption.MANDATORY)) {
            builder.appendCell(MessageHandler.getMessage(10486995));
        } else {
            builder.appendCell(MessageHandler.getMessage(10486994));
        }
        builder.startRow();
        builder.appendCell(MessageHandler.getMessage(10487029));
        builder.appendCell(HEADING_SEPARATOR);
        if (pd.hasOption(PropertyOption.MONITORING)) {
            builder.appendCell(MessageHandler.getMessage(10487022));
        } else if (pd.hasOption(PropertyOption.READ_ONLY)) {
            builder.appendCell(MessageHandler.getMessage(10487021, d.getUserFriendlyName()));
        } else {
            builder.appendCell(MessageHandler.getMessage(10486994));
        }
        TextTablePrinter factory = new TextTablePrinter(out);
        factory.setDisplayHeadings(false);
        factory.setColumnWidth(0, HEADING_WIDTH);
        factory.setColumnWidth(2, 0);
        factory.setPadding(0);
        builder.print(factory);
        AdministratorAction action = pd.getAdministratorAction();
        String synopsis = action.getSynopsis();
        if (synopsis == null) {
            switch (action.getType()) {
                case COMPONENT_RESTART: {
                    synopsis = MessageHandler.getMessage(10487020, d.getUserFriendlyName());
                    break;
                }
                case SERVER_RESTART: {
                    synopsis = MessageHandler.getMessage(10487019);
                    break;
                }
            }
        }
        if (synopsis != null) {
            out.println();
            out.println(StaticUtils.wrapText(synopsis, ServerConstants.MAX_LINE_WIDTH));
        }
    }

    private HelpSubCommandHandler(ConsoleApplication app, SubCommandArgumentParser parser) throws ArgumentException {
        super(app);
        String name = "list-properties";
        int descriptionID = 10486777;
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, descriptionID, new Object[0]);
        this.categoryArgument = new StringArgument(OPTION_DSCFG_LONG_CATEGORY, OPTION_DSCFG_SHORT_CATEGORY, OPTION_DSCFG_LONG_CATEGORY, false, false, true, "{CATEGORY}", null, null, 10487046, new Object[0]);
        this.subCommand.addArgument(this.categoryArgument);
        this.typeArgument = new StringArgument(OPTION_DSCFG_LONG_TYPE, OPTION_DSCFG_SHORT_TYPE, OPTION_DSCFG_LONG_TYPE, false, false, true, "{TYPE}", null, null, 0xA00444, new Object[0]);
        this.subCommand.addArgument(this.typeArgument);
        this.inheritedModeArgument = new BooleanArgument(OPTION_DSCFG_LONG_INHERITED, OPTION_DSCFG_SHORT_INHERITED, OPTION_DSCFG_LONG_INHERITED, 0xA0050A, new Object[0]);
        this.subCommand.addArgument(this.inheritedModeArgument);
        this.registerAdvancedModeArgument(this.subCommand, 10486978, new String[0]);
        this.registerPropertyNameArgument(this.subCommand);
        this.categoryMap = new TreeMap();
        this.tagMap = new HashMap();
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    public void registerManagedObjectDefinition(AbstractManagedObjectDefinition<?, ?> d) {
        AbstractManagedObjectDefinition<?, ?> parent = d;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        String baseName = parent.getName();
        String typeName = null;
        if (parent == d) {
            typeName = GENERIC_TYPE;
        } else {
            String suffix = "-" + baseName;
            typeName = d.getName();
            if (typeName.endsWith(suffix)) {
                typeName = typeName.substring(0, typeName.length() - suffix.length());
            }
        }
        Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes = this.categoryMap.get(baseName);
        if (subTypes == null) {
            subTypes = new TreeMap();
            this.categoryMap.put(baseName, subTypes);
        }
        subTypes.put(typeName, d);
        for (Tag tag : d.getAllTags()) {
            subTypes = this.tagMap.get(baseName);
            if (subTypes == null) {
                subTypes = new TreeMap();
                this.tagMap.put(tag, subTypes);
            }
            subTypes.put(typeName, d);
        }
    }

    @Override
    public int run() throws ArgumentException, ClientException {
        String categoryName = this.categoryArgument.getValue();
        String typeName = this.typeArgument.getValue();
        Tag tag = null;
        Set<String> propertyNames = this.getPropertyNames();
        LinkedList dlist = new LinkedList();
        AbstractManagedObjectDefinition<?, ?> tmp = null;
        if (categoryName != null) {
            Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes = this.categoryMap.get(categoryName);
            if (subTypes == null) {
                try {
                    tag = Tag.valueOf(categoryName);
                }
                catch (IllegalArgumentException e) {
                    throw ArgumentExceptionFactory.unknownCategory(categoryName);
                }
                categoryName = null;
                subTypes = this.tagMap.get(tag);
                if (subTypes == null) {
                    throw ArgumentExceptionFactory.unknownCategory(categoryName);
                }
            } else {
                tmp = subTypes.get(GENERIC_TYPE);
            }
            if (typeName != null) {
                AbstractManagedObjectDefinition<?, ?> d = subTypes.get(typeName);
                if (d == null) {
                    throw ArgumentExceptionFactory.unknownTypeInCategory(categoryName, typeName);
                }
                dlist.add(d);
                tmp = d;
            } else {
                dlist.addAll(subTypes.values());
            }
        } else if (typeName != null) {
            boolean isFound = false;
            for (Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes : this.categoryMap.values()) {
                AbstractManagedObjectDefinition<?, ?> d = subTypes.get(typeName);
                if (d == null) continue;
                dlist.add(d);
                isFound = true;
            }
            if (!isFound) {
                throw ArgumentExceptionFactory.unknownType(typeName);
            }
        } else {
            for (Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes : this.categoryMap.values()) {
                dlist.addAll(subTypes.values());
            }
        }
        if (dlist.size() == 1) {
            tmp = (AbstractManagedObjectDefinition<?, ?>)dlist.get(0);
        }
        for (String propertyName : propertyNames) {
            boolean isFound = false;
            for (AbstractManagedObjectDefinition abstractManagedObjectDefinition : dlist) {
                try {
                    abstractManagedObjectDefinition.getPropertyDefinition(propertyName);
                    isFound = true;
                }
                catch (IllegalArgumentException e) {}
            }
            if (isFound) continue;
            if (tmp != null) {
                throw ArgumentExceptionFactory.unknownProperty(tmp, propertyName);
            }
            throw ArgumentExceptionFactory.unknownProperty(propertyName);
        }
        if (!this.getConsoleApplication().isVerbose()) {
            this.displayNonVerbose(categoryName, typeName, tag, propertyNames);
        } else {
            this.displayVerbose(categoryName, typeName, tag, propertyNames);
        }
        return 0;
    }

    private void displayNonVerbose(String categoryName, String typeName, Tag tag, Set<String> propertyNames) {
        PrintStream out = this.getConsoleApplication().getOutputStream();
        if (!this.getConsoleApplication().isScriptFriendly()) {
            out.println(MessageHandler.getMessage(10487031));
            out.println();
            out.print(" r -- ");
            out.println(MessageHandler.getMessage(10487032));
            out.print(" w -- ");
            out.println(MessageHandler.getMessage(10487033));
            out.print(" m -- ");
            out.println(MessageHandler.getMessage(10487034));
            out.print(" s -- ");
            out.println(MessageHandler.getMessage(10487035));
            out.print(" a -- ");
            out.println(MessageHandler.getMessage(10487036));
            out.println();
            out.println();
        }
        TableBuilder builder = new TableBuilder();
        builder.appendHeading(MessageHandler.getMessage(10486778));
        builder.appendHeading(MessageHandler.getMessage(10486842));
        builder.appendHeading(MessageHandler.getMessage(10486779));
        builder.appendHeading(MessageHandler.getMessage(10486782));
        builder.appendHeading(MessageHandler.getMessage(10486781));
        builder.addSortKey(0);
        builder.addSortKey(1);
        builder.addSortKey(2);
        for (String category : this.categoryMap.keySet()) {
            if (categoryName != null && !categoryName.equals(category)) continue;
            Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes = this.categoryMap.get(category);
            for (String type : subTypes.keySet()) {
                if (typeName != null && !typeName.equals(type)) continue;
                AbstractManagedObjectDefinition<?, ?> mod = subTypes.get(type);
                if (tag != null && !mod.hasTag(tag)) continue;
                TreeSet pds = new TreeSet();
                if (this.inheritedModeArgument.isPresent()) {
                    pds.addAll(mod.getAllPropertyDefinitions());
                } else {
                    pds.addAll(mod.getPropertyDefinitions());
                    if (mod.getParent() != null) {
                        pds.removeAll(mod.getParent().getAllPropertyDefinitions());
                    }
                }
                for (PropertyDefinition propertyDefinition : pds) {
                    if (propertyDefinition.hasOption(PropertyOption.HIDDEN) || !this.isAdvancedMode() && propertyDefinition.hasOption(PropertyOption.ADVANCED) || !propertyNames.isEmpty() && !propertyNames.contains(propertyDefinition.getName())) continue;
                    builder.startRow();
                    builder.appendCell(category);
                    builder.appendCell(type);
                    builder.appendCell(propertyDefinition.getName());
                    builder.appendCell(this.getPropertyOptionSummary(propertyDefinition));
                    PropertyDefinitionUsageBuilder v = new PropertyDefinitionUsageBuilder(false);
                    builder.appendCell(v.getUsage(propertyDefinition));
                }
            }
        }
        TablePrinter printer = this.getConsoleApplication().isScriptFriendly() ? this.createScriptFriendlyTablePrinter(out) : new TextTablePrinter(out);
        builder.print(printer);
    }

    private void displayVerbose(String categoryName, String typeName, Tag tag, Set<String> propertyNames) {
        PrintStream out = this.getConsoleApplication().getOutputStream();
        char[] c1 = new char[ServerConstants.MAX_LINE_WIDTH];
        Arrays.fill(c1, '=');
        char[] c2 = new char[ServerConstants.MAX_LINE_WIDTH];
        Arrays.fill(c2, '-');
        boolean isFirstManagedObject = true;
        for (String category : this.categoryMap.keySet()) {
            if (categoryName != null && !categoryName.equals(category)) continue;
            Map<String, AbstractManagedObjectDefinition<?, ?>> subTypes = this.categoryMap.get(category);
            for (String type : subTypes.keySet()) {
                if (typeName != null && !typeName.equals(type)) continue;
                AbstractManagedObjectDefinition<?, ?> mod = subTypes.get(type);
                if (tag != null && !mod.hasTag(tag)) continue;
                TreeSet pds = new TreeSet();
                if (this.inheritedModeArgument.isPresent()) {
                    pds.addAll(mod.getAllPropertyDefinitions());
                } else {
                    pds.addAll(mod.getPropertyDefinitions());
                    if (mod.getParent() != null) {
                        pds.removeAll(mod.getParent().getAllPropertyDefinitions());
                    }
                }
                boolean isFirstProperty = true;
                for (PropertyDefinition propertyDefinition : pds) {
                    if (propertyDefinition.hasOption(PropertyOption.HIDDEN) || !this.isAdvancedMode() && propertyDefinition.hasOption(PropertyOption.ADVANCED) || !propertyNames.isEmpty() && !propertyNames.contains(propertyDefinition.getName())) continue;
                    if (isFirstProperty) {
                        if (!isFirstManagedObject) {
                            out.println();
                            out.println(c1);
                            out.println();
                        } else {
                            isFirstManagedObject = false;
                        }
                        out.println(StaticUtils.wrapText(MessageHandler.getMessage(10487024, mod.getUserFriendlyName()), ServerConstants.MAX_LINE_WIDTH));
                        out.println();
                        out.println(StaticUtils.wrapText(mod.getSynopsis(), ServerConstants.MAX_LINE_WIDTH));
                        if (mod.getDescription() != null) {
                            out.println();
                            out.println(StaticUtils.wrapText(mod.getDescription(), ServerConstants.MAX_LINE_WIDTH));
                        }
                    }
                    out.println();
                    out.println(c2);
                    out.println();
                    HelpSubCommandHandler.displayVerboseSingleProperty(mod, propertyDefinition.getName(), out);
                    isFirstProperty = false;
                }
            }
        }
    }

    private String getPropertyOptionSummary(PropertyDefinition<?> pd) {
        StringBuilder b = new StringBuilder();
        if (pd.hasOption(PropertyOption.MONITORING) || pd.hasOption(PropertyOption.READ_ONLY)) {
            b.append("r-");
        } else {
            b.append("rw");
        }
        if (pd.hasOption(PropertyOption.MANDATORY)) {
            b.append('m');
        } else {
            b.append('-');
        }
        if (pd.hasOption(PropertyOption.MULTI_VALUED)) {
            b.append('-');
        } else {
            b.append('s');
        }
        AdministratorAction action = pd.getAdministratorAction();
        if (action.getType() != AdministratorAction.Type.NONE) {
            b.append('a');
        } else {
            b.append('-');
        }
        return b.toString();
    }

    static {
        OPTION_DSCFG_SHORT_INHERITED = null;
        OPTION_DSCFG_SHORT_TYPE = Character.valueOf('t');
        OPTION_DSCFG_SHORT_CATEGORY = Character.valueOf('c');
        int tmp = MessageHandler.getMessage(10487030).length();
        tmp = Math.max(tmp, MessageHandler.getMessage(10487025).length());
        tmp = Math.max(tmp, MessageHandler.getMessage(10487028).length());
        tmp = Math.max(tmp, MessageHandler.getMessage(10487026).length());
        HEADING_WIDTH = tmp = Math.max(tmp, MessageHandler.getMessage(10487029).length());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SyntaxPrinter {
        private final Visitor pimpl = new Visitor();

        public void print(PrintStream out, PropertyDefinition<?> pd) {
            pd.accept(this.pimpl, out);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Visitor
        extends PropertyDefinitionVisitor<Void, PrintStream> {
            private Visitor() {
            }

            @Override
            public <E extends Enum<E>> Void visitEnum(EnumPropertyDefinition<E> d, PrintStream p) {
                this.displayUsage(p, MessageHandler.getMessage(10487014));
                p.println();
                TableBuilder builder = new TableBuilder();
                boolean isFirst = true;
                for (Enum value : EnumSet.allOf(d.getEnumClass())) {
                    if (!isFirst) {
                        builder.startRow();
                    }
                    builder.startRow();
                    builder.appendCell();
                    builder.appendCell();
                    builder.appendCell(value.toString());
                    builder.appendCell(HelpSubCommandHandler.HEADING_SEPARATOR);
                    builder.appendCell(d.getValueSynopsis(value));
                    isFirst = false;
                }
                TextTablePrinter factory = new TextTablePrinter(p);
                factory.setDisplayHeadings(false);
                factory.setColumnWidth(0, HEADING_WIDTH);
                factory.setColumnWidth(1, HelpSubCommandHandler.HEADING_SEPARATOR.length());
                factory.setColumnWidth(4, 0);
                factory.setPadding(0);
                builder.print(factory);
                return null;
            }

            @Override
            public Void visitString(StringPropertyDefinition d, PrintStream p) {
                PropertyDefinitionUsageBuilder usageBuilder = new PropertyDefinitionUsageBuilder(true);
                TableBuilder builder = new TableBuilder();
                builder.startRow();
                builder.appendCell(MessageHandler.getMessage(10487030));
                builder.appendCell(HelpSubCommandHandler.HEADING_SEPARATOR);
                builder.appendCell(usageBuilder.getUsage(d));
                if (d.getPattern() != null) {
                    builder.startRow();
                    builder.startRow();
                    builder.appendCell();
                    builder.appendCell();
                    builder.appendCell(d.getPatternSynopsis());
                }
                TextTablePrinter factory = new TextTablePrinter(p);
                factory.setDisplayHeadings(false);
                factory.setColumnWidth(0, HEADING_WIDTH);
                factory.setColumnWidth(2, 0);
                factory.setPadding(0);
                builder.print(factory);
                return null;
            }

            @Override
            public Void visitUnknown(PropertyDefinition<?> d, PrintStream p) throws UnknownPropertyDefinitionException {
                PropertyDefinitionUsageBuilder usageBuilder = new PropertyDefinitionUsageBuilder(true);
                this.displayUsage(p, usageBuilder.getUsage(d));
                return null;
            }

            private void displayUsage(PrintStream p, String usage) {
                TableBuilder builder = new TableBuilder();
                builder.startRow();
                builder.appendCell(MessageHandler.getMessage(10487030));
                builder.appendCell(HelpSubCommandHandler.HEADING_SEPARATOR);
                builder.appendCell(usage);
                TextTablePrinter factory = new TextTablePrinter(p);
                factory.setDisplayHeadings(false);
                factory.setColumnWidth(0, HEADING_WIDTH);
                factory.setColumnWidth(2, 0);
                factory.setPadding(0);
                builder.print(factory);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultBehaviorPrinter {
        public <T> String print(PropertyDefinition<T> pd) {
            DefaultVisitor v = new DefaultVisitor();
            return (String)pd.getDefaultBehaviorProvider().accept(v, pd);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DefaultVisitor<T>
        implements DefaultBehaviorProviderVisitor<T, String, PropertyDefinition<T>> {
            private DefaultVisitor() {
            }

            @Override
            public String visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                return MessageHandler.getMessage(10487016, d.getPropertyName(), d.getManagedObjectPath().getRelationDefinition().getUserFriendlyName());
            }

            @Override
            public String visitAlias(AliasDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                return d.getSynopsis();
            }

            @Override
            public String visitDefined(DefinedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                StringBuilder builder = new StringBuilder();
                PropertyValuePrinter printer = new PropertyValuePrinter(null, null, false);
                boolean isFirst = true;
                for (String s : d.getDefaultValues()) {
                    if (!isFirst) {
                        builder.append(", ");
                    }
                    T value = p.decodeValue(s);
                    builder.append(printer.print(p, value));
                }
                return builder.toString();
            }

            @Override
            public String visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                if (d.getRelativeOffset() == 0) {
                    return MessageHandler.getMessage(10487018, d.getPropertyName(), d.getManagedObjectDefinition().getUserFriendlyName());
                }
                return MessageHandler.getMessage(10487017, d.getPropertyName(), d.getManagedObjectDefinition().getUserFriendlyName());
            }

            @Override
            public String visitUndefined(UndefinedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                return MessageHandler.getMessage(10487015);
            }
        }
    }
}

