/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.text.NumberFormat;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.DurationUnit;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.admin.SizePropertyDefinition;
import org.opends.server.admin.SizeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyValuePrinter {
    private final MyPropertyValueVisitor pimpl;

    public PropertyValuePrinter(SizeUnit sizeUnit, DurationUnit timeUnit, boolean isScriptFriendly) {
        this.pimpl = new MyPropertyValueVisitor(sizeUnit, timeUnit, isScriptFriendly);
    }

    public <T> String print(PropertyDefinition<T> pd, T value) {
        return pd.accept(this.pimpl, value, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyPropertyValueVisitor
    extends PropertyValueVisitor<String, Void> {
        private final SizeUnit sizeUnit;
        private final DurationUnit timeUnit;
        private final boolean isScriptFriendly;
        private final NumberFormat numberFormat;

        private MyPropertyValueVisitor(SizeUnit sizeUnit, DurationUnit timeUnit, boolean isScriptFriendly) {
            this.sizeUnit = sizeUnit;
            this.timeUnit = timeUnit;
            this.isScriptFriendly = isScriptFriendly;
            this.numberFormat = NumberFormat.getNumberInstance();
            if (this.isScriptFriendly) {
                this.numberFormat.setGroupingUsed(false);
                this.numberFormat.setMaximumFractionDigits(2);
            } else {
                this.numberFormat.setGroupingUsed(true);
                this.numberFormat.setMaximumFractionDigits(2);
            }
        }

        @Override
        public String visitDuration(DurationPropertyDefinition d, Long v, Void p) {
            if (d.getUpperLimit() == null && (v < 0L || v == Long.MAX_VALUE)) {
                return "unlimited";
            }
            long ms = d.getBaseUnit().toMilliSeconds(v.longValue());
            if (this.timeUnit == null && !this.isScriptFriendly && ms != 0L) {
                return DurationUnit.toString(ms);
            }
            DurationUnit unit = this.timeUnit;
            if (unit == null) {
                unit = d.getBaseUnit();
            }
            StringBuilder builder = new StringBuilder();
            builder.append(this.numberFormat.format(unit.fromMilliSeconds(ms)));
            builder.append(' ');
            builder.append(unit.getShortName());
            return builder.toString();
        }

        @Override
        public String visitSize(SizePropertyDefinition d, Long v, Void p) {
            if (d.isAllowUnlimited() && v < 0L) {
                return "unlimited";
            }
            SizeUnit unit = this.sizeUnit;
            if (unit == null) {
                unit = this.isScriptFriendly ? SizeUnit.getBestFitUnitExact(v) : SizeUnit.getBestFitUnit(v);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(this.numberFormat.format(unit.fromBytes(v)));
            builder.append(' ');
            builder.append(unit.getShortName());
            return builder.toString();
        }

        @Override
        public <T> String visitUnknown(PropertyDefinition<T> d, T v, Void p) {
            String s = d.encodeValue(v);
            if (this.isScriptFriendly) {
                return s;
            }
            if (s.trim().length() == 0 || s.contains(",")) {
                return "\"" + s + "\"";
            }
            return s;
        }
    }
}

