/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import org.opends.server.admin.AbsoluteInheritedDefaultBehaviorProvider;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.DefaultBehaviorProviderVisitor;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.UnknownPropertyDefinitionException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.ConsoleApplication;
import org.opends.server.tools.dsconfig.HelpCallback;
import org.opends.server.tools.dsconfig.HelpSubCommandHandler;
import org.opends.server.tools.dsconfig.PropertyValuePrinter;
import org.opends.server.tools.dsconfig.ValidationCallback;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyValueReader {
    private final ConsoleApplication app;

    public PropertyValueReader(ConsoleApplication app) {
        this.app = app;
    }

    public <T> T read(ManagedObject<?> mo, PropertyDefinition<T> pd) throws ArgumentException {
        while (true) {
            this.app.println();
            String value = pd.accept(new Visitor(), null);
            try {
                return pd.decodeValue(value);
            }
            catch (IllegalPropertyValueStringException e) {
                this.app.println();
                this.app.printMessage(ArgumentExceptionFactory.adaptPropertyException(e, mo.getManagedObjectDefinition()).getMessage());
                continue;
            }
            break;
        }
    }

    public void readAll(ManagedObject<?> mo, Collection<PropertyDefinition<?>> c) throws ArgumentException {
        for (PropertyDefinition<?> pd : c) {
            if (!pd.hasOption(PropertyOption.MANDATORY) || !mo.getPropertyValues(pd).isEmpty()) continue;
            this.editProperty(mo, pd);
        }
        boolean isFinished = false;
        PropertyValuePrinter valuePrinter = new PropertyValuePrinter(null, null, false);
        while (!isFinished) {
            int choice;
            TableBuilder builder = new TableBuilder();
            builder.appendHeading();
            builder.appendHeading(MessageHandler.getMessage(10486779));
            builder.appendHeading(MessageHandler.getMessage(10486780));
            int i = 0;
            ArrayList pl = new ArrayList(c);
            for (PropertyDefinition propertyDefinition : pl) {
                builder.startRow();
                builder.appendCell("[" + i + "]");
                builder.appendCell(propertyDefinition.getName());
                String values = this.getPropertyValuesAsString(mo, propertyDefinition, valuePrinter);
                builder.appendCell(values);
                ++i;
            }
            builder.startRow();
            builder.startRow();
            builder.appendCell("[" + i + "]");
            builder.appendCell(MessageHandler.getMessage(10487004));
            this.app.println();
            this.app.printMessage(MessageHandler.getMessage(10487008, i));
            this.app.println();
            TextTablePrinter printer = new TextTablePrinter(this.app.getErrorStream());
            printer.setColumnWidth(2, 0);
            builder.print(printer);
            final int n = i;
            String promptMsg = MessageHandler.getMessage(10486997, i);
            ValidationCallback<Integer> validator = new ValidationCallback<Integer>(){

                @Override
                public Integer validate(ConsoleApplication app, String input) {
                    String ninput = input.trim();
                    try {
                        int j = Integer.parseInt(ninput);
                        if (j < 1 || j > n) {
                            throw new NumberFormatException();
                        }
                        return j;
                    }
                    catch (NumberFormatException e) {
                        app.println();
                        String errMsg = MessageHandler.getMessage(10749143, n);
                        app.printMessage(errMsg);
                        return null;
                    }
                }
            };
            try {
                choice = this.app.readValidatedInput(promptMsg, validator);
            }
            catch (ClientException e) {
                throw new RuntimeException(e);
            }
            if (choice == n) {
                isFinished = true;
                continue;
            }
            this.editProperty(mo, (PropertyDefinition)pl.get(choice));
        }
    }

    private <T> void editProperty(ManagedObject<?> mo, PropertyDefinition<T> pd) throws ArgumentException {
        if (pd.hasOption(PropertyOption.MANDATORY) && mo.getPropertyValues(pd).isEmpty()) {
            this.app.println();
            String promptMsg = MessageHandler.getMessage(10487009, pd.getName());
            this.app.printMessage(promptMsg);
            T value = this.read(mo, pd);
            mo.setPropertyValue(pd, value);
        }
        boolean isFinished = false;
        while (!isFinished) {
            ArrayList<String> descriptions = new ArrayList<String>();
            ArrayList<MenuCallback> callbacks = new ArrayList<MenuCallback>();
            if (pd.hasOption(PropertyOption.MULTI_VALUED)) {
                descriptions.add(MessageHandler.getMessage(10487002));
                callbacks.add(new AddValueMenuCallback());
                if (!mo.getPropertyValues(pd).isEmpty()) {
                    descriptions.add(MessageHandler.getMessage(10487003));
                    callbacks.add(new RemoveValueMenuCallback());
                }
            } else {
                descriptions.add(MessageHandler.getMessage(10487001));
                callbacks.add(new SetValueMenuCallback());
            }
            if (!pd.hasOption(PropertyOption.MANDATORY) || !(pd.getDefaultBehaviorProvider() instanceof UndefinedDefaultBehaviorProvider)) {
                descriptions.add(MessageHandler.getMessage(10487000));
                callbacks.add(new ResetValueMenuCallback());
            }
            descriptions.add(MessageHandler.getMessage(10487004));
            callbacks.add(null);
            String promptMsg = MessageHandler.getMessage(10487010, pd.getName());
            MenuCallback callback = (MenuCallback)this.app.readChoice(promptMsg, descriptions, callbacks, new PropertyHelpCallback(mo, pd));
            if (callback != null) {
                callback.invoke(mo, pd);
                continue;
            }
            isFinished = true;
        }
    }

    private <T> String getPropertyValuesAsString(ManagedObject<?> mo, PropertyDefinition<T> pd, PropertyValuePrinter valuePrinter) {
        SortedSet<T> values = mo.getPropertyValues(pd);
        if (values.isEmpty()) {
            DefaultBehaviorProviderVisitor visitor = new DefaultBehaviorProviderVisitor<T, String, Void>(){

                @Override
                public String visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, Void p) {
                    throw new IllegalStateException();
                }

                @Override
                public String visitAlias(AliasDefaultBehaviorProvider<T> d, Void p) {
                    if (PropertyValueReader.this.app.isVerbose()) {
                        return d.getSynopsis();
                    }
                    return null;
                }

                @Override
                public String visitDefined(DefinedDefaultBehaviorProvider<T> d, Void p) {
                    throw new IllegalStateException();
                }

                @Override
                public String visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, Void p) {
                    throw new IllegalStateException();
                }

                @Override
                public String visitUndefined(UndefinedDefaultBehaviorProvider<T> d, Void p) {
                    return null;
                }
            };
            String content = (String)pd.getDefaultBehaviorProvider().accept(visitor, null);
            if (content == null) {
                return "-";
            }
            return content;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object value : values) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(valuePrinter.print(pd, value));
            isFirst = false;
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Visitor
    extends PropertyDefinitionVisitor<String, Void> {
        private ArgumentException ae = null;

        private Visitor() {
        }

        public String read(PropertyDefinition<?> pd) throws ArgumentException {
            String result = pd.accept(this, null);
            if (result != null) {
                return result;
            }
            if (this.ae != null) {
                throw this.ae;
            }
            throw new IllegalStateException("No result and no ArgumentException caught");
        }

        @Override
        public String visitBoolean(BooleanPropertyDefinition d, Void p) {
            List<String> values = Arrays.asList("false", "true");
            try {
                String promptMsg = MessageHandler.getMessage(10487006, d.getName());
                return PropertyValueReader.this.app.readChoice(promptMsg, values, values, null);
            }
            catch (ArgumentException e) {
                this.ae = e;
                return null;
            }
        }

        @Override
        public <E extends Enum<E>> String visitEnum(EnumPropertyDefinition<E> d, Void p) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (Enum value : EnumSet.allOf(d.getEnumClass())) {
                String s = String.format("%s : %s", value.toString(), d.getValueSynopsis(value));
                map.put(value.toString(), s);
            }
            ArrayList<String> descriptions = new ArrayList<String>(map.values());
            ArrayList values = new ArrayList(map.keySet());
            try {
                String promptMsg = MessageHandler.getMessage(10487006, d.getName());
                return (String)PropertyValueReader.this.app.readChoice(promptMsg, descriptions, values, null);
            }
            catch (ArgumentException e) {
                this.ae = e;
                return null;
            }
        }

        @Override
        public String visitUnknown(PropertyDefinition<?> d, Void p) throws UnknownPropertyDefinitionException {
            try {
                String promptMsg = MessageHandler.getMessage(10487007, d.getName());
                return PropertyValueReader.this.app.readLineOfInput(promptMsg);
            }
            catch (ArgumentException e) {
                this.ae = e;
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SetValueMenuCallback
    implements MenuCallback {
        private SetValueMenuCallback() {
        }

        @Override
        public <T> void invoke(ManagedObject<?> mo, PropertyDefinition<T> pd) throws ArgumentException {
            T value = PropertyValueReader.this.read(mo, pd);
            mo.setPropertyValue(pd, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ResetValueMenuCallback
    implements MenuCallback {
        private ResetValueMenuCallback() {
        }

        @Override
        public <T> void invoke(ManagedObject<?> mo, PropertyDefinition<T> pd) throws ArgumentException {
            mo.setPropertyValue(pd, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RemoveValueMenuCallback
    implements MenuCallback {
        private RemoveValueMenuCallback() {
        }

        @Override
        public <T> void invoke(ManagedObject<?> mo, PropertyDefinition<T> pd) throws ArgumentException {
            Object value2;
            PropertyValuePrinter printer = new PropertyValuePrinter(null, null, false);
            SortedSet<T> values = mo.getPropertyValues(pd);
            ArrayList<String> descriptions = new ArrayList<String>(values.size());
            ArrayList lvalues = new ArrayList(values.size());
            for (Object value2 : values) {
                descriptions.add(printer.print(pd, value2));
                lvalues.add(value2);
            }
            String promptMsg = MessageHandler.getMessage(10487005, pd.getName());
            value2 = PropertyValueReader.this.app.readChoice(promptMsg, descriptions, lvalues, null);
            values.remove(value2);
            mo.setPropertyValues(pd, values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AddValueMenuCallback
    implements MenuCallback {
        private AddValueMenuCallback() {
        }

        @Override
        public <T> void invoke(ManagedObject<?> mo, PropertyDefinition<T> pd) throws ArgumentException {
            T value = PropertyValueReader.this.read(mo, pd);
            SortedSet<T> values = mo.getPropertyValues(pd);
            values.add(value);
            mo.setPropertyValues(pd, values);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MenuCallback {
        public <T> void invoke(ManagedObject<?> var1, PropertyDefinition<T> var2) throws ArgumentException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PropertyHelpCallback
    implements HelpCallback {
        private final ManagedObject<?> mo;
        private final PropertyDefinition<?> pd;

        public PropertyHelpCallback(ManagedObject<?> mo, PropertyDefinition<?> pd) {
            this.mo = mo;
            this.pd = pd;
        }

        @Override
        public void display(ConsoleApplication app) {
            app.println();
            HelpSubCommandHandler.displayVerboseSingleProperty(this.mo.getManagedObjectDefinition(), this.pd.getName(), app.getErrorStream());
        }
    }
}

