/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AggregationRelationDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelationDefinitionVisitor;
import org.opends.server.admin.RelationOption;
import org.opends.server.admin.SingletonRelationDefinition;
import org.opends.server.tools.dsconfig.ConsoleApplication;
import org.opends.server.tools.dsconfig.CreateSubCommandHandler;
import org.opends.server.tools.dsconfig.DeleteSubCommandHandler;
import org.opends.server.tools.dsconfig.GetPropSubCommandHandler;
import org.opends.server.tools.dsconfig.HelpSubCommandHandler;
import org.opends.server.tools.dsconfig.ListSubCommandHandler;
import org.opends.server.tools.dsconfig.SetPropSubCommandHandler;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.SubCommandArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SubCommandBuilder {
    public Collection<SubCommandHandler> getSubCommandHandlers(ConsoleApplication app, SubCommandArgumentParser parser) throws ArgumentException {
        Visitor v = new Visitor(app, parser);
        return v.getSubCommandHandlers();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Visitor
    implements RelationDefinitionVisitor<Void, ManagedObjectPath<?, ?>> {
        private final ConsoleApplication app;
        private ArgumentException exception = null;
        private List<SubCommandHandler> handlers = null;
        private HelpSubCommandHandler helpHandler = null;
        private final SubCommandArgumentParser parser;

        private Visitor(ConsoleApplication app, SubCommandArgumentParser parser) {
            this.app = app;
            this.parser = parser;
        }

        public List<SubCommandHandler> getSubCommandHandlers() throws ArgumentException {
            if (this.handlers == null) {
                this.handlers = new LinkedList<SubCommandHandler>();
                this.helpHandler = HelpSubCommandHandler.create(this.app, this.parser);
                this.handlers.add(this.helpHandler);
                this.processPath(ManagedObjectPath.emptyPath());
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.handlers;
        }

        @Override
        public Void visitAggregation(AggregationRelationDefinition<?, ?> r, ManagedObjectPath<?, ?> p) {
            return null;
        }

        @Override
        public Void visitInstantiable(InstantiableRelationDefinition<?, ?> r, ManagedObjectPath<?, ?> p) {
            try {
                this.handlers.add(CreateSubCommandHandler.create(this.app, this.parser, p, r));
                this.handlers.add(DeleteSubCommandHandler.create(this.app, this.parser, p, r));
                this.handlers.add(ListSubCommandHandler.create(this.app, this.parser, p, r));
                this.handlers.add(GetPropSubCommandHandler.create(this.app, this.parser, p, r));
                this.handlers.add(SetPropSubCommandHandler.create(this.app, this.parser, p, r));
                this.processRelation(p, r);
            }
            catch (ArgumentException e) {
                this.exception = e;
            }
            return null;
        }

        @Override
        public Void visitOptional(OptionalRelationDefinition<?, ?> r, ManagedObjectPath<?, ?> p) {
            try {
                this.handlers.add(CreateSubCommandHandler.create(this.app, this.parser, p, r));
                this.handlers.add(DeleteSubCommandHandler.create(this.app, this.parser, p, r));
                this.handlers.add(ListSubCommandHandler.create(this.app, this.parser, p, r));
                this.handlers.add(GetPropSubCommandHandler.create(this.app, this.parser, p, r));
                this.handlers.add(SetPropSubCommandHandler.create(this.app, this.parser, p, r));
                this.processRelation(p, r);
            }
            catch (ArgumentException e) {
                this.exception = e;
            }
            return null;
        }

        @Override
        public Void visitSingleton(SingletonRelationDefinition<?, ?> r, ManagedObjectPath<?, ?> p) {
            try {
                this.handlers.add(GetPropSubCommandHandler.create(this.app, this.parser, p, r));
                this.handlers.add(SetPropSubCommandHandler.create(this.app, this.parser, p, r));
                this.processRelation(p, r);
            }
            catch (ArgumentException e) {
                this.exception = e;
            }
            return null;
        }

        private void processPath(ManagedObjectPath<?, ?> path) {
            AbstractManagedObjectDefinition<?, ?> d = path.getManagedObjectDefinition();
            for (RelationDefinition<?, ?> r : d.getRelationDefinitions()) {
                if (r.hasOption(RelationOption.HIDDEN)) continue;
                r.accept(this, path);
            }
        }

        private <C extends ConfigurationClient, S extends Configuration> void processRelation(ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<C, S> r) {
            AbstractManagedObjectDefinition d = r.getChildDefinition();
            this.helpHandler.registerManagedObjectDefinition(d);
            this.processPath(path.child(r, d, "DUMMY"));
            for (AbstractManagedObjectDefinition c : d.getAllChildren()) {
                this.helpHandler.registerManagedObjectDefinition(c);
                this.processPath(path.child(r, c, "DUMMY"));
            }
        }

        private <C extends ConfigurationClient, S extends Configuration> void processRelation(ManagedObjectPath<?, ?> path, OptionalRelationDefinition<C, S> r) {
            AbstractManagedObjectDefinition d = r.getChildDefinition();
            this.helpHandler.registerManagedObjectDefinition(d);
            this.processPath(path.child(r, d));
            for (AbstractManagedObjectDefinition c : d.getAllChildren()) {
                this.helpHandler.registerManagedObjectDefinition(c);
                this.processPath(path.child(r, c));
            }
        }

        private <C extends ConfigurationClient, S extends Configuration> void processRelation(ManagedObjectPath<?, ?> path, SingletonRelationDefinition<C, S> r) {
            AbstractManagedObjectDefinition d = r.getChildDefinition();
            this.helpHandler.registerManagedObjectDefinition(d);
            this.processPath(path.child(r, d));
            for (AbstractManagedObjectDefinition c : d.getAllChildren()) {
                this.helpHandler.registerManagedObjectDefinition(c);
                this.processPath(path.child(r, c));
            }
        }
    }
}

