/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import java.util.Random;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceTag
extends Tag {
    private int percentage = 100;
    private Random random;

    @Override
    public String getName() {
        return "Presence";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] arguments, int lineNumber, List<String> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber);
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<String> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber);
    }

    private void initializeInternal(TemplateFile templateFile, String[] arguments, int lineNumber) throws InitializationException {
        this.random = templateFile.getRandom();
        if (arguments.length != 1) {
            int msgID = 10682903;
            String message = MessageHandler.getMessage(msgID, this.getName(), lineNumber, 1, arguments.length);
            throw new InitializationException(msgID, message);
        }
        try {
            this.percentage = Integer.parseInt(arguments[0]);
            if (this.percentage < 0) {
                int msgID = 10682906;
                String message = MessageHandler.getMessage(this.percentage, 0, this.getName(), lineNumber);
                throw new InitializationException(msgID, message);
            }
            if (this.percentage > 100) {
                int msgID = 10682908;
                String message = MessageHandler.getMessage(this.percentage, 100, this.getName(), lineNumber);
                throw new InitializationException(msgID, message);
            }
        }
        catch (NumberFormatException nfe) {
            int msgID = 10682907;
            String message = MessageHandler.getMessage(msgID, arguments[0], this.getName(), lineNumber);
            throw new InitializationException(msgID, message);
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        int intValue = this.random.nextInt(100);
        if (intValue < this.percentage) {
            return TagResult.SUCCESS_RESULT;
        }
        return TagResult.OMIT_FROM_ENTRY;
    }
}

