/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDNTag
extends Tag {
    @Override
    public String getName() {
        return "RDN";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] arguments, int lineNumber, List<String> warnings) throws InitializationException {
        if (arguments.length != 0) {
            int msgID = 10682903;
            String message = MessageHandler.getMessage(msgID, this.getName(), lineNumber, 0, arguments.length);
            throw new InitializationException(msgID, message);
        }
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<String> warnings) throws InitializationException {
        if (arguments.length != 0) {
            int msgID = 10682903;
            String message = MessageHandler.getMessage(msgID, this.getName(), lineNumber, 0, arguments.length);
            throw new InitializationException(msgID, message);
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        DN dn = templateEntry.getDN();
        if (dn == null || dn.isNullDN()) {
            return TagResult.SUCCESS_RESULT;
        }
        dn.getRDN().toString(templateValue.getValue());
        return TagResult.SUCCESS_RESULT;
    }
}

