/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequentialTag
extends Tag {
    private boolean resetOnNewParents;
    private int initialValue;
    private int nextValue;

    @Override
    public String getName() {
        return "Sequential";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] arguments, int lineNumber, List<String> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber);
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] arguments, int lineNumber, List<String> warnings) throws InitializationException {
        this.initializeInternal(templateFile, arguments, lineNumber);
    }

    private void initializeInternal(TemplateFile templateFile, String[] arguments, int lineNumber) throws InitializationException {
        switch (arguments.length) {
            case 0: {
                this.initialValue = 0;
                this.nextValue = 0;
                this.resetOnNewParents = true;
                break;
            }
            case 1: {
                try {
                    this.initialValue = Integer.parseInt(arguments[0]);
                }
                catch (NumberFormatException nfe) {
                    int msgID = 10682907;
                    String message = MessageHandler.getMessage(msgID, arguments[0], this.getName(), lineNumber);
                    throw new InitializationException(msgID, message);
                }
                this.nextValue = this.initialValue;
                this.resetOnNewParents = true;
                break;
            }
            case 2: {
                try {
                    this.initialValue = Integer.parseInt(arguments[0]);
                }
                catch (NumberFormatException nfe) {
                    int msgID = 10682907;
                    String message = MessageHandler.getMessage(msgID, arguments[0], this.getName(), lineNumber);
                    throw new InitializationException(msgID, message);
                }
                if (arguments[1].equalsIgnoreCase("true")) {
                    this.resetOnNewParents = true;
                } else if (arguments[1].equalsIgnoreCase("false")) {
                    this.resetOnNewParents = false;
                } else {
                    int msgID = 10682910;
                    String message = MessageHandler.getMessage(msgID, arguments[1], this.getName(), lineNumber);
                    throw new InitializationException(msgID, message);
                }
                this.nextValue = this.initialValue;
                break;
            }
            default: {
                int msgID = 10682904;
                String message = MessageHandler.getMessage(msgID, this.getName(), lineNumber, 0, 2, arguments.length);
                throw new InitializationException(msgID, message);
            }
        }
    }

    @Override
    public void initializeForParent(TemplateEntry parentEntry) {
        if (this.resetOnNewParents) {
            this.nextValue = this.initialValue;
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        templateValue.getValue().append(this.nextValue++);
        return TagResult.SUCCESS_RESULT;
    }
}

