/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.EntryWriter;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateLine;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    private AttributeType[] rdnAttributes;
    private int[] numEntriesPerTemplate;
    private String name;
    private String[] subordinateTemplateNames;
    private Template[] subordinateTemplates;
    private TemplateFile templateFile;
    private TemplateLine[] templateLines;

    public Template(TemplateFile templateFile, String name, AttributeType[] rdnAttributes, String[] subordinateTemplateNames, int[] numEntriesPerTemplate) {
        this.templateFile = templateFile;
        this.name = name;
        this.rdnAttributes = rdnAttributes;
        this.subordinateTemplateNames = subordinateTemplateNames;
        this.numEntriesPerTemplate = numEntriesPerTemplate;
        this.templateLines = new TemplateLine[0];
        this.subordinateTemplates = null;
    }

    public Template(TemplateFile templateFile, String name, AttributeType[] rdnAttributes, String[] subordinateTemplateNames, int[] numEntriesPerTemplate, TemplateLine[] templateLines) {
        this.templateFile = templateFile;
        this.name = name;
        this.rdnAttributes = rdnAttributes;
        this.subordinateTemplateNames = subordinateTemplateNames;
        this.numEntriesPerTemplate = numEntriesPerTemplate;
        this.templateLines = templateLines;
        this.subordinateTemplates = null;
    }

    public void completeTemplateInitialization(Map<String, Template> templates) throws MakeLDIFException {
        Object l;
        if (this.subordinateTemplateNames == null) {
            this.subordinateTemplateNames = new String[0];
            this.subordinateTemplates = new Template[0];
        } else {
            this.subordinateTemplates = new Template[this.subordinateTemplateNames.length];
            for (int i = 0; i < this.subordinateTemplates.length; ++i) {
                this.subordinateTemplates[i] = templates.get(StaticUtils.toLowerCase(this.subordinateTemplateNames[i]));
                if (this.subordinateTemplates[i] != null) continue;
                int msgID = 10682923;
                String message = MessageHandler.getMessage(msgID, this.subordinateTemplateNames[i], this.name);
                throw new MakeLDIFException(msgID, message);
            }
        }
        HashSet<AttributeType> rdnAttrs = new HashSet<AttributeType>(this.rdnAttributes.length);
        for (AttributeType t : this.rdnAttributes) {
            rdnAttrs.add(t);
        }
        Object[] arr$ = this.templateLines;
        int len$ = arr$.length;
        for (int i$ = 0; !(i$ >= len$ || rdnAttrs.remove(((TemplateLine)(l = arr$[i$])).getAttributeType()) && rdnAttrs.isEmpty()); ++i$) {
        }
        if (!rdnAttrs.isEmpty()) {
            AttributeType t = (AttributeType)rdnAttrs.iterator().next();
            int msgID = 10682933;
            String message = MessageHandler.getMessage(msgID, this.name, t.getNameOrOID());
            throw new MakeLDIFException(msgID, message);
        }
    }

    public String getName() {
        return this.name;
    }

    public AttributeType[] getRDNAttributes() {
        return this.rdnAttributes;
    }

    public String[] getSubordinateTemplateNames() {
        return this.subordinateTemplateNames;
    }

    public Template[] getSubordinateTemplates() {
        return this.subordinateTemplates;
    }

    public int[] getNumEntriesPerTemplate() {
        return this.numEntriesPerTemplate;
    }

    public TemplateLine[] getTemplateLines() {
        return this.templateLines;
    }

    public void addTemplateLine(TemplateLine line) {
        TemplateLine[] newTemplateLines = new TemplateLine[this.templateLines.length + 1];
        System.arraycopy(this.templateLines, 0, newTemplateLines, 0, this.templateLines.length);
        newTemplateLines[this.templateLines.length] = line;
        this.templateLines = newTemplateLines;
    }

    public boolean hasAttribute(AttributeType attributeType) {
        for (TemplateLine l : this.templateLines) {
            if (!l.getAttributeType().equals(attributeType)) continue;
            return true;
        }
        return false;
    }

    public TagResult writeEntries(EntryWriter entryWriter, DN parentDN, int count) throws IOException, MakeLDIFException {
        for (int i = 0; i < count; ++i) {
            this.templateFile.nextFirstAndLastNames();
            TemplateEntry templateEntry = new TemplateEntry(this, parentDN);
            for (TemplateLine l : this.templateLines) {
                TagResult r = l.generateLine(templateEntry);
                if (r.keepProcessingEntry() && r.keepProcessingParent() && r.keepProcessingTemplateFile()) continue;
                return r;
            }
            Entry entry = templateEntry.toEntry();
            if (!entryWriter.writeEntry(entry)) {
                return TagResult.STOP_PROCESSING;
            }
            for (int j = 0; j < this.subordinateTemplates.length; ++j) {
                TagResult r = this.subordinateTemplates[j].writeEntries(entryWriter, entry.getDN(), this.numEntriesPerTemplate[j]);
                if (r.keepProcessingParent() && r.keepProcessingTemplateFile()) continue;
                if (r.keepProcessingTemplateFile()) {
                    return TagResult.SUCCESS_RESULT;
                }
                return r;
            }
        }
        return TagResult.SUCCESS_RESULT;
    }
}

