/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.AttributeValueTag;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.DNTag;
import org.opends.server.tools.makeldif.EntryWriter;
import org.opends.server.tools.makeldif.FileTag;
import org.opends.server.tools.makeldif.FirstNameTag;
import org.opends.server.tools.makeldif.GUIDTag;
import org.opends.server.tools.makeldif.IfAbsentTag;
import org.opends.server.tools.makeldif.IfPresentTag;
import org.opends.server.tools.makeldif.LastNameTag;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.ParentDNTag;
import org.opends.server.tools.makeldif.PresenceTag;
import org.opends.server.tools.makeldif.RDNTag;
import org.opends.server.tools.makeldif.RandomTag;
import org.opends.server.tools.makeldif.SequentialTag;
import org.opends.server.tools.makeldif.StaticTextTag;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateLine;
import org.opends.server.tools.makeldif.UnderscoreDNTag;
import org.opends.server.tools.makeldif.UnderscoreParentDNTag;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateFile {
    public static final String FIRST_NAME_FILE = "first.names";
    public static final String LAST_NAME_FILE = "last.names";
    private HashMap<String, String[]> fileLines;
    private int firstNameIndex;
    private int lastNameIndex;
    private int nameLoopCounter;
    private int nameUniquenessCounter;
    private LinkedHashMap<DN, Branch> branches;
    private LinkedHashMap<String, String> constants;
    private LinkedHashMap<String, Tag> registeredTags;
    private LinkedHashMap<String, Template> templates;
    private Random random;
    private String firstName;
    private String lastName;
    private String resourcePath;
    private String templatePath;
    private String[] firstNames;
    private String[] lastNames;

    public TemplateFile(String resourcePath) {
        this(resourcePath, new Random());
    }

    public TemplateFile(String resourcePath, Random random) {
        this.resourcePath = resourcePath;
        this.random = random;
        this.fileLines = new HashMap();
        this.branches = new LinkedHashMap();
        this.constants = new LinkedHashMap();
        this.registeredTags = new LinkedHashMap();
        this.templates = new LinkedHashMap();
        this.templatePath = null;
        this.firstNames = new String[0];
        this.lastNames = new String[0];
        this.firstName = null;
        this.lastName = null;
        this.firstNameIndex = 0;
        this.lastNameIndex = 0;
        this.nameLoopCounter = 0;
        this.nameUniquenessCounter = 1;
        this.registerDefaultTags();
        try {
            this.readNameFiles();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.firstNames = new String[]{"John"};
            this.lastNames = new String[]{"Doe"};
        }
    }

    public Map<String, Tag> getTags() {
        return this.registeredTags;
    }

    public Tag getTag(String lowerName) {
        return this.registeredTags.get(lowerName);
    }

    public void registerTag(String tagClass) throws MakeLDIFException {
        Tag t;
        Class<?> c;
        try {
            c = Class.forName(tagClass);
        }
        catch (Exception e) {
            int msgID = 10682912;
            String message = MessageHandler.getMessage(msgID, tagClass);
            throw new MakeLDIFException(msgID, message, e);
        }
        try {
            t = (Tag)c.newInstance();
        }
        catch (Exception e) {
            int msgID = 10682913;
            String message = MessageHandler.getMessage(msgID, tagClass);
            throw new MakeLDIFException(msgID, message, e);
        }
        String lowerName = StaticUtils.toLowerCase(t.getName());
        if (this.registeredTags.containsKey(lowerName)) {
            int msgID = 10682914;
            String message = MessageHandler.getMessage(msgID, tagClass, t.getName());
            throw new MakeLDIFException(msgID, message);
        }
        this.registeredTags.put(lowerName, t);
    }

    private void registerDefaultTags() {
        Class[] defaultTagClasses;
        for (Class c : defaultTagClasses = new Class[]{AttributeValueTag.class, DNTag.class, FileTag.class, FirstNameTag.class, GUIDTag.class, IfAbsentTag.class, IfPresentTag.class, LastNameTag.class, ParentDNTag.class, PresenceTag.class, RandomTag.class, RDNTag.class, SequentialTag.class, StaticTextTag.class, UnderscoreDNTag.class, UnderscoreParentDNTag.class}) {
            try {
                Tag t = (Tag)c.newInstance();
                this.registeredTags.put(StaticUtils.toLowerCase(t.getName()), t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Map<String, String> getConstants() {
        return this.constants;
    }

    public String getConstant(String lowerName) {
        return this.constants.get(lowerName);
    }

    public void registerConstant(String name, String value) {
        this.constants.put(StaticUtils.toLowerCase(name), value);
    }

    public Map<DN, Branch> getBranches() {
        return this.branches;
    }

    public Branch getBranch(DN branchDN) {
        return this.branches.get(branchDN);
    }

    public void registerBranch(Branch branch) {
        this.branches.put(branch.getBranchDN(), branch);
    }

    public Map<String, Template> getTemplates() {
        return this.templates;
    }

    public Template getTemplate(String lowerName) {
        return this.templates.get(lowerName);
    }

    public void registerTemplate(Template template) {
        this.templates.put(StaticUtils.toLowerCase(template.getName()), template);
    }

    public Random getRandom() {
        return this.random;
    }

    private void readNameFiles() throws IOException {
        String line;
        File f = this.getFile(FIRST_NAME_FILE);
        ArrayList<String> nameList = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(f));
        while ((line = reader.readLine()) != null) {
            nameList.add(line);
        }
        reader.close();
        this.firstNames = new String[nameList.size()];
        nameList.toArray(this.firstNames);
        f = this.getFile(LAST_NAME_FILE);
        nameList = new ArrayList();
        reader = new BufferedReader(new FileReader(f));
        while ((line = reader.readLine()) != null) {
            nameList.add(line);
        }
        reader.close();
        this.lastNames = new String[nameList.size()];
        nameList.toArray(this.lastNames);
    }

    public void nextFirstAndLastNames() {
        this.firstName = this.firstNames[this.firstNameIndex++];
        this.lastName = this.lastNames[this.lastNameIndex++];
        if (this.nameUniquenessCounter > 1) {
            this.lastName = this.lastName + this.nameUniquenessCounter;
        }
        if (this.firstNameIndex >= this.firstNames.length) {
            this.firstNameIndex = 0;
            if (this.firstNames.length > this.lastNames.length) {
                this.lastNameIndex = ++this.nameLoopCounter;
                if (this.lastNameIndex >= this.lastNames.length) {
                    this.lastNameIndex = 0;
                    ++this.nameUniquenessCounter;
                }
            }
        }
        if (this.lastNameIndex >= this.lastNames.length) {
            this.lastNameIndex = 0;
            if (this.lastNames.length > this.firstNames.length) {
                this.firstNameIndex = ++this.nameLoopCounter;
                if (this.firstNameIndex >= this.firstNames.length) {
                    this.firstNameIndex = 0;
                    ++this.nameUniquenessCounter;
                }
            }
        }
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void parse(String filename, List<String> warnings) throws IOException, InitializationException, MakeLDIFException {
        String line;
        ArrayList<String> fileLines = new ArrayList<String>();
        this.templatePath = null;
        File f = this.getFile(filename);
        if (f == null || !f.exists()) {
            int msgID = 10682960;
            String message = MessageHandler.getMessage(msgID, filename);
            throw new IOException(message);
        }
        this.templatePath = f.getParentFile().getAbsolutePath();
        BufferedReader reader = new BufferedReader(new FileReader(f));
        while ((line = reader.readLine()) != null) {
            fileLines.add(line);
        }
        reader.close();
        String[] lines = new String[fileLines.size()];
        fileLines.toArray(lines);
        this.parse(lines, warnings);
    }

    public void parse(InputStream inputStream, List<String> warnings) throws IOException, InitializationException, MakeLDIFException {
        String line;
        ArrayList<String> fileLines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            fileLines.add(line);
        }
        reader.close();
        String[] lines = new String[fileLines.size()];
        fileLines.toArray(lines);
        this.parse(lines, warnings);
    }

    public void parse(String[] lines, List<String> warnings) throws InitializationException, MakeLDIFException {
        LinkedHashMap<String, Tag> templateFileIncludeTags = new LinkedHashMap<String, Tag>();
        LinkedHashMap<String, String> templateFileConstants = new LinkedHashMap<String, String>();
        LinkedHashMap<DN, Branch> templateFileBranches = new LinkedHashMap<DN, Branch>();
        LinkedHashMap<String, Template> templateFileTemplates = new LinkedHashMap<String, Template>();
        for (int lineNumber = 0; lineNumber < lines.length; ++lineNumber) {
            String message;
            int msgID;
            String constantValue;
            String constantName;
            int openPos;
            StringBuilder lineBuffer;
            ArrayList<String> lineList;
            int startLineNumber;
            String message2;
            String message3;
            int msgID2;
            String line = lines[lineNumber];
            int closePos = line.lastIndexOf(93);
            if (closePos > 0) {
                StringBuilder lineBuffer2 = new StringBuilder(line);
                int openPos2 = line.lastIndexOf(91, closePos);
                if (openPos2 >= 0) {
                    String constantName2 = StaticUtils.toLowerCase(line.substring(openPos2 + 1, closePos));
                    String constantValue2 = (String)templateFileConstants.get(constantName2);
                    if (constantValue2 == null) {
                        msgID2 = 10551843;
                        message3 = MessageHandler.getMessage(msgID2, constantName2, lineNumber);
                        warnings.add(message3);
                    } else {
                        lineBuffer2.replace(openPos2, closePos + 1, constantValue2);
                    }
                }
                line = lineBuffer2.toString();
            }
            String lowerLine = StaticUtils.toLowerCase(line);
            if (line.length() == 0 || line.startsWith("#")) continue;
            if (lowerLine.startsWith("include ")) {
                Tag tag;
                Class<?> tagClass;
                String className = line.substring(8).trim();
                try {
                    tagClass = Class.forName(className);
                }
                catch (Exception e) {
                    msgID2 = 10682912;
                    message3 = MessageHandler.getMessage(msgID2, className);
                    throw new MakeLDIFException(msgID2, message3, e);
                }
                try {
                    tag = (Tag)tagClass.newInstance();
                }
                catch (Exception e) {
                    int msgID3 = 10682913;
                    message2 = MessageHandler.getMessage(msgID3, className);
                    throw new MakeLDIFException(msgID3, message2, e);
                }
                String lowerName = StaticUtils.toLowerCase(tag.getName());
                if (this.registeredTags.containsKey(lowerName) || templateFileIncludeTags.containsKey(lowerName)) {
                    int msgID4 = 10682914;
                    message2 = MessageHandler.getMessage(msgID4, className, tag.getName());
                    throw new MakeLDIFException(msgID4, message2);
                }
                templateFileIncludeTags.put(lowerName, tag);
                continue;
            }
            if (lowerLine.startsWith("define ")) {
                int equalPos = line.indexOf(61, 7);
                if (equalPos < 0) {
                    int msgID5 = 10682916;
                    String message4 = MessageHandler.getMessage(msgID5, lineNumber);
                    throw new MakeLDIFException(msgID5, message4);
                }
                String name = line.substring(7, equalPos).trim();
                if (name.length() == 0) {
                    int msgID6 = 10682917;
                    String message5 = MessageHandler.getMessage(msgID6, lineNumber);
                    throw new MakeLDIFException(msgID6, message5);
                }
                String lowerName = StaticUtils.toLowerCase(name);
                if (templateFileConstants.containsKey(lowerName)) {
                    msgID2 = 10682918;
                    message3 = MessageHandler.getMessage(msgID2, name, lineNumber);
                    throw new MakeLDIFException(msgID2, message3);
                }
                String value = line.substring(equalPos + 1);
                if (value.length() == 0) {
                    int msgID7 = 10682919;
                    message2 = MessageHandler.getMessage(msgID7, name, lineNumber);
                    warnings.add(message2);
                }
                templateFileConstants.put(lowerName, value);
                continue;
            }
            if (lowerLine.startsWith("branch: ")) {
                startLineNumber = lineNumber;
                lineList = new ArrayList<String>();
                lineList.add(line);
                while (++lineNumber < lines.length && (line = lines[lineNumber]).length() != 0) {
                    closePos = line.lastIndexOf(93);
                    if (closePos > 0) {
                        lineBuffer = new StringBuilder(line);
                        openPos = line.lastIndexOf(91, closePos);
                        if (openPos >= 0) {
                            constantName = StaticUtils.toLowerCase(line.substring(openPos + 1, closePos));
                            constantValue = templateFileConstants.get(constantName);
                            if (constantValue == null) {
                                msgID = 10551843;
                                message = MessageHandler.getMessage(msgID, constantName, lineNumber);
                                warnings.add(message);
                            } else {
                                lineBuffer.replace(openPos, closePos + 1, constantValue);
                            }
                        }
                        line = lineBuffer.toString();
                    }
                    lineList.add(line);
                }
                String[] branchLines = new String[lineList.size()];
                lineList.toArray(branchLines);
                Branch b = this.parseBranchDefinition(branchLines, lineNumber, templateFileIncludeTags, templateFileConstants, warnings);
                DN branchDN = b.getBranchDN();
                if (templateFileBranches.containsKey(branchDN)) {
                    int msgID8 = 10682920;
                    String message6 = MessageHandler.getMessage(msgID8, String.valueOf(branchDN), startLineNumber);
                    throw new MakeLDIFException(msgID8, message6);
                }
                templateFileBranches.put(branchDN, b);
                continue;
            }
            if (lowerLine.startsWith("template: ")) {
                startLineNumber = lineNumber;
                lineList = new ArrayList();
                lineList.add(line);
                while (++lineNumber < lines.length && (line = lines[lineNumber]).length() != 0) {
                    closePos = line.lastIndexOf(93);
                    if (closePos > 0) {
                        lineBuffer = new StringBuilder(line);
                        openPos = line.lastIndexOf(91, closePos);
                        if (openPos >= 0) {
                            constantName = StaticUtils.toLowerCase(line.substring(openPos + 1, closePos));
                            constantValue = templateFileConstants.get(constantName);
                            if (constantValue == null) {
                                msgID = 10551843;
                                message = MessageHandler.getMessage(msgID, constantName, lineNumber);
                                warnings.add(message);
                            } else {
                                lineBuffer.replace(openPos, closePos + 1, constantValue);
                            }
                        }
                        line = lineBuffer.toString();
                    }
                    lineList.add(line);
                }
                String[] templateLines = new String[lineList.size()];
                lineList.toArray(templateLines);
                Template t = this.parseTemplateDefinition(templateLines, startLineNumber, templateFileIncludeTags, templateFileConstants, templateFileTemplates, warnings);
                String lowerName = StaticUtils.toLowerCase(t.getName());
                if (templateFileTemplates.containsKey(lowerName)) {
                    int msgID9 = 10682921;
                    String message7 = MessageHandler.getMessage(msgID9, String.valueOf(t.getName()), startLineNumber);
                    throw new MakeLDIFException(msgID9, message7);
                }
                templateFileTemplates.put(lowerName, t);
                continue;
            }
            int msgID10 = 10682922;
            String message8 = MessageHandler.getMessage(msgID10, line, lineNumber);
            throw new MakeLDIFException(msgID10, message8);
        }
        for (Branch b : templateFileBranches.values()) {
            b.completeBranchInitialization(templateFileTemplates);
        }
        for (Template t : templateFileTemplates.values()) {
            t.completeTemplateInitialization(templateFileTemplates);
        }
        this.registeredTags.putAll(templateFileIncludeTags);
        this.constants.putAll(templateFileConstants);
        this.branches.putAll(templateFileBranches);
        this.templates.putAll(templateFileTemplates);
    }

    private Branch parseBranchDefinition(String[] branchLines, int startLineNumber, LinkedHashMap<String, Tag> tags, LinkedHashMap<String, String> constants, List<String> warnings) throws InitializationException, MakeLDIFException {
        DN branchDN;
        String dnString = branchLines[0].substring(8).trim();
        try {
            branchDN = DN.decode(dnString);
        }
        catch (Exception e) {
            int msgID = 10682924;
            String message = MessageHandler.getMessage(msgID, dnString, startLineNumber);
            throw new MakeLDIFException(msgID, message);
        }
        Branch branch = new Branch(this, branchDN);
        for (int i = 1; i < branchLines.length; ++i) {
            String line = branchLines[i];
            String lowerLine = StaticUtils.toLowerCase(line);
            int lineNumber = startLineNumber + i;
            if (lowerLine.startsWith("#")) continue;
            if (lowerLine.startsWith("subordinatetemplate: ")) {
                int colonPos = line.indexOf(58, 21);
                if (colonPos <= 21) {
                    int msgID = 10682925;
                    String message = MessageHandler.getMessage(msgID, lineNumber, dnString);
                    throw new MakeLDIFException(msgID, message);
                }
                String templateName = line.substring(21, colonPos).trim();
                try {
                    String message;
                    int msgID;
                    int numEntries = Integer.parseInt(line.substring(colonPos + 1).trim());
                    if (numEntries < 0) {
                        msgID = 10682926;
                        message = MessageHandler.getMessage(msgID, lineNumber, dnString, numEntries, templateName);
                        throw new MakeLDIFException(msgID, message);
                    }
                    if (numEntries == 0) {
                        msgID = 10551855;
                        message = MessageHandler.getMessage(msgID, lineNumber, dnString, templateName);
                        warnings.add(message);
                    }
                    branch.addSubordinateTemplate(templateName, numEntries);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    int msgID = 10682928;
                    String message = MessageHandler.getMessage(msgID, templateName, lineNumber, dnString);
                    throw new MakeLDIFException(msgID, message);
                }
            }
            TemplateLine templateLine = this.parseTemplateLine(line, lowerLine, lineNumber, branch, null, tags, warnings);
            branch.addExtraLine(templateLine);
        }
        return branch;
    }

    private Template parseTemplateDefinition(String[] templateLines, int startLineNumber, LinkedHashMap<String, Tag> tags, LinkedHashMap<String, String> constants, LinkedHashMap<String, Template> definedTemplates, List<String> warnings) throws InitializationException, MakeLDIFException {
        TemplateLine[] parsedLines;
        int arrayLineNumber;
        String templateName = templateLines[0].substring(10).trim();
        Template parentTemplate = null;
        AttributeType[] rdnAttributes = null;
        ArrayList<String> subTemplateNames = new ArrayList<String>();
        ArrayList<Integer> entriesPerTemplate = new ArrayList<Integer>();
        for (arrayLineNumber = 1; arrayLineNumber < templateLines.length; ++arrayLineNumber) {
            int lineNumber = startLineNumber + arrayLineNumber;
            String line = templateLines[arrayLineNumber];
            String lowerLine = StaticUtils.toLowerCase(line);
            if (lowerLine.startsWith("#")) continue;
            if (lowerLine.startsWith("extends: ")) {
                String parentTemplateName = line.substring(9).trim();
                parentTemplate = definedTemplates.get(parentTemplateName.toLowerCase());
                if (parentTemplate != null) continue;
                int msgID = 10683243;
                String message = MessageHandler.getMessage(msgID, parentTemplateName, lineNumber, templateName);
                throw new MakeLDIFException(msgID, message);
            }
            if (lowerLine.startsWith("rdnattr: ")) {
                ArrayList<AttributeType> attrList = new ArrayList<AttributeType>();
                String rdnAttrNames = lowerLine.substring(9).trim();
                StringTokenizer tokenizer = new StringTokenizer(rdnAttrNames, "+");
                while (tokenizer.hasMoreTokens()) {
                    attrList.add(DirectoryServer.getAttributeType(tokenizer.nextToken(), true));
                }
                rdnAttributes = new AttributeType[attrList.size()];
                attrList.toArray(rdnAttributes);
                continue;
            }
            if (!lowerLine.startsWith("subordinatetemplate: ")) break;
            int colonPos = line.indexOf(58, 21);
            if (colonPos <= 21) {
                int msgID = 10682929;
                String message = MessageHandler.getMessage(msgID, lineNumber, templateName);
                throw new MakeLDIFException(msgID, message);
            }
            String subTemplateName = line.substring(21, colonPos).trim();
            try {
                String message;
                int msgID;
                int numEntries = Integer.parseInt(line.substring(colonPos + 1).trim());
                if (numEntries < 0) {
                    msgID = 10682930;
                    message = MessageHandler.getMessage(msgID, lineNumber, templateName, numEntries, subTemplateName);
                    throw new MakeLDIFException(msgID, message);
                }
                if (numEntries == 0) {
                    msgID = 10551859;
                    message = MessageHandler.getMessage(msgID, lineNumber, templateName, subTemplateName);
                    warnings.add(message);
                }
                subTemplateNames.add(subTemplateName);
                entriesPerTemplate.add(numEntries);
                continue;
            }
            catch (NumberFormatException nfe) {
                int msgID = 10682932;
                String message = MessageHandler.getMessage(msgID, subTemplateName, lineNumber, templateName);
                throw new MakeLDIFException(msgID, message);
            }
        }
        String[] subordinateTemplateNames = new String[subTemplateNames.size()];
        subTemplateNames.toArray(subordinateTemplateNames);
        int[] numEntriesPerTemplate = new int[entriesPerTemplate.size()];
        for (int i = 0; i < numEntriesPerTemplate.length; ++i) {
            numEntriesPerTemplate[i] = (Integer)entriesPerTemplate.get(i);
        }
        if (parentTemplate == null) {
            parsedLines = new TemplateLine[]{};
        } else {
            TemplateLine[] parentLines = parentTemplate.getTemplateLines();
            parsedLines = new TemplateLine[parentLines.length];
            System.arraycopy(parentLines, 0, parsedLines, 0, parentLines.length);
        }
        Template template = new Template(this, templateName, rdnAttributes, subordinateTemplateNames, numEntriesPerTemplate, parsedLines);
        while (arrayLineNumber < templateLines.length) {
            String line = templateLines[arrayLineNumber];
            String lowerLine = StaticUtils.toLowerCase(line);
            int lineNumber = startLineNumber + arrayLineNumber;
            if (!lowerLine.startsWith("#")) {
                TemplateLine templateLine = this.parseTemplateLine(line, lowerLine, lineNumber, null, template, tags, warnings);
                template.addTemplateLine(templateLine);
            }
            ++arrayLineNumber;
        }
        return template;
    }

    private TemplateLine parseTemplateLine(String line, String lowerLine, int lineNumber, Branch branch, Template template, LinkedHashMap<String, Tag> tags, List<String> warnings) throws InitializationException, MakeLDIFException {
        int pos;
        int colonPos = lowerLine.indexOf(58);
        if (colonPos < 0) {
            if (branch == null) {
                int msgID = 10682937;
                String message = MessageHandler.getMessage(msgID, lineNumber, template.getName());
                throw new MakeLDIFException(msgID, message);
            }
            int msgID = 10682934;
            String message = MessageHandler.getMessage(msgID, lineNumber, String.valueOf(branch.getBranchDN()));
            throw new MakeLDIFException(msgID, message);
        }
        if (colonPos == 0) {
            if (branch == null) {
                int msgID = 10682938;
                String message = MessageHandler.getMessage(msgID, lineNumber, template.getName());
                throw new MakeLDIFException(msgID, message);
            }
            int msgID = 10682935;
            String message = MessageHandler.getMessage(msgID, lineNumber, String.valueOf(branch.getBranchDN()));
            throw new MakeLDIFException(msgID, message);
        }
        AttributeType attributeType = DirectoryServer.getAttributeType(lowerLine.substring(0, colonPos), true);
        int length = line.length();
        for (pos = colonPos + 1; pos < length && lowerLine.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            String message;
            int msgID;
            if (branch == null) {
                msgID = 10551867;
                message = MessageHandler.getMessage(msgID, lineNumber, template.getName());
                warnings.add(message);
            } else {
                msgID = 10551864;
                message = MessageHandler.getMessage(msgID, lineNumber, String.valueOf(branch.getBranchDN()));
                warnings.add(message);
            }
        }
        boolean PARSING_STATIC_TEXT = false;
        boolean PARSING_REPLACEMENT_TAG = true;
        int PARSING_ATTRIBUTE_TAG = 2;
        int phase = 0;
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        StringBuilder buffer = new StringBuilder();
        while (pos < length) {
            char c = line.charAt(pos);
            block0 : switch (phase) {
                case 0: {
                    Tag t;
                    switch (c) {
                        case '<': {
                            String[] args;
                            if (buffer.length() > 0) {
                                t = new StaticTextTag();
                                args = new String[]{buffer.toString()};
                                ((StaticTextTag)t).initializeForBranch(this, branch, args, lineNumber, warnings);
                                tagList.add(t);
                                buffer = new StringBuilder();
                            }
                            phase = 1;
                            break block0;
                        }
                        case '{': {
                            String[] args;
                            if (buffer.length() > 0) {
                                t = new StaticTextTag();
                                args = new String[]{buffer.toString()};
                                ((StaticTextTag)t).initializeForBranch(this, branch, args, lineNumber, warnings);
                                tagList.add(t);
                                buffer = new StringBuilder();
                            }
                            phase = 2;
                            break block0;
                        }
                    }
                    buffer.append(c);
                    break;
                }
                case 1: {
                    Tag t;
                    switch (c) {
                        case '>': {
                            t = this.parseReplacementTag(buffer.toString(), branch, template, lineNumber, tags, warnings);
                            tagList.add(t);
                            buffer = new StringBuilder();
                            phase = 0;
                            break block0;
                        }
                    }
                    buffer.append(c);
                    break;
                }
                case 2: {
                    Tag t;
                    switch (c) {
                        case '}': {
                            t = this.parseAttributeTag(buffer.toString(), branch, template, lineNumber, warnings);
                            tagList.add(t);
                            buffer = new StringBuilder();
                            phase = 0;
                            break block0;
                        }
                    }
                    buffer.append(c);
                }
            }
            ++pos;
        }
        if (phase == 0) {
            if (buffer.length() > 0) {
                StaticTextTag t = new StaticTextTag();
                String[] args = new String[]{buffer.toString()};
                t.initializeForBranch(this, branch, args, lineNumber, warnings);
                tagList.add(t);
            }
        } else {
            int msgID = 10682975;
            String message = MessageHandler.getMessage(msgID, lineNumber);
            throw new InitializationException(msgID, message);
        }
        Tag[] tagArray = new Tag[tagList.size()];
        tagList.toArray(tagArray);
        return new TemplateLine(attributeType, lineNumber, tagArray);
    }

    private Tag parseReplacementTag(String tagString, Branch branch, Template template, int lineNumber, LinkedHashMap<String, Tag> tags, List<String> warnings) throws InitializationException, MakeLDIFException {
        Tag newTag;
        StringTokenizer tokenizer = new StringTokenizer(tagString, ":");
        String tagName = tokenizer.nextToken().trim();
        String lowerTagName = StaticUtils.toLowerCase(tagName);
        Tag t = this.getTag(lowerTagName);
        if (t == null && (t = tags.get(lowerTagName)) == null) {
            int msgID = 10682940;
            String message = MessageHandler.getMessage(msgID, tagName, lineNumber);
            throw new MakeLDIFException(msgID, message);
        }
        ArrayList<String> argList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            argList.add(tokenizer.nextToken().trim());
        }
        String[] args = new String[argList.size()];
        argList.toArray(args);
        try {
            newTag = (Tag)t.getClass().newInstance();
        }
        catch (Exception e) {
            int msgID = 10682941;
            String message = MessageHandler.getMessage(msgID, tagName, lineNumber, String.valueOf(e));
            throw new MakeLDIFException(msgID, message, e);
        }
        if (branch == null) {
            newTag.initializeForTemplate(this, template, args, lineNumber, warnings);
        } else if (newTag.allowedInBranch()) {
            newTag.initializeForBranch(this, branch, args, lineNumber, warnings);
        } else {
            int msgID = 10682976;
            String message = MessageHandler.getMessage(msgID, newTag.getName(), lineNumber);
            throw new MakeLDIFException(msgID, message);
        }
        return newTag;
    }

    private Tag parseAttributeTag(String tagString, Branch branch, Template template, int lineNumber, List<String> warnings) throws InitializationException, MakeLDIFException {
        StringTokenizer tokenizer = new StringTokenizer(tagString, ":");
        ArrayList<String> argList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            argList.add(tokenizer.nextToken());
        }
        String[] args = new String[argList.size()];
        argList.toArray(args);
        AttributeValueTag tag = new AttributeValueTag();
        if (branch == null) {
            tag.initializeForTemplate(this, template, args, lineNumber, warnings);
        } else {
            tag.initializeForBranch(this, branch, args, lineNumber, warnings);
        }
        return tag;
    }

    public File getFile(String path) {
        File f = new File(path);
        if (f.exists()) {
            return f;
        }
        if (f.isAbsolute()) {
            return f;
        }
        String newPath = this.resourcePath + File.separator + path;
        f = new File(newPath);
        if (f.exists()) {
            return f;
        }
        if (this.templatePath != null && (f = new File(newPath = (this.templatePath = File.separator + path))).exists()) {
            return f;
        }
        return null;
    }

    public String[] getFileLines(File file) throws IOException {
        String absolutePath = file.getAbsolutePath();
        String[] lines = this.fileLines.get(absolutePath);
        if (lines == null) {
            String line;
            ArrayList<String> lineList = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                lineList.add(line);
            }
            reader.close();
            lines = new String[lineList.size()];
            lineList.toArray(lines);
            lineList.clear();
            this.fileLines.put(absolutePath, lines);
        }
        return lines;
    }

    public TagResult generateLDIF(EntryWriter entryWriter) throws IOException, MakeLDIFException {
        for (Branch b : this.branches.values()) {
            TagResult result = b.writeEntries(entryWriter);
            if (result.keepProcessingTemplateFile()) continue;
            return result;
        }
        entryWriter.closeEntryWriter();
        return TagResult.SUCCESS_RESULT;
    }
}

