/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.AttributeType;

public class TemplateLine {
    private AttributeType attributeType;
    private int lineNumber;
    private Tag[] tags;

    public TemplateLine(AttributeType attributeType, int lineNumber, Tag[] tags) {
        this.attributeType = attributeType;
        this.lineNumber = lineNumber;
        this.tags = tags;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public TagResult generateLine(TemplateEntry templateEntry) {
        TemplateValue value = new TemplateValue(this);
        for (Tag t : this.tags) {
            TagResult result = t.generateValue(templateEntry, value);
            if (result.keepProcessingLine() && result.keepProcessingEntry() && result.keepProcessingParent() && result.keepProcessingTemplateFile()) continue;
            return result;
        }
        templateEntry.addValue(value);
        return TagResult.SUCCESS_RESULT;
    }
}

