/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.Base64;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final AttributeType attributeType;
    private LinkedHashSet<AttributeValue> values;
    private final LinkedHashSet<String> options;
    private final LinkedHashSet<String> lowerOptions;
    private final String name;

    public Attribute(AttributeType attributeType) {
        this.attributeType = attributeType;
        this.name = attributeType.getPrimaryName();
        this.options = new LinkedHashSet(0);
        this.values = new LinkedHashSet();
        this.lowerOptions = this.options;
    }

    public Attribute(AttributeType attributeType, String name) {
        this.attributeType = attributeType;
        this.name = name;
        this.options = new LinkedHashSet(0);
        this.values = new LinkedHashSet();
        this.lowerOptions = this.options;
    }

    public Attribute(AttributeType attributeType, String name, LinkedHashSet<AttributeValue> values) {
        this.attributeType = attributeType;
        this.name = name;
        this.options = new LinkedHashSet(0);
        this.lowerOptions = this.options;
        this.values = values == null ? new LinkedHashSet() : values;
    }

    public Attribute(String lowerName, String valueString) {
        this.attributeType = DirectoryServer.getAttributeType(lowerName, true);
        this.name = lowerName;
        this.values = new LinkedHashSet();
        this.values.add(new AttributeValue(this.attributeType, valueString));
        this.options = new LinkedHashSet(0);
        this.lowerOptions = this.options;
    }

    public Attribute(AttributeType attributeType, String name, LinkedHashSet<String> options, LinkedHashSet<AttributeValue> values) {
        this.attributeType = attributeType;
        this.name = name;
        if (options == null || options.isEmpty()) {
            this.options = new LinkedHashSet(0);
            this.lowerOptions = options;
        } else {
            this.options = options;
            this.lowerOptions = new LinkedHashSet(options.size());
            for (String option : options) {
                this.lowerOptions.add(StaticUtils.toLowerCase(option));
            }
        }
        this.values = values == null ? new LinkedHashSet(0) : values;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithOptions() {
        if (this.options.isEmpty()) {
            return this.name;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.name);
        for (String option : this.options) {
            buffer.append(';');
            buffer.append(option);
        }
        return buffer.toString();
    }

    public LinkedHashSet<String> getOptions() {
        return this.options;
    }

    public boolean hasOption(String option) {
        return this.lowerOptions.contains(StaticUtils.toLowerCase(option));
    }

    public boolean hasOptions() {
        return !this.options.isEmpty();
    }

    public boolean hasOptions(Collection<String> options) {
        if (options == null) {
            return true;
        }
        for (String option : options) {
            if (this.lowerOptions.contains(StaticUtils.toLowerCase(option))) continue;
            return false;
        }
        return true;
    }

    public boolean optionsEqual(Set<String> options) {
        if (options == null) {
            return this.options == null || this.options.isEmpty();
        }
        if (options.isEmpty() && this.options.isEmpty()) {
            return true;
        }
        if (options.size() != this.options.size()) {
            return false;
        }
        for (String s : options) {
            if (this.lowerOptions.contains(StaticUtils.toLowerCase(s))) continue;
            return false;
        }
        return true;
    }

    public LinkedHashSet<AttributeValue> getValues() {
        return this.values;
    }

    public void setValues(LinkedHashSet<AttributeValue> values) {
        this.values = values == null ? new LinkedHashSet() : values;
    }

    public boolean hasValue() {
        return !this.getValues().isEmpty();
    }

    public boolean hasValue(AttributeValue value) {
        return this.getValues().contains(value);
    }

    public boolean hasAllValues(Collection<AttributeValue> values) {
        for (AttributeValue value : values) {
            if (this.getValues().contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAnyValue(Collection<AttributeValue> values) {
        for (AttributeValue value : values) {
            if (!this.getValues().contains(value)) continue;
            return true;
        }
        return false;
    }

    public ConditionResult matchesSubstring(ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        ByteString normalizedSubFinal;
        ArrayList<ByteString> normalizedSubAny;
        ByteString normalizedSubInitial;
        SubstringMatchingRule matchingRule = this.attributeType.getSubstringMatchingRule();
        if (matchingRule == null) {
            return ConditionResult.UNDEFINED;
        }
        if (subInitial == null) {
            normalizedSubInitial = null;
        } else {
            try {
                normalizedSubInitial = matchingRule.normalizeSubstring(subInitial);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return ConditionResult.UNDEFINED;
            }
        }
        if (subAny == null) {
            normalizedSubAny = null;
        } else {
            normalizedSubAny = new ArrayList<ByteString>(subAny.size());
            for (ByteString subAnyElement : subAny) {
                try {
                    normalizedSubAny.add(matchingRule.normalizeSubstring(subAnyElement));
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    return ConditionResult.UNDEFINED;
                }
            }
        }
        if (subFinal == null) {
            normalizedSubFinal = null;
        } else {
            try {
                normalizedSubFinal = matchingRule.normalizeSubstring(subFinal);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return ConditionResult.UNDEFINED;
            }
        }
        ConditionResult result = ConditionResult.FALSE;
        for (AttributeValue value : this.getValues()) {
            try {
                if (!matchingRule.valueMatchesSubstring(value.getNormalizedValue(), normalizedSubInitial, normalizedSubAny, normalizedSubFinal)) continue;
                return ConditionResult.TRUE;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                result = ConditionResult.UNDEFINED;
            }
        }
        return result;
    }

    public ConditionResult greaterThanOrEqualTo(AttributeValue value) {
        ByteString normalizedValue;
        OrderingMatchingRule matchingRule = this.attributeType.getOrderingMatchingRule();
        if (matchingRule == null) {
            return ConditionResult.UNDEFINED;
        }
        try {
            normalizedValue = value.getNormalizedValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return ConditionResult.UNDEFINED;
        }
        ConditionResult result = ConditionResult.FALSE;
        for (AttributeValue v : this.getValues()) {
            try {
                ByteString nv = v.getNormalizedValue();
                int comparisonResult = matchingRule.compareValues(nv, normalizedValue);
                if (comparisonResult < 0) continue;
                return ConditionResult.TRUE;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                result = ConditionResult.UNDEFINED;
            }
        }
        return result;
    }

    public ConditionResult lessThanOrEqualTo(AttributeValue value) {
        ByteString normalizedValue;
        OrderingMatchingRule matchingRule = this.attributeType.getOrderingMatchingRule();
        if (matchingRule == null) {
            return ConditionResult.UNDEFINED;
        }
        try {
            normalizedValue = value.getNormalizedValue();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return ConditionResult.UNDEFINED;
        }
        ConditionResult result = ConditionResult.FALSE;
        for (AttributeValue v : this.getValues()) {
            try {
                ByteString nv = v.getNormalizedValue();
                int comparisonResult = matchingRule.compareValues(nv, normalizedValue);
                if (comparisonResult > 0) continue;
                return ConditionResult.TRUE;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                result = ConditionResult.UNDEFINED;
            }
        }
        return result;
    }

    public ConditionResult approximatelyEqualTo(AttributeValue value) {
        ByteString normalizedValue;
        ApproximateMatchingRule matchingRule = this.attributeType.getApproximateMatchingRule();
        if (matchingRule == null) {
            return ConditionResult.UNDEFINED;
        }
        try {
            normalizedValue = matchingRule.normalizeValue(value.getValue());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return ConditionResult.UNDEFINED;
        }
        ConditionResult result = ConditionResult.FALSE;
        for (AttributeValue v : this.getValues()) {
            try {
                ByteString nv = matchingRule.normalizeValue(v.getValue());
                if (!matchingRule.approximatelyMatch(nv, normalizedValue)) continue;
                return ConditionResult.TRUE;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                result = ConditionResult.UNDEFINED;
            }
        }
        return result;
    }

    public boolean isVirtual() {
        return false;
    }

    public Attribute duplicate() {
        return this.duplicate(false);
    }

    public Attribute duplicate(boolean omitValues) {
        LinkedHashSet<String> optionsCopy = new LinkedHashSet<String>(this.options);
        if (omitValues) {
            return new Attribute(this.attributeType, this.name, optionsCopy, null);
        }
        LinkedHashSet<AttributeValue> valuesCopy = new LinkedHashSet<AttributeValue>(this.getValues());
        return new Attribute(this.attributeType, this.name, optionsCopy, valuesCopy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Attribute)) {
            return false;
        }
        Attribute a = (Attribute)o;
        if (!this.attributeType.equals(a.attributeType)) {
            return false;
        }
        if (this.getValues().size() != a.getValues().size()) {
            return false;
        }
        if (!this.hasAllValues(a.getValues())) {
            return false;
        }
        return this.optionsEqual(a.options);
    }

    public int hashCode() {
        int hashCode = this.attributeType.hashCode();
        for (AttributeValue value : this.getValues()) {
            hashCode += value.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("Attribute(");
        buffer.append(this.name);
        buffer.append(", {");
        boolean firstValue = true;
        for (AttributeValue value : this.getValues()) {
            if (!firstValue) {
                buffer.append(", ");
            }
            value.toString(buffer);
            firstValue = false;
        }
        buffer.append("})");
    }

    public String toLDIF() {
        StringBuilder buffer = new StringBuilder();
        this.toLDIF(buffer);
        return buffer.toString();
    }

    public void toLDIF(StringBuilder buffer) {
        for (AttributeValue value : this.getValues()) {
            buffer.append(this.name);
            if (StaticUtils.needsBase64Encoding(value.getValueBytes())) {
                buffer.append("::");
                buffer.append(Base64.encode(value.getValueBytes()));
            } else {
                buffer.append(": ");
                buffer.append(value.getStringValue());
            }
            buffer.append(ServerConstants.EOL);
        }
    }
}

