/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupDirectory {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String PROPERTY_BACKEND_CONFIG_DN = "backend_dn";
    private DN configEntryDN;
    private LinkedHashMap<String, BackupInfo> backups;
    private String path;

    public BackupDirectory(String path, DN configEntryDN) {
        this.path = path;
        this.configEntryDN = configEntryDN;
        this.backups = new LinkedHashMap();
    }

    public BackupDirectory(String path, DN configEntryDN, LinkedHashMap<String, BackupInfo> backups) {
        this.path = path;
        this.configEntryDN = configEntryDN;
        this.backups = backups == null ? new LinkedHashMap() : backups;
    }

    public String getPath() {
        return this.path;
    }

    public DN getConfigEntryDN() {
        return this.configEntryDN;
    }

    public LinkedHashMap<String, BackupInfo> getBackups() {
        return this.backups;
    }

    public BackupInfo getBackupInfo(String backupID) {
        return this.backups.get(backupID);
    }

    public BackupInfo getLatestBackup() {
        BackupInfo latestBackup = null;
        for (BackupInfo backup : this.backups.values()) {
            if (latestBackup == null) {
                latestBackup = backup;
                continue;
            }
            if (backup.getBackupDate().getTime() <= latestBackup.getBackupDate().getTime()) continue;
            latestBackup = backup;
        }
        return latestBackup;
    }

    public void addBackup(BackupInfo backupInfo) throws ConfigException {
        String backupID = backupInfo.getBackupID();
        if (this.backups.containsKey(backupID)) {
            int msgID = 262443;
            String message = MessageHandler.getMessage(msgID, backupID, this.path);
            throw new ConfigException(msgID, message);
        }
        this.backups.put(backupID, backupInfo);
    }

    public void removeBackup(String backupID) throws ConfigException {
        if (!this.backups.containsKey(backupID)) {
            int msgID = 262444;
            String message = MessageHandler.getMessage(msgID, backupID, this.path);
            throw new ConfigException(msgID, message);
        }
        for (BackupInfo backup : this.backups.values()) {
            if (!backup.dependsOn(backupID)) continue;
            int msgID = 262445;
            String message = MessageHandler.getMessage(msgID, backupID, this.path, backup.getBackupID());
            throw new ConfigException(msgID, message);
        }
        this.backups.remove(backupID);
    }

    public String getDescriptorPath() {
        return this.path + File.separator + "backup.info";
    }

    public void writeBackupDirectoryDescriptor() throws IOException {
        File dir = new File(this.path);
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 262446;
                String message = MessageHandler.getMessage(msgID, this.path, StaticUtils.getExceptionMessage(e));
                throw new IOException(message);
            }
        } else if (!dir.isDirectory()) {
            int msgID = 262447;
            String message = MessageHandler.getMessage(msgID, this.path);
            throw new IOException(message);
        }
        String newDescriptorFilePath = this.path + File.separator + "backup.info" + ".new";
        File newDescriptorFile = new File(newDescriptorFilePath);
        BufferedWriter writer = new BufferedWriter(new FileWriter(newDescriptorFile, false));
        writer.write("backend_dn=" + this.configEntryDN.toString());
        writer.newLine();
        writer.newLine();
        for (BackupInfo backup : this.backups.values()) {
            LinkedList<String> backupLines = backup.encode();
            for (String line : backupLines) {
                writer.write(line);
                writer.newLine();
            }
            writer.newLine();
        }
        writer.flush();
        writer.close();
        String descriptorFilePath = this.path + File.separator + "backup.info";
        File descriptorFile = new File(descriptorFilePath);
        if (descriptorFile.exists()) {
            String savedDescriptorFilePath = descriptorFilePath + ".save";
            File savedDescriptorFile = new File(savedDescriptorFilePath);
            if (savedDescriptorFile.exists()) {
                try {
                    savedDescriptorFile.delete();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    int msgID = 262448;
                    String message = MessageHandler.getMessage(msgID, savedDescriptorFilePath, StaticUtils.getExceptionMessage(e), newDescriptorFilePath, descriptorFilePath);
                    throw new IOException(message);
                }
            }
            try {
                descriptorFile.renameTo(savedDescriptorFile);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 262449;
                String message = MessageHandler.getMessage(msgID, descriptorFilePath, savedDescriptorFilePath, StaticUtils.getExceptionMessage(e), newDescriptorFilePath);
                throw new IOException(message);
            }
        }
        try {
            newDescriptorFile.renameTo(descriptorFile);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 262450;
            String message = MessageHandler.getMessage(msgID, newDescriptorFilePath, descriptorFilePath, StaticUtils.getExceptionMessage(e));
            throw new IOException(message);
        }
    }

    public static BackupDirectory readBackupDirectoryDescriptor(String path) throws IOException, ConfigException {
        DN configEntryDN;
        String descriptorFilePath = path + File.separator + "backup.info";
        File descriptorFile = new File(descriptorFilePath);
        if (!descriptorFile.exists()) {
            int msgID = 262451;
            String message = MessageHandler.getMessage(msgID, descriptorFilePath);
            throw new ConfigException(msgID, message);
        }
        BufferedReader reader = new BufferedReader(new FileReader(descriptorFile));
        String line = reader.readLine();
        if (line == null || line.length() == 0) {
            int msgID = 262452;
            String message = MessageHandler.getMessage(msgID, descriptorFilePath);
            throw new ConfigException(msgID, message);
        }
        if (!line.startsWith(PROPERTY_BACKEND_CONFIG_DN)) {
            int msgID = 262453;
            String message = MessageHandler.getMessage(msgID, descriptorFilePath, line);
            throw new ConfigException(msgID, message);
        }
        String dnString = line.substring(PROPERTY_BACKEND_CONFIG_DN.length() + 1);
        try {
            configEntryDN = DN.decode(dnString);
        }
        catch (DirectoryException de) {
            int msgID = 262454;
            String message = MessageHandler.getMessage(msgID, dnString, de.getErrorMessage());
            throw new ConfigException(msgID, message, de);
        }
        catch (Exception e) {
            int msgID = 262454;
            String message = MessageHandler.getMessage(msgID, dnString, StaticUtils.getExceptionMessage(e));
            throw new ConfigException(msgID, message, e);
        }
        BackupDirectory backupDirectory = new BackupDirectory(path, configEntryDN);
        LinkedList<String> lines = new LinkedList<String>();
        while (true) {
            if ((line = reader.readLine()) == null || line.length() == 0) {
                if (lines.isEmpty()) {
                    if (line != null) continue;
                    break;
                }
                BackupInfo backupInfo = BackupInfo.decode(backupDirectory, lines);
                backupDirectory.addBackup(backupInfo);
                lines.clear();
                if (line != null) continue;
                break;
            }
            lines.add(line);
        }
        reader.close();
        return backupDirectory;
    }
}

