/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TimeZone;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.Base64;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupInfo {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String PROPERTY_BACKUP_DATE = "backup_date";
    public static final String PROPERTY_BACKUP_ID = "backup_id";
    public static final String PROPERTY_IS_INCREMENTAL = "incremental";
    public static final String PROPERTY_IS_COMPRESSED = "compressed";
    public static final String PROPERTY_IS_ENCRYPTED = "encrypted";
    public static final String PROPERTY_UNSIGNED_HASH = "hash";
    public static final String PROPERTY_SIGNED_HASH = "signed_hash";
    public static final String PROPERTY_DEPENDENCY = "dependency";
    public static final String PROPERTY_CUSTOM_PREFIX = "property.";
    private BackupDirectory backupDirectory;
    private boolean isCompressed;
    private boolean isEncrypted;
    private boolean isIncremental;
    private byte[] signedHash;
    private byte[] unsignedHash;
    private Date backupDate;
    private HashSet<String> dependencies;
    private HashMap<String, String> backupProperties;
    private String backupID;

    public BackupInfo(BackupDirectory backupDirectory, String backupID, Date backupDate, boolean isIncremental, boolean isCompressed, boolean isEncrypted, byte[] unsignedHash, byte[] signedHash, HashSet<String> dependencies, HashMap<String, String> backupProperties) {
        this.backupDirectory = backupDirectory;
        this.backupID = backupID;
        this.backupDate = backupDate;
        this.isIncremental = isIncremental;
        this.isCompressed = isCompressed;
        this.isEncrypted = isEncrypted;
        this.unsignedHash = unsignedHash;
        this.signedHash = signedHash;
        this.dependencies = dependencies == null ? new HashSet() : dependencies;
        this.backupProperties = backupProperties == null ? new HashMap() : backupProperties;
    }

    public BackupDirectory getBackupDirectory() {
        return this.backupDirectory;
    }

    public String getBackupID() {
        return this.backupID;
    }

    public Date getBackupDate() {
        return this.backupDate;
    }

    public boolean isIncremental() {
        return this.isIncremental;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public byte[] getUnsignedHash() {
        return this.unsignedHash;
    }

    public byte[] getSignedHash() {
        return this.signedHash;
    }

    public HashSet<String> getDependencies() {
        return this.dependencies;
    }

    public boolean dependsOn(String backupID) {
        return this.dependencies.contains(backupID);
    }

    public HashMap<String, String> getBackupProperties() {
        return this.backupProperties;
    }

    public String getBackupProperty(String name) {
        return this.backupProperties.get(name);
    }

    public LinkedList<String> encode() {
        LinkedList<String> list = new LinkedList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        list.add("backup_id=" + this.backupID);
        list.add("backup_date=" + dateFormat.format(this.backupDate));
        list.add("incremental=" + String.valueOf(this.isIncremental));
        list.add("compressed=" + String.valueOf(this.isCompressed));
        list.add("encrypted=" + String.valueOf(this.isEncrypted));
        if (this.unsignedHash != null) {
            list.add("hash=" + Base64.encode(this.unsignedHash));
        }
        if (this.signedHash != null) {
            list.add("signed_hash=" + Base64.encode(this.signedHash));
        }
        if (!this.dependencies.isEmpty()) {
            for (String dependency : this.dependencies) {
                list.add("dependency=" + dependency);
            }
        }
        if (!this.backupProperties.isEmpty()) {
            for (String name : this.backupProperties.keySet()) {
                String value = this.backupProperties.get(name);
                if (value == null) {
                    value = "";
                }
                list.add(PROPERTY_CUSTOM_PREFIX + name + "=" + value);
            }
        }
        return list;
    }

    public static BackupInfo decode(BackupDirectory backupDirectory, LinkedList<String> encodedInfo) throws ConfigException {
        String message;
        String backupID = null;
        Date backupDate = null;
        boolean isIncremental = false;
        boolean isCompressed = false;
        boolean isEncrypted = false;
        byte[] unsignedHash = null;
        byte[] signedHash = null;
        HashSet<String> dependencies = new HashSet<String>();
        HashMap<String, String> backupProperties = new HashMap<String, String>();
        String backupPath = backupDirectory.getPath();
        try {
            for (String line : encodedInfo) {
                String message2;
                int equalPos = line.indexOf(61);
                if (equalPos < 0) {
                    int msgID = 262436;
                    message2 = MessageHandler.getMessage(msgID, line, backupPath);
                    throw new ConfigException(msgID, message2);
                }
                if (equalPos == 0) {
                    int msgID = 262437;
                    message2 = MessageHandler.getMessage(msgID, line, backupPath);
                    throw new ConfigException(msgID, message2);
                }
                String name = line.substring(0, equalPos);
                String value = line.substring(equalPos + 1);
                if (name.equals(PROPERTY_BACKUP_ID)) {
                    if (backupID == null) {
                        backupID = value;
                        continue;
                    }
                    int msgID = 262438;
                    String message3 = MessageHandler.getMessage(msgID, backupPath, backupID, value);
                    throw new ConfigException(msgID, message3);
                }
                if (name.equals(PROPERTY_BACKUP_DATE)) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    backupDate = dateFormat.parse(value);
                    continue;
                }
                if (name.equals(PROPERTY_IS_INCREMENTAL)) {
                    isIncremental = Boolean.valueOf(value);
                    continue;
                }
                if (name.equals(PROPERTY_IS_COMPRESSED)) {
                    isCompressed = Boolean.valueOf(value);
                    continue;
                }
                if (name.equals(PROPERTY_IS_ENCRYPTED)) {
                    isEncrypted = Boolean.valueOf(value);
                    continue;
                }
                if (name.equals(PROPERTY_UNSIGNED_HASH)) {
                    unsignedHash = Base64.decode(value);
                    continue;
                }
                if (name.equals(PROPERTY_SIGNED_HASH)) {
                    signedHash = Base64.decode(value);
                    continue;
                }
                if (name.equals(PROPERTY_DEPENDENCY)) {
                    dependencies.add(value);
                    continue;
                }
                if (name.startsWith(PROPERTY_CUSTOM_PREFIX)) {
                    String propertyName = name.substring(PROPERTY_CUSTOM_PREFIX.length());
                    backupProperties.put(propertyName, value);
                    continue;
                }
                int msgID = 262439;
                String message4 = MessageHandler.getMessage(msgID, backupPath, name, value);
                throw new ConfigException(msgID, message4);
            }
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 262440;
            String message5 = MessageHandler.getMessage(msgID, backupPath, StaticUtils.getExceptionMessage(e));
            throw new ConfigException(msgID, message5, e);
        }
        if (backupID == null) {
            int msgID = 262441;
            message = MessageHandler.getMessage(msgID, backupPath);
            throw new ConfigException(msgID, message);
        }
        if (backupDate == null) {
            int msgID = 262442;
            message = MessageHandler.getMessage(msgID, backupID, backupPath);
            throw new ConfigException(msgID, message);
        }
        return new BackupInfo(backupDirectory, backupID, backupDate, isIncremental, isCompressed, isEncrypted, unsignedHash, signedHash, dependencies, backupProperties);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        LinkedList<String> lines = this.encode();
        for (String line : lines) {
            buffer.append(line);
            buffer.append(ServerConstants.EOL);
        }
    }
}

