/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.Serializable;
import java.util.ArrayList;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DN
implements Comparable<DN>,
Serializable {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static DN NULL_DN = new DN();
    private static final long serialVersionUID = 1184263456768819888L;
    private int numComponents;
    private RDN[] rdnComponents;
    private String dnString;
    private String normalizedDN;

    public DN() {
        this(new RDN[0]);
    }

    public DN(RDN[] rdnComponents) {
        this.rdnComponents = rdnComponents == null ? new RDN[0] : rdnComponents;
        this.numComponents = this.rdnComponents.length;
        this.dnString = null;
        this.normalizedDN = this.toNormalizedString();
    }

    public DN(ArrayList<RDN> rdnComponents) {
        if (rdnComponents == null || rdnComponents.isEmpty()) {
            this.rdnComponents = new RDN[0];
        } else {
            this.rdnComponents = new RDN[rdnComponents.size()];
            rdnComponents.toArray(this.rdnComponents);
        }
        this.numComponents = this.rdnComponents.length;
        this.dnString = null;
        this.normalizedDN = this.toNormalizedString();
    }

    public static DN nullDN() {
        return NULL_DN;
    }

    public boolean isNullDN() {
        return this.numComponents == 0;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public RDN getRDN() {
        if (this.numComponents == 0) {
            return null;
        }
        return this.rdnComponents[0];
    }

    public RDN getRDN(int pos) {
        return this.rdnComponents[pos];
    }

    public DN getParent() {
        if (this.numComponents <= 1) {
            return null;
        }
        RDN[] parentComponents = new RDN[this.numComponents - 1];
        System.arraycopy(this.rdnComponents, 1, parentComponents, 0, this.numComponents - 1);
        return new DN(parentComponents);
    }

    public DN getParentDNInSuffix() {
        if (this.numComponents <= 1 || DirectoryServer.isNamingContext(this)) {
            return null;
        }
        RDN[] parentComponents = new RDN[this.numComponents - 1];
        System.arraycopy(this.rdnComponents, 1, parentComponents, 0, this.numComponents - 1);
        return new DN(parentComponents);
    }

    public DN concat(RDN rdn) {
        RDN[] newComponents = new RDN[this.rdnComponents.length + 1];
        newComponents[0] = rdn;
        System.arraycopy(this.rdnComponents, 0, newComponents, 1, this.rdnComponents.length);
        return new DN(newComponents);
    }

    public DN concat(RDN[] rdnComponents) {
        RDN[] newComponents = new RDN[rdnComponents.length + this.rdnComponents.length];
        System.arraycopy(rdnComponents, 0, newComponents, 0, rdnComponents.length);
        System.arraycopy(this.rdnComponents, 0, newComponents, rdnComponents.length, this.rdnComponents.length);
        return new DN(newComponents);
    }

    public DN concat(DN relativeBaseDN) {
        RDN[] newComponents = new RDN[this.rdnComponents.length + relativeBaseDN.rdnComponents.length];
        System.arraycopy(relativeBaseDN.rdnComponents, 0, newComponents, 0, relativeBaseDN.rdnComponents.length);
        System.arraycopy(this.rdnComponents, 0, newComponents, relativeBaseDN.rdnComponents.length, this.rdnComponents.length);
        return new DN(newComponents);
    }

    public boolean isDescendantOf(DN dn) {
        int offset = this.numComponents - dn.numComponents;
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < dn.numComponents; ++i) {
            if (this.rdnComponents[i + offset].equals(dn.rdnComponents[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestorOf(DN dn) {
        int offset = dn.numComponents - this.numComponents;
        if (offset < 0) {
            return false;
        }
        for (int i = 0; i < this.numComponents; ++i) {
            if (this.rdnComponents[i].equals(dn.rdnComponents[i + offset])) continue;
            return false;
        }
        return true;
    }

    public boolean matchesBaseAndScope(DN baseDN, SearchScope scope) {
        switch (scope) {
            case BASE_OBJECT: {
                return this.equals(baseDN);
            }
            case SINGLE_LEVEL: {
                return baseDN.equals(this.getParent());
            }
            case WHOLE_SUBTREE: {
                return this.isDescendantOf(baseDN);
            }
            case SUBORDINATE_SUBTREE: {
                return !this.equals(baseDN) && this.isDescendantOf(baseDN);
            }
        }
        return false;
    }

    public static DN decode(ByteString dnString) throws DirectoryException {
        if (dnString == null) {
            return new DN(new ArrayList<RDN>(0));
        }
        byte[] dnBytes = dnString.value();
        int length = dnBytes.length;
        if (length == 0) {
            return new DN(new ArrayList<RDN>(0));
        }
        for (byte b : dnBytes) {
            if ((b & 0x7F) == b && b != 92) continue;
            return DN.decode(dnString.stringValue());
        }
        int pos = 0;
        byte b = dnBytes[pos];
        while (b == 32) {
            if (++pos == length) {
                return new DN(new ArrayList<RDN>(0));
            }
            b = dnBytes[pos];
        }
        boolean allowExceptions = DirectoryServer.allowAttributeNameExceptions();
        ArrayList<RDN> rdnComponents = new ArrayList<RDN>();
        block2: while (true) {
            String message;
            StringBuilder attributeName;
            if ((pos = DN.parseAttributeName(dnBytes, pos, attributeName = new StringBuilder(), allowExceptions)) >= length) {
                int msgID = 6488099;
                message = MessageHandler.getMessage(msgID, dnString.stringValue(), attributeName.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
            }
            b = dnBytes[pos];
            while (b == 32) {
                if (++pos >= length) {
                    int msgID = 6488099;
                    message = MessageHandler.getMessage(msgID, dnString.stringValue(), attributeName.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                b = dnBytes[pos];
            }
            if (b == 61) {
                ++pos;
            } else {
                int msgID = 6488100;
                message = MessageHandler.getMessage(msgID, dnString.stringValue(), attributeName.toString(), Character.valueOf((char)b));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
            }
            while (pos < length && (b = dnBytes[pos]) == 32) {
                ++pos;
            }
            if (pos >= length) {
                String name = attributeName.toString();
                String lowerName = StaticUtils.toLowerCase(name);
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(name);
                }
                AttributeValue value = new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString());
                rdnComponents.add(new RDN(attrType, name, value));
                return new DN(rdnComponents);
            }
            ASN1OctetString parsedValue = new ASN1OctetString();
            pos = DN.parseAttributeValue(dnBytes, pos, (ByteString)parsedValue);
            String name = attributeName.toString();
            String lowerName = StaticUtils.toLowerCase(name);
            AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
            if (attrType == null) {
                attrType = DirectoryServer.getDefaultAttributeType(name);
            }
            AttributeValue value = new AttributeValue(attrType, (ByteString)parsedValue);
            RDN rdn = new RDN(attrType, name, value);
            while (pos < length && (b = dnBytes[pos]) == 32) {
                ++pos;
            }
            if (pos >= length) {
                rdnComponents.add(rdn);
                return new DN(rdnComponents);
            }
            if (b == 44 || b == 59) {
                rdnComponents.add(rdn);
                ++pos;
                continue;
            }
            if (b != 43) {
                int msgID = 6488101;
                String message2 = MessageHandler.getMessage(msgID, new String(dnBytes), Character.valueOf((char)b), pos);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message2, msgID);
            }
            do {
                ++pos;
                while (pos < length && dnBytes[pos] == 32) {
                    ++pos;
                }
                attributeName = new StringBuilder();
                if ((pos = DN.parseAttributeName(dnBytes, pos, attributeName, allowExceptions)) >= length) {
                    int msgID = 6488099;
                    String message3 = MessageHandler.getMessage(msgID, dnString.stringValue(), attributeName.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message3, msgID);
                }
                b = dnBytes[pos];
                while (b == 32) {
                    if (++pos >= length) {
                        int msgID = 6488099;
                        String message4 = MessageHandler.getMessage(msgID, dnString.stringValue(), attributeName.toString());
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message4, msgID);
                    }
                    b = dnBytes[pos];
                }
                if (b == 61) {
                    ++pos;
                } else {
                    int msgID = 6488100;
                    String message5 = MessageHandler.getMessage(msgID, dnString.stringValue(), attributeName.toString(), Character.valueOf((char)b));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message5, msgID);
                }
                while (pos < length && (b = dnBytes[pos]) == 32) {
                    ++pos;
                }
                if (pos >= length) {
                    name = attributeName.toString();
                    lowerName = StaticUtils.toLowerCase(name);
                    attrType = DirectoryServer.getAttributeType(lowerName);
                    if (attrType == null) {
                        attrType = DirectoryServer.getDefaultAttributeType(name);
                    }
                    value = new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString());
                    rdn.addValue(attrType, name, value);
                    rdnComponents.add(rdn);
                    return new DN(rdnComponents);
                }
                parsedValue = new ASN1OctetString();
                pos = DN.parseAttributeValue(dnBytes, pos, (ByteString)parsedValue);
                name = attributeName.toString();
                lowerName = StaticUtils.toLowerCase(name);
                attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(name);
                }
                value = new AttributeValue(attrType, (ByteString)parsedValue);
                rdn.addValue(attrType, name, value);
                while (pos < length && (b = dnBytes[pos]) == 32) {
                    ++pos;
                }
                if (pos >= length) {
                    rdnComponents.add(rdn);
                    return new DN(rdnComponents);
                }
                if (b != 44 && b != 59) continue;
                rdnComponents.add(rdn);
                ++pos;
                continue block2;
            } while (b == 43);
            break;
        }
        int msgID = 6488101;
        String message = MessageHandler.getMessage(msgID, dnString.stringValue(), Character.valueOf((char)b), pos);
        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
    }

    public static DN decode(String dnString) throws DirectoryException {
        if (dnString == null) {
            return new DN(new ArrayList<RDN>(0));
        }
        int length = dnString.length();
        if (length == 0) {
            return new DN(new ArrayList<RDN>(0));
        }
        int pos = 0;
        char c = dnString.charAt(pos);
        while (c == ' ') {
            if (++pos == length) {
                return new DN(new ArrayList<RDN>(0));
            }
            c = dnString.charAt(pos);
        }
        boolean allowExceptions = DirectoryServer.allowAttributeNameExceptions();
        ArrayList<RDN> rdnComponents = new ArrayList<RDN>();
        block1: while (true) {
            String message;
            StringBuilder attributeName;
            if ((pos = DN.parseAttributeName(dnString, pos, attributeName = new StringBuilder(), allowExceptions)) >= length) {
                int msgID = 6488099;
                message = MessageHandler.getMessage(msgID, dnString, attributeName.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
            }
            c = dnString.charAt(pos);
            while (c == ' ') {
                if (++pos >= length) {
                    int msgID = 6488099;
                    message = MessageHandler.getMessage(msgID, dnString, attributeName.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                c = dnString.charAt(pos);
            }
            if (c == '=') {
                ++pos;
            } else {
                int msgID = 6488100;
                message = MessageHandler.getMessage(msgID, dnString, attributeName.toString(), Character.valueOf(c));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
            }
            while (pos < length && (c = dnString.charAt(pos)) == ' ') {
                ++pos;
            }
            if (pos >= length) {
                String name = attributeName.toString();
                String lowerName = StaticUtils.toLowerCase(name);
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(name);
                }
                AttributeValue value = new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString());
                rdnComponents.add(new RDN(attrType, name, value));
                return new DN(rdnComponents);
            }
            ASN1OctetString parsedValue = new ASN1OctetString();
            pos = DN.parseAttributeValue(dnString, pos, (ByteString)parsedValue);
            String name = attributeName.toString();
            String lowerName = StaticUtils.toLowerCase(name);
            AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
            if (attrType == null) {
                attrType = DirectoryServer.getDefaultAttributeType(name);
            }
            AttributeValue value = new AttributeValue(attrType, (ByteString)parsedValue);
            RDN rdn = new RDN(attrType, name, value);
            while (pos < length && (c = dnString.charAt(pos)) == ' ') {
                ++pos;
            }
            if (pos >= length) {
                rdnComponents.add(rdn);
                return new DN(rdnComponents);
            }
            if (c == ',' || c == ';') {
                rdnComponents.add(rdn);
                ++pos;
                continue;
            }
            if (c != '+') {
                int msgID = 6488101;
                String message2 = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c), pos);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message2, msgID);
            }
            do {
                ++pos;
                while (pos < length && dnString.charAt(pos) == ' ') {
                    ++pos;
                }
                attributeName = new StringBuilder();
                if ((pos = DN.parseAttributeName(dnString, pos, attributeName, allowExceptions)) >= length) {
                    int msgID = 6488099;
                    String message3 = MessageHandler.getMessage(msgID, dnString, attributeName.toString());
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message3, msgID);
                }
                c = dnString.charAt(pos);
                while (c == ' ') {
                    if (++pos >= length) {
                        int msgID = 6488099;
                        String message4 = MessageHandler.getMessage(msgID, dnString, attributeName.toString());
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message4, msgID);
                    }
                    c = dnString.charAt(pos);
                }
                if (c == '=') {
                    ++pos;
                } else {
                    int msgID = 6488100;
                    String message5 = MessageHandler.getMessage(msgID, dnString, attributeName.toString(), Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message5, msgID);
                }
                while (pos < length && (c = dnString.charAt(pos)) == ' ') {
                    ++pos;
                }
                if (pos >= length) {
                    name = attributeName.toString();
                    lowerName = StaticUtils.toLowerCase(name);
                    attrType = DirectoryServer.getAttributeType(lowerName);
                    if (attrType == null) {
                        attrType = DirectoryServer.getDefaultAttributeType(name);
                    }
                    value = new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString());
                    rdn.addValue(attrType, name, value);
                    rdnComponents.add(rdn);
                    return new DN(rdnComponents);
                }
                parsedValue = new ASN1OctetString();
                pos = DN.parseAttributeValue(dnString, pos, (ByteString)parsedValue);
                name = attributeName.toString();
                lowerName = StaticUtils.toLowerCase(name);
                attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(name);
                }
                value = new AttributeValue(attrType, (ByteString)parsedValue);
                rdn.addValue(attrType, name, value);
                while (pos < length && (c = dnString.charAt(pos)) == ' ') {
                    ++pos;
                }
                if (pos >= length) {
                    rdnComponents.add(rdn);
                    return new DN(rdnComponents);
                }
                if (c != ',' && c != ';') continue;
                rdnComponents.add(rdn);
                ++pos;
                continue block1;
            } while (c == '+');
            break;
        }
        int msgID = 6488101;
        String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c), pos);
        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
    }

    static int parseAttributeName(byte[] dnBytes, int pos, StringBuilder attributeName, boolean allowExceptions) throws DirectoryException {
        int msgID;
        int length = dnBytes.length;
        if (pos < length) {
            while (dnBytes[pos] == 32) {
                if (++pos != length) continue;
                int msgID2 = 6488090;
                String message = MessageHandler.getMessage(msgID2, new String(dnBytes));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID2);
            }
        }
        boolean checkForOID = false;
        boolean endOfName = false;
        while (pos < length) {
            byte b = dnBytes[pos];
            switch (b) {
                case 32: {
                    endOfName = true;
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    int msgID3 = 6488092;
                    String message = MessageHandler.getMessage(msgID3, new String(dnBytes), Character.valueOf((char)b), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                }
                case 45: {
                    if (attributeName.length() > 0) {
                        attributeName.append((char)b);
                        break;
                    }
                    int msgID3 = 6488094;
                    String message = MessageHandler.getMessage(msgID3, new String(dnBytes), Character.valueOf((char)b));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                }
                case 46: {
                    attributeName.append((char)b);
                    checkForOID = true;
                    break;
                }
                case 47: {
                    int msgID3 = 6488092;
                    String message = MessageHandler.getMessage(msgID3, new String(dnBytes), Character.valueOf((char)b), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    attributeName.append((char)b);
                    break;
                }
                case 58: 
                case 59: 
                case 60: {
                    int msgID3 = 6488092;
                    String message = MessageHandler.getMessage(msgID3, new String(dnBytes), Character.valueOf((char)b), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                }
                case 61: {
                    endOfName = true;
                    break;
                }
                case 62: 
                case 63: 
                case 64: {
                    int msgID3 = 6488092;
                    String message = MessageHandler.getMessage(msgID3, new String(dnBytes), Character.valueOf((char)b), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: {
                    attributeName.append((char)b);
                    break;
                }
                case 91: 
                case 92: 
                case 93: 
                case 94: {
                    int msgID3 = 6488092;
                    String message = MessageHandler.getMessage(msgID3, new String(dnBytes), Character.valueOf((char)b), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                }
                case 95: {
                    if (attributeName.length() == 0) {
                        int msgID3 = 6488095;
                        String message = MessageHandler.getMessage(msgID3, new String(dnBytes), "ds-cfg-allow-attribute-name-exceptions");
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                    }
                    if (allowExceptions) {
                        attributeName.append((char)b);
                        break;
                    }
                    int msgID4 = 6488093;
                    String message = MessageHandler.getMessage(msgID4, new String(dnBytes), "ds-cfg-allow-attribute-name-exceptions");
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID4);
                }
                case 96: {
                    int msgID4 = 6488092;
                    String message = MessageHandler.getMessage(msgID4, new String(dnBytes), Character.valueOf((char)b), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID4);
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    attributeName.append((char)b);
                    break;
                }
                default: {
                    int msgID4 = 6488092;
                    String message = MessageHandler.getMessage(msgID4, new String(dnBytes), Character.valueOf((char)b), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID4);
                }
            }
            if (endOfName) break;
            ++pos;
        }
        if (attributeName.length() == 0) {
            msgID = 6488097;
            String message = MessageHandler.getMessage(msgID, new String(dnBytes));
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
        }
        if (checkForOID) {
            boolean validOID = true;
            int namePos = 0;
            int nameLength = attributeName.length();
            char ch = attributeName.charAt(0);
            if (ch == 'o' || ch == 'O') {
                if (nameLength <= 4) {
                    validOID = false;
                } else {
                    ch = attributeName.charAt(1);
                    if (!(ch != 'i' && ch != 'I' || (ch = attributeName.charAt(2)) != 'd' && ch != 'D' || attributeName.charAt(3) != '.')) {
                        attributeName.delete(0, 4);
                        nameLength -= 4;
                    } else {
                        validOID = false;
                    }
                }
            }
            while (validOID && namePos < nameLength) {
                if (StaticUtils.isDigit(ch = attributeName.charAt(namePos++))) {
                    while (validOID && namePos < nameLength && StaticUtils.isDigit(attributeName.charAt(namePos))) {
                        ++namePos;
                    }
                    if (namePos >= nameLength || attributeName.charAt(namePos) == '.') continue;
                    validOID = false;
                    continue;
                }
                if (ch == '.') {
                    if (namePos != 1 && attributeName.charAt(namePos - 2) != '.') continue;
                    validOID = false;
                    continue;
                }
                validOID = false;
            }
            if (validOID && attributeName.charAt(nameLength - 1) == '.') {
                validOID = false;
            }
            if (!validOID) {
                int msgID5 = 6488098;
                String message = MessageHandler.getMessage(msgID5, new String(dnBytes), attributeName.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID5);
            }
        } else if (StaticUtils.isDigit(attributeName.charAt(0)) && !allowExceptions) {
            msgID = 6488096;
            String message = MessageHandler.getMessage(msgID, new String(dnBytes), Character.valueOf(attributeName.charAt(0)), "ds-cfg-allow-attribute-name-exceptions");
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
        }
        return pos;
    }

    static int parseAttributeName(String dnString, int pos, StringBuilder attributeName, boolean allowExceptions) throws DirectoryException {
        int msgID;
        int length = dnString.length();
        if (pos < length) {
            while (dnString.charAt(pos) == ' ') {
                if (++pos != length) continue;
                int msgID2 = 6488090;
                String message = MessageHandler.getMessage(msgID2, dnString);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID2);
            }
        }
        boolean checkForOID = false;
        boolean endOfName = false;
        while (pos < length) {
            char c = dnString.charAt(pos);
            switch (c) {
                case ' ': {
                    endOfName = true;
                    break;
                }
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': {
                    int msgID3 = 6488092;
                    String message = MessageHandler.getMessage(msgID3, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                }
                case '-': {
                    if (attributeName.length() > 0) {
                        attributeName.append(c);
                        break;
                    }
                    int msgID3 = 6488094;
                    String message = MessageHandler.getMessage(msgID3, dnString, Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                }
                case '.': {
                    attributeName.append(c);
                    checkForOID = true;
                    break;
                }
                case '/': {
                    int msgID3 = 6488092;
                    String message = MessageHandler.getMessage(msgID3, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    attributeName.append(c);
                    break;
                }
                case ':': 
                case ';': 
                case '<': {
                    int msgID3 = 6488092;
                    String message = MessageHandler.getMessage(msgID3, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                }
                case '=': {
                    endOfName = true;
                    break;
                }
                case '>': 
                case '?': 
                case '@': {
                    int msgID3 = 6488092;
                    String message = MessageHandler.getMessage(msgID3, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    attributeName.append(c);
                    break;
                }
                case '[': 
                case '\\': 
                case ']': 
                case '^': {
                    int msgID3 = 6488092;
                    String message = MessageHandler.getMessage(msgID3, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                }
                case '_': {
                    if (attributeName.length() == 0) {
                        int msgID3 = 6488095;
                        String message = MessageHandler.getMessage(msgID3, dnString, "ds-cfg-allow-attribute-name-exceptions");
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID3);
                    }
                    if (allowExceptions) {
                        attributeName.append(c);
                        break;
                    }
                    int msgID4 = 6488093;
                    String message = MessageHandler.getMessage(msgID4, dnString, "ds-cfg-allow-attribute-name-exceptions");
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID4);
                }
                case '`': {
                    int msgID4 = 6488092;
                    String message = MessageHandler.getMessage(msgID4, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID4);
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    attributeName.append(c);
                    break;
                }
                default: {
                    int msgID4 = 6488092;
                    String message = MessageHandler.getMessage(msgID4, dnString, Character.valueOf(c), pos);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID4);
                }
            }
            if (endOfName) break;
            ++pos;
        }
        if (attributeName.length() == 0) {
            msgID = 6488097;
            String message = MessageHandler.getMessage(msgID, dnString);
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
        }
        if (checkForOID) {
            boolean validOID = true;
            int namePos = 0;
            int nameLength = attributeName.length();
            char ch = attributeName.charAt(0);
            if (ch == 'o' || ch == 'O') {
                if (nameLength <= 4) {
                    validOID = false;
                } else {
                    ch = attributeName.charAt(1);
                    if (!(ch != 'i' && ch != 'I' || (ch = attributeName.charAt(2)) != 'd' && ch != 'D' || attributeName.charAt(3) != '.')) {
                        attributeName.delete(0, 4);
                        nameLength -= 4;
                    } else {
                        validOID = false;
                    }
                }
            }
            while (validOID && namePos < nameLength) {
                if (StaticUtils.isDigit(ch = attributeName.charAt(namePos++))) {
                    while (validOID && namePos < nameLength && StaticUtils.isDigit(attributeName.charAt(namePos))) {
                        ++namePos;
                    }
                    if (namePos >= nameLength || attributeName.charAt(namePos) == '.') continue;
                    validOID = false;
                    continue;
                }
                if (ch == '.') {
                    if (namePos != 1 && attributeName.charAt(namePos - 2) != '.') continue;
                    validOID = false;
                    continue;
                }
                validOID = false;
            }
            if (validOID && attributeName.charAt(nameLength - 1) == '.') {
                validOID = false;
            }
            if (!validOID) {
                int msgID5 = 6488098;
                String message = MessageHandler.getMessage(msgID5, dnString, attributeName.toString());
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID5);
            }
        } else if (StaticUtils.isDigit(attributeName.charAt(0)) && !allowExceptions) {
            msgID = 6488096;
            String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(attributeName.charAt(0)), "ds-cfg-allow-attribute-name-exceptions");
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
        }
        return pos;
    }

    static int parseAttributeValue(byte[] dnBytes, int pos, ByteString attributeValue) throws DirectoryException {
        int lastPos;
        byte b;
        int length = dnBytes.length;
        if (pos >= length) {
            attributeValue.setValue("");
            return pos;
        }
        if ((b = dnBytes[pos++]) == 35) {
            StringBuilder hexString = new StringBuilder();
            if (pos + 2 > length) {
                int msgID = 6488102;
                String message = MessageHandler.getMessage(msgID, new String(dnBytes));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
            }
            for (int i = 0; i < 2; ++i) {
                if (!StaticUtils.isHexDigit(b = dnBytes[pos++])) {
                    int msgID = 6488103;
                    String message = MessageHandler.getMessage(msgID, new String(dnBytes), Character.valueOf((char)b));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                hexString.append((char)b);
            }
            while (pos < length) {
                int msgID;
                if (StaticUtils.isHexDigit(b = dnBytes[pos++])) {
                    hexString.append((char)b);
                    if (pos < length) {
                        if (StaticUtils.isHexDigit(b = dnBytes[pos++])) {
                            hexString.append((char)b);
                            continue;
                        }
                        msgID = 6488103;
                        String message = MessageHandler.getMessage(msgID, new String(dnBytes), Character.valueOf((char)b));
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                    }
                    msgID = 6488102;
                    String message = MessageHandler.getMessage(msgID, new String(dnBytes));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                if (b == 32 || b == 44 || b == 59 || b == 43) {
                    --pos;
                    break;
                }
                msgID = 6488103;
                String message = MessageHandler.getMessage(msgID, new String(dnBytes), Character.valueOf((char)b));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
            }
            try {
                attributeValue.setValue(StaticUtils.hexStringToByteArray(hexString.toString()));
                return pos;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 6488104;
                String message = MessageHandler.getMessage(msgID, new String(dnBytes), String.valueOf(e));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
            }
        }
        if (b == 34) {
            int valueStartPos = pos;
            do {
                if (pos < length) continue;
                int msgID = 6488105;
                String message = MessageHandler.getMessage(msgID, new String(dnBytes));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
            } while (dnBytes[pos++] != 34);
            byte[] valueBytes = new byte[pos - valueStartPos - 1];
            System.arraycopy(dnBytes, valueStartPos, valueBytes, 0, valueBytes.length);
            try {
                attributeValue.setValue(valueBytes);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                String valueStr = new String(valueBytes);
                attributeValue.setValue(valueStr);
            }
            return pos;
        }
        int valueStartPos = pos - 1;
        while (pos < length) {
            if ((b = dnBytes[pos++]) != 44 && b != 59 && b != 43) continue;
            --pos;
            break;
        }
        byte[] valueBytes = new byte[pos - valueStartPos];
        System.arraycopy(dnBytes, valueStartPos, valueBytes, 0, valueBytes.length);
        boolean extraSpaces = false;
        for (lastPos = valueBytes.length - 1; lastPos > 0 && valueBytes[lastPos] == 32; --lastPos) {
            extraSpaces = true;
        }
        if (extraSpaces) {
            byte[] newValueBytes = new byte[lastPos + 1];
            System.arraycopy(valueBytes, 0, newValueBytes, 0, lastPos + 1);
            valueBytes = newValueBytes;
        }
        try {
            attributeValue.setValue(valueBytes);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            String valueStr = new String(valueBytes);
            attributeValue.setValue(valueStr);
        }
        return pos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int parseAttributeValue(String dnString, int pos, ByteString attributeValue) throws DirectoryException {
        boolean escaped;
        StringBuilder hexChars;
        StringBuilder valueString;
        char c;
        int length = dnString.length();
        if (pos >= length) {
            attributeValue.setValue("");
            return pos;
        }
        if ((c = dnString.charAt(pos++)) == '#') {
            StringBuilder hexString = new StringBuilder();
            if (pos + 2 > length) {
                int msgID = 6488102;
                String message = MessageHandler.getMessage(msgID, dnString);
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
            }
            for (int i = 0; i < 2; ++i) {
                if (!StaticUtils.isHexDigit(c = dnString.charAt(pos++))) {
                    int msgID = 6488103;
                    String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                hexString.append(c);
            }
            while (pos < length) {
                int msgID;
                if (StaticUtils.isHexDigit(c = dnString.charAt(pos++))) {
                    hexString.append(c);
                    if (pos >= length) {
                        msgID = 6488102;
                        String message = MessageHandler.getMessage(msgID, dnString);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                    }
                    if (!StaticUtils.isHexDigit(c = dnString.charAt(pos++))) {
                        msgID = 6488103;
                        String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c));
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                    }
                    hexString.append(c);
                    continue;
                }
                if (c != ' ' && c != ',' && c != ';') {
                    msgID = 6488103;
                    String message = MessageHandler.getMessage(msgID, dnString, Character.valueOf(c));
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                --pos;
                break;
            }
            try {
                attributeValue.setValue(StaticUtils.hexStringToByteArray(hexString.toString()));
                return pos;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                int msgID = 6488104;
                String message = MessageHandler.getMessage(msgID, dnString, String.valueOf(e));
                throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
            }
        }
        if (c != '\"') {
            valueString = new StringBuilder();
            hexChars = new StringBuilder();
            if (c == '\\') {
                escaped = true;
            } else {
                escaped = false;
                valueString.append(c);
            }
        } else {
            boolean escaped2 = false;
            StringBuilder valueString2 = new StringBuilder();
            while (true) {
                if (pos >= length) {
                    int msgID = 6488105;
                    String message = MessageHandler.getMessage(msgID, dnString);
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                }
                c = dnString.charAt(pos++);
                if (escaped2) {
                    valueString2.append(c);
                    escaped2 = false;
                    continue;
                }
                if (c == '\\') {
                    escaped2 = true;
                    continue;
                }
                if (c == '\"') {
                    attributeValue.setValue(valueString2.toString());
                    return pos;
                }
                valueString2.append(c);
            }
        }
        while (true) {
            if (pos >= length) {
                DN.appendHexChars(dnString, valueString, hexChars);
                break;
            }
            c = dnString.charAt(pos++);
            if (escaped) {
                if (StaticUtils.isHexDigit(c)) {
                    char c2;
                    if (pos >= length) {
                        int msgID = 6488106;
                        String message = MessageHandler.getMessage(msgID, dnString);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                    }
                    if (!StaticUtils.isHexDigit(c2 = dnString.charAt(pos++))) {
                        int msgID = 6488106;
                        String message = MessageHandler.getMessage(msgID, dnString);
                        throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
                    }
                    hexChars.append(c);
                    hexChars.append(c2);
                } else {
                    DN.appendHexChars(dnString, valueString, hexChars);
                    valueString.append(c);
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == ',' || c == ';') {
                DN.appendHexChars(dnString, valueString, hexChars);
                --pos;
                break;
            }
            if (c == '+') {
                DN.appendHexChars(dnString, valueString, hexChars);
                --pos;
                break;
            }
            DN.appendHexChars(dnString, valueString, hexChars);
            valueString.append(c);
        }
        if (pos > 2 && dnString.charAt(pos - 1) == ' ' && dnString.charAt(pos - 2) != '\\') {
            for (int lastPos = valueString.length() - 1; lastPos > 0 && valueString.charAt(lastPos) == ' '; --lastPos) {
                valueString.delete(lastPos, lastPos + 1);
            }
        }
        attributeValue.setValue(valueString.toString());
        return pos;
    }

    private static void appendHexChars(String dnString, StringBuilder valueString, StringBuilder hexChars) throws DirectoryException {
        try {
            byte[] hexBytes = StaticUtils.hexStringToByteArray(hexChars.toString());
            valueString.append(new String(hexBytes, "UTF-8"));
            hexChars.delete(0, hexChars.length());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 6488104;
            String message = MessageHandler.getMessage(msgID, dnString, String.valueOf(e));
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, msgID);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        try {
            return this.normalizedDN.equals(((DN)o).normalizedDN);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    public int hashCode() {
        return this.normalizedDN.hashCode();
    }

    public String toString() {
        if (this.dnString == null) {
            if (this.numComponents == 0) {
                this.dnString = "";
            } else {
                StringBuilder buffer = new StringBuilder();
                this.rdnComponents[0].toString(buffer);
                for (int i = 1; i < this.numComponents; ++i) {
                    buffer.append(",");
                    this.rdnComponents[i].toString(buffer);
                }
                this.dnString = buffer.toString();
            }
        }
        return this.dnString;
    }

    public void toString(StringBuilder buffer) {
        buffer.append(this.toString());
    }

    public String toNormalizedString() {
        if (this.normalizedDN == null) {
            if (this.numComponents == 0) {
                this.normalizedDN = "";
            } else {
                StringBuilder buffer = new StringBuilder();
                this.rdnComponents[0].toNormalizedString(buffer);
                for (int i = 1; i < this.numComponents; ++i) {
                    buffer.append(',');
                    this.rdnComponents[i].toNormalizedString(buffer);
                }
                this.normalizedDN = buffer.toString();
            }
        }
        return this.normalizedDN;
    }

    public void toNormalizedString(StringBuilder buffer) {
        buffer.append(this.toNormalizedString());
    }

    @Override
    public int compareTo(DN dn) {
        if (this.equals(dn)) {
            return 0;
        }
        if (this.isNullDN()) {
            return -1;
        }
        if (dn.isNullDN()) {
            return 1;
        }
        if (this.isAncestorOf(dn)) {
            return -1;
        }
        if (this.isDescendantOf(dn)) {
            return 1;
        }
        int minComps = Math.min(this.numComponents, dn.numComponents);
        for (int i = 0; i < minComps; ++i) {
            RDN r1 = this.rdnComponents[this.rdnComponents.length - 1 - i];
            RDN r2 = dn.rdnComponents[dn.rdnComponents.length - 1 - i];
            int result = r1.compareTo(r2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

