/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.List;
import org.opends.server.types.DN;
import org.opends.server.types.IdentifiedException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryException
extends IdentifiedException {
    private static final long serialVersionUID = 2615453139798417203L;
    private final DN matchedDN;
    private final int errorMessageID;
    private final List<String> referralURLs;
    private final ResultCode resultCode;
    private final String errorMessage;

    public DirectoryException(ResultCode resultCode, String errorMessage, int errorMessageID) {
        super(errorMessage);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.errorMessageID = errorMessageID;
        this.matchedDN = null;
        this.referralURLs = null;
    }

    public DirectoryException(ResultCode resultCode, String errorMessage, int errorMessageID, Throwable cause) {
        super(errorMessage, cause);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.errorMessageID = errorMessageID;
        this.matchedDN = null;
        this.referralURLs = null;
    }

    public DirectoryException(ResultCode resultCode, String errorMessage, int errorMessageID, DN matchedDN, Throwable cause) {
        super(errorMessage, cause);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.errorMessageID = errorMessageID;
        this.matchedDN = matchedDN;
        this.referralURLs = null;
    }

    public DirectoryException(ResultCode resultCode, String errorMessage, int errorMessageID, DN matchedDN, List<String> referralURLs, Throwable cause) {
        super(errorMessage, cause);
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.errorMessageID = errorMessageID;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs;
    }

    public final ResultCode getResultCode() {
        return this.resultCode;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public final int getMessageID() {
        return this.errorMessageID;
    }

    public final DN getMatchedDN() {
        return this.matchedDN;
    }

    public final List<String> getReferralURLs() {
        return this.referralURLs;
    }
}

