/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.HashMap;
import org.opends.server.messages.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ErrorLogSeverity {
    FATAL_ERROR(54),
    INFORMATIONAL(56),
    MILD_ERROR(57),
    MILD_WARNING(58),
    NOTICE(131),
    SEVERE_ERROR(59),
    SEVERE_WARNING(60);

    private static HashMap<String, ErrorLogSeverity> nameMap;
    private int severityID;
    private String severityName;

    private ErrorLogSeverity(int severityID) {
        this.severityID = severityID;
        this.severityName = null;
    }

    public static ErrorLogSeverity getByName(String name) {
        return nameMap.get(name);
    }

    public int getSeverityID() {
        return this.severityID;
    }

    public String getSeverityName() {
        if (this.severityName == null) {
            this.severityName = MessageHandler.getMessage(this.severityID);
        }
        return this.severityName;
    }

    public String toString() {
        return this.getSeverityName();
    }

    static {
        nameMap = new HashMap(10);
        nameMap.put("FATAL_ERROR", FATAL_ERROR);
        nameMap.put("INFO", INFORMATIONAL);
        nameMap.put("MILD_ERROR", MILD_ERROR);
        nameMap.put("MILD_WARNING", MILD_WARNING);
        nameMap.put("NOTICE", NOTICE);
        nameMap.put("SEVERE_ERROR", SEVERE_ERROR);
        nameMap.put("SEVERE_WARNING", SEVERE_WARNING);
    }
}

