/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.ObjectClassSyntax;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.Schema;
import org.opends.server.types.SchemaFileElement;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectClass
extends CommonSchemaElements
implements SchemaFileElement {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final Set<AttributeType> optionalAttributes;
    private final Set<AttributeType> optionalAttributesChain;
    private final Set<AttributeType> requiredAttributes;
    private final Set<AttributeType> requiredAttributesChain;
    private final ObjectClass superiorClass;
    private final ObjectClassType objectClassType;
    private final boolean isExtensibleObject;
    private final String definition;

    public ObjectClass(String definition, String primaryName, Collection<String> names, String oid, String description, ObjectClass superiorClass, Set<AttributeType> requiredAttributes, Set<AttributeType> optionalAttributes, ObjectClassType objectClassType, boolean isObsolete, Map<String, List<String>> extraProperties) {
        super(primaryName, names, oid, description, isObsolete, extraProperties);
        HashSet<AttributeType> tmp;
        Validator.ensureNotNull(definition, oid);
        this.superiorClass = superiorClass;
        int schemaFilePos = definition.indexOf("X-SCHEMA-FILE");
        if (schemaFilePos > 0) {
            String defStr;
            try {
                int firstQuotePos = definition.indexOf(39, schemaFilePos);
                int secondQuotePos = definition.indexOf(39, firstQuotePos + 1);
                defStr = definition.substring(0, schemaFilePos).trim() + " " + definition.substring(secondQuotePos + 1).trim();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                defStr = definition;
            }
            this.definition = defStr;
        } else {
            this.definition = definition;
        }
        this.isExtensibleObject = this.hasName("extensibleobject") || oid.equals("1.3.6.1.4.1.1466.101.120.111");
        this.requiredAttributes = requiredAttributes != null ? Collections.unmodifiableSet(new LinkedHashSet<AttributeType>(requiredAttributes)) : Collections.emptySet();
        if (this.superiorClass == null) {
            this.requiredAttributesChain = this.requiredAttributes;
        } else {
            tmp = new HashSet<AttributeType>(this.requiredAttributes);
            tmp.addAll(this.superiorClass.getRequiredAttributeChain());
            this.requiredAttributesChain = Collections.unmodifiableSet(tmp);
        }
        this.optionalAttributes = optionalAttributes != null ? Collections.unmodifiableSet(new LinkedHashSet<AttributeType>(optionalAttributes)) : Collections.emptySet();
        if (this.superiorClass == null) {
            this.optionalAttributesChain = this.optionalAttributes;
        } else {
            tmp = new HashSet<AttributeType>(this.optionalAttributes);
            tmp.addAll(this.superiorClass.getOptionalAttributeChain());
            this.optionalAttributesChain = Collections.unmodifiableSet(tmp);
        }
        this.objectClassType = objectClassType != null ? objectClassType : ObjectClassType.STRUCTURAL;
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    @Override
    public ObjectClass recreateFromDefinition() throws DirectoryException {
        ByteString value = ByteStringFactory.create(this.definition);
        Schema schema = DirectoryConfig.getSchema();
        ObjectClass oc = ObjectClassSyntax.decodeObjectClass(value, schema, false);
        oc.setSchemaFile(this.getSchemaFile());
        return oc;
    }

    public ObjectClass getSuperiorClass() {
        return this.superiorClass;
    }

    public boolean isDescendantOf(ObjectClass objectClass) {
        if (this.superiorClass == null) {
            return false;
        }
        return this.superiorClass.equals(objectClass) || this.superiorClass.isDescendantOf(objectClass);
    }

    public Set<AttributeType> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public Set<AttributeType> getRequiredAttributeChain() {
        return this.requiredAttributesChain;
    }

    public boolean isRequired(AttributeType attributeType) {
        return this.requiredAttributesChain.contains(attributeType);
    }

    public Set<AttributeType> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public Set<AttributeType> getOptionalAttributeChain() {
        return this.optionalAttributesChain;
    }

    public boolean isOptional(AttributeType attributeType) {
        if (this.optionalAttributesChain.contains(attributeType)) {
            return true;
        }
        return this.isExtensibleObject && !this.requiredAttributesChain.contains(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType) {
        return this.isRequired(attributeType) || this.isOptional(attributeType);
    }

    public ObjectClassType getObjectClassType() {
        return this.objectClassType;
    }

    public boolean isExtensibleObject() {
        return this.isExtensibleObject;
    }

    @Override
    protected void toStringContent(StringBuilder buffer) {
        String firstName;
        Iterator<AttributeType> iterator;
        if (this.superiorClass != null) {
            buffer.append(" SUP ");
            buffer.append(this.superiorClass.getNameOrOID());
        }
        if (this.objectClassType != null) {
            buffer.append(" ");
            buffer.append(this.objectClassType.toString());
        }
        if (!this.requiredAttributes.isEmpty()) {
            iterator = this.requiredAttributes.iterator();
            firstName = iterator.next().getNameOrOID();
            if (iterator.hasNext()) {
                buffer.append(" MUST ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next().getNameOrOID());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MUST ");
                buffer.append(firstName);
            }
        }
        if (!this.optionalAttributes.isEmpty()) {
            iterator = this.optionalAttributes.iterator();
            firstName = iterator.next().getNameOrOID();
            if (iterator.hasNext()) {
                buffer.append(" MAY ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next().getNameOrOID());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MAY ");
                buffer.append(firstName);
            }
        }
    }
}

