/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RawAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RawModification {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public static RawModification create(ModificationType modificationType, RawAttribute attribute) {
        return new LDAPModification(modificationType, attribute);
    }

    public static RawModification create(ModificationType modificationType, String attributeType) {
        RawAttribute rawAttribute = RawAttribute.create(attributeType);
        return new LDAPModification(modificationType, rawAttribute);
    }

    public static RawModification create(ModificationType modificationType, String attributeType, String attributeValue) {
        RawAttribute rawAttribute = RawAttribute.create(attributeType, attributeValue);
        return new LDAPModification(modificationType, rawAttribute);
    }

    public static RawModification create(ModificationType modificationType, String attributeType, ByteString attributeValue) {
        RawAttribute rawAttribute = RawAttribute.create(attributeType, attributeValue);
        return new LDAPModification(modificationType, rawAttribute);
    }

    public static RawModification create(ModificationType modificationType, String attributeType, List<ByteString> attributeValues) {
        RawAttribute rawAttribute = RawAttribute.create(attributeType, attributeValues);
        return new LDAPModification(modificationType, rawAttribute);
    }

    public abstract ModificationType getModificationType();

    public abstract void setModificationType(ModificationType var1);

    public abstract RawAttribute getAttribute();

    public abstract void setAttribute(RawAttribute var1);

    public final ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1Enumerated(this.getModificationType().intValue()));
        elements.add(this.getAttribute().encode());
        return new ASN1Sequence(elements);
    }

    public static LDAPModification decode(ASN1Element element) throws LDAPException {
        LDAPAttribute attribute;
        ModificationType modificationType;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293869;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        int numElements = elements.size();
        if (numElements != 2) {
            int msgID = 2293870;
            String message = MessageHandler.getMessage(msgID, numElements);
            throw new LDAPException(2, msgID, message);
        }
        try {
            switch (elements.get(0).decodeAsEnumerated().intValue()) {
                case 0: {
                    modificationType = ModificationType.ADD;
                    break;
                }
                case 1: {
                    modificationType = ModificationType.DELETE;
                    break;
                }
                case 2: {
                    modificationType = ModificationType.REPLACE;
                    break;
                }
                case 3: {
                    modificationType = ModificationType.INCREMENT;
                    break;
                }
                default: {
                    int intValue = elements.get(0).decodeAsEnumerated().intValue();
                    int msgID = 2293871;
                    String message = MessageHandler.getMessage(msgID, intValue);
                    throw new LDAPException(2, msgID, message);
                }
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293872;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        try {
            attribute = RawAttribute.decode(elements.get(1));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            int msgID = 2293873;
            String message = MessageHandler.getMessage(msgID, String.valueOf(e));
            throw new LDAPException(2, msgID, message, e);
        }
        return new LDAPModification(modificationType, attribute);
    }

    public abstract Modification toModification() throws LDAPException;

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);

    public abstract void toString(StringBuilder var1, int var2);
}

